/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import buzzcity.Buzzcity;
import com.twistfuture.app.App;
import com.twistfuture.main.Path;
import com.twistfuture.main.PathContainer;
import com.twistfuture.main.TwistMidlet;
import com.twistfuture.utill.Button;
import com.twistfuture.utill.DataStore;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class TwistCanvas
extends GameCanvas
implements Runnable,
Button.callBack,
Buzzcity.Callback {
    private Image img_GameOver;
    private Image img_UpperStrip;
    private boolean isGameOver;
    private Button btn_TryAgain;
    private Button btn_Back;
    private Path path;
    private PathContainer pathContainer;
    private final String[] name = new String[]{"start"};
    private Thread mThread;
    private int mScore;
    private String mBestScore;
    private final String RMS_BESTSCORE;
    int counter;

    public TwistCanvas() {
        super(true);
        this.RMS_BESTSCORE = "score";
        this.setFullScreenMode(true);
        this.img_GameOver = App.createImage("game_over.png");
        this.img_UpperStrip = App.createImage("strip.png");
        Image temp = App.createImage("button/tryagain.png");
        this.btn_TryAgain = new Button("button/tryagain.png", "button/tryagainp.png", (this.getWidth() - temp.getWidth()) / 2, 300, 0, this);
        this.btn_Back = new Button("button/back.png", "button/backp.png", this.getWidth() - 40, this.getHeight() - 40, 1, this);
        this.pathContainer = new PathContainer();
        for (int i = 0; i < 5; ++i) {
            if (i == 0) {
                this.path = new Path(App.createImage("path/start.png"), i);
            } else {
                int num = App.getRandom(1, 10);
                this.path = new Path(App.createImage("path/" + num + ".png"), num);
            }
            this.pathContainer.addElement(this.path);
        }
        this.startThread();
        this.mBestScore = DataStore.readData("score", "0");
    }

    protected void showNotify() {
        TwistMidlet.buzzcity.registerForUP(this);
        TwistMidlet.buzzcity.unregisterDown();
    }

    private void startThread() {
        if (this.mThread != null) {
            this.mThread = null;
        }
        this.mThread = new Thread(this);
        App.THREAD_STATUS = true;
    }

    private void stopThread() {
        if (this.mThread != null) {
            this.mThread = null;
        }
        App.THREAD_STATUS = false;
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.img_UpperStrip, 0, 0, 0);
        this.pathContainer.paint(g);
        g.fillRect(0, 0, this.getWidth(), 20);
        g.setColor(0xFFFFFF);
        g.setFont(App.small);
        g.drawString("Score: " + this.mScore, 5, 3, 0);
        g.drawString("Best: " + this.mBestScore, this.getWidth() - App.small.stringWidth("Best: " + this.mBestScore), 3, 0);
        if (this.isGameOver) {
            g.drawImage(this.img_GameOver, 0, 0, 0);
            TwistMidlet.buzzcity.paintAd(g);
            g.setFont(App.small);
            g.drawString("" + this.mScore, 134, 147, 0);
            g.drawString("" + this.mBestScore, 134, 178, 0);
            this.btn_TryAgain.paint(g);
        }
        this.btn_Back.paint(g);
    }

    protected void pointerPressed(int x, int y) {
        if (this.pathContainer.pointerPressed(x, y) && !this.isGameOver && !this.mThread.isAlive()) {
            this.mThread.start();
        }
        if (this.isGameOver) {
            TwistMidlet.buzzcity.adClicked(x, y);
            this.btn_TryAgain.pointerPressed(x, y);
        }
        this.btn_Back.pointerPressed(x, y);
        this.repaint();
    }

    protected void pointerDragged(int x, int y) {
        this.pathContainer.pointerDragged(x, y);
    }

    protected void pointerReleased(int x, int y) {
        this.pathContainer.pointerReleased(x, y);
    }

    public void run() {
        while (App.THREAD_STATUS) {
            if (this.counter++ % 3 == 0) {
                ++this.mScore;
            }
            this.pathContainer.update();
            if (!this.pathContainer.isCollision) {
                this.isGameOver = true;
                this.stopThread();
                this.repaint();
                int score = Integer.parseInt(this.mBestScore);
                if (this.mScore > score) {
                    DataStore.writeData("score", String.valueOf(this.mScore));
                }
            }
            App.sleepThread(App.SLEEP_TIME);
            this.repaint();
            this.flushGraphics();
        }
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                TwistMidlet.mMidlet.callTwistCanvas();
                this.isGameOver = false;
                App.THREAD_STATUS = true;
                this.img_GameOver = null;
                break;
            }
            case 1: {
                TwistMidlet.mMidlet.callMainMenu();
            }
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint(xcordi, ycordi, width, height);
    }
}

