/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.interfaces.GameObject;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.StringUtils;
import com.manthanstudio.tools.UIFont;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextArea
implements GameObject {
    private int visible_line;
    String text;
    private String[] wrappedText;
    public int gapHeight = 2;
    public boolean auto_scroll;
    int x;
    int y;
    int width;
    int height;
    byte defaultUIFont;
    byte specialFont;
    int drawX;
    int drawY;
    int startIndex;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    int[] padding = new int[]{2, 2, 2, 2};
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public int align = 1;
    private Image imgArrowUp;
    private Image imgArrowDown;
    public boolean drawArrow;
    boolean[] specialLine;
    int ticks;
    long fluff;
    int sign;
    int pixelCount = 0;
    public int pixelMovement;
    private int wrappedTextHeight;

    public TextArea(String text, byte uiFont) {
        this(text, uiFont, 220);
    }

    public TextArea(String text, byte uiFont, int width) {
        this.init();
        this.width = width;
        this.text = text;
        this.defaultUIFont = uiFont;
        Vector vect = StringUtils.initRowString(this.text, uiFont, this.width - (this.padding[0] + this.padding[1]));
        this.wrappedText = new String[vect.size()];
        vect.copyInto(this.wrappedText);
        this.wrappedTextHeight = this.height = this.wrappedText.length * (UIFont.getHeight(uiFont) + this.gapHeight);
        this.visible_line = this.wrappedText.length;
        this.drawArrow = false;
    }

    public TextArea(String text, byte uiFont, int x, int y, int width, int height) {
        this.init();
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.defaultUIFont = uiFont;
        Vector vect = StringUtils.initRowString(this.text, uiFont, width - (this.padding[0] + this.padding[1]));
        this.wrappedText = new String[vect.size()];
        vect.copyInto(this.wrappedText);
        this.wrappedTextHeight = this.wrappedText.length * (UIFont.getHeight(uiFont) + this.gapHeight);
        if (this.wrappedTextHeight >= this.height - (this.padding[2] + this.padding[3])) {
            this.visible_line = (this.height - (this.padding[2] + this.padding[3])) / (UIFont.getHeight(uiFont) + this.gapHeight) + 1;
            this.drawArrow = true;
        } else {
            this.visible_line = this.wrappedText.length;
        }
        this.drawX = x;
        this.drawY = y;
    }

    public void setSpecialLineFont(byte specialFont) {
        this.specialFont = specialFont;
    }

    public void setPostion(int x, int y) {
        this.drawX = x;
        this.drawY = y;
        this.x = x;
        this.y = y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void init() {
        this.imgArrowDown = ResManager.getImage(ResManager.IMAGE_ARROW_DOWN);
        this.imgArrowUp = ResManager.getImage(ResManager.IMAGE_ARROW_UP);
    }

    public void setArrows(Image up, Image down) {
        this.imgArrowDown = down;
        this.imgArrowUp = up;
    }

    public void reInit() {
    }

    public void renderer(Graphics g) {
        int org_x = g.getClipX();
        int org_y = g.getClipY();
        int org_width = g.getClipWidth();
        int org_height = g.getClipHeight();
        g.setClip(this.x, this.y, this.width, this.height);
        int j = 0;
        int pos_x = 0;
        for (int i = 0; i < this.wrappedText.length; ++i) {
            switch (this.align) {
                case 0: {
                    pos_x = this.drawX + this.padding[0];
                    break;
                }
                case 1: {
                    if (this.wrappedText[i].length() != 0 && this.wrappedText[i].charAt(0) == '~') {
                        pos_x = this.drawX + this.padding[0] + (this.width - (this.padding[0] + this.padding[1]) - UIFont.stringWidth(this.wrappedText[i], this.specialFont)) / 2;
                        break;
                    }
                    pos_x = this.drawX + this.padding[0] + (this.width - (this.padding[0] + this.padding[1]) - UIFont.stringWidth(this.wrappedText[i], this.defaultUIFont)) / 2;
                    break;
                }
                case 2: {
                    pos_x = this.drawX + this.width - this.padding[1] - UIFont.stringWidth(this.wrappedText[i], this.defaultUIFont);
                }
            }
            if (this.wrappedText[i].length() != 0 && this.wrappedText[i].charAt(0) == '~') {
                UIFont.drawString(g, this.wrappedText[i], pos_x, this.drawY + this.padding[2] + j * (UIFont.getHeight(this.defaultUIFont) + this.gapHeight) - this.pixelMovement, this.specialFont);
            } else {
                UIFont.drawString(g, this.wrappedText[i], pos_x, this.drawY + this.padding[2] + j * (UIFont.getHeight(this.defaultUIFont) + this.gapHeight) - this.pixelMovement, this.defaultUIFont);
            }
            ++j;
        }
        g.setClip(org_x, org_y, org_width, org_height);
        if (this.drawArrow) {
            if (this.canMoveUp()) {
                g.drawImage(this.imgArrowUp, this.x + (this.width - this.imgArrowUp.getWidth()) / 2, this.y + this.height + 10, 0);
            }
            if (this.canMoveDown()) {
                g.drawImage(this.imgArrowDown, this.x + (this.width - this.imgArrowUp.getWidth()) / 2, this.y + this.height + this.imgArrowUp.getHeight() + 11, 0);
            }
        }
    }

    public void moveUp() {
        this.pixelCount += 2;
        this.sign = -1;
    }

    public void moveDown() {
        this.sign = 1;
        this.pixelCount += 2;
    }

    private void move(int movePixel) {
        this.pixelMovement += movePixel;
        if (this.pixelMovement < 0) {
            this.pixelMovement = 0;
            this.pixelCount = 0;
        } else if (this.pixelMovement > this.wrappedTextHeight - this.height) {
            this.pixelMovement = Math.max(0, this.wrappedTextHeight - this.height);
            this.pixelCount = 0;
        }
    }

    public boolean canMoveUp() {
        return this.pixelMovement > 0;
    }

    public boolean canMoveDown() {
        return this.pixelMovement < this.wrappedTextHeight - this.height;
    }

    public void cycle(long deltaMS) {
        if (this.pixelCount > 0) {
            this.ticks = (int)(deltaMS + this.fluff) / 30;
            this.fluff += deltaMS - (long)(this.ticks * 30);
            if (this.ticks > 0) {
                this.move(2 * this.sign);
                this.pixelCount -= 2;
            }
        }
    }

    public void free() {
    }

    public void destroy() {
        this.text = null;
        this.wrappedText = null;
        this.padding = null;
    }

    public void enable() {
    }

    public void disable() {
    }

    public void pause() {
    }

    public void resume() {
    }
}

