/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

import com.manthanstudio.game.Actor;
import com.manthanstudio.tools.ImageSet;
import javax.microedition.lcdui.Graphics;

public class Sprite {
    private int currentFrameIndex;
    private int currentFrame;
    private int currentState;
    private long currentStateBegan;
    private ImageSet imageSet;
    private long lastFrameChange;
    private int totalCycles;
    private int previousState;
    private int previousFrame;
    Actor owner;

    public Sprite(ImageSet is, int startingState, int startingFrameIndex) {
        this.imageSet = is;
        this.setState(startingState, true);
        this.currentFrameIndex = startingFrameIndex;
        this.currentFrame = is.getFrameNumber(startingState, this.currentFrameIndex);
    }

    public final void setFrame(int f) {
        this.currentFrame = f;
    }

    public final void setState(int s, boolean force) {
        if (this.currentState != s || force) {
            this.currentState = s;
            this.currentFrameIndex = 0;
            this.currentFrame = this.imageSet.getFrameNumber(this.currentState, this.currentFrameIndex);
            this.totalCycles = 0;
            this.currentStateBegan = System.currentTimeMillis();
        }
    }

    public void setOwner(Actor owner) {
        this.owner = owner;
    }

    public final void reset() {
        this.currentFrameIndex = 0;
        this.currentFrame = this.imageSet.getFrameNumber(this.currentState, this.currentFrameIndex);
        this.totalCycles = 0;
        this.currentStateBegan = 0L;
        this.lastFrameChange = 0L;
    }

    public final long getWhenStateBegan() {
        return this.currentStateBegan;
    }

    public final long getTimeInCurrentState() {
        return System.currentTimeMillis() - this.currentStateBegan;
    }

    public final int getCurrentState() {
        return this.currentState;
    }

    public final int getCurrentFrame() {
        return this.currentFrame;
    }

    public final void draw(Graphics target, int targetX, int targetY) {
        this.imageSet.draw(target, this.currentState, this.currentFrame, targetX, targetY);
    }

    public final void cycle(long deltaMS) {
        long deltaTime;
        if (this.imageSet.getTotalFrames(this.currentState) > 1 && this.imageSet.getAnimTime(this.currentState) > 0 && (deltaTime = System.currentTimeMillis() - this.lastFrameChange) > (long)this.imageSet.getAnimTimeForFrame(this.currentState, this.currentFrame)) {
            ++this.currentFrameIndex;
            this.lastFrameChange = System.currentTimeMillis();
            if (this.currentFrameIndex >= this.imageSet.getTotalFrames(this.currentState)) {
                this.currentFrameIndex = 0;
                ++this.totalCycles;
            }
            this.currentFrame = this.imageSet.getFrameNumber(this.currentState, this.currentFrameIndex);
        }
    }

    public int getCurrentFrameWidth() {
        return this.imageSet.getFrameWidth(this.currentState, this.currentFrame);
    }

    public int getCurrentFrameHeight() {
        return this.imageSet.getFrameHeight(this.currentState, this.currentFrame);
    }

    public final int getTotalCycles() {
        return this.totalCycles;
    }
}

