/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.tools.MathFP;
import javax.microedition.lcdui.Graphics;

public abstract class Actor {
    public static final int MAX_VEHICLES = 8;
    public static final int ACTOR_AMBULANCE = 0;
    public static final int ACTOR_TAXI = 1;
    public static final int ACTOR_DOUBLE_DECKER = 2;
    public static final int ACTOR_SUV = 3;
    public static final int ACTOR_CAR1 = 4;
    public static final int ACTOR_BUS1 = 5;
    public static final int ACTOR_CAR2 = 6;
    public static final int ACTOR_BUS2 = 7;
    public static final int ACTOR_HERO = 8;
    public static final int ACTOR_POWER_FRUIT = 9;
    public static final int ACTOR_POWER_BIRDS = 10;
    public int actorID = -1;
    protected int actorX;
    protected int actorY;
    protected int width;
    protected int height;
    protected int xActorFP;
    protected int yActorFP;
    protected int xVelFP;
    protected int yVelFP;
    protected GameWorld world;
    protected Actor nextLinked;
    protected Actor prevLinked;
    private boolean collidable;
    private boolean visible;
    public int speedFP = Constants.SPEED_ACTOR_PIXEL_PER_MS_FP;

    public Actor(int x, int y) {
        this.actorX = x;
        this.actorY = y;
    }

    public void init() {
        this.collidable = true;
        this.visible = true;
    }

    public void cycle(long deltaMS) {
    }

    public abstract void renderer(Graphics var1, int var2, int var3);

    public void setXY(int x, int y) {
        this.xActorFP = MathFP.toFP(x);
        this.yActorFP = MathFP.toFP(y);
        this.setX(x);
        this.setY(y);
    }

    public int getX() {
        return this.actorX;
    }

    public void setX(int x) {
        this.xActorFP = MathFP.toFP(x);
        this.actorX = x;
    }

    public int getY() {
        return this.actorY;
    }

    public void setY(int y) {
        this.yActorFP = MathFP.toFP(y);
        this.actorY = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public GameWorld getWorld() {
        return this.world;
    }

    public void setWorld(GameWorld world) {
        this.world = world;
    }

    public final Actor getNextLinked() {
        return this.nextLinked;
    }

    public final void setNextLinked(Actor nextLinked) {
        this.nextLinked = nextLinked;
    }

    public final Actor getPrevLinked() {
        return this.prevLinked;
    }

    public final void setPrevLinked(Actor prevLinked) {
        this.prevLinked = prevLinked;
    }

    public final int getActorID() {
        return this.actorID;
    }

    public final void setActorID(int type) {
        this.actorID = type;
    }

    public final void deactivate() {
        this.collidable = false;
        this.visible = false;
    }

    public final void setCollidable(boolean b) {
        this.collidable = b;
    }

    public final boolean isCollidable() {
        return this.collidable;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getSpeedFP() {
        return this.speedFP;
    }

    public void setSpeedFP(int speedFP) {
        this.speedFP = speedFP;
    }

    public boolean isCollidingWith(int px, int py) {
        return px >= this.getX() && px <= this.getX() + this.getWidth() && py >= this.getY() && py <= this.getY() + this.getHeight();
    }

    public boolean isCollidingWith(Actor another) {
        return this.isCollidingWith(another.getX(), another.getY()) || this.isCollidingWith(another.getX() + another.getWidth(), another.getY()) || this.isCollidingWith(another.getX(), another.getY() + another.getHeight()) || this.isCollidingWith(another.getX() + another.getWidth(), another.getY() + another.getHeight());
    }
}

