/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.GameMenu;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.game.TextArea;
import com.manthanstudio.interfaces.GameObject;
import com.manthanstudio.locale.Locale;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.SoundUtils;
import com.manthanstudio.tools.UIFont;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas
implements Runnable,
Constants,
GameObject {
    private int cps;
    private int cyclesThisSecond;
    private long lastCPSTime = 0L;
    private static final int MAX_CPS = 50;
    private static final int MS_PER_FRAME = 20;
    private long cycleStartTime;
    private long timeSinceStart;
    private long lastCycleTime;
    private long msSinceLastCycle;
    private static final int LOGO_TIME = 3000;
    private long logoStartTime = 0L;
    Thread gameThread;
    boolean running;
    boolean isDoubleBuffered;
    public static boolean hasPointerEvent;
    Graphics osg;
    Image osb;
    public static int keysPressed;
    public static int keysHold;
    public static int keysReleased;
    TextArea textArea;
    String lskSoftKey;
    String rskSoftKey;
    int canvasState = 0;
    public Locale locale;
    Image logo;
    Image splash;
    private Image imgYes;
    private Image imgNo;
    SoundUtils soundUtils;
    public static boolean isSound;
    public static boolean isVibrate;
    GameMenu gameMenu;
    GameWorld gameWorld;
    public static int gameMode;
    boolean isSizeChange;
    String sizeChangeMsg;
    public static boolean interruptInGallery;
    public static final int TOTAL_FRAME = 6;
    public static final int ANIMATION_TIME_DELAY = 200;
    public static final int LOGO_FRAME_HEIGHT = 68;
    public static final int LOGO_FRAME_WIDTH = 156;
    public static final int LOGO_FRAME_HALF_HEIGHT = 34;
    public static final int LOGO_FRAME_HALF_WIDTH = 78;
    int row;
    int col;
    int tileNo = 0;
    int logo_ticks;
    int logo_fluff;
    public static final int FP_PI2;
    public static final int FP_DEGREES_PER_RAD;
    int[] startX;
    int[] startY;
    int[] currentX;
    int[] currentY;
    int xFP;
    int yFP;
    int xVelFP;
    int yVelFP;
    int xAccFP = 0;
    int yAccFp = 0;
    int speed = 15;
    int angle = 15;
    int direction;
    long fluff;
    long fluffBlink;
    boolean isBlink;

    public GameCanvas() {
        this.setFullScreenMode(true);
        hasPointerEvent = this.hasPointerEvents();
        gameMode = 1;
        this.isDoubleBuffered = gameMode == 1 ? false : this.isDoubleBuffered();
        if (!this.isDoubleBuffered) {
            this.osb = Image.createImage((int)220, (int)176);
            this.osg = this.osb.getGraphics();
        }
        UIFont.initFonts();
        this.locale = Locale.getInstance();
        this.locale.init();
        this.soundUtils = new SoundUtils();
        this.textArea = new TextArea(this.locale.getMessage(37), 3, 200);
        this.lskSoftKey = this.locale.getMessage(23);
        this.rskSoftKey = this.locale.getMessage(24);
        this.textArea.setPostion((220 - this.textArea.getWidth()) / 2, (176 - this.textArea.getHeight()) / 2);
        this.gameWorld = new GameWorld(this);
        this.imgYes = ResManager.getImage(ResManager.IMAGE_GAME_YES);
        this.imgNo = ResManager.getImage(ResManager.IMAGE_GAME_NO);
        this.sizeChangeMsg = this.locale.getMessage(54);
        this.initTitleSplash();
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.gameThread) {
            try {
                this.cycleStartTime = System.currentTimeMillis();
                this.msSinceLastCycle = System.currentTimeMillis() - this.lastCycleTime;
                this.processKey();
                if (this.msSinceLastCycle < 100L) {
                    this.cycle(this.msSinceLastCycle);
                }
                this.repaint();
                if (System.currentTimeMillis() - this.lastCPSTime > 1000L) {
                    this.lastCPSTime = System.currentTimeMillis();
                    this.cps = this.cyclesThisSecond;
                    this.cyclesThisSecond = 0;
                } else {
                    ++this.cyclesThisSecond;
                }
                this.lastCycleTime = System.currentTimeMillis();
                this.timeSinceStart = System.currentTimeMillis() - this.cycleStartTime;
                if (this.timeSinceStart >= 20L) continue;
                Thread.sleep(20L - this.timeSinceStart);
            }
            catch (Exception e) {
                System.out.println("App exception: " + e);
                e.printStackTrace();
            }
        }
    }

    public void processKey() {
        switch (this.canvasState) {
            case 0: {
                if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
                    isSound = true;
                    this.logo = ResManager.getImage(ResManager.IMAGE_MANTHAN_SPLASH);
                    this.canvasState = 1;
                    this.logoStartTime = System.currentTimeMillis();
                    this.textArea.destroy();
                    this.textArea = null;
                } else if (GameCanvas.keyWasPressed(262144)) {
                    isSound = false;
                    this.logo = ResManager.getImage(ResManager.IMAGE_MANTHAN_SPLASH);
                    this.canvasState = 1;
                    this.logoStartTime = System.currentTimeMillis();
                    this.textArea.destroy();
                    this.textArea = null;
                }
                GameCanvas.resetKeys();
                break;
            }
            case 1: {
                GameCanvas.resetKeys();
                break;
            }
            case 2: {
                if (GameCanvas.keyWasPressed(Integer.MIN_VALUE)) {
                    this.canvasState = 3;
                    this.gameMenu = new GameMenu(this);
                    this.soundUtils.stopSound((byte)0);
                }
                GameCanvas.resetKeys();
                break;
            }
            case 3: {
                this.gameMenu.processKeys();
                break;
            }
            case 4: {
                this.gameWorld.processKeys();
            }
        }
    }

    public void cycle(long deltaMS) {
        switch (this.canvasState) {
            case 0: {
                break;
            }
            case 1: {
                this.cycleCompanyLogo(deltaMS);
                if (System.currentTimeMillis() - this.logoStartTime <= 3000L) break;
                this.logo = null;
                ResManager.releaseImage(ResManager.IMAGE_MANTHAN_SPLASH);
                this.splash = ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH);
                this.canvasState = 2;
                this.soundUtils.loadSound((byte)0);
                this.soundUtils.playSound((byte)0, -1);
                break;
            }
            case 2: {
                this.cycleTitleSplash(deltaMS);
                break;
            }
            case 3: {
                this.gameMenu.cycle(deltaMS);
                break;
            }
            case 4: {
                this.gameWorld.cycle(deltaMS);
            }
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.isSizeChange) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                UIFont.drawString(graphics, this.sizeChangeMsg, (this.getWidth() - UIFont.stringWidth(this.sizeChangeMsg, (byte)4)) / 2, (this.getHeight() - UIFont.getHeight(4)) / 2, 4);
                return;
            }
            if (gameMode == 1) {
                if (this.isDoubleBuffered) {
                    this.renderer(graphics);
                } else {
                    this.renderer(this.osg);
                    graphics.drawRegion(this.osb, 0, 0, this.osb.getWidth(), this.osb.getHeight(), 5, 0, 0, 0);
                }
            } else if (this.isDoubleBuffered) {
                this.renderer(graphics);
            } else {
                this.renderer(this.osg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renderer(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        switch (this.canvasState) {
            case 0: {
                this.textArea.renderer(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 1: {
                this.drawCompanyLogo(g, 38, 54);
                break;
            }
            case 2: {
                this.renderTitleSplash(g);
                break;
            }
            case 3: {
                this.gameMenu.renderer(g);
                break;
            }
            case 4: {
                this.gameWorld.renderer(g);
            }
        }
    }

    public void start() {
        if (this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.lastCycleTime = System.currentTimeMillis();
            this.lastCPSTime = 0L;
            this.gameThread.start();
        }
        if (this.canvasState == 2 && isSound && this.soundUtils != null) {
            try {
                this.soundUtils.loadSound((byte)0);
                this.soundUtils.playSound((byte)0, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if ((isSound || this.soundUtils.isPlaying()) && this.soundUtils != null) {
            this.soundUtils.stopSound();
        }
        this.gameThread = null;
    }

    public void loadGame() {
        this.canvasState = 4;
        this.gameWorld = new GameWorld(this);
        this.gameWorld.loadGame();
    }

    public void unloadGame() {
        if (this.gameWorld != null) {
            this.gameWorld.free();
        }
        this.gameWorld = null;
    }

    public void pauseGame() {
        if (this.gameWorld != null) {
            this.gameWorld.pause();
        }
        if (this.gameMenu != null) {
            this.gameMenu.setScreenState(7);
        }
        this.canvasState = 3;
    }

    public void resumeGame() {
        if (this.gameWorld != null) {
            this.gameWorld.resume();
        }
        this.canvasState = 4;
    }

    public void gameOver() {
        GameCanvas.resetKeys();
        if (isSound) {
            this.soundUtils.stopSound((byte)2);
            this.soundUtils.stopSound();
        }
        this.gameMenu.loadScore();
        if (this.gameMenu.playersScores[4] < GameWorld.score) {
            this.gameMenu.setScreenState(10);
        } else {
            this.gameMenu.setScreenState(11);
        }
        this.canvasState = 3;
        this.gameWorld.free();
    }

    protected void hideNotify() {
        try {
            if (this.canvasState == 4) {
                interruptInGallery = GameWorld.gameState != GameWorld.LEVEL_FULL_IMAGE;
                this.pauseGame();
            }
            GameCanvas.resetKeys();
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showNotify() {
        try {
            GameCanvas.resetKeys();
            this.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sizeChanged(int width, int height) {
        if (gameMode == 0) {
            if (width != 220) {
                this.isSizeChange = true;
                this.stop();
            } else {
                this.isSizeChange = false;
                this.start();
            }
        } else if (width == 220) {
            this.isSizeChange = true;
            this.stop();
        } else {
            this.isSizeChange = false;
            this.start();
        }
    }

    public void keyPressed(int keyCode) {
        if (!this.isSizeChange) {
            keysPressed = GameCanvas.getKeyState(keyCode);
            keysHold |= keysPressed;
        }
    }

    public void keyReleased(int keyCode) {
        if (!this.isSizeChange) {
            keysReleased = GameCanvas.getKeyState(keyCode);
            keysHold &= ~keysReleased;
        }
    }

    public static int getKeyState(int keyCode) {
        int key_state = 0;
        if (gameMode == 1) {
            switch (keyCode) {
                case -1: {
                    key_state = 8;
                    break;
                }
                case -2: {
                    key_state = 4;
                    break;
                }
                case -4: {
                    key_state = 1;
                    break;
                }
                case -3: {
                    key_state = 2;
                    break;
                }
                case -5: {
                    key_state = 16;
                    break;
                }
                case 48: {
                    key_state = 32;
                    break;
                }
                case 49: {
                    key_state = 64;
                    break;
                }
                case 50: {
                    key_state = 512;
                    break;
                }
                case 51: {
                    key_state = 256;
                    break;
                }
                case 52: {
                    key_state = 8192;
                    break;
                }
                case 53: {
                    key_state = 1024;
                    break;
                }
                case 54: {
                    key_state = 128;
                    break;
                }
                case 55: {
                    key_state = 4096;
                    break;
                }
                case 56: {
                    key_state = 2048;
                    break;
                }
                case 57: {
                    key_state = 16384;
                    break;
                }
                case 42: {
                    key_state = 32768;
                    break;
                }
                case 35: {
                    key_state = 65536;
                    break;
                }
                case -6: {
                    key_state = 131072;
                    break;
                }
                case -7: {
                    key_state = 262144;
                    break;
                }
                case -22: {
                    key_state = 524288;
                    break;
                }
                case -11: {
                    key_state = 0x100000;
                }
            }
        } else {
            switch (keyCode) {
                case -1: {
                    key_state = 1;
                    break;
                }
                case -2: {
                    key_state = 2;
                    break;
                }
                case -4: {
                    key_state = 4;
                    break;
                }
                case -3: {
                    key_state = 8;
                    break;
                }
                case -5: {
                    key_state = 16;
                    break;
                }
                case 48: {
                    key_state = 32;
                    break;
                }
                case 49: {
                    key_state = 64;
                    break;
                }
                case 50: {
                    key_state = 128;
                    break;
                }
                case 51: {
                    key_state = 256;
                    break;
                }
                case 52: {
                    key_state = 512;
                    break;
                }
                case 53: {
                    key_state = 1024;
                    break;
                }
                case 54: {
                    key_state = 2048;
                    break;
                }
                case 55: {
                    key_state = 4096;
                    break;
                }
                case 56: {
                    key_state = 8192;
                    break;
                }
                case 57: {
                    key_state = 16384;
                    break;
                }
                case 42: {
                    key_state = 32768;
                    break;
                }
                case 35: {
                    key_state = 65536;
                    break;
                }
                case -6: {
                    key_state = 131072;
                    break;
                }
                case -7: {
                    key_state = 262144;
                    break;
                }
                case -22: {
                    key_state = 524288;
                    break;
                }
                case -11: {
                    key_state = 0x100000;
                }
            }
        }
        return key_state |= Integer.MIN_VALUE;
    }

    public static boolean keyIsHeld(int key) {
        return (keysHold & key) != 0;
    }

    public static boolean keyWasPressed(int key) {
        return (keysPressed & key) != 0;
    }

    public static void resetKey(int key) {
        keysPressed &= ~key;
    }

    public static void resetKeys() {
        keysPressed = 0;
        keysHold = 0;
        keysReleased = 0;
    }

    public void paintLSK(Graphics g) {
        if (gameMode == 1) {
            g.drawImage(this.imgYes, 220 - this.imgYes.getWidth() - 2, 176 - this.imgYes.getHeight() - 2, 0);
        } else {
            g.drawImage(this.imgYes, 2, 176 - this.imgYes.getHeight() - 2, 0);
        }
    }

    public void paintRSK(Graphics g) {
        if (gameMode == 1) {
            g.drawImage(this.imgNo, 220 - this.imgNo.getWidth() - 2, 2, 0);
        } else {
            g.drawImage(this.imgNo, 220 - this.imgNo.getWidth() - 2, 176 - this.imgYes.getHeight() - 2, 0);
        }
    }

    public void cycleCompanyLogo(long deltaMS) {
        this.logo_ticks = (int)(deltaMS + (long)this.logo_fluff) / 200;
        this.logo_fluff = (int)((long)this.logo_fluff + (deltaMS - (long)(this.logo_ticks * 200)));
        if (this.logo_ticks > 0 && this.tileNo < 5) {
            ++this.tileNo;
        }
    }

    public void drawCompanyLogo(Graphics g, int targetX, int targetY) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 220, 176);
        this.row = this.logo.getHeight() / 68;
        this.col = this.logo.getWidth() / 156;
        g.setClip(targetX, targetY, 156, 68);
        g.drawImage(this.logo, targetX - this.tileNo % this.col * 156, targetY - this.tileNo / this.col % this.row * 68, 0);
        g.setClip(0, 0, 220, 176);
    }

    public void initTitleSplash() {
        this.startX = new int[3];
        this.startY = new int[3];
        this.currentX = new int[3];
        this.currentY = new int[3];
        this.startX[0] = -ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR1).getWidth() + 25;
        this.startY[0] = 67;
        this.currentX[0] = this.startX[0];
        this.currentY[0] = this.startY[0];
        this.startX[1] = -(ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR1).getWidth() + ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR3).getWidth() + 45);
        this.startY[1] = this.startY[0] + ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR1).getHeight() + 35;
        this.currentX[1] = this.startX[1];
        this.currentY[1] = this.startY[1];
        this.startX[2] = -(ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR1).getWidth() + ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR3).getWidth() + 45 + ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR2).getWidth() + 45);
        this.startY[2] = this.startY[1] + ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR1).getHeight() + 35;
        this.currentX[2] = this.startX[2];
        this.currentY[2] = this.startY[2];
        int angleFP = MathFP.div(MathFP.toFP(this.angle), FP_DEGREES_PER_RAD);
        this.xVelFP = MathFP.mul(MathFP.toFP(this.speed), MathFP.cos(angleFP));
        this.yVelFP = MathFP.mul(MathFP.toFP(this.speed), -MathFP.sin(angleFP));
    }

    public void cycleTitleSplash(long deltaMS) {
        int ticks = (int)(deltaMS + this.fluff) / 20;
        this.fluff += deltaMS - (long)(ticks * 20);
        if (ticks > 0) {
            int ticksFP = MathFP.toFP(ticks);
            for (int i = 0; i < this.currentX.length; ++i) {
                this.xFP = MathFP.toFP(this.currentX[i]);
                this.yFP = MathFP.toFP(this.currentY[i]);
                this.xFP = MathFP.add(this.xFP, MathFP.mul(this.xVelFP, ticksFP));
                this.currentX[i] = MathFP.toInt(this.xFP);
                this.yFP = MathFP.add(this.yFP, MathFP.mul(this.yVelFP, ticksFP));
                this.currentY[i] = MathFP.toInt(this.yFP);
            }
        }
        for (int i = 0; i < this.currentX.length; ++i) {
            if (this.currentX[i] <= 250) continue;
            this.currentX[i] = this.startX[i];
            this.currentY[i] = this.startY[i];
        }
        int ticks2 = (int)(deltaMS + this.fluffBlink) / 500;
        this.fluffBlink += deltaMS - (long)(ticks2 * 500);
        if (ticks2 > 0) {
            this.isBlink = !this.isBlink;
        }
    }

    public void renderTitleSplash(Graphics g) {
        g.drawImage(this.splash, 0, 0, 0);
        g.drawImage(ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR1), this.currentX[0], this.currentY[0], 0);
        g.drawImage(ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR2), this.currentX[2], this.currentY[2], 0);
        g.drawImage(ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_CAR3), this.currentX[1], this.currentY[1], 0);
        g.drawImage(ResManager.getImage(ResManager.IMAGE_TITLE_SPLASH_IMAGE), 10, 0, 0);
        if (this.isBlink) {
            UIFont.drawString(g, this.locale.getMessage(1), (220 - UIFont.stringWidth(this.locale.getMessage(1), (byte)3)) / 2, 176 - UIFont.getHeight(3) - 10, 3);
        }
    }

    public void init() {
    }

    public void reInit() {
    }

    public void free() {
        if (this.gameMenu != null) {
            this.gameMenu.free();
        }
        if (this.gameWorld != null) {
            this.gameWorld.free();
        }
    }

    public void destroy() {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void pause() {
    }

    public void resume() {
    }

    static {
        interruptInGallery = false;
        FP_PI2 = MathFP.mul(12868, MathFP.toFP(2));
        FP_DEGREES_PER_RAD = MathFP.div(MathFP.toFP(360), FP_PI2);
    }
}

