/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.Actor;
import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.game.Vehicles;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero
extends Actor {
    public static final int FP_PI2 = MathFP.mul(12868, MathFP.toFP(2));
    public static final int FP_DEGREES_PER_RAD = MathFP.div(MathFP.toFP(360), FP_PI2);
    public static final int STATE_STAND_LEFT = 0;
    public static final int STATE_STAND_RIGHT = 1;
    public static final int STATE_WALK_LEFT = 2;
    public static final int STATE_WALK_RIGHT = 3;
    public static final int STATE_JUMP_ON_ROOF = 4;
    public static final int STATE_GLIDE_UP = 5;
    public static final int STATE_GLIDE_DOWN = 6;
    public static final int STATE_UMBRELLA_CLOSED = 7;
    public static final int STATE_FALL = 8;
    public static final int STATE_UMBRELLA_OPEN = 9;
    public static final int UP = -1;
    public static final int DOWN = 1;
    int state = 0;
    public int preState;
    public static boolean isHeroOnVehicale = false;
    public static boolean isHeroOnRoad = false;
    private int glideDirection;
    private Sprite spriteHero;
    private Vehicles owner;
    public int prevFrameWidth;
    public int currentFrameWidth;
    public int prevFrameHeight;
    public int currentFrameHeight;
    public int panPixelsToMoveFP;
    private long timeStateChanged;
    private long timeSinceStateChange;
    private long flfluffUmbrellaOpen;
    private long fluffGlideUp;
    private long fluffGlideDown;
    private long fluffUmbrellaClosed;
    private long fluffFall;
    int fluff;
    private static int dx;
    private static int dy;
    private static int xFP;
    private static int yFP;
    private static int distanceFP;
    private static int[] result;

    public Hero(int x, int y) {
        super(x, y);
        this.actorID = 8;
        this.width = 30;
        this.height = 30;
        this.glideDirection = 1;
    }

    public Hero(int diameter, int x, int y) {
        this(x, y);
    }

    public void init() {
        isHeroOnVehicale = false;
        isHeroOnRoad = false;
        this.glideDirection = 1;
        Image imgHeroWalk = ResManager.getImage(ResManager.IMAGE_HERO_WALK);
        int frameWidth = imgHeroWalk.getWidth() / 4;
        int frameHeight = imgHeroWalk.getHeight();
        this.setWidth(frameWidth);
        this.setHeight(frameHeight);
        this.speedFP = Constants.SPEED_ACTOR_PIXEL_PER_MS_FP;
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(imgHeroWalk, new int[]{400, 400, 400, 400}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{1});
        imageSet.addState(imgHeroWalk, new int[]{400, 400, 400, 400}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{1});
        imageSet.addState(imgHeroWalk, new int[]{80, 80, 80, 80}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2, 1});
        imageSet.addState(imgHeroWalk, new int[]{100, 100, 100, 100}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2, 0});
        imageSet.addState(imgHeroWalk, new int[]{100, 100, 100, 100}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{3});
        Image imgHeroGlid = ResManager.getImage(ResManager.IMAGE_HERO_GLID);
        frameWidth = imgHeroGlid.getWidth() / 7;
        frameHeight = imgHeroGlid.getHeight();
        imageSet.addState(imgHeroGlid, new int[]{1000, 100, 60, 60, 60, 60, 60}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{2, 1, 0, 1, 2, 3});
        imageSet.addState(imgHeroGlid, new int[]{130, 130, 130, 130, 130, 130, 130}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{4, 3, 2, 1, 0, 1, 2, 3});
        imageSet.addState(imgHeroGlid, new int[]{400, 400, 400, 400, 400, 400, 400}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{5});
        imageSet.addState(imgHeroGlid, new int[]{400, 400, 400, 400, 400, 400, 400}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{6});
        imageSet.addState(imgHeroGlid, new int[]{100, 100, 100, 100, 100, 60, 100}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{5});
        this.spriteHero = new Sprite(imageSet, 0, 0);
        this.state = 0;
        this.spriteHero.setState(this.state, true);
        this.prevFrameWidth = 0;
        this.currentFrameWidth = this.spriteHero.getCurrentFrameWidth();
        this.prevFrameHeight = 0;
        this.currentFrameHeight = this.spriteHero.getCurrentFrameHeight();
        ResManager.releaseImage(ResManager.IMAGE_HERO_WALK);
    }

    public void reInit() {
    }

    public void cycle(long deltaMS) {
        if (172 < this.getY() + this.getHeight()) {
            if (!isHeroOnRoad) {
                Tools.vibrate(300, 100);
            }
            isHeroOnRoad = true;
            this.setState(0);
            this.spriteHero.setState(this.state, true);
            this.world.setState(GameWorld.GAME_DONE);
            this.setY(172 - this.getHeight());
            --this.world.actorLife;
            this.world.strActorLife = " X ";
            this.world.strActorLife = this.world.strActorLife + this.world.actorLife;
        }
        this.prevFrameWidth = this.spriteHero.getCurrentFrameWidth();
        this.prevFrameHeight = this.spriteHero.getCurrentFrameHeight();
        this.spriteHero.setState(this.state, false);
        this.currentFrameWidth = this.spriteHero.getCurrentFrameWidth();
        this.currentFrameHeight = this.spriteHero.getCurrentFrameHeight();
        if (!isHeroOnRoad) {
            this.panPixelsToMoveFP += MathFP.mul(this.speedFP, MathFP.toFP((int)deltaMS));
            int wholePixels = MathFP.toInt(this.panPixelsToMoveFP);
            if (wholePixels > 0) {
                if (!isHeroOnVehicale) {
                    this.setX(this.getX() + wholePixels);
                } else {
                    this.setX(this.getX() + wholePixels);
                    if (this.owner != null) {
                        this.setY(this.owner.actorY - this.getHeight() + this.owner.collisionY);
                    }
                    if (this.state == 4) {
                        this.spriteHero.cycle(deltaMS);
                        this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
                        if (this.timeSinceStateChange > 30L) {
                            this.setState(2);
                        }
                    }
                    if (this.state == 2) {
                        this.spriteHero.cycle(deltaMS);
                        if (this.owner.actorX + this.owner.collisionX >= this.actorX) {
                            this.world.resetPanPixel();
                            if (this.owner != null) {
                                this.speedFP = this.owner.getSpeedFP();
                            }
                            if (this.owner.actorX + this.owner.collisionX < this.actorX) {
                                this.setX(this.owner.actorX + this.owner.collisionX);
                            }
                            this.setState(0);
                        }
                    }
                    if (this.state == 0) {
                        this.spriteHero.cycle(deltaMS);
                        if (this.owner != null) {
                            this.setX(this.owner.actorX + this.owner.collisionX);
                        }
                    }
                }
                this.panPixelsToMoveFP = MathFP.sub(this.panPixelsToMoveFP, MathFP.toFP(wholePixels));
            }
            switch (this.state) {
                case 9: {
                    this.spriteHero.cycle(deltaMS);
                    this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
                    int ticksUmbrellaOpen = (int)(deltaMS + this.flfluffUmbrellaOpen) / 30;
                    this.flfluffUmbrellaOpen += deltaMS - (long)(ticksUmbrellaOpen * 30);
                    if (this.timeSinceStateChange <= 30L || ticksUmbrellaOpen <= 0) break;
                    this.setState(5);
                    break;
                }
                case 5: {
                    this.spriteHero.cycle(deltaMS);
                    int ticksGlideUp = (int)(deltaMS + this.fluffGlideUp) / 30;
                    this.fluffGlideUp += deltaMS - (long)(ticksGlideUp * 30);
                    if (this.getY() < this.world.maxGlideHeight && ticksGlideUp > 0) {
                        this.glideDirection = 1;
                        this.setState(6);
                    }
                    this.setY(this.getY() + ticksGlideUp * 2 * this.glideDirection);
                    break;
                }
                case 6: {
                    this.spriteHero.cycle(deltaMS);
                    int ticksGlideDown = (int)(deltaMS + this.fluffGlideDown) / 30;
                    this.fluffGlideDown += deltaMS - (long)(ticksGlideDown * 30);
                    if (ticksGlideDown <= 0) break;
                    this.setY(this.getY() + ticksGlideDown * 1 * this.glideDirection);
                    break;
                }
                case 7: {
                    this.spriteHero.cycle(deltaMS);
                    int ticksUmbrellaClosed = (int)(deltaMS + this.fluffUmbrellaClosed) / 30;
                    this.fluffUmbrellaClosed += deltaMS - (long)(ticksUmbrellaClosed * 30);
                    if (ticksUmbrellaClosed <= 0) break;
                    this.setY(this.getY() + ticksUmbrellaClosed * 4);
                    break;
                }
                case 8: {
                    this.spriteHero.cycle(deltaMS);
                    int ticksFall = (int)(deltaMS + this.fluffFall) / 30;
                    this.fluffFall += deltaMS - (long)(ticksFall * 30);
                    if (ticksFall <= 0) break;
                    this.setY(this.getY() + ticksFall * 6);
                }
            }
        }
        if (this.world.currentViewX + 130 < this.getX()) {
            this.world.setCurrentViewXY(this.getX() - 130, this.world.currentViewY);
        }
    }

    public void renderer(Graphics g, int offsetX, int offsetY) {
        this.spriteHero.draw(g, this.getX() - offsetX, this.getY() - offsetY);
    }

    public void setGlideHero() {
        this.world.resetPanPixel();
        if (this.owner != null) {
            this.world.currentGlidScores = 0;
        }
        this.setY(this.getY() - 4);
        this.glideDirection = -1;
        isHeroOnVehicale = false;
        this.speedFP = Constants.SPEED_ACTOR_PIXEL_PER_MS_FP;
        this.owner = null;
    }

    public void processKeys() {
        if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            if (this.getY() < 149 - (this.getHeight() + 3)) {
                if (this.state == 5 || this.state == 6) {
                    this.setState(7);
                } else if (this.state == 0 || this.state == 2) {
                    this.setGlideHero();
                    this.setState(9);
                    this.spriteHero.setState(this.state, true);
                    this.setY(this.getY() - (this.spriteHero.getCurrentFrameHeight() - this.prevFrameHeight));
                }
            }
            GameCanvas.resetKeys();
        }
    }

    public Actor getOwner() {
        return this.owner;
    }

    public void setOwner(Vehicles owner) {
        this.owner = owner;
        this.setState(0);
        this.spriteHero.setState(0, true);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.preState = this.state;
        this.state = state;
        this.timeStateChanged = System.currentTimeMillis();
        this.fluff = 0;
    }

    public int getHeight() {
        return this.spriteHero.getCurrentFrameHeight();
    }

    public int getWidth() {
        return this.spriteHero.getCurrentFrameWidth();
    }

    public void free() {
        this.spriteHero = null;
    }

    public void destroy() {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public boolean isCollidingWidhtRoof(Vehicles another) {
        return Tools.isIntersectingRect(this.getX() + 6, this.getY() + this.getHeight() - 3, 10, 6, another.getX() + another.collisionX, another.getY() + another.collisionY, another.collisionWidth, another.collisionHeight);
    }

    public static final int getAngleFromRadians(int radiansFP) {
        return MathFP.toInt(MathFP.mul(radiansFP, FP_DEGREES_PER_RAD));
    }

    public static final int getRadiansFromAngle(int angle) {
        return MathFP.div(MathFP.toFP(angle), FP_DEGREES_PER_RAD);
    }

    public static int toCosFP(int i) {
        return MathFP.cos(Hero.getRadiansFromAngle(i));
    }

    public static int toSinFP(int i) {
        return MathFP.sin(Hero.getRadiansFromAngle(i));
    }

    public static final int[] getProjectedPos(int x, int y, int angle, int distance) {
        dx = Hero.toCosFP(angle);
        dy = -Hero.toSinFP(angle);
        xFP = MathFP.toFP(x);
        yFP = MathFP.toFP(y);
        distanceFP = MathFP.toFP(distance);
        xFP = MathFP.add(xFP, MathFP.mul(dx, distanceFP));
        yFP = MathFP.add(yFP, MathFP.mul(dy, distanceFP));
        Hero.result[0] = MathFP.toInt(xFP);
        Hero.result[1] = MathFP.toInt(yFP);
        return result;
    }

    static {
        result = new int[2];
    }
}

