/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.Actor;
import com.manthanstudio.game.Hero;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Power
extends Actor {
    public static final int LIFE_FREQUENCY = 15000;
    public static final int OBSTACLE_FREQUENCY = 7500;
    private Image imgPower;
    private Sprite powerSprite;
    private int panPixelsToMoveFP;
    public boolean isInUse = false;
    public boolean isPowerCollide = false;
    int sign = 1;
    public static final int POWER_Y_SWITCH_DELAY = 600;
    int verticalSpeed = 1;
    private long timeStateChanged;
    private long timeSinceStateChange;
    public long timeElaps;
    long fluff;
    long ticks;

    public Power(int id, int x, int y, int speedFP) {
        super(x, y);
        this.actorID = id;
        this.speedFP = speedFP;
    }

    public Power(int id) {
        this(id, 0, 0, Constants.SPEED_FRUIT_PIXEL_PER_MS_FP);
    }

    public void init() {
        switch (this.actorID) {
            case 9: {
                this.imgPower = ResManager.getImage(ResManager.IMAGE_GAME_POWER_HEART);
                ImageSet imageSet = new ImageSet(1);
                imageSet.addState(this.imgPower, new int[]{300, 300, 300}, new int[]{this.imgPower.getWidth() / 3, this.imgPower.getWidth() / 3, this.imgPower.getWidth() / 3}, new int[]{this.imgPower.getHeight(), this.imgPower.getHeight(), this.imgPower.getHeight()}, new int[]{0, 1, 2});
                this.powerSprite = new Sprite(imageSet, 0, 0);
                this.powerSprite.setState(0, true);
                this.speedFP = Constants.SPEED_FRUIT_PIXEL_PER_MS_FP;
                break;
            }
            case 10: {
                this.imgPower = ResManager.getImage(ResManager.IMAGE_GAME_POWER_OBSTACLE);
                ImageSet imageSet = new ImageSet(1);
                imageSet.addState(this.imgPower, new int[]{300, 300, 300}, new int[]{this.imgPower.getWidth() / 3, this.imgPower.getWidth() / 3, this.imgPower.getWidth() / 3}, new int[]{this.imgPower.getHeight(), this.imgPower.getHeight(), this.imgPower.getHeight()}, new int[]{0, 1, 2});
                this.powerSprite = new Sprite(imageSet, 0, 0);
                this.powerSprite.setState(0, true);
                this.speedFP = Constants.SPEED_BIRDS_PIXEL_PER_MS_FP;
            }
        }
        this.setWidth(20);
        this.setHeight(20);
        if (this.powerSprite != null) {
            this.setWidth(this.powerSprite.getCurrentFrameWidth());
            this.setHeight(this.powerSprite.getCurrentFrameHeight());
        }
    }

    public void reInit() {
    }

    public void cycle(long deltaMS) {
        this.ticks = (int)(deltaMS + this.fluff) / 600;
        this.fluff += deltaMS - this.ticks * 600L;
        if (this.ticks > 0L) {
            this.sign *= -1;
        }
        if (this.actorY > this.world.maxGlideHeight && this.actorY < 87 - this.getHeight()) {
            this.setY(this.actorY + this.sign * this.verticalSpeed);
        }
        this.panPixelsToMoveFP += MathFP.mul(this.speedFP, MathFP.toFP((int)deltaMS));
        int wholePixels = MathFP.toInt(this.panPixelsToMoveFP);
        if (wholePixels > 0) {
            this.setX(this.actorX + wholePixels);
            this.powerSprite.cycle(deltaMS);
            if (this.actorX < -(4 * this.getWidth())) {
                this.actorX = -(4 * this.getWidth());
            }
            this.panPixelsToMoveFP = MathFP.sub(this.panPixelsToMoveFP, MathFP.toFP(wholePixels));
        }
        if (this.actorX > 220 + 4 * this.getWidth()) {
            this.isInUse = false;
            this.schedulePower();
        }
    }

    public void renderer(Graphics g, int offsetX, int offsetY) {
        if (this.actorX < -(this.getWidth() + 5)) {
            return;
        }
        if (this.actorX > 225) {
            return;
        }
        if (this.isVisible()) {
            switch (this.actorID) {
                case 9: {
                    this.powerSprite.draw(g, this.actorX, this.actorY);
                    break;
                }
                case 10: {
                    this.powerSprite.draw(g, this.actorX, this.actorY);
                }
            }
        }
    }

    public void schedulePower() {
        this.timeStateChanged = System.currentTimeMillis();
        this.timeElaps = 0L;
    }

    public void monitor(long deltaMS) {
        if (Hero.isHeroOnVehicale) {
            this.timeElaps += deltaMS;
        }
        switch (this.actorID) {
            case 9: {
                this.timeSinceStateChange = System.currentTimeMillis() - (this.timeStateChanged + this.timeElaps);
                if (this.timeSinceStateChange <= 15000L) break;
                this.isPowerCollide = false;
                this.setVisible(true);
                this.setX(-10 * this.getWidth());
                this.setY(Tools.getRand(this.world.maxGlideHeight, 87 - this.getHeight()));
                this.isInUse = true;
                break;
            }
            case 10: {
                this.timeSinceStateChange = System.currentTimeMillis() - (this.timeStateChanged + this.timeElaps);
                if (this.timeSinceStateChange <= 7500L) break;
                this.isPowerCollide = false;
                this.setVisible(true);
                this.setX(-4 * this.getWidth());
                this.setY(Tools.getRand(this.world.maxGlideHeight, 87 - this.getHeight()));
                this.isInUse = true;
            }
        }
    }

    public int getWidth() {
        return this.powerSprite.getCurrentFrameWidth();
    }

    public int getHeight() {
        return this.powerSprite.getCurrentFrameHeight();
    }

    public boolean isCollidingWith(Actor a2) {
        return Tools.isIntersectingRect(this.getX() + 3, this.getY() + 3, this.getWidth() - 3, this.getHeight() - 3, a2.getX() - this.world.currentViewX, a2.getY() - this.world.currentViewY, a2.getWidth(), a2.getHeight());
    }

    public void free() {
        switch (this.actorID) {
            case 9: {
                break;
            }
        }
        this.imgPower = null;
    }

    public void destroy() {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void pause() {
    }

    public void resume() {
    }
}

