/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.Totem;
import com.twistfuture.app.GeneralFunction;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Box {
    private static final Image[] BOX_IMAGES;
    private static final Image[] BOX_ANIM_IMAGES;
    private static final Image WOOD_LEFT_IMAGE;
    private static final Image WOOD_RIGHT_IMAGE;
    private Image imgBox;
    private Image woodImg;
    private int X;
    private int Y;
    private int endX;
    private int boxId;
    int woodX;
    int woodY;
    private boolean woodisOnLeft;

    public Box(int boxId, int boxIndex, int Y) {
        this.boxId = boxId;
        this.imgBox = BOX_IMAGES[boxId];
        this.X = (240 - this.imgBox.getWidth()) / 2;
        this.Y = Y - this.imgBox.getHeight() * (boxIndex + 1);
        this.endX = this.X + this.imgBox.getWidth();
    }

    public void paint(Graphics g) {
        if (this.woodImg != null) {
            g.drawImage(this.woodImg, this.woodX, this.Y + 5, 0);
        }
        g.drawImage(this.imgBox, this.X, this.Y, 0);
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public void setY(int Y) {
        this.Y = Y;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getHeight() {
        return this.imgBox.getHeight();
    }

    public void setWoodImg(int c) {
        if (c == 0) {
            this.woodisOnLeft = true;
            this.woodImg = WOOD_LEFT_IMAGE;
            this.woodX = this.X - this.woodImg.getWidth() + 10;
        } else if (c == 1) {
            this.woodisOnLeft = false;
            this.woodImg = WOOD_RIGHT_IMAGE;
            this.woodX = this.endX - 9;
        } else {
            this.woodImg = null;
        }
    }

    public int getWoodX() {
        return this.woodX;
    }

    public Image getWoodImg() {
        return this.woodImg;
    }

    public boolean isWoodisOnLeft() {
        return this.woodisOnLeft;
    }

    int getEndY() {
        return this.Y + this.imgBox.getHeight();
    }

    public void setAnimImgBox() {
        int id = this.boxId * 2;
        if (Totem.onLeftSide) {
            this.X += 20;
            this.imgBox = BOX_ANIM_IMAGES[id + 1];
        } else {
            this.imgBox = BOX_ANIM_IMAGES[id];
            this.X -= 60;
        }
    }

    public void setImgBox(int boxid) {
        this.boxId = boxid;
        this.imgBox = BOX_IMAGES[boxid];
        this.X = (240 - this.imgBox.getWidth()) / 2;
    }

    static {
        int i;
        BOX_IMAGES = new Image[3];
        BOX_ANIM_IMAGES = new Image[6];
        for (i = 0; i < BOX_IMAGES.length; ++i) {
            Box.BOX_IMAGES[i] = GeneralFunction.createImage("maincanvas/box/" + i + ".png");
            Box.BOX_ANIM_IMAGES[i] = GeneralFunction.createImage("maincanvas/box/" + i + ".png");
            Box.BOX_ANIM_IMAGES[i + 1] = GeneralFunction.createImage("maincanvas/box/" + i + ".png");
        }
        for (i = 0; i < BOX_ANIM_IMAGES.length; ++i) {
            Box.BOX_ANIM_IMAGES[i] = GeneralFunction.createImage("maincanvas/" + i + ".png");
        }
        WOOD_LEFT_IMAGE = GeneralFunction.createImage("maincanvas/box/woodleft.png");
        WOOD_RIGHT_IMAGE = GeneralFunction.createImage("maincanvas/box/woodright.png");
    }
}

