/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.Box;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.Game.Timer;
import com.twistfuture.Game.Totem;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.utility.SoundManger;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameManager {
    private boolean totemJumpStatus;
    private final Image woodBase;
    private final Box[] box;
    private final Totem totem;
    private final Random random;
    public static final int GROUND_Y = 303;
    public static int SCORE;
    private static SoundManger manger;
    Font f = Font.getFont((int)32, (int)1, (int)0);
    private boolean collisionStatus;
    private int count;

    public GameManager(int level) {
        SCORE = 0;
        this.box = new Box[6];
        this.woodBase = GeneralFunction.createImage("maincanvas/box/woodbase.png");
        this.random = new Random();
        this.totem = new Totem(level * 4);
        for (int i = 0; i < this.box.length; ++i) {
            this.box[i] = new Box(this.random.nextInt(3), i, 303);
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.woodBase, 95, 303, 0);
        this.totem.paint(g);
        for (int i = 0; i < this.box.length; ++i) {
            this.box[i].paint(g);
        }
        g.setFont(this.f);
        g.setColor(0xFFFFFF);
        if (SCORE > 0) {
            g.drawString("" + SCORE, 200, 42, 0);
        }
    }

    public void pointerPressed(int x, int y) {
        if (y > 40 && y < 303) {
            if (!(this.totemJumpStatus || x >= 120 && x < 120)) {
                this.totemJumpStatus = true;
                Timer.bonusTime += 0.25f;
                ++SCORE;
                if (x < 120) {
                    Totem.onLeftSide = true;
                } else if (x >= 120) {
                    Totem.onLeftSide = false;
                }
                this.collisionStatus = this.collision(this.box[0]);
                this.totem.update();
                this.box[0].setAnimImgBox();
                manger.playSound("impact");
            }
        } else {
            Timer.bonusTime = 0.0f;
        }
    }

    public void update(MainCanvas canvas) {
        if (this.totemJumpStatus) {
            canvas.repaint();
            GeneralFunction.sleepThread(100);
            this.boxUpdation();
            if (!this.collisionStatus) {
                this.collision(this.box[0]);
            }
            this.totemJumpStatus = false;
            this.totem.reset();
        }
    }

    private void boxUpdation() {
        ++this.count;
        this.box[0].setImgBox(this.random.nextInt(3));
        Box tempBox = this.box[0];
        for (int i = 1; i < this.box.length; ++i) {
            this.box[i].setY(303 - i * this.box[i].getHeight());
            this.box[i - 1] = this.box[i];
        }
        tempBox.setY(303 - this.box.length * tempBox.getHeight());
        if (this.count % 3 == 0) {
            tempBox.setWoodImg(this.random.nextInt(2));
        }
        this.box[this.box.length - 1] = tempBox;
    }

    private boolean collision(Box box) {
        if (box.getWoodImg() != null && this.totem.getY() < box.getEndY() && Totem.onLeftSide == box.isWoodisOnLeft()) {
            MainCanvas.threadStatus = false;
            manger.playSound("deadnew");
            return true;
        }
        return false;
    }

    static {
        manger = new SoundManger();
    }
}

