/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.game.objects;

import in.spicelabs.doodleCopter.common.Config;
import in.spicelabs.game.objects.Copter;
import in.spicelabs.game.objects.LevelGenerator;
import in.spicelabs.game.objects.PowerSprite;
import in.spicelabs.game.objects.Sprite;
import in.spicelabs.game.objects.World;
import in.spicelabs.game.objects.WorldListener;
import in.spicelabs.game.objects.XYRect;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Controller
implements WorldListener {
    public static final int DIS_W = Config.SCREEN_WIDTH;
    public static final int DIS_H = Config.SCREEN_HEIGHT;
    private static final int BEGIN_CYCLE_RATE = 60;
    private static final int SCORE_BONUS_FOR_ENEMY_DEFEAT = 1000;
    private static final int GAP = 2;
    private static Controller controller;
    private Copter copter;
    private World world;
    private boolean isGameOver;
    private int cycleRate = 60;
    private int score;
    private int duration;
    private boolean isPaused;
    private boolean isGameStarted;
    private StringBuffer strHighScore = new StringBuffer("");
    private int gameOverType;
    private PowerSprite coin;
    public boolean isresume;

    private Controller() {
        int y = 2;
        this.coin = new PowerSprite(Config.COIN_STATUS, 2, y);
        this.coin.setColor(0xFF0000);
        y += this.coin.rect.height + 2;
    }

    public void draw(Graphics g) {
        if (!this.isPaused && this.isGameStarted) {
            ++this.score;
            this.duration += this.cycleRate;
            this.world.tick();
        }
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.world.draw(g);
        this.coin.draw(g, "" + this.copter.getCoins());
        g.setColor(0xFF0000);
        g.drawString(this.strHighScore.toString(), DIS_W - g.getFont().stringWidth(this.strHighScore.toString()), 2, 0);
        g.drawString("" + this.score, DIS_W - g.getFont().stringWidth("" + this.score) - 2, 4 + g.getFont().getHeight(), 0);
        if (!this.isGameStarted) {
            Vector hintVec = this.wrap("Press SPACE or TAP on the screen to fly the copter.", (int)((double)DIS_W * 0.8), g);
            int x = (int)((double)DIS_W * 0.1);
            int y = this.copter.rect.y + this.copter.rect.height;
            int i = 0;
            while (i < hintVec.size()) {
                String str = (String)hintVec.elementAt(i);
                if (!this.isresume) {
                    g.drawString(str, x, y, 0);
                }
                y += g.getFont().getHeight();
                ++i;
            }
        }
    }

    public static Controller getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    public static int getWorldSpeed() {
        return Controller.controller.world.getSpeed();
    }

    public static int getDurationInSeconds() {
        return Controller.controller.duration / 1000;
    }

    public void startNewGame() {
        this.isGameOver = false;
        this.isPaused = false;
        this.isGameStarted = false;
        this.isresume = false;
        this.score = 0;
        this.duration = 0;
        this.cycleRate = 60;
        int x = DIS_W / 7;
        LevelGenerator.getInstance().reset();
        this.world = new World(new XYRect(0, 0, DIS_W, DIS_H));
        this.world.addListener(this);
        this.copter = new Copter(x, DIS_H - Config.COPTER_FRAMES[0][0].getHeight() >> 1, Config.COPTER_FRAMES, this.world);
        this.copter.setCanConsume(true);
        this.world.setNinja(this.copter);
        this.world.initEnvironment();
    }

    public void resumeGame() {
        this.copter.resume();
        this.world.setShouldStop(false);
        this.isGameOver = false;
        this.isGameStarted = false;
        this.isresume = true;
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getScore() {
        return this.score;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setKeepPropelling(boolean isFlying) {
        if (!this.isGameOver) {
            if (!this.isGameStarted) {
                this.isGameStarted = true;
            }
            this.copter.setFlying(isFlying);
        }
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void gameOver() {
        this.isGameOver = true;
    }

    public void taskAchieved(int taskType) {
        if (taskType == 1001) {
            this.score += 1000;
        }
    }

    public static boolean isOutOfWorld(Sprite sprite) {
        return !Controller.controller.world.intersectWith(sprite.rect);
    }

    public static int getCycleRate() {
        return Controller.controller.cycleRate;
    }

    public static void setCycleRate(int cycleRate) {
        Controller.controller.cycleRate = cycleRate;
    }

    public int getCoins() {
        return this.copter.getCoins();
    }

    public void setCoins(int coins) {
        this.copter.setCoins(coins);
    }

    public void setHighscore(long highscore) {
        this.strHighScore = new StringBuffer("Best: ");
        this.strHighScore.append(highscore);
    }

    private Vector wrap(String text, int width, Graphics g) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = g.getFont().substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }
}

