/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.doodleCopter.screens;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import in.spicelabs.doodleCopter.common.Config;
import in.spicelabs.doodleCopter.midlet.MainMidlet;
import in.spicelabs.doodleCopter.screens.GameOverScreen;
import in.spicelabs.doodleCopter.screens.HomeScreen;
import in.spicelabs.doodleCopter.store.RMSData;
import in.spicelabs.game.objects.Controller;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class GameScreen
extends GameCanvas
implements CommandListener,
Runnable {
    public static GameScreen screen;
    private Controller controller;
    private boolean isGameExited;
    Alert alert;
    private Command backCommand;
    Thread runner;

    public GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.controller = Controller.getController();
        this.controller.setHighscore(RMSData.getScore());
        ++Config.gameCount;
        this.controller.startNewGame();
        this.start();
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-11");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public static GameScreen getinstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    public void paint(Graphics g) {
        this.controller.draw(g);
    }

    public void run() {
        while (!this.controller.isGameOver()) {
            if (this.isGameExited) break;
            this.repaint();
            try {
                Thread.sleep(Controller.getCycleRate());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isGameExited) {
            return;
        }
        int ttlCoins = (int)(RMSData.getClassicGameTotalCoins() + (long)this.controller.getCoins());
        if ((long)ttlCoins >= 500L) {
            this.showConfirmationForCoinReedem("", "You can resume from here by redeeming your 500 coins.", ttlCoins);
        } else {
            Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-11");
            tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.controller.getScore())));
            RMSData.setClassicGameTotalCoins(RMSData.getClassicGameTotalCoins() + (long)this.controller.getCoins());
            if ((long)this.controller.getScore() > RMSData.getScore()) {
                RMSData.setScore(this.controller.getScore());
                MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), this.controller.getCoins(), true));
            } else {
                MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), this.controller.getCoins(), false));
            }
            screen = null;
            this.runner = null;
        }
    }

    public void showConfirmationForCoinReedem(String title, String text, final int ttlCoins) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    int coinsLeft = 0;
                    if (RMSData.getClassicGameTotalCoins() < 500L) {
                        coinsLeft = (int)((long)ttlCoins - 500L);
                        GameScreen.this.controller.setCoins(coinsLeft);
                    }
                    GameScreen.this.controller.resumeGame();
                    GameScreen.this.start();
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
                    long remainingCoins = (long)ttlCoins - 500L - (long)coinsLeft;
                    RMSData.setClassicGameTotalCoins(remainingCoins);
                    GameScreen.this.alert = null;
                }
                if (c.getLabel().equals("No")) {
                    Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-11");
                    tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(GameScreen.this.controller.getScore())));
                    RMSData.setClassicGameTotalCoins(RMSData.getClassicGameTotalCoins() + (long)GameScreen.this.controller.getCoins());
                    if ((long)GameScreen.this.controller.getScore() > RMSData.getScore()) {
                        RMSData.setScore(GameScreen.this.controller.getScore());
                        MainMidlet.display.setCurrent((Displayable)new GameOverScreen(GameScreen.this.controller.getScore(), GameScreen.this.controller.getCoins(), true));
                    } else {
                        MainMidlet.display.setCurrent((Displayable)new GameOverScreen(GameScreen.this.controller.getScore(), GameScreen.this.controller.getCoins(), false));
                    }
                    GameScreen.this.alert = null;
                    screen = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    protected void showNotify() {
        if (!this.controller.isGameOver()) {
            this.controller.setPaused(false);
        }
    }

    protected void hideNotify() {
        if (!this.controller.isGameOver()) {
            this.controller.setPaused(true);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.controller.setKeepPropelling(true);
    }

    protected void pointerReleased(int x, int y) {
        this.controller.setKeepPropelling(false);
    }

    public void commandAction(Command c, Displayable arg1) {
        if (c == this.backCommand) {
            this.showConfirmationYesOrNo(" ", "Are you sure you want to exit?");
            if (!this.controller.isGameOver()) {
                this.controller.setPaused(true);
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        String key1 = this.getKeyName(keyCode);
        if (key1.equals("Space")) {
            this.controller.setKeepPropelling(true);
        }
    }

    protected void showConfirmationYesOrNo(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    GameScreen.this.isGameExited = true;
                    Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-11");
                    tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(GameScreen.this.controller.getScore())));
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    GameScreen.this.runner = null;
                    screen = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
                    GameScreen.this.isGameExited = false;
                    if (!GameScreen.this.controller.isGameOver() && GameScreen.this.controller.isPaused()) {
                        GameScreen.this.controller.setPaused(false);
                    }
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    protected void keyReleased(int keyCode) {
        String key1 = this.getKeyName(keyCode);
        if (key1.equals("Space")) {
            this.controller.setKeepPropelling(false);
        }
    }

    protected void keyPressed(int keyCode) {
        String key1 = this.getKeyName(keyCode);
        if (key1.equals("Space")) {
            this.controller.setKeepPropelling(true);
        }
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                this.controller.setKeepPropelling(true);
            }
        }
        if (!(this.getKeyName(keyCode).equals("2") || this.getKeyName(keyCode).equals("4") || this.getKeyName(keyCode).equals("6"))) {
            this.getKeyName(keyCode).equals("8");
        }
    }
}

