/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import com.spicelabs.eggtoss.screens.Config;
import com.spicelabs.eggtoss.screens.Controller;
import com.spicelabs.eggtoss.screens.GameListener;
import com.spicelabs.eggtoss.screens.GameOverScreen;
import com.spicelabs.eggtoss.screens.HomeScreen;
import com.spicelabs.eggtoss.screens.MainMidlet;
import com.spicelabs.eggtoss.screens.MediaPlayerUtils;
import com.spicelabs.eggtoss.screens.RMSData;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import vInAppAdEngine.VservAd;
import vInAppAdEngine.VservAdListener;
import vInAppAdEngine.VservManager;

public class GameScreen
extends GameCanvas
implements GameListener,
CommandListener,
VservAdListener {
    private Controller controller;
    private boolean isGameExited;
    private int tossCount;
    private static GameScreen screen;
    private Command backCommand;
    Alert alert;
    private VservManager vservManager;
    private VservAd vservAd;
    Image imageAd;
    String textAd;

    public GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.controller = Controller.getController();
        this.controller.setGameListener(this);
        this.controller.setHighscore(RMSData.getScore());
        ++Config.gameCount;
        this.controller.startNewGame();
        this.start();
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.initlize();
    }

    public static GameScreen getInstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    private void initlize() {
        Hashtable<String, String> vservConfigTable = new Hashtable<String, String>();
        vservConfigTable.put("appId", "a9827f50");
        this.vservManager = new VservManager(Config.midlet, vservConfigTable);
        this.vservAd = new VservAd(this);
        this.vservAd.requestAd();
    }

    private void start() {
        new Thread(new Runnable(){

            public void run() {
                while (!GameScreen.this.controller.isGameOver() && !GameScreen.this.controller.isPaused()) {
                    GameScreen.this.repaint();
                    try {
                        Thread.sleep(Controller.getCycleRate());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    private void toss() {
        boolean throwEgg = this.controller.throwEgg();
        if (throwEgg) {
            ++this.tossCount;
        }
    }

    public void paint(Graphics g) {
        this.controller.draw(g);
        g.drawImage(Config.getImage("back.png"), Config.DISPLAY_WIDTH - Config.getImage("back.png").getWidth(), Config.DISPLAY_HEIGHT - Config.getImage("back.png").getHeight(), 0);
        if (this.imageAd != null) {
            g.drawImage(this.imageAd, (Config.DISPLAY_WIDTH - this.imageAd.getWidth()) / 2, 0, 0);
        }
        if (this.textAd != null) {
            g.drawString(this.textAd, (Config.DISPLAY_WIDTH - g.getFont().stringWidth(this.textAd)) / 2, 0, 0);
        }
    }

    public void onGameOver() {
        Hashtable<String, String> vservConfigTableAd = new Hashtable<String, String>();
        vservConfigTableAd.put("zoneId", "2efddbb2");
        vservConfigTableAd.put("showAt", "mid");
        VservManager vservManager = new VservManager(Config.midlet, vservConfigTableAd);
        if ((long)this.controller.getScore() > RMSData.getScore()) {
            MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), true));
        } else {
            MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), false));
        }
        screen = null;
    }

    public void onLevelUp() {
    }

    protected void pointerPressed(int x, int y) {
        if (x > 0 && x < Config.DISPLAY_WIDTH - Config.getImage("back.png").getWidth() && y > 0 && y < Config.DISPLAY_HEIGHT) {
            this.toss();
        }
        if (x > 0 && x < Config.DISPLAY_WIDTH && y > 0 && y < 50 && this.vservAd.hasAction) {
            this.vservAd.handleAdAction();
        }
    }

    protected void pointerReleased(int x, int y) {
        if (x > Config.DISPLAY_WIDTH - Config.getImage("back.png").getWidth() && x < Config.DISPLAY_WIDTH && y > Config.DISPLAY_HEIGHT - Config.getImage("back.png").getHeight()) {
            this.showConfirmationYesOrNo(" ", "Are you sure you want to exit?");
        }
    }

    protected void showConfirmationYesOrNo(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    GameScreen.this.isGameExited = true;
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    screen = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getInstance());
                    GameScreen.this.isGameExited = false;
                    if (!GameScreen.this.controller.isGameOver() && GameScreen.this.controller.isPaused()) {
                        GameScreen.this.controller.setPaused(false);
                        GameScreen.this.start();
                    }
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.showConfirmationYesOrNo(" ", "Are you sure you want to exit?");
            if (!this.controller.isGameOver()) {
                this.controller.setPaused(true);
            }
        }
    }

    public void vservAdReceived(Object obj) {
        if (((VservAd)obj).getAdType().equals("image")) {
            this.imageAd = (Image)((VservAd)obj).getAd();
            System.out.println("image");
        } else if (((VservAd)obj).getAdType().equals("text")) {
            this.textAd = (String)((VservAd)obj).getAd();
            System.out.println("text");
        }
    }

    public void vservAdFailed(Object arg0) {
        System.out.println("not received");
    }

    protected void showNotify() {
        MediaPlayerUtils.getInstance().playMedia("/back.mid", -1);
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-7");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    protected void hideNotify() {
        MediaPlayerUtils.getInstance().stopMedia("/back.mid");
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-7");
        tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.controller.getScore())));
    }

    protected void keyPressed(int keyCode) {
        System.out.println(this.getKeyName(keyCode) + this.getGameAction(keyCode));
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 8: {
                this.toss();
            }
        }
    }
}

