/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.Config;
import com.spicelabs.eggtoss.screens.Controller;
import com.spicelabs.eggtoss.screens.LevelGeneratorListener;
import java.util.Random;

public class LevelGenerator {
    private static Random random = new Random();
    private static LevelGenerator generator;
    private static int lastSpeed;
    private int level;
    private int maxSpeed;
    private int minSpeed;
    private int dyFactor;
    private LevelGeneratorListener listener;

    private LevelGenerator() {
    }

    public static LevelGenerator getInstance() {
        if (generator == null) {
            generator = new LevelGenerator();
        }
        return generator;
    }

    public void setListener(LevelGeneratorListener listener) {
        this.listener = listener;
    }

    public static void increamentLevel() {
        ++LevelGenerator.generator.level;
        generator.resetFactors();
        generator.notifyListener();
    }

    public static void reset() {
        LevelGenerator.generator.level = 0;
        generator.resetFactors();
        LevelGenerator.generator.maxSpeed = Controller.DIS_H / 40;
        LevelGenerator.generator.minSpeed = Controller.DIS_H / 80;
    }

    private void resetFactors() {
        switch (this.level / 10) {
            case 0: {
                this.maxSpeed = Controller.DIS_H / 40;
                break;
            }
            case 1: {
                this.maxSpeed = Controller.DIS_H / 35;
                break;
            }
            case 2: {
                this.maxSpeed = Controller.DIS_H / 30;
                break;
            }
            case 3: {
                this.dyFactor = Config.NEST[0].getHeight() >> 2;
                break;
            }
            case 4: {
                this.maxSpeed = Controller.DIS_H / 25;
                break;
            }
            case 6: {
                this.maxSpeed = Controller.DIS_H / 20;
                break;
            }
            case 7: {
                this.dyFactor *= 2;
                break;
            }
            case 8: {
                this.maxSpeed = Controller.DIS_H / 15;
                break;
            }
            case 9: {
                this.maxSpeed = Controller.DIS_H / 10;
                break;
            }
            case 10: {
                this.dyFactor *= 2;
                break;
            }
            case 11: {
                this.maxSpeed = Controller.DIS_H / 5;
            }
        }
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.onLevelUp();
        }
    }

    public static int getSpeed() {
        int nextInt = random.nextInt(LevelGenerator.generator.maxSpeed - LevelGenerator.generator.minSpeed);
        switch (nextInt) {
            case 0: {
                if (lastSpeed == 0) {
                    lastSpeed = LevelGenerator.generator.minSpeed;
                    break;
                }
                lastSpeed = 0;
                break;
            }
            default: {
                lastSpeed = LevelGenerator.generator.minSpeed + nextInt;
            }
        }
        return lastSpeed;
    }

    public static int getDyFactor() {
        if (LevelGenerator.generator.dyFactor > 0) {
            return random.nextInt(2) > 0 ? random.nextInt(LevelGenerator.generator.dyFactor) : 0;
        }
        return 0;
    }
}

