/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.AnimatableSprite;
import com.spicelabs.eggtoss.screens.Config;
import com.spicelabs.eggtoss.screens.Controller;
import com.spicelabs.eggtoss.screens.Egg;
import com.spicelabs.eggtoss.screens.LevelGenerator;
import com.spicelabs.eggtoss.screens.Line2D;
import com.spicelabs.eggtoss.screens.Nest;
import com.spicelabs.eggtoss.screens.Sprite;
import com.spicelabs.eggtoss.screens.WorldListener;
import com.spicelabs.eggtoss.screens.XYRect;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class World
extends AnimatableSprite {
    static final int STATE_NORMAL = 1;
    static final int STATE_ANIMATION = 2;
    private WorldListener listener;
    private Random random = new Random();
    private int speed = 30;
    int leftBoundary = 0;
    int rightBoundary;
    private Vector nestQueue = new Vector();
    public static final int DEF_ONE_THIRD = Controller.DIS_H / 3;
    private static final int temp = DEF_ONE_THIRD / 4;
    private int distanceToShift;
    private boolean isShifting;
    private int state;
    private Egg egg;

    public World(XYRect rect) {
        super(rect, null);
        this.rightBoundary = rect.width;
        this.state = 1;
    }

    public void initEnvironment(Egg egg) {
        this.egg = egg;
        int y = 2 * temp + 2 * DEF_ONE_THIRD;
        int x = this.rect.width - Config.NEST[0].getWidth() >> 1;
        Nest nest = new Nest(new Line2D(x, y, this.rect.width, y), 0, true, this);
        nest.setEgg(egg);
        this.nestQueue.addElement(nest);
        y = 2 * temp + DEF_ONE_THIRD;
        this.nestQueue.addElement(new Nest(new Line2D(x, y, this.rect.width, y), LevelGenerator.getSpeed(), false, this));
        y = 2 * temp;
        this.nestQueue.addElement(new Nest(new Line2D(0.0f, y, this.rect.width, y), LevelGenerator.getSpeed(), false, this));
    }

    protected void draw(Graphics g) {
        int j = this.nestQueue.size() - 1;
        while (j >= 0) {
            Sprite sp = (Sprite)this.nestQueue.elementAt(j);
            sp.tick();
            sp.draw(g);
            --j;
        }
        super.draw(g);
    }

    protected void tick() {
        this.checkIfStartShifting();
        if (this.isShifting) {
            int j = this.nestQueue.size() - 1;
            int dx = temp >> 1;
            while (j >= 0) {
                Sprite sp = (Sprite)this.nestQueue.elementAt(j);
                if (sp instanceof Nest) {
                    Nest nst = (Nest)sp;
                    nst.getPath().translate(0.0f, dx);
                } else {
                    sp.rect.y += dx;
                }
                --j;
            }
            this.distanceToShift -= dx;
            if (this.distanceToShift <= 0) {
                this.isShifting = false;
                this.state = 1;
            }
        }
    }

    private void checkIfStartShifting() {
        Nest nest;
        if (!this.isShifting && (this.isShifting = (nest = (Nest)this.nestQueue.elementAt(1)).hasEgg())) {
            int x = this.random.nextInt(this.rect.width - Config.NEST[0].getWidth());
            int y = nest.rect.y - 2 * DEF_ONE_THIRD;
            int dy = LevelGenerator.getDyFactor();
            if (dy > 0) {
                x = nest.rect.x;
            }
            int i = this.random.nextInt(2);
            this.nestQueue.addElement(new Nest(new Line2D(x, y + (i == 0 ? dy : 0), this.rect.width, y + (i != 0 ? dy : 0)), LevelGenerator.getSpeed(), false, this));
            this.distanceToShift = DEF_ONE_THIRD;
        }
    }

    public Vector getNestQueue() {
        return this.nestQueue;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void addListener(WorldListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void removeNest(Nest nest) {
        if (nest != null && this.nestQueue.contains(nest)) {
            this.nestQueue.removeElement(nest);
        }
    }

    public void notifyGameOver(int type) {
        if (this.listener != null && !Controller.getController().isGameOver()) {
            this.listener.gameOver(type);
        }
    }

    public boolean throwEgg() {
        if (this.state == 1 && this.egg.isCaught()) {
            this.state = 2;
            int j = this.nestQueue.size() - 1;
            while (j >= 0) {
                Nest sp = (Nest)this.nestQueue.elementAt(j);
                if (sp.hasEgg()) {
                    sp.throwEgg();
                    return true;
                }
                --j;
            }
        }
        return false;
    }
}

