/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.Config;
import com.spicelabs.eggtoss.screens.FallableSprite;
import com.spicelabs.eggtoss.screens.Nest;
import com.spicelabs.eggtoss.screens.World;
import com.spicelabs.eggtoss.screens.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Egg
extends FallableSprite {
    public static final int STATE_SETTLE = 64;
    private int frequency;
    private Image[] frames = this.getFramesForCurrentState();
    private int frameCount;
    private boolean canBeCatch = true;
    private int life = 12;

    public Egg(int x, int y, World world) {
        super(new XYRect(x, y, Config.EGG[0][0].getWidth(), Config.EGG[0][0].getHeight()), world);
    }

    protected void draw(Graphics g) {
        g.drawImage(this.frames[this.frameCount], this.getAbsoluteX(), this.getAbsoluteY(), 0);
        super.draw(g);
    }

    private Image[] getFramesForCurrentState() {
        switch (this.state) {
            case 2: 
            case 4: {
                return Config.EGG[0];
            }
            case 64: {
                return Config.EGG[1];
            }
        }
        return new Image[]{Config.EGG[0][0]};
    }

    protected void tick() {
        ++this.frameCount;
        this.frameCount %= this.frames.length;
        super.tick();
    }

    public void setCaughtBy(Nest nest) {
        if (nest != null) {
            this.setState(1);
            this.setParent(nest);
            this.setCanBeCatch(true);
        }
    }

    public void setCanBeCatch(boolean canBeCatch) {
        this.canBeCatch = canBeCatch;
    }

    public boolean isCanBeCatch() {
        return this.canBeCatch;
    }

    public boolean isCaught() {
        return this.state == 1;
    }

    public boolean isFalling() {
        return this.state == 4;
    }

    public void throughTillHeight(int height) {
        this.setState(2);
        this.velocityY = (int)Math.sqrt(2 * this.mass * 2 * height);
    }

    public void setState(int state) {
        super.setState(state);
        this.frames = this.getFramesForCurrentState();
        this.frameCount = 0;
    }

    public int getLife() {
        return this.life;
    }

    public void decrementLife() {
        --this.life;
    }
}

