/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.common.Config;
import in.spicelabs.hippojump.objects.GameListener;
import in.spicelabs.hippojump.objects.Hippo;
import in.spicelabs.hippojump.objects.LevelGenerator;
import in.spicelabs.hippojump.objects.LevelGeneratorListener;
import in.spicelabs.hippojump.objects.Sprite;
import in.spicelabs.hippojump.objects.World;
import in.spicelabs.hippojump.objects.WorldListener;
import in.spicelabs.hippojump.objects.XYRect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Controller
implements WorldListener,
LevelGeneratorListener {
    public static final int DIS_W = Config.SCREEN_WIDTH;
    public static final int DIS_H = Config.SCREEN_HEIGHT;
    private static final int BEGIN_CYCLE_RATE = 45;
    private static final int HIPPO_H_VELOCITY = DIS_W / 50;
    private static Controller controller;
    private World world;
    private boolean isGameOver;
    private int cycleRate = 45;
    private int duration;
    private boolean isPaused;
    private int gameOverType;
    private GameListener gameListener;
    private StringBuffer strHighScore = new StringBuffer();
    private Hippo hippo;

    private Controller() {
    }

    public void draw(Graphics g) {
        if (this.isPaused) {
            return;
        }
        g.drawImage(Config.BG, 0, 0, 0);
        this.duration += this.cycleRate;
        this.world.tick();
        this.world.draw(g);
        g.setFont(Font.getFont((int)0, (int)0, (int)0));
        g.setColor(0xFFFFFF);
        int h = g.getFont().getHeight();
        g.setColor(0);
        String score = "" + this.world.getScore();
        g.drawString(score, DIS_W - g.getFont().stringWidth(score) - (h >> 1), h >> 1, 0);
        g.drawString(this.strHighScore.toString(), h >> 1, h >> 1, 0);
    }

    public static Controller getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    public void setGameListener(GameListener gameListener) {
        this.gameListener = gameListener;
    }

    public static int getDurationInSeconds() {
        return Controller.controller.duration / 1000;
    }

    public void startNewGame() {
        this.isGameOver = false;
        this.isPaused = false;
        this.duration = 0;
        this.cycleRate = 45;
        LevelGenerator.getInstance().setListener(this);
        LevelGenerator.reset();
        this.world = new World(new XYRect(0, 0, DIS_W, DIS_H));
        this.world.addListener(this);
        this.hippo = new Hippo(0, 0, this.world);
        this.world.initEnvironment(this.hippo);
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getScore() {
        return this.world.getScore();
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void gameOver(int type) {
        this.isGameOver = true;
        if (this.gameListener != null) {
            switch (type) {
                case 0: {
                    this.gameListener.onGameOver();
                }
            }
        }
        this.gameOverType = type;
    }

    public static boolean isOutOfWorld(Sprite sprite) {
        return !Controller.controller.world.intersectWith(sprite.rect);
    }

    public static int getCycleRate() {
        return Controller.controller.cycleRate;
    }

    public static void setCycleRate(int cycleRate) {
        Controller.controller.cycleRate = cycleRate;
    }

    public boolean throwEgg() {
        return this.world.throwEgg();
    }

    public void moveHippoWithSpeed(int dx) {
        int n = dx = dx > 0 ? HIPPO_H_VELOCITY : -HIPPO_H_VELOCITY;
        if (this.hippo.isInState(4) || this.hippo.isInState(2)) {
            int temp = this.hippo.velocityX + dx;
            if (temp > HIPPO_H_VELOCITY) {
                temp = HIPPO_H_VELOCITY;
            } else if (temp < -HIPPO_H_VELOCITY) {
                temp = -HIPPO_H_VELOCITY;
            }
            this.hippo.velocityX = temp;
        }
    }

    public void setHighscore(long highscore) {
        this.strHighScore = new StringBuffer();
        this.strHighScore.append(highscore);
    }

    public int getGameOverType() {
        return this.gameOverType;
    }

    public void onLevelUp() {
    }
}

