/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme;

import com.emobtech.googleanalyticsme.util.PropertyStore;
import java.util.Random;

final class Session {
    private final String storeName;
    private final String appId;
    private final int domainHash;
    private int userId;
    private long firstVisitTimestamp;
    private long lastVisitTimestamp;
    private long currentVisitTimestamp;
    private int visitNumber;
    private long lastRequestTimestamp;

    private static long nowInSecs() {
        return System.currentTimeMillis() / 1000L;
    }

    Session(String appId) {
        this.appId = appId;
        this.domainHash = appId.hashCode();
        this.storeName = appId + "_v11";
        this.load();
    }

    void updateLastRequestTimestamp() {
        this.lastRequestTimestamp = Session.nowInSecs();
        this.save();
    }

    void renewIfExpired() {
        if (this.isExpired()) {
            ++this.visitNumber;
            this.lastVisitTimestamp = this.currentVisitTimestamp;
            this.lastRequestTimestamp = this.currentVisitTimestamp = Session.nowInSecs();
            this.save();
        }
    }

    boolean isExpired() {
        long SESSION_EXPIRES_IN = 1800L;
        long elapsed = Session.nowInSecs() - this.lastRequestTimestamp;
        return elapsed >= 1800L;
    }

    String getAppId() {
        return this.appId;
    }

    int getDomainHash() {
        return this.domainHash;
    }

    int getUserId() {
        return this.userId;
    }

    long getFirstVisitTimestamp() {
        return this.firstVisitTimestamp;
    }

    long getLastVisitTimestamp() {
        return this.lastVisitTimestamp;
    }

    long getCurrentVisitTimestamp() {
        return this.currentVisitTimestamp;
    }

    int getVisitNumber() {
        return this.visitNumber;
    }

    private void load() {
        PropertyStore prefs = new PropertyStore(this.storeName);
        if (prefs.size() > 0) {
            this.userId = prefs.getInt("userId");
            this.firstVisitTimestamp = prefs.getLong("firstVisitTimestamp");
            this.lastVisitTimestamp = prefs.getLong("lastVisitTimestamp");
            this.currentVisitTimestamp = prefs.getLong("currentVisitTimestamp");
            this.visitNumber = prefs.getInt("visitNumber");
            this.lastRequestTimestamp = prefs.getLong("lastRequestTimestamp");
        } else {
            Random r = new Random(System.currentTimeMillis());
            r.nextInt();
            r.nextInt();
            r.nextInt();
            this.userId = Math.abs(r.nextInt());
            this.firstVisitTimestamp = this.currentVisitTimestamp = Session.nowInSecs();
            this.lastVisitTimestamp = this.currentVisitTimestamp;
            this.lastRequestTimestamp = this.currentVisitTimestamp;
            this.visitNumber = 1;
            this.save();
        }
    }

    private void save() {
        PropertyStore prefs = new PropertyStore(this.storeName);
        prefs.putInt("userId", this.userId);
        prefs.putLong("firstVisitTimestamp", this.firstVisitTimestamp);
        prefs.putLong("lastVisitTimestamp", this.lastVisitTimestamp);
        prefs.putLong("currentVisitTimestamp", this.currentVisitTimestamp);
        prefs.putInt("visitNumber", this.visitNumber);
        prefs.putLong("lastRequestTimestamp", this.lastRequestTimestamp);
        prefs.save();
    }
}

