/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.common.Config;
import in.spicelabs.hippojump.objects.AnimatableSprite;
import in.spicelabs.hippojump.objects.Branch;
import in.spicelabs.hippojump.objects.Controller;
import in.spicelabs.hippojump.objects.Hippo;
import in.spicelabs.hippojump.objects.LevelGenerator;
import in.spicelabs.hippojump.objects.Monster;
import in.spicelabs.hippojump.objects.Sprite;
import in.spicelabs.hippojump.objects.WorldListener;
import in.spicelabs.hippojump.objects.XYRect;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World
extends AnimatableSprite {
    static final int STATE_NORMAL = 1;
    static final int STATE_ANIMATION = 2;
    public static final int HIPPO_JUMP_H = Controller.DIS_W > Controller.DIS_H ? Controller.DIS_H / 3 : Controller.DIS_W / 3;
    public static int hippo_upper_bound;
    private WorldListener listener;
    private Random random = new Random();
    int leftBoundary = 0;
    int rightBoundary;
    private Vector branchQueue = new Vector();
    private int state;
    private Hippo hippo;
    private int score;

    public World(XYRect rect) {
        super(rect, null);
        this.rightBoundary = rect.width;
        this.state = 1;
    }

    public void initEnvironment(Hippo hippo) {
        this.hippo = hippo;
        int y = Controller.DIS_H - 3 * (Config.BRANCH[0].getHeight() >> 1);
        int x = this.rect.width - Config.BRANCH[0].getWidth() >> 1;
        Branch branch = new Branch(x, y, 0, true, 0, this);
        hippo.rect.y = y - hippo.rect.height + (Config.BRANCH[0].getHeight() >> 3);
        hippo.rect.x = x + (branch.rect.width - hippo.rect.width >> 1);
        hippo_upper_bound = hippo.getAbsoluteY() - HIPPO_JUMP_H;
        this.branchQueue.addElement(branch);
        this.appendBranches();
    }

    protected void draw(Graphics g) {
        int j = this.branchQueue.size() - 1;
        while (j >= 0) {
            Sprite sp = (Sprite)this.branchQueue.elementAt(j);
            sp.tick();
            sp.draw(g);
            --j;
        }
        this.hippo.draw(g);
        super.draw(g);
    }

    protected void tick() {
        LevelGenerator.getInstance().tick();
        this.hippo.tick();
        this.landHippo();
        this.isHitWithMonster();
    }

    private boolean isHitWithMonster() {
        if (this.hippo != null && !this.hippo.isFalling() && !this.hippo.isInState(64)) {
            Enumeration e = this.branchQueue.elements();
            while (e.hasMoreElements()) {
                Sprite sp = (Sprite)e.nextElement();
                XYRect rect = new XYRect(sp.rect);
                rect.overlap(this.hippo.rect);
                if (!(sp instanceof Monster) || !this.hippo.intersectWith(((Monster)sp).getCollisionRect())) continue;
                this.hippo.setState(64);
                return true;
            }
        }
        return false;
    }

    private boolean landHippo() {
        if (this.hippo != null && this.hippo.isFalling() && !this.hippo.isInState(64)) {
            Enumeration e = this.branchQueue.elements();
            while (e.hasMoreElements()) {
                Sprite sp = (Sprite)e.nextElement();
                if (this.hippo.rect.y >= sp.rect.y || !(sp instanceof Branch) || !this.isHippoLands(sp)) continue;
                Branch branch = (Branch)sp;
                if (branch.getType() == 1) {
                    branch.startBreaking();
                } else {
                    branch.setFlicked(true);
                    this.hippo.throughTillHeight(branch.getType() == 3 ? 3 * HIPPO_JUMP_H : HIPPO_JUMP_H);
                    if (branch.getType() == 3) {
                        branch.openSpring();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isHippoLands(Sprite sp) {
        XYRect rect = new XYRect(sp.rect);
        rect.overlap(this.hippo.rect);
        if (this.hippo.rect.y < rect.y && rect.width >= this.hippo.rect.width / 4 && rect.height > 0 && rect.height >= this.hippo.rect.height >> 3) {
            return true;
        }
        rect.set(sp.rect);
        XYRect rect2 = new XYRect(this.hippo.rect);
        rect2.y += this.hippo.velocityY;
        int temp = 3 * (rect2.width >> 2);
        if (rect2.x > rect.x - temp && rect2.x + rect2.width < rect.x + rect.width + temp && rect2.y > rect.y) {
            this.hippo.velocityY >>= 1;
        }
        return false;
    }

    public void rollWorldWithSpeed(int speed) {
        ++this.score;
        Enumeration e = this.branchQueue.elements();
        while (e.hasMoreElements()) {
            Sprite object = (Sprite)e.nextElement();
            object.rect.y += speed;
        }
        this.appendBranches();
    }

    private void appendBranches() {
        Sprite sp = (Sprite)this.branchQueue.lastElement();
        while (sp.rect.y > 0) {
            int x = this.random.nextInt(this.rect.width - Config.BRANCH[0].getWidth());
            int type = LevelGenerator.getNestType();
            int nestSpeed = type == 2 ? LevelGenerator.getSpeed() : 0;
            int y = sp.rect.y - LevelGenerator.getGap() - Config.BRANCH[0].getHeight();
            if (sp instanceof Branch && ((Branch)sp).getType() == 3) {
                y -= Config.SPRING[0].getHeight();
            }
            Branch branch = new Branch(x, y, nestSpeed, false, type, this);
            this.branchQueue.addElement(branch);
            sp = branch;
            if (!LevelGenerator.getInstance().canAddMonster()) continue;
            Image[] frms = Config.ENEMY_OWL;
            x = this.random.nextInt(this.rect.width - frms[0].getWidth());
            y -= LevelGenerator.getGap() + frms[0].getHeight();
            int temp = (frms[0].getHeight() - 2 * Config.BRANCH[0].getHeight()) / 3;
            if (x > Config.BRANCH[0].getWidth()) {
                this.branchQueue.addElement(new Branch(this.random.nextInt(x - Config.BRANCH[0].getWidth()), y - 2 * temp - Config.BRANCH[0].getHeight(), 0, false, 0, this));
                this.branchQueue.addElement(new Branch(this.random.nextInt(x - Config.BRANCH[0].getWidth()), y - temp, 0, false, 0, this));
            }
            if (Controller.DIS_W - x - frms[0].getWidth() > Config.BRANCH[0].getWidth()) {
                int xx = Controller.DIS_W - x - frms[0].getWidth() - Config.BRANCH[0].getWidth();
                this.branchQueue.addElement(new Branch(x + frms[0].getWidth() + this.random.nextInt(xx), y - 2 * temp - Config.BRANCH[0].getHeight(), 0, false, 0, this));
                this.branchQueue.addElement(new Branch(x + frms[0].getWidth() + this.random.nextInt(xx), y - temp, 0, false, 0, this));
            }
            Monster monster = new Monster(x, y, frms, 0, this);
            this.branchQueue.addElement(monster);
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public void addListener(WorldListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void removeSprite(Sprite sp) {
        if (sp != null && this.branchQueue.contains(sp)) {
            this.branchQueue.removeElement(sp);
        }
    }

    public void notifyGameOver(int type) {
        if (this.listener != null && !Controller.getController().isGameOver()) {
            this.listener.gameOver(type);
        }
    }

    public boolean throwEgg() {
        if (this.state == 1 && this.hippo.isCaught()) {
            this.state = 2;
            this.hippo.throughTillHeight(HIPPO_JUMP_H);
            ((Branch)this.branchQueue.elementAt(0)).setFlicked(true);
        }
        return false;
    }

    public int getScore() {
        return this.score;
    }
}

