/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.screen;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import in.spicelabs.hippojump.common.Config;
import in.spicelabs.hippojump.midlet.MainMidlet;
import in.spicelabs.hippojump.objects.Controller;
import in.spicelabs.hippojump.objects.GameListener;
import in.spicelabs.hippojump.screen.GameOverScreen;
import in.spicelabs.hippojump.screen.HomeScreen;
import in.spicelabs.hippojump.store.RMSData;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class GameScreen
extends GameCanvas
implements GameListener,
CommandListener {
    public static GameScreen screen;
    private Controller controller;
    private boolean isGameStarted;
    private Command backCommand;
    int startxpoint;
    int startyPoint;
    boolean isfirstToss = true;
    Alert alert;

    protected GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.controller = Controller.getController();
        this.controller.setGameListener(this);
        ++Config.gameCount;
        this.controller.setHighscore(RMSData.getScore());
        this.controller.startNewGame();
        this.start();
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-15");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    public static GameScreen getInstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    private void start() {
        new Thread(new Runnable(){

            public void run() {
                while (!GameScreen.this.controller.isGameOver() && !GameScreen.this.controller.isPaused()) {
                    GameScreen.this.repaint();
                    try {
                        Thread.sleep(Controller.getCycleRate());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    public void paint(Graphics g) {
        this.controller.draw(g);
    }

    private void toss() {
        if (this.isGameStarted) {
            return;
        }
        boolean throwEgg = this.controller.throwEgg();
        this.isGameStarted = true;
    }

    protected void pointerReleased(int x, int y) {
        int xdiff = x - this.startxpoint;
        int ydiff = y - this.startyPoint;
        if (Math.abs(xdiff) > Math.abs(ydiff)) {
            if (xdiff > 0) {
                this.controller.moveHippoWithSpeed(1);
            } else {
                this.controller.moveHippoWithSpeed(-1);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        this.startxpoint = x;
        this.startyPoint = y;
        if (this.isfirstToss) {
            System.out.println("isfirsttoss");
            this.toss();
            this.isfirstToss = false;
        }
    }

    protected void hideNotify() {
        if (!this.controller.isGameOver()) {
            this.controller.setPaused(true);
        }
    }

    protected void showNotify() {
        if (!this.controller.isGameOver() && this.controller.isPaused()) {
            this.controller.setPaused(false);
            this.start();
        }
    }

    public void onGameOver() {
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-15");
        tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.controller.getScore())));
        screen = null;
        if ((long)this.controller.getScore() > RMSData.getScore()) {
            MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), true));
        } else {
            MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), false));
        }
    }

    public void onLevelUp() {
    }

    protected void keyPressed(int keyCode) {
        String key = this.getKeyName(keyCode);
        int gameAction = this.getGameAction(keyCode);
        System.out.println("key" + key + " " + gameAction);
        if (key.equals("4") || gameAction == 2 || key.equals("q")) {
            this.controller.moveHippoWithSpeed(-1);
        } else if (key.equals("6") || gameAction == 5 || key.equals("p")) {
            this.controller.moveHippoWithSpeed(1);
        } else if (key.equals("5") || gameAction == 8 || key.equals("Space") || key.equals("Enter") || key.equals("g")) {
            this.toss();
        }
    }

    public void commandAction(Command c, Displayable arg1) {
        if (c == this.backCommand) {
            this.showConfirmationYesOrNo(" ", "Are you sure you want to exit?");
        }
    }

    protected void showConfirmationYesOrNo(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    screen = null;
                    GameScreen.this.alert = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getInstance());
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }
}

