/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.common.Config;
import in.spicelabs.jpride.objects.AttackableSprite;
import in.spicelabs.jpride.objects.Controller;
import in.spicelabs.jpride.objects.FallableSprite;
import in.spicelabs.jpride.objects.Sprite;
import in.spicelabs.jpride.objects.World;
import in.spicelabs.jpride.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FireBall
extends FallableSprite
implements AttackableSprite {
    public static final int TYPE_MISSILE = 0;
    protected int speed = Controller.DIS_W / 20;
    protected int direction;
    protected Image[] frames;
    private boolean canHit = true;

    public FireBall(int x, int y, int direction, int type, World world) {
        this(x, y, direction, FireBall.getFrames(type), world);
    }

    public FireBall(int x, int y, int direction, Image[] frames, World world) {
        super(new XYRect(x, y, frames[0].getWidth(), frames[0].getHeight()), world);
        this.frames = frames;
        this.direction = direction;
        this.addState(2);
    }

    private static Image[] getFrames(int type) {
        switch (type) {
            case 0: {
                return Config.ROCKET;
            }
        }
        return Config.ROCKET;
    }

    protected void draw(Graphics g) {
        if (this.rect.x > Controller.DIS_W) {
            if (this.rect.x < 2 * Controller.DIS_W) {
                int color = g.getColor();
                g.setColor(0xFF0000);
                g.drawString("!!!", Controller.DIS_W - g.getFont().stringWidth("!!!"), this.rect.y, 0);
                g.setColor(color);
            }
        } else {
            g.drawImage(this.frames[this.frameCount], this.rect.x, this.rect.y, 0);
        }
    }

    public XYRect getCollisionRect() {
        int dx = this.rect.width / 10;
        int dy = this.rect.height / 5;
        return new XYRect(this.rect.x + dx, this.rect.y + dy, this.rect.width - 2 * dx, this.rect.height - dy);
    }

    protected void tick() {
        if (this.frames != null) {
            ++this.frameCount;
            this.frameCount %= this.frames.length;
        }
        switch (this.direction) {
            case 1: {
                this.rect.x -= this.speed;
                break;
            }
            case 2: {
                this.rect.x += this.speed;
                break;
            }
            case 3: {
                this.rect.y -= this.speed;
                break;
            }
            case 4: {
                this.rect.y += this.speed;
            }
        }
        if (this.isOnTheBase()) {
            this.notifyRemoval();
        }
        switch (this.direction) {
            case 1: {
                if (this.rect.x > -this.rect.height) break;
                this.notifyRemoval();
                break;
            }
            case 4: {
                if (this.rect.y <= Controller.DIS_H) break;
                this.notifyRemoval();
                break;
            }
            case 2: {
                if (this.rect.x <= Controller.DIS_W) break;
                this.notifyRemoval();
                break;
            }
            case 3: {
                if (this.rect.y >= -this.rect.y) break;
                this.notifyRemoval();
            }
        }
        super.tick();
    }

    public void setCanHit(boolean canHit) {
        if (this.canHit) {
            this.canHit = canHit;
        }
    }

    public void addState(int state) {
    }

    public boolean beingAttacked(Sprite sprite) {
        if (this.canHit) {
            this.notifyRemoval();
            return true;
        }
        return false;
    }

    private void notifyRemoval() {
        this.world.removeSprite(this);
    }
}

