/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.app.GeneralFunction;
import com.twistfuture.general.SoundManger;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ninja {
    private static Image[] img_Running_Ninja;
    public static Image[] img_Sliding_Ninja;
    private static final Image[] img_gameOver;
    private Image imgNinja;
    private int width;
    private int height;
    private float X;
    private float Y;
    private float lastX;
    private float lastY;
    private int currentImage;
    private boolean slidingStatus;
    private boolean jumpStatus;
    private final float gravity;
    private float drivingForce;
    private int floorY;
    int ninjaCount;
    int count;
    private boolean jumpUpStatus;
    private boolean jumpDownStatus;

    public Ninja(int floorY) {
        this.gravity = 0.8f;
        this.imgNinja = img_Running_Ninja[this.currentImage];
        this.height = this.imgNinja.getHeight();
        this.width = this.imgNinja.getWidth();
        this.floorY = floorY;
        this.Y = floorY - this.height;
        this.lastY = this.Y + (float)this.height;
        this.lastX = 68.0f;
        this.X = this.lastX - (float)this.width;
    }

    public void paint(Graphics g) {
        g.drawImage(this.imgNinja, (int)this.X, (int)this.Y, 0);
    }

    public void pointerPressed(int x, int y) {
        if (!this.slidingStatus && !this.jumpStatus) {
            SoundManger.playAudioSound.PlaySample("sounds/touch.mp3", false, 1, "audio/mpeg");
            this.slidingStatus = false;
            this.jumpStatus = true;
            this.jumpUpStatus = true;
            this.drivingForce = 12.0f;
        }
    }

    public void update() {
        if (!this.slidingStatus && !this.jumpStatus) {
            this.imgNinja = img_Running_Ninja[this.currentImage];
        } else if (this.slidingStatus) {
            this.slideNinja();
        }
        this.height = this.imgNinja.getHeight();
        this.width = this.imgNinja.getWidth();
        this.X = this.lastX - (float)this.width;
        if (this.jumpStatus) {
            this.jump();
        }
        this.currentImage = this.currentImage < 4 ? ++this.currentImage : 0;
    }

    private void slideNinja() {
        ++this.count;
        this.Y = this.floorY - this.imgNinja.getHeight() + 3;
        this.imgNinja = img_Sliding_Ninja[0];
        if (this.count % 20 == 0) {
            this.slidingStatus = false;
            this.count = 0;
            this.Y = this.floorY - img_Running_Ninja[0].getHeight();
        }
        this.lastY = this.Y + (float)this.imgNinja.getHeight();
    }

    private void jump() {
        this.imgNinja = img_Running_Ninja[4];
        if (this.jumpUpStatus) {
            this.jumpUp();
        } else if (this.jumpDownStatus) {
            this.fallDown();
        }
    }

    private void jumpUp() {
        this.Y -= this.drivingForce;
        this.lastY -= this.drivingForce;
        this.drivingForce -= 0.8f;
        if (this.drivingForce <= 0.0f) {
            this.jumpUpStatus = false;
            this.jumpDownStatus = true;
        }
    }

    private void fallDown() {
        if (this.Y + this.drivingForce >= (float)(this.floorY - this.height)) {
            this.jumpStatus = false;
            this.jumpDownStatus = false;
            this.Y = this.floorY - this.height;
            this.lastY = this.floorY;
        } else {
            this.Y += this.drivingForce;
            this.lastY += this.drivingForce;
            this.drivingForce += 0.8f;
        }
    }

    public Image getImgNinja() {
        return this.imgNinja;
    }

    public void setImgNinja(Image imgNinja) {
        this.imgNinja = imgNinja;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getX() {
        return this.X;
    }

    public float getY() {
        return this.Y;
    }

    public float getLastX() {
        return this.lastX;
    }

    public float getLastY() {
        return this.lastY;
    }

    void gameOver(int count) {
        this.imgNinja = img_gameOver[count];
    }

    static {
        int i;
        img_Running_Ninja = new Image[5];
        img_Sliding_Ninja = new Image[2];
        img_gameOver = new Image[10];
        for (i = 0; i < img_Running_Ninja.length; ++i) {
            Ninja.img_Running_Ninja[i] = GeneralFunction.createImage("maincanvas/ninja/" + i + ".png");
        }
        for (i = 0; i < img_Sliding_Ninja.length; ++i) {
            Ninja.img_Sliding_Ninja[i] = GeneralFunction.createImage("maincanvas/ninja/slide" + i + ".png");
        }
        for (i = 0; i < img_gameOver.length; ++i) {
            Ninja.img_gameOver[i] = GeneralFunction.createImage("maincanvas/gameover/" + i + ".png");
        }
    }
}

