/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.general.SoundManger;
import com.twistfuture.utility.Button;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ScoreCanvas
extends Canvas
implements Button.ButtonCallback,
TwistMidlet.Callback {
    private final Image bg;
    private final String[] btnNames = new String[]{"menu", "replay", "share"};
    private final Button[] buttons;
    private final int btnLenght;
    private float bestScore;
    private final float score;
    private RecordStore recordStore;
    private boolean gameStatus;
    private Image ninjaTextImage;
    private Image hintImage;
    private int gameMode;
    Font font = Font.getFont((int)0, (int)1, (int)16);

    public ScoreCanvas(float score, int gameMode) {
        this.setFullScreenMode(true);
        this.gameMode = gameMode;
        this.score = score;
        this.openRecordStore();
        this.setRecord(gameMode);
        this.btnLenght = this.btnNames.length;
        this.buttons = new Button[this.btnLenght];
        this.ninjaTextImage = GeneralFunction.createImage("scorecanvas/ninja.png");
        this.bg = GeneralFunction.createImage("mainmenu/bg.png");
        for (int i = 0; i < this.btnLenght; ++i) {
            this.buttons[i] = new Button(GeneralFunction.createImage("scorecanvas/" + this.btnNames[i] + ".png"), i, i, i, this);
            int x = (this.getWidth() / 3 - this.buttons[i].getWidth()) / 2 + i * this.getWidth() / 3;
            int y = this.getHeight() - 80;
            this.buttons[i].SetCordinate(x, y);
        }
        this.hintImage = this.gameStatus ? GeneralFunction.createImage("scorecanvas/newscore.png") : GeneralFunction.createImage("scorecanvas/betterluck.png");
        if (this.gameStatus) {
            SoundManger.playAudioSound.PlaySample("sounds/cheer.mp3", false, 1, "audio/mpeg");
        }
    }

    protected void showNotify() {
        TwistMidlet.mMidlet.registerForDown(this);
        TwistMidlet.mMidlet.registerForUP(this);
    }

    private void openRecordStore() {
        try {
            int i;
            this.recordStore = RecordStore.openRecordStore((String)"ninja", (boolean)true);
            String str = String.valueOf(this.bestScore);
            byte[] b = str.getBytes();
            if (this.recordStore.getNumRecords() <= 0) {
                for (i = 0; i < 3; ++i) {
                    this.recordStore.addRecord(b, 0, b.length);
                }
            }
            this.bestScore = 0.0f;
            str = String.valueOf(this.bestScore);
            b = str.getBytes();
            for (i = 3; i < 15; ++i) {
                this.recordStore.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void setRecord(int index) {
        this.getRecord(index);
        this.gameStatus = this.score > this.bestScore;
        if (this.gameStatus) {
            String str = String.valueOf(this.score);
            byte[] b = str.getBytes();
            try {
                this.recordStore.setRecord(index + 1, b, 0, b.length);
            }
            catch (InvalidRecordIDException ex) {
            }
            catch (RecordStoreException ex) {
                // empty catch block
            }
        }
    }

    private void getRecord(int index) {
        try {
            byte[] b = this.recordStore.getRecord(index + 1);
            String str = new String(b);
            this.bestScore = Float.parseFloat(str);
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        g.drawImage(this.ninjaTextImage, (this.getWidth() - this.ninjaTextImage.getWidth()) / 2, 40, 0);
        g.drawImage(this.hintImage, (this.getWidth() - this.hintImage.getWidth()) / 2, 90, 0);
        for (int i = 0; i < this.btnLenght; ++i) {
            this.buttons[i].paint(g);
        }
        g.setFont(this.font);
        g.setColor(0xFFFFFF);
        if (!this.gameStatus) {
            this.setScoreString(g, this.bestScore);
        } else {
            this.setScoreString(g, this.score);
        }
        TwistMidlet.mMidlet.paintAd(g);
    }

    private void setScoreString(Graphics g, float tempscore) {
        String timsStr;
        String temp;
        int index;
        String scoreString;
        String minuteStr = "00";
        String secondStr = "00";
        String milliSec = "000";
        g.setFont(this.font);
        g.setColor(0);
        if (tempscore / 59.0f > 0.0f) {
            int minute = (int)tempscore / 59;
            minuteStr = minute < 10 ? "0" + minute : "" + minute;
            int second = (int)tempscore - minute * 59;
            secondStr = second < 10 ? "0" + second : "" + second;
        }
        if ((milliSec = (scoreString = "" + tempscore).substring((index = scoreString.indexOf(46)) + 1, scoreString.length())).length() == 2) {
            milliSec = milliSec + "1";
        } else if (milliSec.length() == 1) {
            milliSec = milliSec + "10";
        } else if (milliSec.length() == 0) {
            milliSec = milliSec + "101";
        }
        if (!this.gameStatus) {
            temp = "Best Score";
            timsStr = minuteStr + "." + secondStr + "." + milliSec;
        } else {
            temp = "New Score";
            timsStr = minuteStr + "." + secondStr + "." + milliSec;
        }
        g.setColor(0xFFFFFF);
        g.drawString(temp, (this.getWidth() - this.font.stringWidth(temp)) / 2, 150, 0);
        g.drawString(timsStr, (this.getWidth() - this.font.stringWidth(timsStr)) / 2, 150 + this.font.getHeight() + 10, 0);
    }

    protected void pointerPressed(int x, int y) {
        for (int i = 0; i < this.btnLenght; ++i) {
            this.buttons[i].pointerPressed(x, y);
        }
        TwistMidlet.mMidlet.adClicked(x, y);
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                TwistMidlet.mMidlet.startMainMenu();
                break;
            }
            case 1: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(this.gameMode));
                break;
            }
            case 2: {
                try {
                    TwistMidlet.mMidlet.platformRequest("https://www.facebook.com/pages/Twistfuture/306772299414140");
                    break;
                }
                catch (ConnectionNotFoundException connectionNotFoundException) {
                    // empty catch block
                }
            }
        }
    }
}

