/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.app.GeneralFunction;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Obstatcle {
    private static final Image[] img_obstacle;
    private static final Image[] img_fire;
    private static final Image[] img_rocket;
    private static final Image[] img_greenScull;
    private static final Image[] img_redScull;
    private Random random;
    private Image[] imgObstacles;
    private Image tempImage;
    private int currentImage;
    private int X;
    private int Y;
    private int lastX;
    private int lastY;
    private int id;
    private int width;
    private boolean downStatus;
    private int index;
    private int floorY;
    private static int lastIndex;

    public Obstatcle(int id, int floorY) {
        this.id = id;
        this.random = new Random();
        this.setImages();
        this.floorY = floorY;
        this.tempImage = this.imgObstacles[this.currentImage];
        this.width = this.tempImage.getWidth();
        this.X = 240 + id * 300 + this.random.nextInt(150);
        this.lastX = this.X + this.width;
        this.setObstaclesY();
    }

    private void setImages() {
        while (this.index == lastIndex) {
            this.index = this.random.nextInt(12);
        }
        lastIndex = this.index;
        switch (this.index) {
            case 8: {
                this.imgObstacles = img_fire;
                break;
            }
            case 9: {
                this.imgObstacles = img_rocket;
                break;
            }
            case 10: {
                this.imgObstacles = img_greenScull;
                break;
            }
            case 11: {
                this.imgObstacles = img_redScull;
                break;
            }
            default: {
                this.imgObstacles = new Image[1];
                this.imgObstacles[0] = img_obstacle[this.index];
            }
        }
    }

    private void setObstaclesY() {
        if (this.index != 9) {
            this.downStatus = true;
            this.Y = this.floorY - this.tempImage.getHeight();
            this.lastY = this.floorY;
        } else {
            this.downStatus = false;
            this.Y = this.floorY - this.tempImage.getHeight() - 30;
            this.lastY = this.Y + this.tempImage.getHeight();
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.tempImage, this.X, this.Y, 0);
    }

    public void update() {
        if (this.X < -this.width) {
            this.setImages();
            this.tempImage = this.imgObstacles[this.random.nextInt(this.imgObstacles.length)];
            this.setObstaclesY();
            this.X = new Random().nextInt(150) + 640;
        } else {
            this.currentImage = this.currentImage < this.imgObstacles.length - 1 ? ++this.currentImage : 0;
            this.tempImage = this.imgObstacles[this.currentImage];
            this.X -= 5;
        }
        this.width = this.tempImage.getWidth();
        this.lastX = this.index < 8 ? this.X + this.width : this.X + this.width - 30;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public int getLastX() {
        return this.lastX;
    }

    public int getLastY() {
        return this.lastY;
    }

    public boolean isDownStatus() {
        return this.downStatus;
    }

    static {
        int i;
        img_obstacle = new Image[8];
        img_fire = new Image[8];
        img_rocket = new Image[6];
        img_greenScull = new Image[5];
        img_redScull = new Image[5];
        for (i = 0; i < img_obstacle.length; ++i) {
            Obstatcle.img_obstacle[i] = GeneralFunction.createImage("maincanvas/obstacle/" + i + ".png");
        }
        for (i = 0; i < img_fire.length; ++i) {
            Obstatcle.img_fire[i] = GeneralFunction.createImage("maincanvas/fire/" + i + ".png");
        }
        for (i = 0; i < img_rocket.length; ++i) {
            Obstatcle.img_rocket[i] = GeneralFunction.createImage("maincanvas/rocket/" + i + ".png");
        }
        for (i = 0; i < img_greenScull.length; ++i) {
            Obstatcle.img_greenScull[i] = GeneralFunction.createImage("maincanvas/greenscull/" + i + ".png");
        }
        for (i = 0; i < img_redScull.length; ++i) {
            Obstatcle.img_redScull[i] = GeneralFunction.createImage("maincanvas/redscull/" + i + ".png");
        }
    }
}

