/*
 * Decompiled with CFR 0.152.
 */
package screens;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import main.MainCanvas;
import main.RSManager;
import screens.Menu;
import utils.Utils;

public class MenuScreen {
    public static final int SCREEN_SPLASH = 0;
    public static final int SCREEN_SPLASH2 = 1;
    public static final int SCREEN_MAIN_MENU = 2;
    public static final int SCREEN_AVATAR_MENU = 3;
    public static final int SCREEN_LEVEL_MENU = 4;
    public static final int SCREEN_GAME = 5;
    public static final int SCREEN_PAUSE = 6;
    public static final int SCREEN_GAME_OVER = 7;
    public static final int SCREEN_OPTIONS = 8;
    public static final int SCREEN_LANGUAGE = 9;
    public static final int SCREEN_SOUNDS = 10;
    public static final int SCREEN_ABOUT = 11;
    private int currentScreen = 2;
    private Image menuBg;
    private LayerManager selectionLayer;
    private Sprite selections;
    private Sprite LSK;
    private Sprite RSK;
    private Sprite Left;
    private Sprite Right;
    private int selectionFrame = 0;
    private Menu mainMenu;
    private Menu optionsMenu;
    private Menu languageMenu;
    private Menu soundMenu;

    public MenuScreen() {
        this.init();
    }

    private void init() {
        try {
            this.menuBg = Image.createImage((String)"/images/menu_background.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCurrentScreen() {
        return this.currentScreen;
    }

    public void setCurrentScreen(int nCurrentScreen) {
        this.currentScreen = nCurrentScreen;
        switch (this.currentScreen) {
            case 2: {
                this.mainMenu = new Menu();
                this.mainMenu.add(Utils.getText(10), 1);
                this.mainMenu.add(Utils.getText(11), 3);
                this.mainMenu.add(Utils.getText(12), 4);
                this.mainMenu.add(Utils.getText(13), 14);
                break;
            }
            case 3: {
                this.generateSelection("/images/sel_avatar.png");
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.optionsMenu = new Menu();
                this.optionsMenu.add(Utils.getText(14), 5);
                this.optionsMenu.add(Utils.getText(16), 13);
                break;
            }
            case 9: {
                this.languageMenu = new Menu();
                if (MainCanvas.isEastern) {
                    this.languageMenu.add("English", 7);
                    this.languageMenu.add("Russian", 15);
                    this.languageMenu.add("Polish", 16);
                } else {
                    this.languageMenu.add("Deutsch", 6);
                    this.languageMenu.add("English", 7);
                    this.languageMenu.add("Francais", 8);
                    this.languageMenu.add("Espanol", 9);
                }
                this.languageMenu.setSelectedIndex(MainCanvas.languageSelected);
                break;
            }
            case 10: {
                this.soundMenu = new Menu();
                this.soundMenu.add(Utils.getText(17), 11);
                this.soundMenu.add(Utils.getText(18), 12);
                this.soundMenu.setSelectedIndex(MainCanvas.soundSelected);
            }
        }
    }

    private void generateSelection(String image) {
        try {
            Image softkeys = Image.createImage((String)"/images/sel_sk.png");
            int softkeyWidth = softkeys.getWidth() / 4;
            this.LSK = new Sprite(softkeys, softkeyWidth, softkeys.getHeight());
            this.LSK.setFrame(0);
            this.LSK.setPosition(0, MainCanvas.height - softkeys.getHeight());
            this.RSK = new Sprite(softkeys, softkeyWidth, softkeys.getHeight());
            this.RSK.setFrame(3);
            this.RSK.setPosition(MainCanvas.width - softkeyWidth, MainCanvas.height - softkeys.getHeight());
            Image buttons = Image.createImage((String)"/images/sel_btn.png");
            int buttonWidth = buttons.getWidth() / 6;
            this.Left = new Sprite(buttons, buttonWidth, buttons.getHeight());
            this.Left.setFrame(3);
            this.Left.setPosition(buttonWidth, MainCanvas.height / 3 + Utils.getCenterVPosition(buttons.getHeight(), MainCanvas.height / 2));
            this.Right = new Sprite(buttons, buttonWidth, buttons.getHeight());
            this.Right.setFrame(0);
            this.Right.setPosition(MainCanvas.width - buttonWidth * 2, MainCanvas.height / 3 + Utils.getCenterVPosition(buttons.getHeight(), MainCanvas.height / 2));
            Image avatarSelection = Image.createImage((String)image);
            this.selections = new Sprite(avatarSelection, avatarSelection.getWidth() / 4, avatarSelection.getHeight());
            this.selections.setPosition(Utils.getCenterPosition(avatarSelection.getWidth() / 4, MainCanvas.width), MainCanvas.height / 3 + Utils.getCenterVPosition(avatarSelection.getHeight(), MainCanvas.height / 2));
            this.selections.setFrame(this.selectionFrame);
            this.selectionLayer = new LayerManager();
            this.selectionLayer.append((Layer)this.selections);
            this.selectionLayer.append((Layer)this.LSK);
            this.selectionLayer.append((Layer)this.RSK);
            this.selectionLayer.append((Layer)this.Left);
            this.selectionLayer.append((Layer)this.Right);
            this.selectionLayer.setViewWindow(0, 0, MainCanvas.width, MainCanvas.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mainMenuAction(int type) {
        switch (type) {
            case 1: {
                this.setCurrentScreen(3);
                break;
            }
            case 3: {
                this.setCurrentScreen(8);
                break;
            }
            case 4: {
                this.setCurrentScreen(11);
                break;
            }
        }
    }

    private void optionMenuAction(int type) {
        switch (type) {
            case 5: {
                this.setCurrentScreen(9);
                break;
            }
            case 10: {
                this.setCurrentScreen(10);
                break;
            }
            case 13: {
                this.setCurrentScreen(2);
            }
        }
    }

    private void languageMenuAction(int type) {
        if (type > -1) {
            MainCanvas.languageSelected = this.languageMenu.getSelectedIndex();
            RSManager.setSettings();
            MainCanvas.loadText();
            this.setCurrentScreen(8);
        }
    }

    private void soundMenuAction(int type) {
        if (type > -1) {
            MainCanvas.soundSelected = this.soundMenu.getSelectedIndex();
            RSManager.setSettings();
            this.setCurrentScreen(8);
        }
    }

    public int touch(int x, int y) {
        int type = -1;
        switch (this.currentScreen) {
            case 2: {
                type = this.mainMenu.touch(x, y);
                this.mainMenuAction(type);
                break;
            }
            case 3: 
            case 4: {
                if (x >= this.LSK.getX() && x <= this.LSK.getX() + this.LSK.getWidth() && y >= this.LSK.getY() && y <= this.LSK.getY() + this.LSK.getHeight()) {
                    type = this.input(-6);
                    break;
                }
                if (x >= this.RSK.getX() && x <= this.RSK.getX() + this.RSK.getWidth() && y >= this.RSK.getY() && y <= this.RSK.getY() + this.RSK.getHeight()) {
                    type = this.input(-7);
                    break;
                }
                if (x >= this.Left.getX() && x <= this.Left.getX() + this.Left.getWidth() && y >= this.Left.getY() && y <= this.Left.getY() + this.Left.getHeight()) {
                    type = this.input(4);
                    break;
                }
                if (x < this.Right.getX() || x > this.Right.getX() + this.Right.getWidth() || y < this.Right.getY() || y > this.Right.getY() + this.Right.getHeight()) break;
                type = this.input(32);
                break;
            }
            case 8: {
                type = this.optionsMenu.touch(x, y);
                this.optionMenuAction(type);
                break;
            }
            case 9: {
                type = this.languageMenu.touch(x, y);
                this.languageMenuAction(type);
                break;
            }
            case 10: {
                type = this.soundMenu.touch(x, y);
                this.soundMenuAction(type);
            }
        }
        return type;
    }

    public int input(int keyStates) {
        int type = -1;
        switch (this.currentScreen) {
            case 2: {
                type = this.mainMenu.input(keyStates);
                this.mainMenuAction(type);
                break;
            }
            case 3: 
            case 4: {
                switch (keyStates) {
                    case 2: 
                    case 4: {
                        this.selectionFrame = this.selectionFrame > 0 ? --this.selectionFrame : this.selections.getFrameSequenceLength() - 1;
                        this.selections.setFrame(this.selectionFrame);
                        break;
                    }
                    case 5: 
                    case 32: {
                        this.selectionFrame = this.selectionFrame < this.selections.getFrameSequenceLength() - 1 ? ++this.selectionFrame : 0;
                        this.selections.setFrame(this.selectionFrame);
                        break;
                    }
                    case -7: 
                    case 256: {
                        if (this.currentScreen != 3) break;
                        MainCanvas.selectedAvatar = this.selectionFrame;
                        this.selectionFrame = 0;
                        MainCanvas.selectedLevel = 0;
                        type = 0;
                        break;
                    }
                    case -6: {
                        if (this.currentScreen == 4) {
                            this.selectionFrame = MainCanvas.selectedAvatar;
                            this.setCurrentScreen(3);
                            break;
                        }
                        this.setCurrentScreen(2);
                    }
                }
                break;
            }
            case 8: {
                type = this.optionsMenu.input(keyStates);
                this.optionMenuAction(type);
                break;
            }
            case 9: {
                type = this.languageMenu.input(keyStates);
                this.languageMenuAction(type);
                break;
            }
            case 10: {
                type = this.soundMenu.input(keyStates);
                this.soundMenuAction(type);
            }
        }
        return type;
    }

    public void paint(Graphics g, int scrWidth, int scrHeight) {
        switch (this.currentScreen) {
            case 2: {
                if (this.menuBg != null) {
                    g.drawImage(this.menuBg, 0, 0, 0);
                }
                int yMenu = -1;
                this.mainMenu.paint(g, -1, yMenu);
                break;
            }
            case 3: 
            case 4: {
                if (this.menuBg != null) {
                    g.drawImage(this.menuBg, 0, 0, 0);
                }
                this.selectionLayer.paint(g, 0, 0);
                String name = "";
                name = this.currentScreen == 3 ? Utils.getSelectedAvatar(this.selectionFrame) : Utils.getSelectedLevel(this.selectionFrame);
                int yName = MainCanvas.height / 3;
                MainCanvas.letters.drawString(g, name, Utils.getCenterPosition(MainCanvas.letters.getStringWidth(name), MainCanvas.width), yName, -1);
                break;
            }
            case 8: {
                if (this.menuBg != null) {
                    g.drawImage(this.menuBg, 0, 0, 0);
                }
                int yMenu = -1;
                this.optionsMenu.paint(g, -1, yMenu);
                break;
            }
            case 9: {
                if (this.menuBg != null) {
                    g.drawImage(this.menuBg, 0, 0, 0);
                }
                int yMenu = -1;
                this.languageMenu.paint(g, -1, yMenu);
                break;
            }
            case 10: {
                if (this.menuBg != null) {
                    g.drawImage(this.menuBg, 0, 0, 0);
                }
                int yMenu = -1;
                this.soundMenu.paint(g, -1, yMenu);
                break;
            }
        }
    }

    public void close() {
        this.menuBg = null;
        this.selectionLayer = null;
        this.selections = null;
        this.mainMenu = null;
        this.optionsMenu = null;
        this.languageMenu = null;
        this.soundMenu = null;
        this.LSK = null;
        this.RSK = null;
        this.Left = null;
        this.Right = null;
    }
}

