/*
 * Decompiled with CFR 0.152.
 */
package gnu.zip;

import gnu.zip.DataFormatException;
import gnu.zip.Inflater;
import gnu.zip.ZipException;
import java.io.IOException;
import java.io.InputStream;
import java13.io.FilterInputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InflaterInputStream
extends FilterInputStream {
    protected Inflater a;
    protected byte[] a;
    protected int a;
    private byte[] b = new byte[1];

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n2) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("in may not be null");
        }
        if (inflater == null) {
            throw new NullPointerException("inf may not be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("size may not be negative");
        }
        this.a = inflater;
        this.a = new byte[n2];
    }

    public int available() {
        if (this.a == null) {
            throw new IOException("stream closed");
        }
        if (this.a.finished()) {
            return 0;
        }
        return 1;
    }

    public synchronized void close() {
        if (this.a != null) {
            ((InputStream)((Object)this.a)).close();
        }
        this.a = null;
    }

    public int read() {
        int n2 = this.read(this.b, 0, 1);
        if (n2 > 0) {
            return this.b[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.a == null) {
            throw new IOException("stream closed");
        }
        if (n3 == 0) {
            return 0;
        }
        while (true) {
            int n4;
            try {
                n4 = this.a.inflate(byArray, n2, n3);
            }
            catch (DataFormatException dataFormatException) {
                throw new ZipException(dataFormatException.getMessage());
            }
            if (n4 > 0) {
                return n4;
            }
            if (this.a.needsDictionary() | this.a.finished()) {
                return -1;
            }
            if (!this.a.needsInput()) break;
            InflaterInputStream inflaterInputStream = this;
            if (inflaterInputStream.a == null) {
                throw new ZipException("InflaterInputStream is closed");
            }
            inflaterInputStream.a = ((InputStream)((Object)inflaterInputStream.a)).read(inflaterInputStream.a, 0, inflaterInputStream.a.length);
            if (inflaterInputStream.a < 0) {
                throw new ZipException("Deflated stream ends early.");
            }
            inflaterInputStream.a.setInput(inflaterInputStream.a, 0, inflaterInputStream.a);
        }
        throw new Error("Don't know what to do");
    }

    public long skip(long l2) {
        if (this.a == null) {
            throw new IOException("stream closed");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 == 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(l2, 2048L);
        byte[] byArray = new byte[n2];
        long l3 = 0L;
        while (l2 > 0L && (n2 = this.read(byArray, 0, n2)) > 0) {
            l2 -= (long)n2;
            l3 += (long)n2;
            n2 = (int)Math.min(l2, 2048L);
        }
        return l3;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n2) {
    }

    public void reset() {
        throw new IOException("reset not supported");
    }
}

