/*
 * Decompiled with CFR 0.152.
 */
import fs.File;
import fs.Manager;
import java.io.DataInputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class MNM {
    private static Hashtable table = new Hashtable();
    private static DataInputStream in;
    private static File fc;
    private static int filesize;
    private static byte zm;
    static double[] latlon;
    private static final double LOGdiv2 = -0.6931471805599453;

    private static void close() {
        try {
            in.close();
            fc.close();
        }
        catch (Exception e) {
            main.m.error.append(e.toString() + "\n");
        }
    }

    public static boolean exists(double lat, double lon, int zoom) {
        if (zoom < zm) {
            zoom = zm;
        }
        if (table.containsKey(lat + "/" + zoom) && table.containsKey(lon + "/" + zoom)) {
            return true;
        }
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int ytile = (int)Math.floor((1.0 - MNM.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return table.containsKey(new Integer(xtile /= 2)) && table.containsKey(new Integer(ytile /= 2));
    }

    public static Image getMNMTile(double lat, double lon, int zoom) {
        if (zoom < zm) {
            zoom = zm;
        }
        try {
            int xtile;
            if (in == null) {
                return null;
            }
            if (in.markSupported()) {
                in.reset();
                in.mark(filesize);
                in.skip(9L);
            }
            if (!table.containsKey(lon + "/" + zoom)) {
                xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
                table.put(lon + "/" + zoom, new Integer(xtile /= 2));
            }
            if (!table.containsKey(lat + "/" + zoom)) {
                int ytile = (int)Math.floor((1.0 - MNM.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
                table.put(lat + "/" + zoom, new Integer(ytile /= 2));
            }
            if (table.containsKey(lat + "/" + zoom) && table.containsKey(lon + "/" + zoom)) {
                xtile = (Integer)table.get(lon + "/" + zoom);
                int ytile = (Integer)table.get(lat + "/" + zoom);
                int shift = (Integer)table.get(xtile + "/" + ytile);
                int skip = (Integer)table.get(new Integer(shift));
                byte[] data = new byte[skip];
                in.skipBytes(shift);
                in.readFully(data);
                return Image.createImage((byte[])data, (int)0, (int)data.length);
            }
        }
        catch (Exception e) {
            try {
                in.reset();
                in.mark(filesize);
                in.skip(9L);
            }
            catch (Exception _e) {
                // empty catch block
            }
            main.m.error.append(e.toString() + "\n");
        }
        return null;
    }

    public static double log(double x) {
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x > 1.0) {
            x = 1.0 / x;
            return -MNM._log(x);
        }
        return MNM._log(x);
    }

    private static double _log(double x) {
        double y;
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        double f = 0.0;
        int appendix = 0;
        while (x > 0.0 && x <= 1.0) {
            x *= 2.0;
            ++appendix;
        }
        --appendix;
        double y1 = (x /= 2.0) - 1.0;
        double y2 = x + 1.0;
        double k = y = y1 / y2;
        y2 = k * y;
        for (long i = 1L; i < 50L; i += 2L) {
            f += k / (double)i;
            k *= y2;
        }
        f *= 2.0;
        for (int i = 0; i < appendix; ++i) {
            f += -0.6931471805599453;
        }
        return f;
    }

    static {
        filesize = -1;
        zm = 1;
        if (fc == null) {
            try {
                int blocks;
                byte lon2;
                byte lon1;
                byte lat2;
                byte lat1;
                fc = Manager.create();
                fc.open(Location.folder + "img/", 1);
                String[] list = fc.list("*.mnm", true);
                fc.close();
                if (list.length > 0) {
                    fc.open(Location.folder + "img/" + list[0], 1);
                    filesize = (int)fc.fileSize();
                    in = fc.openDataInputStream();
                    in.mark(filesize);
                    lat1 = in.readByte();
                    lat2 = in.readByte();
                    lon1 = in.readByte();
                    lon2 = in.readByte();
                    zm = in.readByte();
                    blocks = in.readInt();
                    int shift = 9;
                    for (int i = 0; i < blocks; ++i) {
                        int x = in.readInt();
                        int y = in.readInt();
                        int z = in.readInt();
                        byte crc = in.readByte();
                        int skip = in.readInt();
                        table.put(x + "/" + y, new Integer(shift + 17));
                        table.put(new Integer(shift + 17), new Integer(skip));
                        shift = shift + skip + 17;
                        in.skipBytes(shift);
                    }
                }
                if (list.length == 0) {
                    fc.open(Location.folder + "img/", 1);
                    list = fc.list("*.mno", true);
                    fc.close();
                    if (list.length > 0) {
                        fc.open(Location.folder + "img/" + list[0], 1);
                        filesize = (int)fc.fileSize();
                        in = fc.openDataInputStream();
                        in.mark(filesize);
                        lat1 = in.readByte();
                        lat2 = in.readByte();
                        lon1 = in.readByte();
                        lon2 = in.readByte();
                        zm = in.readByte();
                        blocks = in.readInt();
                        for (int i = 0; i < blocks; ++i) {
                            int x = in.readInt();
                            int y = in.readInt();
                            int z = in.readInt();
                            byte crc = in.readByte();
                            int skip = in.readInt();
                            int shift = in.readInt() + 9 + blocks * 21;
                            table.put(x + "/" + y, new Integer(shift));
                            table.put(new Integer(shift), new Integer(skip));
                        }
                    }
                }
            }
            catch (Exception e) {
                main.m.error.append(e.toString() + "\n");
                MNM.close();
            }
        }
        latlon = new double[4];
    }
}

