/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.Component;
import com.gui.DeviceScreen;
import com.gui.GUIChoice;
import com.gui.GUICommand;
import com.gui.GUICommandListener;
import com.gui.GUIGraphics;
import com.gui.GUIList;
import com.gui.GUIManager;
import com.gui.Readline;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GUIChoiceGroup
extends Component
implements GUIChoice {
    private Readline titleString;
    private int type;
    private Image[] icons;
    private int totalItem;
    private int cursorY;
    private int cursorPosition;
    private int selectedItem = 0;
    private int itemHeight;
    private boolean[] selectedFlags;
    private String[] items;

    public GUIChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements) {
        super(label);
        this.type = choiceType;
        this.itemHeight = super.getTextFont().getHeight() + 3;
        this.titleString = new Readline(label);
        this.setAppend(stringElements, imageElements, null);
    }

    private boolean[] flagReset(boolean b) {
        int sz = this.totalItem;
        if (sz > 0) {
            boolean[] ar = new boolean[sz];
            for (int i = 0; i < sz; ++i) {
                ar[i] = b;
            }
            return ar;
        }
        return null;
    }

    private void resetIcons() {
        int sz = this.totalItem;
        if (sz > 0) {
            this.icons = new Image[sz];
            for (int i = 0; i < sz; ++i) {
                this.icons[i] = null;
            }
        }
    }

    private void reset() {
        this.cursorY = 0;
        this.cursorPosition = 0;
    }

    private void setAppend(String[] stringElements, Image[] imageElements, boolean[] flags) {
        if (stringElements == null) {
            this.totalItem = 0;
            this.selectedFlags = this.flagReset(false);
            this.resetIcons();
        } else {
            this.totalItem = stringElements.length;
        }
        this.items = stringElements;
        if (imageElements != null && imageElements.length == this.totalItem) {
            this.icons = imageElements;
        } else {
            this.resetIcons();
        }
        this.setSelectedFlags(flags);
        this.reset();
    }

    private String getShowString(String s, Font f, int w) {
        if (f.stringWidth(s) > w) {
            StringBuffer sb = new StringBuffer();
            char[] ch = s.toCharArray();
            String pr = "...";
            sb.append(pr);
            for (int i = 0; i < s.length(); ++i) {
                if (f.stringWidth(sb.toString()) >= w - 10) {
                    sb.delete(0, sb.length());
                    sb.append(ch, 0, i).append(pr);
                    break;
                }
                sb.append(ch[i]);
            }
            return sb.toString();
        }
        return s;
    }

    private void down() {
        if (this.totalItem > 1 && this.cursorPosition != this.totalItem - 1) {
            ++this.cursorPosition;
            this.cursorY += this.itemHeight;
        }
    }

    private void up() {
        if (this.totalItem > 1 && this.cursorPosition != 0) {
            --this.cursorPosition;
            this.cursorY -= this.itemHeight;
        }
    }

    public void setSelectedFlag(int elementNum, boolean flag) {
        int sz = this.totalItem;
        if (elementNum >= 0 && elementNum < sz) {
            if (this.type == 2) {
                this.selectedFlags[elementNum] = flag;
            } else if (this.type == 1 || this.type == 4) {
                for (int i = 0; i < sz; ++i) {
                    this.selectedFlags[i] = false;
                }
                this.selectedFlags[elementNum] = flag;
            }
            this.selectedItem = elementNum;
        }
    }

    int paintComponent(Graphics g, int x, int y, int width, int height, boolean b) {
        int ys2 = super.getLabelFont().getHeight();
        int ys3 = 2;
        int ys5 = 5;
        int ys6 = 0;
        int ith = this.itemHeight;
        this.titleString.setString(super.getLabel());
        this.titleString.setColor(GUIManager.getTheme().labelRGB);
        int ys1 = this.titleString.paintComponent(g, x + 1, y + 2, width, height, b);
        if (ys1 == 0) {
            ys6 = 2;
            ys3 = 4;
        }
        int ys4 = this.type != 4 ? this.totalItem * ith + ys1 : ys1 + ith;
        if (this.type != 4 && this.type != 3) {
            if (this.totalItem > 0) {
                GUIManager.getTheme().gradientFill(g, x, this.cursorY + y + ys1 + ys3, width - 1, ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
            }
            Image[] w_img = GUIManager.getImages();
            int xs = 3;
            int ys = y + ys1 + ys3;
            for (int i = 0; i < this.size(); ++i) {
                int ih;
                int iw;
                Image img = this.icons[i];
                boolean bf = this.selectedFlags[i];
                int yss = ys + ith / 2;
                if (this.type == 1) {
                    if (w_img != null) {
                        iw = w_img[2].getWidth();
                        ih = w_img[2].getHeight();
                        if (iw <= 30 && ih <= ith) {
                            if (bf) {
                                GUIGraphics.drawImage(g, w_img[3], xs, yss, 6);
                            } else {
                                GUIGraphics.drawImage(g, w_img[2], xs, yss, 6);
                            }
                            xs = xs + iw + 2;
                        }
                    }
                } else if (this.type == 2 && w_img != null) {
                    iw = w_img[0].getWidth();
                    ih = w_img[0].getHeight();
                    if (iw <= 30 && ih <= ith) {
                        if (bf) {
                            GUIGraphics.drawImage(g, w_img[1], xs, yss, 6);
                        } else {
                            GUIGraphics.drawImage(g, w_img[0], xs, yss, 6);
                        }
                        xs = xs + iw + 2;
                    }
                }
                if (img != null) {
                    iw = img.getWidth();
                    ih = img.getHeight();
                    if (iw <= 30 && ih <= ith) {
                        GUIGraphics.drawImage(g, img, xs, yss, 6);
                        xs = xs + iw + 2;
                    }
                }
                g.setColor(GUIManager.getTheme().itemRGB);
                if (i == this.cursorPosition) {
                    g.setColor(GUIManager.getTheme().itemPasteRGB);
                }
                GUIGraphics.drawString(g, this.getShowString(this.items[i], super.getTextFont(), width - xs), xs, ys + 2, 0);
                ys += ith;
                xs = 3;
            }
        } else {
            int kx1 = x + 3;
            int kx2 = x + width - 7;
            int ky1 = y + ys1 + ys3;
            int kx3 = kx1 + kx2 - 20;
            int ky2 = ky1 + ys2;
            g.setColor(GUIManager.getTheme().entryFieldRGB);
            g.fillRect(kx1, ky1, kx2, ys2);
            g.setColor(GUIManager.getTheme().entryFieldFrameRGB);
            g.drawRect(kx1, ky1, kx2, ys2);
            g.drawLine(kx3, ky1, kx3, ky2);
            g.fillTriangle(kx3 + 5, ky1 + 3, kx3 + 15, ky1 + 3, kx3 + 10, ky1 + ys2 - 3);
            g.setFont(super.getTextFont());
            g.setColor(GUIManager.getTheme().entryFieldTextRGB);
            GUIGraphics.drawString(g, this.getShowString(this.items[this.selectedItem], super.getTextFont(), width - 8 - 20), x + 5, y + ys1 + ys3 + 1, 0);
        }
        if (b) {
            g.setColor(GUIManager.getTheme().fonFrameRGB);
            g.drawRect(x, y, width - 1, ys4 + ys5 + ys6);
            g.drawRect(x + 1, y + 1, width - 3, ys4 - 2 + ys5 + ys6);
        }
        return ys4;
    }

    void keyComponent(int key) {
        if (key == GUIManager.DOWN || GUIManager.isDuplicationOfKeysOfNavigation() && key == 56) {
            this.down();
        }
        if (key == GUIManager.UP || GUIManager.isDuplicationOfKeysOfNavigation() && key == 50) {
            this.up();
        }
        if (key == GUIManager.FIRE || GUIManager.isDuplicationOfKeysOfNavigation() && key == 53) {
            switch (this.type) {
                case 2: {
                    if (this.selectedFlags[this.getSelectedIndex()]) {
                        this.setSelectedFlag(this.getSelectedIndex(), false);
                        break;
                    }
                    this.setSelectedFlag(this.getSelectedIndex(), true);
                    break;
                }
                case 1: {
                    this.setSelectedFlag(this.getSelectedIndex(), true);
                    break;
                }
                default: {
                    ListChoice lc = new ListChoice(this, super.getLabel(), this.items, this.icons);
                    GUIManager.show(lc);
                }
            }
        }
    }

    public void setSelectedFlags(boolean[] b) {
        if (b != null && b.length == this.totalItem) {
            if (this.type == 3) {
                this.selectedFlags = this.flagReset(false);
            }
            if (this.type == 1 || this.type == 4) {
                int j = 0;
                for (int i = 0; i < this.totalItem; ++i) {
                    if (!b[i]) continue;
                    ++j;
                }
                if (j == 0 || j > 1) {
                    this.setSelectedFlag(0, true);
                } else {
                    this.selectedFlags = b;
                }
            } else {
                this.selectedFlags = b;
                for (int i = 0; i < this.totalItem; ++i) {
                    this.setSelectedFlag(i, true);
                }
            }
        } else {
            this.selectedFlags = this.flagReset(false);
            if (this.type == 1 || this.type == 4) {
                this.setSelectedFlag(0, true);
            }
        }
    }

    public void append(String stringPart, Image imagePart) {
        int sz = this.totalItem;
        if (stringPart != null) {
            String[] a = new String[sz + 1];
            Image[] imgs = new Image[sz + 1];
            boolean[] s = new boolean[sz + 1];
            for (int i = 0; i < sz; ++i) {
                a[i] = this.items[i];
                imgs[i] = this.icons[i];
                s[i] = this.selectedFlags[i];
            }
            a[sz] = stringPart;
            imgs[sz] = imagePart;
            s[sz] = false;
            this.setAppend(a, imgs, s);
        }
    }

    public void set(int index, String stringPart, Image imagePart) {
        if (index >= 0 && index < this.totalItem) {
            this.items[index] = stringPart;
            this.icons[index] = imagePart;
            this.reset();
        }
    }

    public boolean[] getSelectedFlags() {
        return this.selectedFlags;
    }

    public Image getImage(int index) {
        if (index >= 0 && index < this.totalItem) {
            return this.icons[index];
        }
        return null;
    }

    public Image[] getImages() {
        return this.icons;
    }

    public int getSelectedIndex() {
        if (this.size() > 0) {
            return this.cursorPosition;
        }
        return -1;
    }

    public String getString(int index) {
        if (index >= 0 && index < this.totalItem) {
            return this.items[index];
        }
        return null;
    }

    public String[] getItems() {
        return this.items;
    }

    public int size() {
        return this.totalItem;
    }

    public void delete(int elementNum) {
        int sz = this.totalItem;
        if (elementNum >= 0 && elementNum < sz) {
            String[] a = new String[sz - 1];
            Image[] imgs = new Image[sz - 1];
            boolean[] s = new boolean[sz - 1];
            int j = 0;
            for (int i = 0; i < sz; ++i) {
                if (i == elementNum) continue;
                a[j] = this.items[i];
                imgs[j] = this.icons[i];
                s[j] = this.selectedFlags[i];
                ++j;
            }
            this.setAppend(a, imgs, s);
        }
    }

    public void deleteAll() {
        this.setAppend(null, null, null);
    }

    public int getType() {
        return this.type;
    }

    public boolean isSelected(int elementNum) {
        if (elementNum >= 0 && elementNum < this.size()) {
            return this.selectedFlags[elementNum];
        }
        return false;
    }

    public String getTypeComponent() {
        return "GUIChoiceGroup";
    }

    final class ListChoice
    extends GUIList
    implements GUICommandListener {
        GUIChoiceGroup ch;

        ListChoice(GUIChoiceGroup ch, String titlePart, String[] stringPart, Image[] imagePart) {
            super(titlePart, 3, stringPart, imagePart);
            this.ch = ch;
            super.setGUICommandListener(this);
        }

        public final void commandAction(GUICommand c, DeviceScreen d) {
            this.ch.setSelectedFlag(super.getSelectedIndex(), true);
            GUIManager.show(GUIManager.getPrevScreen());
        }
    }
}

