/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.Component;
import com.gui.DeviceScreen;
import com.gui.GUIChoiceGroup;
import com.gui.GUIManager;
import com.gui.ImageComponent;
import com.gui.Readline;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GUIForm
extends DeviceScreen {
    private Object[] components_c = null;
    private int clipX;
    private int clipY;
    private boolean[] markComponent;
    private int runnerWidth = 5;
    private int runnerMinHeight = 15;
    private int runnerY;
    private int runnerHeight;
    private int runnerStep = 5;
    private int totalHeight = 0;
    private int YS = 0;
    private int step = 15;
    private int cursorY = 0;
    private int cursorHeight = 0;
    private int position;
    private boolean start = true;
    boolean down = true;
    boolean up = true;

    public GUIForm(String t) {
        super.setTitle(t);
        this.clipX = 0;
        this.clipY = 0;
        this.runnerY = 0;
        this.runnerHeight = 0;
    }

    protected void showNotifyScreen() {
        this.start = true;
    }

    protected void hideNotifyScreen() {
    }

    void reset() {
        this.YS = 0;
        this.cursorHeight = 0;
        this.cursorY = 0;
        this.totalHeight = 0;
        this.runnerHeight = 0;
        this.runnerY = 0;
        this.start = true;
    }

    final void paintScreen(Graphics g, int width, int height) {
        int cys;
        Component c;
        int i;
        int sz = this.components_c != null ? this.components_c.length : 0;
        if (this.start) {
            for (i = 0; i < sz; ++i) {
                c = (Component)this.components_c[i];
                cys = this.clipY + this.YS;
                this.clipY += c.paintComponent(g, this.clipX, cys, width - this.runnerWidth, height, false) + 5;
            }
            this.totalHeight = this.clipY;
            this.clipY = 0;
            this.start = false;
            this.repaint();
        }
        if (sz > 0) {
            for (i = 0; i < sz; ++i) {
                c = (Component)this.components_c[i];
                if (c.getTypeComponent().equals("Readline")) {
                    Readline rd = (Readline)c;
                    rd.setColor(GUIManager.getTheme().textRGB);
                    c = rd;
                }
                cys = this.clipY + this.YS;
                boolean b = this.markComponent[i];
                int j = c.paintComponent(g, this.clipX, cys, width - this.runnerWidth, height, b) + 5;
                if (b) {
                    this.cursorY = cys + 1;
                    this.cursorHeight = j - 2;
                }
                this.clipY += j;
                if (cys > this.clipHeight) break;
            }
        }
        this.clipY = 0;
        this.setRunner(g, width + 1, height);
    }

    final void keyPress(int key) {
        Component c = (Component)this.components_c[this.position];
        GUIChoiceGroup gcg = null;
        boolean cg = false;
        c.keyComponent(key);
        if (c.getTypeComponent().equals("GUIChoiceGroup") && this.markComponent[this.position]) {
            gcg = (GUIChoiceGroup)c;
            if (gcg.getType() != 4) {
                cg = true;
            }
        } else {
            cg = false;
        }
        if (key == GUIManager.DOWN || GUIManager.isDuplicationOfKeysOfNavigation() && key == 56) {
            if (cg) {
                int ch = this.clipHeight;
                if (this.cursorHeight + this.cursorY <= ch) {
                    if (gcg.getSelectedIndex() == gcg.size() - 1) {
                        this.up = true;
                        boolean bl = this.down = !this.down;
                        if (this.down) {
                            this.setMark(true);
                        }
                    }
                } else if (this.cursorHeight > ch) {
                    if (-this.YS <= this.totalHeight - ch) {
                        this.YS -= this.step;
                        this.runnerY += this.runnerStep;
                    }
                } else if (-this.YS <= this.totalHeight - ch) {
                    this.YS -= this.step;
                    this.runnerY += this.runnerStep;
                }
            } else {
                this.down();
            }
        }
        if (key == GUIManager.UP || GUIManager.isDuplicationOfKeysOfNavigation() && key == 50) {
            if (cg) {
                if (this.cursorY < 0) {
                    if (this.YS < 0) {
                        this.YS += this.step;
                        this.runnerY -= this.runnerStep;
                    }
                } else if (gcg.getSelectedIndex() == 0) {
                    this.down = true;
                    boolean bl = this.up = !this.up;
                    if (this.up) {
                        this.setMark(false);
                    }
                }
            } else {
                this.up();
            }
        }
        this.repaint();
    }

    final void keyRepeat(int key) {
        this.keyPress(key);
    }

    private void down() {
        int ch = this.clipHeight;
        if (this.cursorHeight + this.cursorY <= ch) {
            this.setMark(true);
        } else if (this.cursorHeight > ch) {
            if (-this.YS <= this.totalHeight - ch) {
                this.YS -= this.step;
                this.runnerY += this.runnerStep;
            }
        } else if (-this.YS <= this.totalHeight - ch) {
            this.YS -= this.step;
            this.runnerY += this.runnerStep;
        }
    }

    private void up() {
        if (this.cursorY < 0) {
            if (this.YS < 0) {
                this.YS += this.step;
                this.runnerY -= this.runnerStep;
            }
        } else {
            this.setMark(false);
        }
    }

    private void setRunner(Graphics g, int width, int height) {
        if (this.totalHeight > height) {
            int countMini = (this.totalHeight - height) / this.step;
            this.runnerHeight = height - this.runnerStep * countMini;
            if (this.runnerHeight < this.runnerMinHeight) {
                this.runnerHeight = this.runnerMinHeight;
                this.runnerStep = (height - this.runnerHeight) / countMini;
            }
            GUIManager.getTheme().gradientFill(g, width - this.runnerWidth, 0, this.runnerWidth, height, false, GUIManager.getTheme().scrollFieldFonRGB1, GUIManager.getTheme().scrollFieldFonRGB2);
            if (this.runnerY < 0) {
                this.runnerY = 0;
            }
            if (this.runnerY + this.runnerHeight > height) {
                this.runnerY = height - this.runnerHeight - 1;
            }
            GUIManager.getTheme().gradientFill(g, width - this.runnerWidth, this.runnerY, this.runnerWidth, this.runnerHeight - 1, false, GUIManager.getTheme().scrollRGB1, GUIManager.getTheme().scrollRGB2);
            g.setColor(GUIManager.getTheme().scrollFrameRGB);
            g.drawRect(width - this.runnerWidth, this.runnerY, this.runnerWidth, this.runnerHeight - 1);
        }
    }

    public final void append(Component c) {
        if (!super.exist(this.components_c, c)) {
            this.components_c = super.addElement(this.components_c, c);
            this.markComponent = this.resetMark();
            this.reset();
        }
    }

    public final void append(String s) {
        Component c;
        Readline rd = new Readline(s);
        if (this.components_c != null && (c = (Component)this.components_c[this.components_c.length - 1]).getTypeComponent().equals("Readline") && c.getLabelAlignment() == 4) {
            String str = c.getString() + s;
            this.set(this.components_c.length - 1, new Readline(str));
            return;
        }
        this.append(rd);
    }

    public final void append(String s, int horizontalAlignment) {
        Component c;
        Readline rd = new Readline(s, horizontalAlignment);
        if (this.components_c != null && (c = (Component)this.components_c[this.components_c.length - 1]).getTypeComponent().equals("Readline") && c.getLabelAlignment() == horizontalAlignment) {
            String str = c.getString() + s;
            this.set(this.components_c.length - 1, new Readline(str, horizontalAlignment));
            return;
        }
        this.append(rd);
    }

    public final void append(Image imageItem) {
        if (imageItem != null) {
            ImageComponent ic = new ImageComponent(imageItem);
            this.append(ic);
        }
    }

    public final void append(Image imageItem, int horizontalAlignment) {
        if (imageItem != null) {
            ImageComponent ic = new ImageComponent(imageItem, horizontalAlignment);
            this.append(ic);
        }
    }

    public final void set(int itemNum, Component c) {
        if (this.components_c != null) {
            int sz = this.components_c.length;
            if (itemNum >= 0 && itemNum < sz) {
                this.components_c[itemNum] = c;
                this.reset();
            }
        }
    }

    public final void delete(Component c) {
        this.components_c = super.removeElement(this.components_c, c);
        this.markComponent = this.resetMark();
        this.reset();
    }

    public final void delete(int index) {
        this.components_c = super.removeElement(this.components_c, index);
        this.markComponent = this.resetMark();
        this.reset();
    }

    public final void deleteAll() {
        this.components_c = null;
        this.reset();
    }

    public final int size() {
        if (this.components_c != null) {
            return this.components_c.length;
        }
        return 0;
    }

    public final void insert(int componentNum, Component component) {
        this.set(componentNum - 1, component);
    }

    private boolean[] resetMark() {
        if (this.components_c != null) {
            boolean[] b = new boolean[this.components_c.length];
            for (int i = 0; i < b.length; ++i) {
                b[i] = false;
            }
            b[0] = true;
            this.position = 0;
            return b;
        }
        return null;
    }

    private void setMark(boolean flag) {
        int s = this.markComponent.length;
        boolean[] b = this.markComponent;
        for (int i = 0; i < s; ++i) {
            if (!b[i]) continue;
            if (flag && i < s - 1) {
                b[i] = false;
                b[i + 1] = true;
                this.position = i + 1;
                break;
            }
            if (flag || i <= 0) continue;
            b[i] = false;
            b[i - 1] = true;
            this.position = i - 1;
            break;
        }
        this.markComponent = b;
    }
}

