/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.DeviceScreen;
import com.gui.GUICommand;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GUIListSub
extends DeviceScreen {
    private Object[] subMenu = null;
    private Object[] tmp = null;
    private String PATH = "";
    private Object[] ITEMS = null;
    private int totalItem = 0;
    private int maxItem;
    private int showItem;
    private int startIndex;
    private int cursorY;
    private int cursorPosition = 0;
    private int runnerY;
    private int runnerHeight;
    private int runnerMinHeight = 15;
    private int runnerWidth = 5;
    private double rs;
    private double ss;
    private boolean start = true;
    public static final GUICommand SELECT_COMMAND = new GUICommand("OK", 7);
    private String titleName;

    public GUIListSub(String titleName) {
        this.titleName = titleName;
        super.setTitle(titleName);
        this.addCommand(SELECT_COMMAND);
    }

    private void setScroll() {
        int s = this.totalItem;
        if (s > 0) {
            this.runnerHeight = this.clipHeight - this.itemHeight * (s - this.showItem);
            if (this.runnerHeight <= this.runnerMinHeight) {
                this.runnerHeight = this.runnerMinHeight;
                this.ss = (double)(this.clipHeight - this.runnerHeight) / (double)(s - this.showItem + 1);
            } else {
                this.ss = this.itemHeight;
            }
        }
    }

    void reset() {
        this.cursorY = 0;
        this.runnerY = 0;
        this.cursorPosition = 0;
        this.startIndex = 0;
        this.rs = 0.0;
        this.setScroll();
        this.start = true;
    }

    void showNotifyScreen() {
    }

    void hideNotifyScreen() {
    }

    final void paintScreen(Graphics g, int width, int height) {
        if (this.start) {
            this.start = false;
            this.tmp = this.searchOfPath(this.subMenu, this.PATH);
            if (this.tmp == null) {
                return;
            }
            this.ITEMS = null;
            this.totalItem = this.tmp.length;
            for (int i = 0; i < this.tmp.length; ++i) {
                TableSub ts = (TableSub)this.tmp[i];
                this.ITEMS = this.addElement(this.ITEMS, ts.getPath() + ts.getName());
            }
            this.maxItem = height / this.itemHeight;
            this.showItem = this.totalItem >= this.maxItem ? this.maxItem : this.totalItem;
        }
        int s = this.totalItem;
        int ith = this.itemHeight;
        if (s > 0) {
            if (s > this.showItem) {
                GUIManager.getTheme().gradientFill(g, 0, this.cursorY, width - this.runnerWidth - 1, ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                g.setColor(GUIManager.getTheme().cursorFrameRGB);
                g.drawRect(0, this.cursorY, width - this.runnerWidth - 1, ith);
            } else {
                GUIManager.getTheme().gradientFill(g, 0, this.cursorY, width - 1, ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                g.setColor(GUIManager.getTheme().cursorFrameRGB);
                g.drawRect(0, this.cursorY, width - 1, ith);
            }
        }
        int ys = 0;
        int js = 0;
        int xs = 2;
        TableSub ts = null;
        g.setFont(this.itemFont);
        for (int i = this.startIndex; i < s; ++i) {
            ts = (TableSub)this.tmp[i];
            Image img = ts.getImage();
            String name = ts.getName();
            int yss = ys + ith / 2;
            if (img != null) {
                int iw = img.getWidth();
                int ih = img.getHeight();
                if (iw <= 30 && ih <= ith + 5) {
                    GUIGraphics.drawImage(g, img, xs, yss, 6);
                    xs = xs + iw + 2;
                }
            }
            g.setColor(GUIManager.getTheme().itemRGB);
            if (i == this.cursorPosition) {
                g.setColor(GUIManager.getTheme().itemPasteRGB);
            }
            GUIGraphics.drawString(g, name.endsWith("/") ? name.replace('/', ' ') : name, xs, ys + 2, 0);
            if (this.searchOfPath(this.subMenu, this.PATH + name) != null) {
                GUIGraphics.drawString(g, ">", width - this.runnerWidth, ys + 2, 24);
            }
            ys += ith;
            xs = 2;
            if (++js == this.showItem) break;
        }
        this.runner(g, width, height);
    }

    final void keyPress(int key) {
        if (key == GUIManager.DOWN || GUIManager.isDuplicationOfKeysOfNavigation() && key == 56) {
            this.down();
        }
        if (key == GUIManager.UP || GUIManager.isDuplicationOfKeysOfNavigation() && key == 50) {
            this.up();
        }
        if (key == GUIManager.FIRE || key == GUIManager.RIGHT || GUIManager.isDuplicationOfKeysOfNavigation() && (key == 53 || key == 54)) {
            Object[] tmp1 = this.searchOfPath(this.subMenu, (String)this.ITEMS[this.cursorPosition]);
            if (tmp1 != null) {
                this.PATH = (String)this.ITEMS[this.cursorPosition];
                this.reset();
            }
            this.guicl.commandAction(SELECT_COMMAND, this);
        }
        if ((key == GUIManager.LEFT || GUIManager.isDuplicationOfKeysOfNavigation() && key == 52) && !this.PATH.equals("")) {
            int i = this.PATH.lastIndexOf(47, this.PATH.length() - 2);
            this.PATH = i != -1 ? this.PATH.substring(0, i + 1) : "";
            this.reset();
        }
    }

    final void keyRepeat(int key) {
        this.keyPress(key);
    }

    private void down() {
        int s = this.totalItem;
        int ih = this.itemHeight;
        int si = this.showItem - 1;
        if (s > 1) {
            if (this.cursorPosition == s - 1) {
                this.cursorY = 0;
                this.runnerY = 0;
                this.rs = 0.0;
                this.cursorPosition = 0;
                this.startIndex = 0;
            } else if (this.cursorPosition >= si && this.cursorY == si * ih) {
                ++this.startIndex;
                ++this.cursorPosition;
                this.rs += this.ss;
                this.runnerY = (int)this.rs;
            } else {
                this.cursorY += ih;
                ++this.cursorPosition;
            }
        }
    }

    private void up() {
        int s = this.totalItem;
        int ih = this.itemHeight;
        int si = this.showItem;
        if (s > 1) {
            if (this.cursorPosition == 0) {
                this.cursorPosition = s - 1;
                this.cursorY = (si - 1) * ih;
                this.runnerY = this.clipHeight - this.runnerHeight;
                this.rs = this.runnerY;
                this.startIndex = s - si;
            } else if (this.cursorY == 0) {
                --this.cursorPosition;
                --this.startIndex;
                this.rs -= this.ss;
                this.runnerY = (int)this.rs;
            } else {
                --this.cursorPosition;
                this.cursorY -= ih;
            }
        }
    }

    private void runner(Graphics g, int width, int height) {
        int s = this.totalItem;
        if (s > 0) {
            this.runnerHeight = this.clipHeight - this.itemHeight * (s - this.showItem);
            if (this.runnerHeight <= this.runnerMinHeight) {
                this.runnerHeight = this.runnerMinHeight;
                this.ss = (double)(this.clipHeight - this.runnerHeight) / (double)(s - this.showItem + 1);
            } else {
                this.ss = this.itemHeight;
            }
        }
        int rw = this.runnerWidth;
        if (s > this.showItem) {
            if (this.cursorPosition == 0) {
                this.runnerY = 0;
            }
            if (this.cursorPosition == s - 1) {
                this.runnerY = height - this.runnerHeight - 1;
            }
            GUIManager.getTheme().gradientFill(g, width - rw, 0, rw, height - 1, false, GUIManager.getTheme().scrollFieldFonRGB1, GUIManager.getTheme().scrollFieldFonRGB2);
            GUIManager.getTheme().gradientFill(g, width - rw + 1, this.runnerY, rw - 1, this.runnerHeight - 1, false, GUIManager.getTheme().scrollRGB1, GUIManager.getTheme().scrollRGB2);
            g.setColor(GUIManager.getTheme().scrollFrameRGB);
            g.drawRect(width - rw + 1, this.runnerY, rw - 1, this.runnerHeight - 1);
        }
    }

    public void append(String itemPath, String[] names, Image[] images) {
        if (itemPath != null && names != null) {
            if (images == null || images.length != names.length) {
                images = null;
            }
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                if (images != null) {
                    this.append(itemPath, names[i], images[i]);
                    continue;
                }
                this.append(itemPath, names[i], null);
            }
            this.reset();
        }
    }

    public void append(String itemPath, String name, Image image) {
        if (itemPath != null && name != null && this.searchOfElement(this.subMenu, name, itemPath) == -1) {
            this.subMenu = this.addElement(this.subMenu, new TableSub(itemPath, name, image));
        }
    }

    public String getString() {
        if (this.ITEMS != null) {
            String name = "";
            String ts = (String)this.ITEMS[this.cursorPosition];
            int i = ts.lastIndexOf(47, ts.length() - 2);
            name = i != -1 ? ts.substring(i + 1) : ts;
            return name;
        }
        return null;
    }

    public String getPath() {
        if (this.ITEMS != null) {
            String path = "";
            String ts = (String)this.ITEMS[this.cursorPosition];
            int i = ts.lastIndexOf(47, ts.length() - 2);
            if (i != -1) {
                path = ts.substring(0, i + 1);
            }
            return path;
        }
        return null;
    }

    public String getFullPath() {
        if (this.ITEMS != null) {
            return (String)this.ITEMS[this.cursorPosition];
        }
        return null;
    }

    public final int size() {
        return this.totalItem;
    }

    public void removeElement(String name, String path) {
        int id;
        if (name != null && path != null && (id = this.searchOfElement(this.subMenu, name, path)) != -1) {
            Object[] tmp1;
            if (name.endsWith("/") && (tmp1 = this.searchOfPath(this.subMenu, path + name)) != null) {
                for (int i = 0; i < tmp1.length; ++i) {
                    TableSub tl = (TableSub)tmp1[i];
                    this.removeElement(tl.getName(), path + name);
                }
            }
            this.subMenu = super.removeElement(this.subMenu, id);
        }
    }

    public final void deleteAll() {
        this.subMenu = null;
        this.reset();
    }

    Object[] searchOfPath(Object[] search, String pathSearch) {
        if (pathSearch != null && search != null) {
            int sz = search.length;
            Object[] tmp1 = null;
            for (int i = 0; i < sz; ++i) {
                TableSub tl = (TableSub)search[i];
                if (!tl.getPath().equals(pathSearch)) continue;
                tmp1 = super.addElement(tmp1, tl);
            }
            return tmp1;
        }
        return null;
    }

    int searchOfElement(Object[] search, String name, String path) {
        if (search != null && name != null && path != null) {
            int sz = search.length;
            for (int i = 0; i < sz; ++i) {
                TableSub tl = (TableSub)search[i];
                if (!tl.getName().equals(name) || !tl.getPath().equals(path)) continue;
                return i;
            }
        }
        return -1;
    }

    final class TableSub {
        private String name;
        private String path;
        private Image img;

        TableSub(String path, String name, Image img) {
            this.name = name;
            this.path = path;
            this.img = img;
        }

        String getPath() {
            return this.path;
        }

        String getName() {
            return this.name;
        }

        Image getImage() {
            return this.img;
        }
    }
}

