/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;

public class KXmlParser {
    public static final int START_DOCUMENT = 0;
    public static final int END_DOCUMENT = 1;
    public static final int START_TAG = 2;
    public static final int END_TAG = 3;
    public static final int TEXT = 4;
    public static final int CDSECT = 5;
    public static final int ENTITY_REF = 6;
    public static final int IGNORABLE_WHITESPACE = 7;
    public static final int PROCESSING_INSTRUCTION = 8;
    public static final int COMMENT = 9;
    public static final int DOCDECL = 10;
    private Object location;
    private static final int LEGACY = 999;
    private static final int XML_DECL = 998;
    private Hashtable entityMap;
    private int depth;
    private String[] elementStack = new String[16];
    private int[] nspCounts = new int[4];
    private Reader reader;
    private String encoding;
    private char[] srcBuf;
    private int srcPos;
    private int srcCount;
    private int line;
    private int column;
    private char[] txtBuf = new char[128];
    private int txtPos;
    private int type;
    private boolean isWhitespace;
    private String namespace;
    private String prefix;
    private String name;
    private boolean degenerated;
    private int attributeCount;
    private String[] attributes = new String[16];
    private int stackMismatch = 0;
    private String error;
    private int[] peek = new int[2];
    private int peekCount;
    private boolean wasCR;
    private boolean unresolved;
    private boolean token;

    public KXmlParser() {
        this.srcBuf = new char[Runtime.getRuntime().freeMemory() >= 262144L ? 8192 : 128];
    }

    private final String[] ensureCapacity(String[] arr, int required) {
        if (arr.length >= required) {
            return arr;
        }
        String[] bigger = new String[required + 16];
        System.arraycopy(arr, 0, bigger, 0, arr.length);
        return bigger;
    }

    private final void error() throws RuntimeException {
        throw new RuntimeException();
    }

    private final void exception() throws RuntimeException {
        this.error();
    }

    private final void nextImpl() throws IOException, RuntimeException {
        if (this.reader == null) {
            this.exception();
        }
        if (this.type == 3) {
            --this.depth;
        }
        do {
            this.attributeCount = -1;
            if (this.degenerated) {
                this.degenerated = false;
                this.type = 3;
                return;
            }
            if (this.error != null) {
                for (int i = 0; i < this.error.length(); ++i) {
                    this.push(this.error.charAt(i));
                }
                this.error = null;
                this.type = 9;
                return;
            }
            this.prefix = null;
            this.name = null;
            this.namespace = null;
            this.type = this.peekType();
            switch (this.type) {
                case 6: {
                    this.pushEntity();
                    return;
                }
                case 2: {
                    this.parseStartTag(false);
                    return;
                }
                case 3: {
                    this.parseEndTag();
                    return;
                }
                case 1: {
                    return;
                }
                case 4: {
                    this.pushText(60, !this.token);
                    if (this.depth == 0 && this.isWhitespace) {
                        this.type = 7;
                    }
                    return;
                }
            }
            this.type = this.parseLegacy(this.token);
        } while (this.type == 998);
    }

    private final int parseLegacy(boolean push) throws IOException, RuntimeException {
        int result;
        int term;
        String req = "";
        int prev = 0;
        this.read();
        int c = this.read();
        if (c == 63) {
            if (!(this.peek(0) != 120 && this.peek(0) != 88 || this.peek(1) != 109 && this.peek(1) != 77)) {
                if (push) {
                    this.push(this.peek(0));
                    this.push(this.peek(1));
                }
                this.read();
                this.read();
                if ((this.peek(0) == 108 || this.peek(0) == 76) && this.peek(1) <= 32) {
                    int pos;
                    if (this.line != 1 || this.column > 4) {
                        this.error();
                    }
                    this.parseStartTag(true);
                    if (this.attributeCount < 1 || !"version".equals(this.attributes[2])) {
                        this.error();
                    }
                    if ((pos = 1) < this.attributeCount && "encoding".equals(this.attributes[6])) {
                        this.encoding = this.attributes[7];
                        ++pos;
                    }
                    if (pos < this.attributeCount && "standalone".equals(this.attributes[4 * pos + 2])) {
                        ++pos;
                    }
                    if (pos != this.attributeCount) {
                        this.error();
                    }
                    this.isWhitespace = true;
                    this.txtPos = 0;
                    return 998;
                }
            }
            term = 63;
            result = 8;
        } else if (c == 33) {
            if (this.peek(0) == 45) {
                result = 9;
                req = "--";
                term = 45;
            } else if (this.peek(0) == 91) {
                result = 5;
                req = "[CDATA[";
                term = 93;
                push = true;
            } else {
                result = 10;
                req = "DOCTYPE";
                term = -1;
            }
        } else {
            this.error();
            return 9;
        }
        for (int i = 0; i < req.length(); ++i) {
            this.read(req.charAt(i));
        }
        if (result == 10) {
            this.parseDoctype(push);
        } else {
            while (true) {
                if ((c = this.read()) == -1) {
                    this.error();
                    return 9;
                }
                if (push) {
                    this.push(c);
                }
                if ((term == 63 || c == term) && this.peek(0) == term && this.peek(1) == 62) break;
                prev = c;
            }
            if (term == 45 && prev == 45) {
                this.error();
            }
            this.read();
            this.read();
            if (push && term != 63) {
                --this.txtPos;
            }
        }
        return result;
    }

    private final void parseDoctype(boolean push) throws IOException, RuntimeException {
        int nesting = 1;
        boolean quoted = false;
        while (true) {
            int i = this.read();
            switch (i) {
                case -1: {
                    this.error();
                    return;
                }
                case 39: {
                    quoted = !quoted;
                    break;
                }
                case 60: {
                    if (quoted) break;
                    ++nesting;
                    break;
                }
                case 62: {
                    if (quoted || --nesting != 0) break;
                    return;
                }
            }
            if (!push) continue;
            this.push(i);
        }
    }

    private final void parseEndTag() throws IOException, RuntimeException {
        this.read();
        this.read();
        this.name = this.readName();
        this.skip();
        this.read('>');
        int sp = this.depth - 1 << 2;
        if (this.depth == 0) {
            this.error();
            this.type = 9;
            return;
        }
        if (!this.name.equals(this.elementStack[sp + 3])) {
            int probe;
            this.error();
            for (probe = sp; probe >= 0 && !this.name.toLowerCase().equals(this.elementStack[probe + 3].toLowerCase()); probe -= 4) {
                ++this.stackMismatch;
            }
            if (probe < 0) {
                this.stackMismatch = 0;
                this.type = 9;
                return;
            }
        }
        this.namespace = this.elementStack[sp];
        this.prefix = this.elementStack[sp + 1];
        this.name = this.elementStack[sp + 2];
    }

    private final int peekType() throws IOException {
        switch (this.peek(0)) {
            case -1: {
                return 1;
            }
            case 38: {
                return 6;
            }
            case 60: {
                switch (this.peek(1)) {
                    case 47: {
                        return 3;
                    }
                    case 33: 
                    case 63: {
                        return 999;
                    }
                }
                return 2;
            }
        }
        return 4;
    }

    private final String get(int pos) {
        return new String(this.txtBuf, pos, this.txtPos - pos);
    }

    private final void push(int c) {
        this.isWhitespace &= c <= 32;
        if (this.txtPos == this.txtBuf.length) {
            char[] bigger = new char[this.txtPos * 4 / 3 + 4];
            System.arraycopy(this.txtBuf, 0, bigger, 0, this.txtPos);
            this.txtBuf = bigger;
        }
        this.txtBuf[this.txtPos++] = (char)c;
    }

    private final void parseStartTag(boolean xmldecl) throws IOException, RuntimeException {
        if (!xmldecl) {
            this.read();
        }
        this.name = this.readName();
        this.attributeCount = 0;
        while (true) {
            this.skip();
            int c = this.peek(0);
            if (xmldecl) {
                if (c == 63) {
                    this.read();
                    this.read('>');
                    return;
                }
            } else {
                if (c == 47) {
                    this.degenerated = true;
                    this.read();
                    this.skip();
                    this.read('>');
                    break;
                }
                if (c == 62 && !xmldecl) {
                    this.read();
                    break;
                }
            }
            if (c == -1) {
                this.error();
                return;
            }
            String attrName = this.readName();
            if (attrName.length() == 0) {
                this.error();
                break;
            }
            int i = this.attributeCount++ << 2;
            this.attributes = this.ensureCapacity(this.attributes, i + 4);
            this.attributes[i++] = "";
            this.attributes[i++] = null;
            this.attributes[i++] = attrName;
            this.skip();
            if (this.peek(0) != 61) {
                this.error();
                this.attributes[i] = "1";
                continue;
            }
            this.read('=');
            this.skip();
            int delimiter = this.peek(0);
            if (delimiter != 39 && delimiter != 34) {
                this.error();
                delimiter = 32;
            } else {
                this.read();
            }
            int p = this.txtPos;
            this.pushText(delimiter, true);
            this.attributes[i] = this.get(p);
            this.txtPos = p;
            if (delimiter == 32) continue;
            this.read();
        }
        int sp = this.depth++ << 2;
        this.elementStack = this.ensureCapacity(this.elementStack, sp + 4);
        this.elementStack[sp + 3] = this.name;
        if (this.depth >= this.nspCounts.length) {
            int[] bigger = new int[this.depth + 4];
            System.arraycopy(this.nspCounts, 0, bigger, 0, this.nspCounts.length);
            this.nspCounts = bigger;
        }
        this.nspCounts[this.depth] = this.nspCounts[this.depth - 1];
        this.elementStack[sp] = this.namespace = "";
        this.elementStack[sp + 1] = this.prefix;
        this.elementStack[sp + 2] = this.name;
    }

    private final void pushEntity() throws IOException, RuntimeException {
        int c;
        this.read();
        int pos = this.txtPos;
        while ((c = this.read()) != 59) {
            if (!(c >= 128 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 45 || c == 35)) {
                this.error();
                if (c != -1) {
                    this.push(c);
                }
                return;
            }
            this.push(c);
        }
        String code = this.get(pos);
        this.txtPos = pos;
        if (this.token && this.type == 6) {
            this.name = code;
        }
        if (code.charAt(0) == '#') {
            int c2 = code.charAt(1) == 'x' ? Integer.parseInt(code.substring(2), 16) : Integer.parseInt(code.substring(1));
            this.push(c2);
            return;
        }
        String result = (String)this.entityMap.get(code);
        boolean bl = this.unresolved = result == null;
        if (this.unresolved) {
            if (!this.token) {
                this.error();
            }
        } else {
            for (int i = 0; i < result.length(); ++i) {
                this.push(result.charAt(i));
            }
        }
    }

    private final void pushText(int delimiter, boolean resolveEntities) throws IOException, RuntimeException {
        int next = this.peek(0);
        int cbrCount = 0;
        while (next != -1 && next != delimiter && (delimiter != 32 || next > 32 && next != 62)) {
            if (next == 38) {
                if (!resolveEntities) break;
                this.pushEntity();
            } else if (next == 10 && this.type == 2) {
                this.read();
                this.push(32);
            } else {
                this.push(this.read());
            }
            if (next == 62 && cbrCount >= 2 && delimiter != 93) {
                this.error();
            }
            cbrCount = next == 93 ? ++cbrCount : 0;
            next = this.peek(0);
        }
    }

    private final void read(char c) throws IOException, RuntimeException {
        int a = this.read();
        if (a != c) {
            this.error();
        }
    }

    private final int read() throws IOException {
        int result;
        if (this.peekCount == 0) {
            result = this.peek(0);
        } else {
            result = this.peek[0];
            this.peek[0] = this.peek[1];
        }
        --this.peekCount;
        ++this.column;
        if (result == 10) {
            ++this.line;
            this.column = 1;
        }
        return result;
    }

    private final int peek(int pos) throws IOException {
        while (pos >= this.peekCount) {
            int nw;
            if (this.srcBuf.length <= 1) {
                nw = this.reader.read();
            } else if (this.srcPos < this.srcCount) {
                nw = this.srcBuf[this.srcPos++];
            } else {
                this.srcCount = this.reader.read(this.srcBuf, 0, this.srcBuf.length);
                nw = this.srcCount <= 0 ? -1 : this.srcBuf[0];
                this.srcPos = 1;
            }
            if (nw == 13) {
                this.wasCR = true;
                this.peek[this.peekCount++] = 10;
                continue;
            }
            if (nw == 10) {
                if (!this.wasCR) {
                    this.peek[this.peekCount++] = 10;
                }
            } else {
                this.peek[this.peekCount++] = nw;
            }
            this.wasCR = false;
        }
        return this.peek[pos];
    }

    private final String readName() throws IOException, RuntimeException {
        int pos = this.txtPos;
        int c = this.peek(0);
        if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 58 || c >= 192)) {
            this.error();
        }
        do {
            this.push(this.read());
        } while ((c = this.peek(0)) >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 45 || c == 58 || c == 46 || c >= 183);
        String result = this.get(pos);
        this.txtPos = pos;
        return result;
    }

    private final void skip() throws IOException {
        int c;
        while ((c = this.peek(0)) <= 32 && c != -1) {
            this.read();
        }
    }

    public void setInput(Reader reader) throws RuntimeException {
        this.reader = reader;
        this.line = 1;
        this.column = 0;
        this.type = 0;
        this.name = null;
        this.namespace = null;
        this.degenerated = false;
        this.attributeCount = -1;
        this.encoding = null;
        if (reader == null) {
            return;
        }
        this.srcPos = 0;
        this.srcCount = 0;
        this.peekCount = 0;
        this.depth = 0;
        this.entityMap = new Hashtable();
        this.entityMap.put("amp", "&");
        this.entityMap.put("apos", "'");
        this.entityMap.put("gt", ">");
        this.entityMap.put("lt", "<");
        this.entityMap.put("quot", "\"");
    }

    public void setInput(InputStream is, String _enc) throws RuntimeException {
        this.srcPos = 0;
        this.srcCount = 0;
        String enc = _enc;
        if (is == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (enc == null) {
                int i;
                int chk = 0;
                while (this.srcCount < 4 && (i = is.read()) != -1) {
                    chk = chk << 8 | i;
                    this.srcBuf[this.srcCount++] = (char)i;
                }
                if (this.srcCount == 4) {
                    switch (chk) {
                        case 3932223: {
                            enc = "UTF-16BE";
                            this.srcBuf[0] = 60;
                            this.srcBuf[1] = 63;
                            this.srcCount = 2;
                            break;
                        }
                        case 1006649088: {
                            enc = "UTF-16LE";
                            this.srcBuf[0] = 60;
                            this.srcBuf[1] = 63;
                            this.srcCount = 2;
                            break;
                        }
                        case 1010792557: {
                            while ((i = is.read()) != -1) {
                                this.srcBuf[this.srcCount++] = (char)i;
                                if (i != 62) continue;
                                String s = new String(this.srcBuf, 0, this.srcCount);
                                int i0 = s.indexOf("encoding");
                                if (i0 == -1) break;
                                while (s.charAt(i0) != '\"' && s.charAt(i0) != '\'') {
                                    ++i0;
                                }
                                char deli = s.charAt(i0++);
                                int i1 = s.indexOf(deli, i0);
                                enc = s.substring(i0, i1);
                                break;
                            }
                        }
                        default: {
                            if ((chk & 0xFFFF0000) == -16842752) {
                                enc = "UTF-16BE";
                                this.srcBuf[0] = (char)(this.srcBuf[2] << 8 | this.srcBuf[3]);
                                this.srcCount = 1;
                                break;
                            }
                            if ((chk & 0xFFFF0000) == -131072) {
                                enc = "UTF-16LE";
                                this.srcBuf[0] = (char)(this.srcBuf[3] << 8 | this.srcBuf[2]);
                                this.srcCount = 1;
                                break;
                            }
                            if ((chk & 0xFFFFFF00) != -272908544) break;
                            enc = "UTF-8";
                            this.srcBuf[0] = this.srcBuf[3];
                            this.srcCount = 1;
                        }
                    }
                }
            }
            if (enc == null) {
                enc = "UTF-8";
            }
            int sc = this.srcCount;
            this.setInput(new InputStreamReader(is, enc));
            this.encoding = _enc;
            this.srcCount = sc;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public String getInputEncoding() {
        return this.encoding;
    }

    public void defineEntityReplacementText(String entity, String value) throws RuntimeException {
        if (this.entityMap == null) {
            this.error();
        }
        this.entityMap.put(entity, value);
    }

    public boolean isWhitespace() {
        if (this.type != 4 && this.type != 7 && this.type != 5) {
            this.exception();
        }
        return this.isWhitespace;
    }

    public String getText() {
        return this.type < 4 || this.type == 6 && this.unresolved ? null : this.get(0);
    }

    public char[] getTextCharacters(int[] poslen) {
        if (this.type >= 4) {
            if (this.type == 6) {
                poslen[0] = 0;
                poslen[1] = this.name.length();
                return this.name.toCharArray();
            }
            poslen[0] = 0;
            poslen[1] = this.txtPos;
            return this.txtBuf;
        }
        poslen[0] = -1;
        poslen[1] = -1;
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isEmptyElementTag() throws RuntimeException {
        if (this.type != 2) {
            this.exception();
        }
        return this.degenerated;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public String getAttributeName(int index) {
        return this.attributes[(index << 2) + 2];
    }

    public String getAttributePrefix(int index) {
        return this.attributes[(index << 2) + 1];
    }

    public String getAttributeValue(int index) {
        return this.attributes[(index << 2) + 3];
    }

    public String getAttributeValue(String namespace, String name) {
        for (int i = (this.attributeCount << 2) - 4; i >= 0; i -= 4) {
            if (!this.attributes[i + 2].equals(name) || namespace != null && !this.attributes[i].equals(namespace)) continue;
            return this.attributes[i + 3];
        }
        return null;
    }

    public int getEventType() {
        return this.type;
    }

    public int next() throws IOException {
        this.txtPos = 0;
        this.isWhitespace = true;
        int minType = 9999;
        this.token = false;
        do {
            this.nextImpl();
            if (this.type >= minType) continue;
            minType = this.type;
        } while (minType > 6 || minType >= 4 && this.peekType() >= 4);
        this.type = minType;
        if (this.type > 4) {
            this.type = 4;
        }
        return this.type;
    }

    public int nextToken() throws IOException {
        this.isWhitespace = true;
        this.txtPos = 0;
        this.token = true;
        this.nextImpl();
        return this.type;
    }

    public int nextTag() throws IOException {
        this.next();
        if (this.type == 4 && this.isWhitespace) {
            this.next();
        }
        if (this.type != 3 && this.type != 2) {
            this.exception();
        }
        return this.type;
    }

    public void require(int type, String namespace, String name) throws RuntimeException, IOException {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            this.exception();
        }
    }

    public String nextText() throws IOException {
        String result;
        if (this.type != 2) {
            this.exception();
        }
        this.next();
        if (this.type == 4) {
            result = this.getText();
            this.next();
        } else {
            result = "";
        }
        if (this.type != 3) {
            this.exception();
        }
        return result;
    }

    public void skipSubTree() throws IOException {
        this.require(2, null, null);
        int level = 1;
        while (level > 0) {
            int eventType = this.next();
            if (eventType == 3) {
                --level;
                continue;
            }
            if (eventType != 2) continue;
            ++level;
        }
    }
}

