/*
 * Decompiled with CFR 0.152.
 */
import org.j4me.util.MathFunc;

public class MapUtil {
    private static double offset = 2.68435456E8;
    private static double radius = offset / Math.PI;
    public static final double LOGdiv2 = -0.6931471805599453;

    public static double[] adjust(double lat, double lon, int deltaX, int deltaY, int z) {
        return new double[]{MapUtil.XToL(MapUtil.LToX(lat) + (double)(deltaX << 21 - z)), MapUtil.YToL(MapUtil.LToY(lon) + (double)(deltaY << 21 - z))};
    }

    private static double LToX(double x) {
        return MapUtil.round(offset + radius * x * Math.PI / 180.0);
    }

    private static double LToY(double y) {
        return MapUtil.round(offset - radius * MapUtil.log((1.0 + Math.sin(y * Math.PI / 180.0)) / (1.0 - Math.sin(y * Math.PI / 180.0))) / 2.0);
    }

    private static double XToL(double x) {
        return (MapUtil.round(x) - offset) / radius * 180.0 / Math.PI;
    }

    private static double YToL(double y) {
        return (1.5707963267948966 - 2.0 * MathFunc.atan(MapUtil.exp((MapUtil.round(y) - offset) / radius))) * 180.0 / Math.PI;
    }

    private static double round(double num) {
        double floor = Math.floor(num);
        if (num - floor >= 0.5) {
            return Math.ceil(num);
        }
        return floor;
    }

    public static double exp(double x) {
        boolean isless;
        if (x == 0.0) {
            return 1.0;
        }
        double f = 1.0;
        long d = 1L;
        boolean bl = isless = x < 0.0;
        if (isless) {
            x = -x;
        }
        double k = x / (double)d;
        for (long i = 2L; i < 50L; ++i) {
            f += k;
            k = k * x / (double)i;
        }
        if (isless) {
            return 1.0 / f;
        }
        return f;
    }

    private static double _log(double x) {
        double y;
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        double f = 0.0;
        int appendix = 0;
        while (x > 0.0 && x <= 1.0) {
            x *= 2.0;
            ++appendix;
        }
        --appendix;
        double y1 = (x /= 2.0) - 1.0;
        double y2 = x + 1.0;
        double k = y = y1 / y2;
        y2 = k * y;
        for (long i = 1L; i < 50L; i += 2L) {
            f += k / (double)i;
            k *= y2;
        }
        f *= 2.0;
        for (int i = 0; i < appendix; ++i) {
            f += -0.6931471805599453;
        }
        return f;
    }

    public static double log(double x) {
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x > 1.0) {
            x = 1.0 / x;
            return -MapUtil._log(x);
        }
        return MapUtil._log(x);
    }
}

