/*
 * Decompiled with CFR 0.152.
 */
package fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LineReader
extends InputStreamReader {
    private char buf;
    private boolean readAhead = false;

    public LineReader(InputStream in) {
        super(in);
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public int read() throws IOException {
        if (this.readAhead) {
            this.readAhead = false;
            return this.buf;
        }
        return super.read();
    }

    public int read(char[] cbuf) throws IOException {
        int ret = 0;
        if (this.readAhead) {
            cbuf[0] = this.buf;
            ++ret;
            this.readAhead = false;
        }
        return super.read(cbuf, ret, cbuf.length - ret) + 1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readAhead) {
            cbuf[off] = this.buf;
            ++off;
            this.readAhead = false;
        }
        return super.read(cbuf, off, len) + 1;
    }

    public void reset() throws IOException {
        throw new IOException("Mark is not supported");
    }

    public long skip(long n) throws IOException {
        long ret = 0L;
        if (this.readAhead) {
            this.readAhead = false;
            --n;
            ++ret;
        }
        if (n > 0L) {
            ret += super.skip(n);
        }
        return ret;
    }

    public boolean ready() throws IOException {
        if (this.readAhead) {
            return true;
        }
        return super.ready();
    }

    public String readLine() throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = this.read()) > 0 && c != 10 && c != 13) {
            sb.append((char)c);
        }
        if (c == 13 && (c = this.read()) != 10 && c > 0) {
            this.buf = (char)c;
            this.readAhead = true;
        }
        return sb.toString();
    }
}

