/*
 * Decompiled with CFR 0.152.
 */
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.j4me.util.MathFunc;

public class GoogleMapsCanvas
extends Canvas
implements Runnable {
    public static int[] rgb = new int[0];
    public static Image pointer;
    public static Image markers;
    public static Thread t;
    public static int x;
    public static int y;
    public static int shiftx;
    public static int shifty;
    public static Calendar calendar;
    public static int step;
    public static Image image;
    public static Font font;
    public static double lat;
    public static double lon;
    public static double newlat;
    public static double newlon;
    public static int zoom;
    public static String format;
    public static int w;
    public static int h;
    public static int type;
    public static int xpos;
    public static int ypos;
    public static int iw;
    public static int ih;
    public static Image im;
    public static Graphics gr;
    public static Plane pl;
    public static float z;
    public static float rootx;
    public static float rooty;
    public static float rootz;
    public static float tx;
    public static float ty;
    public static float tz;
    public static boolean m3g;
    public static float s;
    public static int xtile;
    public static int ytile;
    boolean flag = false;
    public static boolean done;
    int kp = 0;
    public static BoundingBox box;
    public static final double LOGdiv2 = -0.6931471805599453;

    static {
        markers = pointer = Image.createImage((int)1, (int)1);
        x = 0;
        y = 0;
        shiftx = 0;
        shifty = 0;
        calendar = Calendar.getInstance();
        step = 5;
        image = null;
        font = Font.getFont((int)0, (int)0, (int)0);
        lat = 0.0;
        lon = 0.0;
        newlat = 0.0;
        newlon = 0.0;
        zoom = 0;
        format = "";
        w = 0;
        h = 0;
        type = 0;
        xpos = 0;
        ypos = 0;
        iw = 0;
        ih = 0;
        im = pointer;
        gr = pointer.getGraphics();
        z = 2.0f;
        rootx = 45.0f;
        rooty = 0.0f;
        rootz = 0.0f;
        tx = 0.0f;
        ty = 0.2f;
        tz = 1.2f;
        m3g = false;
        s = 0.0f;
        xtile = 0;
        ytile = 0;
        done = false;
    }

    public void show() {
        GUIManager.show((Displayable)main.m.gmaps.canvas);
        this.flag = true;
        t = null;
        t = new Thread(this);
        t.start();
    }

    public void cancel() {
        this.flag = false;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (m3g) {
            if (pl == null) {
                pl = new Plane(this.getWidth(), this.getHeight());
            }
            pl.paint(graphics);
        } else {
            graphics.drawImage(im, shiftx, shifty, 20);
        }
        if (main.m.md == 1) {
            graphics.setColor(0xFF0000);
            GUIGraphics.drawString(graphics, "x: " + String.valueOf(x) + "/" + String.valueOf(shiftx) + "/" + String.valueOf(xpos), 2, 2, 20);
            GUIGraphics.drawString(graphics, "y: " + String.valueOf(y) + "/" + String.valueOf(shifty) + "/" + String.valueOf(ypos), 2, 22, 20);
            GUIGraphics.drawString(graphics, "3d: " + String.valueOf(tx) + "/" + String.valueOf(ty) + "/" + String.valueOf(tz) + "/" + String.valueOf(s), 2, 42, 20);
        }
        graphics.setColor(0, 0, 255);
        graphics.fillTriangle(this.getWidth() - font.charWidth('N') / 2 - 3, this.getHeight() / 4, this.getWidth() - font.charWidth('N') - 3, this.getHeight() / 2, this.getWidth() - 2, this.getHeight() / 2);
        graphics.drawChar('N', this.getWidth() - font.charWidth('N') - 2, this.getHeight() / 4 - font.getHeight() - 3, 20);
        graphics.setColor(255, 0, 0);
        graphics.fillTriangle(this.getWidth() - font.charWidth('S') / 2 - 3, this.getHeight() * 3 / 4, this.getWidth() - font.charWidth('S') - 3, this.getHeight() / 2, this.getWidth() - 2, this.getHeight() / 2);
        graphics.drawChar('S', this.getWidth() - font.charWidth('S') - 3, this.getHeight() * 3 / 4 + 2, 20);
    }

    public void update() {
        if (image != null) {
            gr.drawImage(image, 0, 0, 20);
            gr.drawImage(pointer, x + Math.abs(shiftx), y + Math.abs(shifty), 20);
        }
        if (m3g) {
            if (pl == null) {
                pl = new Plane(this.getWidth(), this.getHeight());
            }
            pl.update(rootx, rooty, rootz, tx, ty, tz);
            pl.setTexture(im);
        }
        this.repaint();
        try {
            double[] dArray = MapUtil.adjust((GoogleMapsCanvas.box.north + GoogleMapsCanvas.box.south) / (double)2, (GoogleMapsCanvas.box.west + GoogleMapsCanvas.box.east) / (double)2, image.getWidth() / 2 - (pointer.getWidth() / 2 + x + Math.abs(shiftx)), image.getHeight() / 2 - (pointer.getHeight() / 2 + y + Math.abs(shifty)), zoom);
            newlat = dArray[0];
            newlon = dArray[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void down() {
        if (done) {
            return;
        }
        try {
            y += step;
            if (m3g) {
                ty -= s;
                tz += s;
            }
            if (y >= this.getHeight() - pointer.getHeight() - 2) {
                y = this.getHeight() - pointer.getHeight() - 2;
                if ((shifty -= step) <= this.getHeight() - ih - pointer.getHeight() * 3 / 2) {
                    shifty = this.getHeight() - ih - pointer.getHeight() * 3 / 2;
                    done = true;
                    this.download(xpos, ++ypos);
                    shifty = 0;
                    y = -pointer.getHeight() / 2;
                    if (m3g) {
                        ty = 0.7f;
                        tz = 0.7f;
                    }
                }
            }
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas down(): " + String.valueOf(exception.toString()) + " " + String.valueOf(exception.getMessage()) + "\n");
        }
        this.update();
    }

    public void up() {
        if (done) {
            return;
        }
        try {
            y -= step;
            if (m3g) {
                ty += s;
                tz -= s;
            }
            if (y <= -pointer.getHeight() / 2) {
                y = -pointer.getHeight() / 2;
                if ((shifty += step) >= 0) {
                    shifty = 0;
                    y = -pointer.getHeight() / 2;
                    done = true;
                    this.download(xpos, --ypos);
                    shifty = this.getHeight() - ih - pointer.getHeight() * 3 / 2;
                    ty = -0.3f;
                    tz = 1.7f;
                }
            }
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas up(): " + String.valueOf(exception.toString()) + " " + String.valueOf(exception.getMessage()) + "\n");
        }
        this.update();
    }

    public void right() {
        if (done) {
            return;
        }
        try {
            x += step;
            if (m3g) {
                tx += s;
            }
            if (x + pointer.getWidth() / 2 + 2 >= this.getWidth()) {
                x = this.getWidth() - pointer.getWidth() / 2 - 2;
                if ((shiftx -= step) <= this.getWidth() - iw + pointer.getWidth()) {
                    shiftx = this.getWidth() - iw + pointer.getWidth();
                    x = this.getWidth() - pointer.getWidth() / 2 + 2;
                    done = true;
                    this.download(++xpos, ypos);
                    x = -pointer.getWidth() / 2;
                    shiftx = 0;
                    if (m3g) {
                        tx = -0.7f;
                    }
                }
            }
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas right(): " + String.valueOf(exception.toString()) + " " + String.valueOf(exception.getMessage()) + "\n");
        }
        this.update();
    }

    public void left() {
        if (done) {
            return;
        }
        try {
            x -= step;
            if (m3g) {
                tx -= s;
            }
            if (x <= -pointer.getWidth() / 2) {
                x = -pointer.getWidth() / 2;
                if ((shiftx += step) >= 0) {
                    x = -pointer.getWidth() / 2;
                    shiftx = 0;
                    done = true;
                    this.download(--xpos, ypos);
                    shiftx = this.getWidth() - iw + pointer.getWidth();
                    x = this.getWidth() - pointer.getWidth() / 2 + 2;
                    if (m3g) {
                        tx = 0.6f;
                    }
                }
            }
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas left(): " + String.valueOf(exception.toString()) + " " + String.valueOf(exception.getMessage()) + "\n");
        }
        this.update();
    }

    public void keyPressed(int n) {
        try {
            if (n == 48 || n == GUIManager.LEFT_SOFT || n == GUIManager.RIGHT_SOFT) {
                main.m.form.setFullScreen(false);
                main.m.md = 0;
                GUIManager.show(main.m.form);
                this.starter(new GoogleMapsCanvas$1(this));
                this.flag = false;
            } else if (n == 50 || n == GUIManager.UP) {
                this.up();
            } else if (n == 56 || n == GUIManager.DOWN) {
                this.down();
            } else if (n == 52 || n == GUIManager.LEFT) {
                this.left();
            } else if (n == 54 || n == GUIManager.RIGHT) {
                this.right();
            }
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas keypressed: " + String.valueOf(exception.toString()) + " " + String.valueOf(exception.getMessage()) + "\n");
        }
    }

    public void keyReleased(int n) {
        this.kp = 0;
    }

    public void keyRepeated(int n) {
        this.kp = n;
    }

    public void run() {
        while (this.flag) {
            this.keyPressed(this.kp);
        }
    }

    public void starter(Thread thread) {
        thread.setPriority(1);
        thread.start();
    }

    public boolean download(int n, int n2) {
        try {
            box = this.tile2boundingBox(n, n2, zoom);
            image = GoogleMaps.map((GoogleMapsCanvas.box.north + GoogleMapsCanvas.box.south) / (double)2, (GoogleMapsCanvas.box.west + GoogleMapsCanvas.box.east) / (double)2, zoom, type, format, w, h);
            this.starter(new GoogleMapsCanvas$2(this));
            done = false;
            return true;
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas download(): " + String.valueOf(exception.toString()) + " " + String.valueOf(exception.getMessage()) + "\n");
            done = false;
            return false;
        }
    }

    public static double log(double d) {
        if (d <= 0.0) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return 0.0;
        }
        if (!(d <= 1.0)) {
            d = 1.0 / d;
            return -GoogleMapsCanvas._log(d);
        }
        return GoogleMapsCanvas._log(d);
    }

    public static double _log(double d) {
        double d2;
        if (d <= 0.0) {
            return Double.NaN;
        }
        double d3 = 0.0;
        int n = 0;
        while (!(d <= 0.0) && d <= 1.0) {
            d *= 2.0;
            ++n;
        }
        --n;
        double d4 = (d /= 2.0) - 1.0;
        double d5 = d + 1.0;
        double d6 = d2 = d4 / d5;
        d5 = d6 * d2;
        long l = 1;
        while (l < (long)50) {
            d3 += d6 / (double)l;
            d6 *= d5;
            l += (long)2;
        }
        d3 *= 2.0;
        int n2 = 0;
        while (n2 < n) {
            d3 += -0.6931471805599453;
            ++n2;
        }
        return d3;
    }

    BoundingBox tile2boundingBox(int n, int n2, int n3) {
        BoundingBox boundingBox = new BoundingBox(this);
        boundingBox.north = GoogleMapsCanvas.tile2lat(n2, n3);
        boundingBox.south = GoogleMapsCanvas.tile2lat(n2 + 1, n3);
        boundingBox.west = GoogleMapsCanvas.tile2lon(n, n3);
        boundingBox.east = GoogleMapsCanvas.tile2lon(n + 1, n3);
        return boundingBox;
    }

    public static double tile2lon(int n, int n2) {
        return (double)n / GoogleMapsCanvas.pow(2.0, n2) * 360.0 - (double)180;
    }

    public static double tile2lat(int n, int n2) {
        double d = Math.PI - 2.0 * Math.PI * (double)n / GoogleMapsCanvas.pow(2.0, n2);
        return Math.toDegrees(MathFunc.atan(GoogleMapsCanvas.sinh(d)));
    }

    public static double exp(double d) {
        boolean bl;
        if (d == 0.0) {
            return 1.0;
        }
        double d2 = 1.0;
        long l = 1;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d3 = d / (double)l;
        long l2 = 2;
        while (l2 < (long)50) {
            d2 += d3;
            d3 = d3 * d / (double)l2;
            ++l2;
        }
        if (bl) {
            return 1.0 / d2;
        }
        return d2;
    }

    public static double sinh(double d) {
        return (GoogleMapsCanvas.exp(d) - GoogleMapsCanvas.exp(-d)) / (double)2;
    }

    public static double pow(double d, int n) {
        return GoogleMapsCanvas.pow(d, (double)n);
    }

    public static double pow(double d, double d2) {
        boolean bl;
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d2 == 1.0) {
            return d;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        long l = (long)Math.floor(d2);
        boolean bl2 = bl = d2 == (double)l;
        if (bl) {
            boolean bl3 = false;
            if (d2 < 0.0) {
                bl3 = true;
            }
            double d3 = d;
            long l2 = 1;
            while (l2 < (bl3 ? -l : l)) {
                d3 *= d;
                ++l2;
            }
            if (bl3) {
                return 1.0 / d3;
            }
            return d3;
        }
        if (!(d <= 0.0)) {
            return GoogleMapsCanvas.exp(d2 * GoogleMapsCanvas.log(d));
        }
        return Double.NaN;
    }

    public GoogleMapsCanvas(int n, int n2, String string, int n3, int n4) {
        this.setFullScreenMode(true);
        try {
            boolean bl = false;
            if (main.m.md == 1) {
                main.m.form.setFullScreen(true);
            } else {
                main.m.form.setFullScreen(false);
            }
            if (lat == Double.parseDouble(Location.lat) && lon == Double.parseDouble(Location.lon) && zoom == n) {
                return;
            }
            if (zoom != n && zoom != 0) {
                lat = newlat;
                lon = newlon;
            } else {
                lat = Double.parseDouble(Location.lat);
                lon = Double.parseDouble(Location.lon);
            }
            zoom = n;
            type = n2;
            format = string;
            w = n3;
            h = n4;
            xpos = (int)Math.floor((lon + (double)180) / (double)360 * (double)(1 << zoom));
            ypos = (int)Math.floor((1.0 - GoogleMapsCanvas.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / (double)2 * (double)(1 << zoom));
            if (xtile != 0 && ytile != 0 && (xpos != xtile || ypos != ytile)) {
                this.download(xpos, ypos);
                xtile = xpos;
                ytile = ypos;
                return;
            }
            try {
                pointer = Image.createImage((String)"/pointer.png");
                markers = Image.createImage((String)"/markers.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (m3g) {
                pl = new Plane(this.getWidth(), this.getHeight());
            }
            if (image == null) {
                this.download(xpos, ypos);
            }
            xtile = xpos;
            ytile = ypos;
            s = (float)step / 200.0f;
            if (image != null) {
                iw = image.getWidth();
                ih = image.getHeight();
                im = Image.createImage((int)iw, (int)ih);
                gr = im.getGraphics();
            }
            shiftx = this.getWidth() / 2 - iw / 2;
            shifty = this.getHeight() / 2 - ih / 2;
            x = this.getWidth() / 2 - pointer.getWidth() / 2;
            y = this.getHeight() / 2 - pointer.getHeight() / 2;
            this.update();
        }
        catch (Exception exception) {
            main.m.error.append("MapCanvas constructor: ".concat(String.valueOf(exception.toString())).concat("\n"));
        }
    }

    class BoundingBox {
        double north;
        double south;
        double east;
        double west;
        GoogleMapsCanvas this$0;

        public BoundingBox(GoogleMapsCanvas googleMapsCanvas) {
            this.this$0 = googleMapsCanvas;
        }
    }
}

