/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.DeviceScreen;
import com.gui.GUICommand;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import com.gui.Readline;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GUIAlert
extends DeviceScreen
implements Runnable {
    private int screenWidth;
    private int screenHeight;
    private int X;
    private int Y;
    private int poleWidth;
    private int poleHeight;
    private int runnerWidth = 5;
    private int runnerMinHeight = 10;
    private int runnerY;
    private int runnerHeight;
    private int runnerStep = 5;
    private int YS = 0;
    private int step = 15;
    private int totalHeight = 0;
    private int clipH = 0;
    public static GUICommand DISMISS_COMMAND = new GUICommand("OK", 1);
    private String TEXT;
    private Image image;
    private Readline mess;
    private Graphics g = this.getGraphics();
    private boolean open = true;
    private DeviceScreen prev;
    public static final int FOREVER = 0;
    private int timeout;

    public GUIAlert(String title, String message, int timeout) {
        this.timeout = timeout;
        this.setTitle(title);
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.poleWidth = this.screenWidth - 20;
        this.TEXT = message != null ? message : "";
        this.mess = new Readline(this.TEXT);
        this.poleHeight = this.getHeightField();
        this.X = (this.screenWidth - this.poleWidth) / 2;
        this.Y = (this.screenHeight - this.poleHeight) / 2;
        this.clipH = this.poleHeight - this.bordHeight * 5 / 2;
        this.addCommand(DISMISS_COMMAND);
    }

    public void run() {
        if (this.open) {
            int x = this.screenWidth / 2;
            int y = this.screenHeight / 2 - 5;
            int h = 10;
            int w = 0;
            for (int i = 5; i < this.poleWidth / 2; i += 3) {
                this.g.setColor(GUIManager.getTheme().alertBordRGB);
                this.g.fillRoundRect(x - i, y, w += 3, h, 20, 20);
                this.g.setColor(GUIManager.getTheme().alertFrameRGB);
                this.g.drawRoundRect(x - i, y, w += 3, h, 20, 20);
                this.flushGraphics();
            }
            for (int j = 0; j < this.poleHeight / 2; j += 3) {
                this.g.setColor(GUIManager.getTheme().alertBordRGB);
                this.g.fillRoundRect(this.X, y - j, this.poleWidth, h += 3, 20, 20);
                this.g.setColor(GUIManager.getTheme().alertFrameRGB);
                this.g.drawRoundRect(this.X, y - j, this.poleWidth, h += 3, 20, 20);
                this.flushGraphics();
            }
            this.open = false;
            this.repaint();
        }
        if (this.timeout != 0) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GUIManager.show(this.prev);
        }
    }

    int getHeightField() {
        int maxH;
        Graphics g1 = this.getGraphics();
        int h = this.mess.paintComponent(g1, 0, 0, this.poleWidth, this.screenHeight, false);
        if (h >= (maxH = this.screenHeight - 40 - this.bordHeight * 5 / 2)) {
            return this.screenHeight - 40;
        }
        return this.bordHeight * 5 / 2 + h;
    }

    void showNotifyScreen() {
        this.open = true;
        this.reset();
        Thread t = new Thread(this);
        t.setPriority(1);
        t.start();
    }

    void init(Image img, DeviceScreen prev) {
        this.image = img;
        this.prev = prev;
    }

    public void setString(String s) {
        this.TEXT = s != null ? s : "";
        this.mess = new Readline(this.TEXT);
        this.poleHeight = this.getHeightField();
        this.X = (this.screenWidth - this.poleWidth) / 2;
        this.Y = (this.screenHeight - this.poleHeight) / 2;
        this.clipH = this.poleHeight - this.bordHeight * 5 / 2;
    }

    public void setString(String s, int alignment) {
        this.TEXT = s != null ? s : "";
        this.mess = new Readline(this.TEXT, alignment);
        this.poleHeight = this.getHeightField();
        this.X = (this.screenWidth - this.poleWidth) / 2;
        this.Y = (this.screenHeight - this.poleHeight) / 2;
        this.clipH = this.poleHeight - this.bordHeight * 5 / 2;
    }

    public String getString() {
        return this.TEXT;
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    public int getTimeout() {
        return this.timeout;
    }

    void reset() {
        this.YS = 0;
        this.runnerY = 0;
    }

    void paintScreen(Graphics g, int width, int height) {
        g.setClip(this.X, this.Y, this.poleWidth + 1, this.poleHeight + 1);
        g.setFont(this.bordFont);
        g.setColor(GUIManager.getTheme().alertBordRGB);
        g.fillRoundRect(this.X, this.Y, this.poleWidth, this.poleHeight, 20, 20);
        g.setColor(GUIManager.getTheme().alertFrameRGB);
        g.drawRoundRect(this.X, this.Y, this.poleWidth, this.poleHeight, 20, 20);
        int ys1 = this.Y + this.bordHeight;
        int ys2 = this.Y + this.poleHeight - this.bordHeight * 3 / 2;
        int xs1 = this.X;
        int xs2 = this.X + this.poleWidth;
        GUIManager.getTheme().gradientFill(g, xs1 + 1, ys1, this.poleWidth - 1, this.clipH, true, GUIManager.getTheme().alertFonRGB1, GUIManager.getTheme().alertFonRGB2);
        g.setColor(GUIManager.getTheme().alertLabelRGB);
        GUIGraphics.drawString(g, this.title, this.screenWidth / 2, this.Y + 1, 17);
        if (this.timeout == 0) {
            if (this.commandLeft != null && this.commandRight != null) {
                GUICommand uicR = (GUICommand)this.commandLeft[0];
                this.button(g, uicR.getLabel(), xs1, ys2 + 3, 0);
                GUICommand uicL = (GUICommand)this.commandRight[0];
                this.button(g, uicL.getLabel(), xs1, ys2 + 3, 1);
            } else if (this.commandLeft != null) {
                GUICommand uic = (GUICommand)this.commandLeft[0];
                this.button(g, uic.getLabel(), xs1, ys2 + 3, 2);
            } else if (this.commandRight != null) {
                GUICommand uic = (GUICommand)this.commandRight[0];
                this.button(g, uic.getLabel(), xs1, ys2 + 3, 2);
            }
        }
        g.setClip(this.X, ys1, this.poleWidth, this.clipH);
        this.mess.setTextFont(this.textFont);
        this.mess.setColor(GUIManager.getTheme().alertTextRGB);
        this.totalHeight = this.mess.paintComponent(g, this.X + 2, ys1 + this.YS, this.poleWidth - this.runnerWidth, this.clipH, false);
        this.setScroll(g, xs2 - this.runnerWidth, ys1, this.clipH);
        g.setClip(0, 0, this.screenWidth, this.screenHeight);
    }

    public void paint(Graphics gr) {
        gr.drawImage(this.image, 0, 0, 0);
        if (!this.open) {
            this.paintScreen(gr, 0, 0);
        }
    }

    private void setScroll(Graphics g, int x, int y, int height) {
        if (this.totalHeight > height) {
            int countMini = (this.totalHeight - height) / this.step;
            this.runnerHeight = height - this.runnerStep * countMini;
            if (this.runnerHeight < this.runnerMinHeight) {
                this.runnerHeight = this.runnerMinHeight;
                this.runnerStep = (height - this.runnerHeight) / countMini;
            }
            GUIManager.getTheme().gradientFill(g, x, y + 1, this.runnerWidth, height - 2, false, GUIManager.getTheme().alertScrollFieldFonRGB1, GUIManager.getTheme().alertScrollFieldFonRGB2);
            if (this.runnerY < 0) {
                this.runnerY = 0;
            }
            if (this.runnerY + this.runnerHeight > height) {
                this.runnerY = height - this.runnerHeight - 1;
            }
            GUIManager.getTheme().gradientFill(g, x + 1, y + this.runnerY + 1, this.runnerWidth - 2, this.runnerHeight - 1, false, GUIManager.getTheme().alertScrollRGB1, GUIManager.getTheme().alertScrollRGB2);
            g.setColor(GUIManager.getTheme().alertScrollFrameRGB);
            g.drawRect(x + 1, y + this.runnerY + 1, this.runnerWidth - 2, this.runnerHeight - 1);
        }
    }

    private void button(Graphics g, String name, int x, int y, int pos) {
        int maxWidthButton = (this.poleWidth - 20) / 2;
        int xs = x;
        int sw = this.bordFont.stringWidth(name);
        if (pos == 0) {
            if (sw > maxWidthButton) {
                xs += (this.poleWidth / 2 - maxWidthButton) / 2;
                name = this.getShowString(name, g.getFont(), maxWidthButton);
            } else {
                xs += (this.poleWidth / 2 - sw) / 2;
                maxWidthButton = sw;
            }
        } else if (pos == 1) {
            if (sw > maxWidthButton) {
                xs += this.poleWidth / 2 + (this.poleWidth / 2 - maxWidthButton) / 2;
                name = this.getShowString(name, g.getFont(), maxWidthButton);
            } else {
                xs += this.poleWidth / 2 + (this.poleWidth / 2 - sw) / 2;
                maxWidthButton = sw;
            }
        } else {
            maxWidthButton = this.poleWidth - 10;
            if (sw > maxWidthButton) {
                xs += (this.poleWidth - maxWidthButton) / 2;
                name = this.getShowString(name, g.getFont(), maxWidthButton);
            } else {
                xs += (this.poleWidth - sw) / 2;
                maxWidthButton = sw;
            }
        }
        GUIManager.getTheme().gradientFill(g, xs - 2, y, maxWidthButton + 4, this.bordHeight, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
        g.setColor(GUIManager.getTheme().cursorFrameRGB);
        g.drawRect(xs - 2, y, maxWidthButton + 4, this.bordHeight);
        g.setColor(GUIManager.getTheme().itemPasteRGB);
        GUIGraphics.drawString(g, name, xs, y + 2, 0);
    }

    public void keyPressed(int key) {
        if (!this.open && this.timeout == 0) {
            if ((key == GUIManager.LEFT_SOFT || key == GUIManager.FIRE || GUIManager.isDuplicationOfKeysOfNavigation() && key == 53) && this.commandLeft != null) {
                GUICommand guicL = (GUICommand)this.commandLeft[0];
                this.guicl.commandAction(guicL, this);
            }
            if (key == GUIManager.RIGHT_SOFT && this.commandRight != null) {
                GUICommand guicR = (GUICommand)this.commandRight[0];
                this.guicl.commandAction(guicR, this);
            }
            if ((key == GUIManager.DOWN || GUIManager.isDuplicationOfKeysOfNavigation() && key == 56) && this.YS + this.totalHeight > this.poleHeight - this.bordHeight * 5 / 2) {
                this.YS -= this.step;
                this.runnerY += this.runnerStep;
            }
            if ((key == GUIManager.UP || GUIManager.isDuplicationOfKeysOfNavigation() && key == 50) && this.YS < 0) {
                this.YS += this.step;
                this.runnerY -= this.runnerStep;
            }
            this.repaint();
        }
    }

    public void keyRepeated(int key) {
        this.keyPressed(key);
    }

    void keyPress(int key) {
    }

    void keyRepeat(int key) {
    }

    void hideNotifyScreen() {
    }

    private String getShowString(String s, Font f, int w) {
        if (f.stringWidth(s) > w) {
            StringBuffer sb = new StringBuffer();
            char[] ch = s.toCharArray();
            for (int i = 0; i < s.length(); ++i) {
                if (f.stringWidth(sb.toString()) >= w - 5) {
                    sb.delete(0, sb.length());
                    sb.append(ch, 0, i);
                    break;
                }
                sb.append(ch[i]);
            }
            return sb.toString();
        }
        return s;
    }
}

