/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.GUIGraphics;
import com.gui.GUIManager;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GUIMenu {
    private String[] item;
    private int WIDTH;
    private int HEIGHT;
    private int maxItem;
    private int maxHeightPole;
    private int widthPole;
    private int heightPole;
    private int showItem;
    private int Y;
    private int X;
    private int startIndex;
    private int cursorY;
    private int cursorPosition;
    private int runnerY;
    private int runnerHeight;
    private int runnerMinHeight = 15;
    private int runnerWidth = 6;
    private double rs;
    private double ss;
    public static final int CENTER = -1000;
    public static final int LEFT = -2000;
    public static final int RIGHT = -3000;
    public static final int UP = -4000;
    public static final int DOWN = -5000;
    private Font font;
    private int fontHeight;
    private Image[] icon = null;

    public GUIMenu(String[] i, Image[] icons, int displayW, int displayH) {
        this.WIDTH = displayW;
        this.HEIGHT = displayH;
        this.font = Font.getFont((int)0, (int)1, (int)0);
        this.fontHeight = this.font.getHeight();
        this.append(i, icons);
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public int getWidthPole() {
        int w = 0;
        if (this.item != null) {
            for (int i = 0; i < this.item.length; ++i) {
                int j = this.font.stringWidth(this.item[i]);
                if (this.icon[i] != null) {
                    int iw = this.icon[i].getWidth();
                    int ih = this.icon[i].getHeight();
                    if (iw <= 30 && ih <= this.fontHeight + 5) {
                        j = j + iw + 4;
                    }
                }
                if (j <= w) continue;
                w = j;
            }
        }
        if (w > 0) {
            w += 30;
        }
        if (w > this.WIDTH) {
            w = this.WIDTH - 1;
        }
        return w;
    }

    public int getHeightPole() {
        int h = 0;
        if (this.item != null) {
            int s = this.item.length;
            if ((h += s * this.fontHeight) > this.maxHeightPole) {
                h = this.maxHeightPole;
            }
            this.showItem = s >= this.maxItem ? this.maxItem : s;
        }
        return h;
    }

    private void instalIcons() {
        int s;
        if (this.item != null && (s = this.item.length) > 0) {
            this.icon = new Image[s];
            for (int i = 0; i < s; ++i) {
                this.icon[i] = null;
            }
        }
    }

    private void setScroll() {
        int s;
        if (this.item != null && (s = this.item.length) > 0) {
            this.runnerHeight = this.heightPole - this.fontHeight * (s - this.showItem);
            if (this.runnerHeight <= this.runnerMinHeight) {
                this.runnerHeight = this.runnerMinHeight;
                this.ss = (double)(this.heightPole - this.runnerHeight) / (double)(s - this.showItem + 1);
            } else {
                this.ss = this.fontHeight;
            }
        }
    }

    private void reset() {
        this.maxItem = (this.HEIGHT - 30) / this.fontHeight - 3;
        this.maxHeightPole = this.maxItem * this.fontHeight;
        this.widthPole = this.getWidthPole();
        this.heightPole = this.getHeightPole();
        this.cursorY = this.Y;
        this.runnerY = this.Y;
        this.cursorPosition = 0;
        this.startIndex = 0;
        this.rs = 0.0;
        this.setScroll();
    }

    void show(Graphics g) {
        if (this.item != null) {
            int s = this.item.length;
            int ith = this.fontHeight;
            if (s >= 0) {
                g.setFont(this.font);
                GUIManager.getTheme().gradientFill(g, this.X, this.Y, this.widthPole, this.heightPole - 1, false, GUIManager.getTheme().fonRGB1, GUIManager.getTheme().fonRGB2);
                g.setColor(GUIManager.getTheme().fonFrameRGB);
                g.drawRect(this.X - 1, this.Y - 1, this.widthPole, this.heightPole + 1);
                if (s > 0) {
                    if (s > this.showItem) {
                        GUIManager.getTheme().gradientFill(g, this.X, this.cursorY, this.widthPole - this.runnerWidth, ith - 1, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                        g.setColor(GUIManager.getTheme().cursorFrameRGB);
                        g.drawRect(this.X, this.cursorY, this.widthPole - this.runnerWidth, ith - 1);
                    } else {
                        GUIManager.getTheme().gradientFill(g, this.X, this.cursorY, this.widthPole - 2, ith - 1, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                        g.setColor(GUIManager.getTheme().cursorFrameRGB);
                        g.drawRect(this.X, this.cursorY, this.widthPole - 2, ith - 1);
                    }
                }
                int ys = this.Y;
                int js = 0;
                int xs = 2;
                for (int i = this.startIndex; i < s; ++i) {
                    g.setColor(GUIManager.getTheme().itemRGB);
                    if (i == this.cursorPosition) {
                        g.setColor(GUIManager.getTheme().itemPasteRGB);
                    }
                    if (this.icon[i] != null) {
                        int iw = this.icon[i].getWidth();
                        int ih = this.icon[i].getHeight();
                        if (iw <= 30 && ih <= ith + 5) {
                            GUIGraphics.drawImage(g, this.icon[i], this.X + xs, ys + ith / 2, 6);
                            xs = xs + iw + 2;
                        }
                    }
                    GUIGraphics.drawString(g, this.item[i], this.X + xs, ys + 1, 0);
                    ys += ith;
                    xs = 2;
                    if (++js == this.showItem) break;
                }
                this.scroll(g);
            }
        }
    }

    public void down() {
        int s;
        if (this.item != null && (s = this.item.length) > 1) {
            if (this.cursorPosition == s - 1) {
                this.cursorY = this.Y;
                this.runnerY = this.Y;
                this.rs = 0.0;
                this.cursorPosition = 0;
                this.startIndex = 0;
            } else if (this.cursorPosition >= this.showItem - 1 && this.cursorY == this.Y + (this.showItem - 1) * this.fontHeight) {
                ++this.startIndex;
                ++this.cursorPosition;
                this.rs += this.ss;
                this.runnerY = (int)this.rs + this.Y;
            } else {
                this.cursorY += this.fontHeight;
                ++this.cursorPosition;
            }
        }
    }

    public void up() {
        int s;
        if (this.item != null && (s = this.item.length) > 1) {
            if (this.cursorPosition == 0) {
                this.cursorPosition = s - 1;
                this.cursorY = this.Y + (this.showItem - 1) * this.fontHeight;
                this.runnerY = this.heightPole - this.runnerHeight;
                this.rs = this.runnerY;
                this.startIndex = s - this.showItem;
            } else if (this.cursorY == this.Y) {
                --this.cursorPosition;
                --this.startIndex;
                this.rs -= this.ss;
                this.runnerY = (int)this.rs + this.Y;
            } else {
                --this.cursorPosition;
                this.cursorY -= this.fontHeight;
            }
        }
    }

    private void scroll(Graphics g) {
        int s;
        if (this.item != null && (s = this.item.length) > this.showItem) {
            if (this.cursorPosition == 0) {
                this.runnerY = this.Y;
            }
            if (this.cursorPosition == s - 1) {
                this.runnerY = this.heightPole - this.runnerHeight - 1 + this.Y;
            }
            GUIManager.getTheme().gradientFill(g, this.X + this.widthPole - this.runnerWidth, this.Y + 1, this.runnerWidth - 1, this.heightPole - 2, false, GUIManager.getTheme().scrollFieldFonRGB1, GUIManager.getTheme().scrollFieldFonRGB2);
            GUIManager.getTheme().gradientFill(g, this.X + this.widthPole - this.runnerWidth + 1, this.runnerY + 1, this.runnerWidth - 2, this.runnerHeight - 2, false, GUIManager.getTheme().scrollRGB1, GUIManager.getTheme().scrollRGB2);
            g.setColor(GUIManager.getTheme().scrollFrameRGB);
            g.drawRect(this.X + this.widthPole - this.runnerWidth, this.runnerY + 1, this.runnerWidth - 1, this.runnerHeight - 2);
        }
    }

    public void append(String[] items, Image[] imgs) {
        if (items != null) {
            this.item = items;
            this.setIcons(imgs);
            this.reset();
            this.setX(-1000);
            this.setY(-1000);
        }
    }

    public void append(String stringPart, Image imagePart) {
        if (stringPart != null) {
            int sz = this.item != null ? this.item.length : 0;
            String[] a = new String[sz + 1];
            Image[] imgs = new Image[sz + 1];
            for (int i = 0; i < sz; ++i) {
                a[i] = this.item[i];
                imgs[i] = this.icon[i];
            }
            a[sz] = stringPart;
            imgs[sz] = imagePart;
            this.append(a, imgs);
        }
    }

    public void setY(int y) {
        int s = this.heightPole;
        switch (y) {
            case -1000: {
                this.Y = (this.HEIGHT - s) / 2;
                break;
            }
            case -4000: {
                this.Y = 0;
                break;
            }
            case -5000: {
                this.Y = this.HEIGHT - s;
                break;
            }
            default: {
                this.Y = y;
            }
        }
        this.cursorY = this.Y;
        this.runnerY = this.Y;
    }

    public void setX(int x) {
        switch (x) {
            case -1000: {
                this.X = (this.WIDTH - this.widthPole) / 2;
                break;
            }
            case -2000: {
                this.X = 0;
                break;
            }
            case -3000: {
                this.X = this.WIDTH - this.widthPole;
                break;
            }
            default: {
                this.X = x;
            }
        }
    }

    private void setIcons(Image[] imgs) {
        if (imgs != null && imgs.length == this.item.length) {
            this.icon = imgs;
        } else {
            this.instalIcons();
        }
    }

    public Image getIcon(int index) {
        if (index >= 0 && index < this.item.length) {
            return this.icon[index];
        }
        return null;
    }

    public Image[] getIcons() {
        return this.icon;
    }

    public int getSelectedIndex() {
        return this.cursorPosition;
    }

    public String getString(int index) {
        if (index >= 0 && index < this.item.length) {
            return this.item[index];
        }
        return null;
    }

    public int getX() {
        return this.X;
    }

    public final int getY() {
        return this.Y;
    }

    public String[] getItems() {
        return this.item;
    }

    public int size() {
        if (this.item != null) {
            return this.item.length;
        }
        return 0;
    }
}

