/*
 * Decompiled with CFR 0.152.
 */
package fs;

import fs.FtpProtocolException;
import fs.LineReader;
import fs.PasvInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;

public class Ftp {
    public static final int RESP_ALL = 255;
    private SocketConnection conn;
    SocketConnection dataConnection;
    OutputStream dataOutput;
    SocketConnection dataInput;
    InputStream in;
    private LineReader input;
    private OutputStream output;
    private String lastMessage;
    private int lastCode;

    public Ftp(String host) throws IOException, FtpProtocolException {
        this(host, 21);
    }

    public Ftp(String host, int port) throws IOException, FtpProtocolException {
        this.conn = (SocketConnection)Connector.open((String)("socket://" + host + ":" + port));
        this.input = new LineReader(this.conn.openInputStream());
        this.output = this.conn.openOutputStream();
        this.getResponse();
        if (this.lastCode == 120) {
            this.expectResponse(220);
        } else if (this.lastCode != 220) {
            throw new FtpProtocolException(this.lastMessage);
        }
    }

    public Ftp(String host, int port, String user, String pass) throws IOException, FtpProtocolException {
        this(host, port);
        this.user(user);
        this.pass(pass);
    }

    public Ftp(String host, int port, String user, String pass, String acct) throws IOException, FtpProtocolException {
        this(host, port, user, pass);
        this.acct(acct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            this.input.close();
            this.output.close();
            this.conn.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.input = null;
            this.output = null;
            this.conn = null;
        }
    }

    public void setChmod(int value, String name) throws IOException, FtpProtocolException {
        this.sendLine("CHMOD " + value + " " + name);
    }

    public boolean abor() throws IOException, FtpProtocolException {
        this.sendLine("\u00e1\u00e0\u00f2ABOR");
        int resp = this.getResponse();
        if (resp == 426) {
            this.expectResponse(226);
        } else if (resp != 226) {
            throw new FtpProtocolException(this.lastMessage);
        }
        return false;
    }

    public void acct(String account) throws IOException, FtpProtocolException {
        this.sendLine("ACCT " + account);
        this.expectResponse(200);
    }

    public boolean allo(long size, long maxRecordSize) throws IOException, FtpProtocolException {
        if (maxRecordSize > 0L) {
            this.sendLine("ALLO " + String.valueOf(size) + " R " + String.valueOf(maxRecordSize));
        } else {
            this.sendLine("ALLO " + String.valueOf(size));
        }
        this.expectResponse(200);
        return false;
    }

    public OutputStream appe(String filename) throws IOException, FtpProtocolException {
        PasvInfo pi = this.pasv();
        this.sendLine("APPE " + filename);
        this.dataConnection = (SocketConnection)Connector.open((String)("socket://" + pi.ip + ":" + pi.port));
        this.expectResponse(150);
        this.dataOutput = this.dataConnection.openOutputStream();
        return this.dataOutput;
    }

    public void close() throws IOException, FtpProtocolException {
        if (this.dataOutput != null) {
            this.dataOutput.close();
        }
        if (this.dataConnection != null) {
            this.dataConnection.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.dataInput != null) {
            this.dataInput.close();
        }
    }

    public void cdup() throws IOException, FtpProtocolException {
        this.sendLine("CDUP");
        this.expectResponse(250);
    }

    public void cwd(String dir) throws IOException, FtpProtocolException {
        this.sendLine("CWD " + dir);
        this.expectResponse(250);
    }

    public void dele(String filename) throws IOException, FtpProtocolException {
        this.sendLine("DELE " + filename);
        this.expectResponse(250);
    }

    public void help(String command) throws IOException, FtpProtocolException {
        if (command != null) {
            this.sendLine("HELP " + command);
        } else {
            this.sendLine("HELP");
        }
        this.expectResponse(214);
    }

    public Enumeration list() throws IOException, FtpProtocolException {
        String line;
        PasvInfo pi = this.pasv();
        this.sendLine("LIST -al");
        SocketConnection dataInput = (SocketConnection)Connector.open((String)("socket://" + pi.ip + ":" + pi.port));
        this.expectResponse(150);
        Vector<String> ret = new Vector<String>();
        LineReader in = new LineReader(dataInput.openInputStream());
        while (!(line = in.readLine()).equals("")) {
            ret.addElement(line);
        }
        in.close();
        dataInput.close();
        this.expectResponse(226);
        return ret.elements();
    }

    public void mkd(String pathname) throws IOException, FtpProtocolException {
        this.sendLine("MKD " + pathname);
        this.expectResponse(250);
    }

    public void mode(char mode) throws IOException, FtpProtocolException {
        this.sendLine("MODE " + mode);
        this.expectResponse(200);
    }

    public Enumeration nlst() throws IOException, FtpProtocolException {
        String line;
        PasvInfo pi = this.pasv();
        this.sendLine("NLST -al");
        SocketConnection dataInput = (SocketConnection)Connector.open((String)("socket://" + pi.ip + ":" + pi.port));
        this.expectResponse(150);
        Vector<String> ret = new Vector<String>();
        LineReader in = new LineReader(dataInput.openInputStream());
        while (!(line = in.readLine()).equals("")) {
            ret.addElement(line);
        }
        in.close();
        dataInput.close();
        this.expectResponse(226);
        return ret.elements();
    }

    public void noop() throws IOException, FtpProtocolException {
        this.sendLine("NOOP");
        this.expectResponse(200);
    }

    public void pass(String pass) throws IOException, FtpProtocolException {
        this.sendLine("PASS " + pass);
        this.expectResponse(230);
    }

    public PasvInfo pasv() throws IOException, FtpProtocolException {
        PasvInfo pi = null;
        this.sendLine("PASV");
        this.expectResponse(227);
        int opening = this.lastMessage.indexOf(40);
        int closing = this.lastMessage.indexOf(41, opening + 1);
        if (closing <= 0) {
            throw new FtpProtocolException("Badly formatted answer received after PASV");
        }
        String dataLink = this.lastMessage.substring(opening + 1, closing);
        pi = new PasvInfo(dataLink);
        return pi;
    }

    public void port(int h1, int h2, int h3, int h4, int port) throws IOException, FtpProtocolException {
        this.sendLine("PORT " + String.valueOf(h1) + "," + String.valueOf(h2) + "," + String.valueOf(h3) + "," + String.valueOf(h4) + "," + String.valueOf((port & 0xFF00) >> 8) + "," + String.valueOf(port & 0xFF));
        this.expectResponse(200);
    }

    public String pwd() throws IOException, FtpProtocolException {
        this.sendLine("PWD");
        this.expectResponse(257);
        String dir = null;
        int firstQuote = this.lastMessage.indexOf(34);
        int secondQuote = this.lastMessage.indexOf(34, firstQuote + 1);
        if (secondQuote > 0) {
            dir = this.lastMessage.substring(firstQuote + 1, secondQuote);
        }
        return dir;
    }

    public void quit() throws IOException, FtpProtocolException {
        this.sendLine("QUIT");
    }

    public void rein() throws IOException, FtpProtocolException {
        this.sendLine("REIN");
        this.expectResponse(230);
    }

    public void rest(String marker) throws IOException, FtpProtocolException {
        this.sendLine("REST " + marker);
        this.expectResponse(350);
    }

    public InputStream retr(String filename) throws IOException, FtpProtocolException {
        PasvInfo pi = this.pasv();
        this.sendLine("RETR " + filename);
        this.dataInput = (SocketConnection)Connector.open((String)("socket://" + pi.ip + ":" + pi.port));
        this.expectResponse(150);
        this.in = this.dataInput.openInputStream();
        return this.in;
    }

    public void rmd(String pathname) throws IOException, FtpProtocolException {
        this.sendLine("RMD " + pathname);
        this.expectResponse(250);
    }

    public void rnfr(String pathname) throws IOException, FtpProtocolException {
        this.sendLine("RNFR " + pathname);
        this.expectResponse(350);
    }

    public void rnto(String pathname) throws IOException, FtpProtocolException {
        this.sendLine("RNTO " + pathname);
        this.expectResponse(250);
    }

    public void site() throws IOException, FtpProtocolException {
        this.sendLine("SITE");
        this.expectResponse(200);
    }

    public void smnt(String pathname) throws IOException, FtpProtocolException {
        this.sendLine("SMNT " + pathname);
        this.expectResponse(250);
    }

    public void stat(String pathname) throws IOException, FtpProtocolException {
        if (pathname != null) {
            this.sendLine("STAT " + pathname);
        } else {
            this.sendLine("STAT");
        }
        this.getResponse();
        if (!this.isPositiveCompletion()) {
            throw new FtpProtocolException(this.lastMessage);
        }
    }

    public OutputStream stor(String filename) throws IOException, FtpProtocolException {
        PasvInfo pi = this.pasv();
        this.sendLine("STOR " + filename);
        this.dataConnection = (SocketConnection)Connector.open((String)("socket://" + pi.ip + ":" + pi.port));
        this.expectResponse(150);
        this.dataOutput = this.dataConnection.openOutputStream();
        return this.dataOutput;
    }

    public OutputStream stou(String filename) throws IOException, FtpProtocolException {
        PasvInfo pi = this.pasv();
        this.sendLine("STOR " + filename);
        this.dataConnection = (SocketConnection)Connector.open((String)("socket://" + pi.ip + ":" + pi.port));
        this.expectResponse(150);
        this.dataOutput = this.dataConnection.openOutputStream();
        return this.dataOutput;
    }

    public void stru(char structure) throws IOException, FtpProtocolException {
        this.sendLine("STRU " + structure);
        this.expectResponse(200);
    }

    public void syst() throws IOException, FtpProtocolException {
        this.sendLine("SYST");
        this.expectResponse(215);
    }

    public void type(char type) throws IOException, FtpProtocolException {
        this.type(type, 8);
    }

    public void type(char type, int bytesize) throws IOException, FtpProtocolException {
        if (type == 'L') {
            this.sendLine("TYPE " + type + " " + String.valueOf(bytesize));
        } else {
            this.sendLine("TYPE " + type);
        }
        this.expectResponse(200);
    }

    public void user(String user) throws IOException, FtpProtocolException {
        this.sendLine("USER " + user);
        this.expectResponse(331);
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    private void sendLine(String line) throws IOException, FtpProtocolException {
        if (this.conn == null) {
            throw new FtpProtocolException("FtpMe is not connected.");
        }
        try {
            this.output.write((line + "\r\n").getBytes());
            this.output.flush();
        }
        catch (IOException e) {
            this.input = null;
            this.output = null;
            this.conn = null;
            throw e;
        }
    }

    private int getResponse() throws FtpProtocolException, IOException {
        StringBuffer sb = new StringBuffer();
        String line = this.input.readLine();
        sb.append(line + "\n");
        String strret = line.substring(0, 3);
        char multiLineIndicator = line.charAt(3);
        try {
            this.lastCode = Integer.parseInt(strret);
        }
        catch (NumberFormatException e) {
            throw new FtpProtocolException("FtpMe: Bad response code");
        }
        if (multiLineIndicator == '-') {
            do {
                line = this.input.readLine();
                sb.append(line + "\n");
            } while (!line.substring(0, 3).equals(strret));
        } else if (multiLineIndicator != ' ') {
            throw new FtpProtocolException("FtpMe: Malformed multi-line response");
        }
        this.lastMessage = sb.toString();
        return this.lastCode;
    }

    public void expectResponse(int expectedCode) throws IOException, FtpProtocolException {
        if (this.getResponse() != expectedCode) {
            throw new FtpProtocolException(this.lastMessage);
        }
    }

    public boolean isPositivePreliminary() {
        return this.lastCode >= 100 && this.lastCode < 200;
    }

    public boolean isPositiveCompletion() {
        return this.lastCode >= 200 && this.lastCode < 300;
    }

    public boolean isPositiveIntermediate() {
        return this.lastCode >= 300 && this.lastCode < 400;
    }

    public boolean isNegativeTransient() {
        return this.lastCode >= 400 && this.lastCode < 500;
    }

    public boolean isNegativePermanent() {
        return this.lastCode >= 500 && this.lastCode < 600;
    }
}

