/*
 * Decompiled with CFR 0.152.
 */
package gps.tracker;

import gps.Coordinates;
import gps.Debug;
import gps.GPS;
import gps.tracker.FileIOListener;
import gps.tracker.Write;
import gps.utilities.Utilities;
import java.io.IOException;
import java.util.Vector;

public class Tracker
implements Runnable {
    private int time = 5;
    private int counterSave = 1;
    private Thread t = new Thread(this);
    private GPS gp;
    private boolean mEndnow = false;
    private Vector coordVector = new Vector();
    private Vector coordVector2 = new Vector();
    private boolean pause = false;
    private boolean meters;
    private int coordinatesFormat;
    private FileIOListener listener;

    public Tracker(GPS gps, int time, int coordinatesFormat, boolean meters, FileIOListener listener) throws NumberFormatException {
        this.meters = meters;
        this.listener = listener;
        if (coordinatesFormat < 0) {
            throw new NumberFormatException("The CoordinatesFormat code is not valid");
        }
        this.coordinatesFormat = coordinatesFormat;
        if (time < 1 || time > 1000) {
            throw new NumberFormatException("time must be between 1 and 1000");
        }
        this.time = time;
        this.mEndnow = false;
        this.gp = gps;
        Debug.setDebug("tracker created", 2);
    }

    public Tracker(GPS gps, FileIOListener listener) {
        this(gps, 0, 5, true, listener);
    }

    public Tracker(GPS gps, int time, int coordinatesFormat, FileIOListener listener) throws NumberFormatException {
        this(gps, time, coordinatesFormat, true, listener);
    }

    public void reset() {
        this.counterSave = 1;
        this.coordVector.removeAllElements();
        Debug.setDebug("tracker reseted", 2);
    }

    public void setTime(int time) throws NumberFormatException {
        if (time < 1 || time > 1000) {
            throw new NumberFormatException("time must be between 1 and 1000");
        }
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public void setCoordinatesFormat(int format) throws NumberFormatException {
        if (this.time < 0) {
            throw new NumberFormatException("Format is not valid");
        }
        this.coordinatesFormat = format;
    }

    public int getCoordinatesFormat() {
        return this.coordinatesFormat;
    }

    public void pause() {
        this.pause = true;
        Debug.setDebug("tracker paused", 2);
    }

    public void resume() {
        this.pause = false;
        Debug.setDebug("tracker Resumed", 2);
    }

    public boolean isPaused() {
        return this.pause;
    }

    public Vector getRecords() {
        return this.coordVector2;
    }

    public void start() {
        if (this.t != null) {
            this.mEndnow = false;
            this.coordVector.removeAllElements();
            this.coordVector2.removeAllElements();
            this.counterSave = 1;
            this.t = new Thread(this);
            this.t.start();
            Debug.setDebug("tracker started", 2);
        }
    }

    public void stop() {
        this.mEndnow = true;
        Debug.setDebug("tracker stopped", 2);
    }

    public void saveCoordinates(String filePath) throws IOException {
        this.mEndnow = true;
        Write rw = new Write(filePath, this.listener);
        rw.save(this.coordVector);
    }

    public void run() {
        String lastTime = "";
        while (!this.mEndnow) {
            String timeNow = this.gp.getTime();
            if (!this.pause) {
                Coordinates point = this.gp.getCoordinates();
                if (this.gp.hasFix() && !timeNow.equals(lastTime)) {
                    String save = new String();
                    switch (this.coordinatesFormat) {
                        case 0: {
                            save = this.counterSave + "," + point.getLongitude() + "," + point.getLatitude() + "," + timeNow + ",";
                            if (this.meters) {
                                save = save + point.getAltitude();
                                break;
                            }
                            save = save + Utilities.metersToFeet(point.getAltitude());
                            break;
                        }
                        case 1: {
                            save = this.counterSave + "," + Utilities.degreesToDegreesMinSec(point.getLongitude(), 1) + "," + Utilities.degreesToDegreesMinSec(point.getLatitude(), 0) + "," + timeNow + ",";
                            if (this.meters) {
                                save = save + point.getAltitude();
                                break;
                            }
                            save = save + Utilities.metersToFeet(point.getAltitude());
                            break;
                        }
                        default: {
                            double[] temp = Utilities.toDatum(point.getLatitude(), point.getLongitude(), this.coordinatesFormat);
                            save = this.counterSave + "," + temp[1] + "," + temp[0] + "," + timeNow + ",";
                            save = this.meters ? save + point.getAltitude() : save + Utilities.metersToFeet(point.getAltitude());
                        }
                    }
                    Debug.setDebug("tracker recording " + save, 2);
                    this.coordVector.addElement(save);
                    this.coordVector2.addElement(point);
                    ++this.counterSave;
                    lastTime = timeNow;
                }
            }
            try {
                Thread.sleep(this.time * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

