/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.Background;
import com.gui.GUICommand;
import com.gui.GUICommandListener;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import com.gui.GUIMenu;
import com.gui.UniKeys;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class DeviceScreen
extends GameCanvas {
    GUICommandListener guicl = null;
    String title;
    int WIDTH;
    int HEIGHT;
    int clipHeight;
    Object[] commandBuffer = null;
    Object[] commandLeft = null;
    Object[] commandRight = null;
    private boolean showMenu = false;
    private GUIMenu commandMenu;
    private boolean fullScreen = false;
    private Background background = null;
    private Image titleImage = null;
    private int titleAlignment = 1;
    Font bordFont;
    Font itemFont;
    Font textFont;
    int bordHeight;
    int itemHeight;
    int textHeight;
    private ThreadClass check = new ThreadClass();

    public DeviceScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.title = "";
        this.WIDTH = this.getWidth();
        this.HEIGHT = this.getHeight();
        this.bordFont = GUIManager.getTheme().bordFont;
        this.itemFont = GUIManager.getTheme().itemFont;
        this.bordHeight = GUIManager.getTheme().bordHeight;
        this.itemHeight = GUIManager.getTheme().itemHeight;
        this.clipHeight = this.HEIGHT - this.bordHeight * 2;
        this.commandMenu = new GUIMenu(null, null, this.getWidth(), this.getHeight());
        this.check.start();
    }

    public final void setGUICommandListener(GUICommandListener l) {
        this.guicl = l;
    }

    public void setBackground(Background bg) {
        this.background = bg;
    }

    public void setTitle(String s) {
        this.title = s == null ? "" : s;
    }

    public void setTitle(String s, int alignment) {
        this.title = s == null ? "" : s;
        if (alignment == 4 || alignment == 8) {
            this.titleAlignment = alignment;
        }
    }

    public void setTitle(String s, Image img) {
        if (img != null) {
            this.titleImage = img;
        }
        this.setTitle(s);
    }

    public void setTitle(String s, Image img, int alignment) {
        if (img != null) {
            this.titleImage = img;
        }
        this.setTitle(s, alignment);
    }

    public final void addCommand(GUICommand cmd) {
        if (!this.exist(this.commandBuffer, cmd)) {
            this.commandBuffer = this.addElement(this.commandBuffer, cmd);
            if (cmd.getAnchor() == 1) {
                this.commandLeft = this.addElement(this.commandLeft, cmd);
            } else if (cmd.getAnchor() == 2) {
                this.commandRight = this.addElement(this.commandRight, cmd);
            }
        }
    }

    public final void remmoveCommand(GUICommand cmd) {
        if (cmd.getAnchor() == 1) {
            this.commandLeft = this.removeElement(this.commandLeft, cmd);
        } else if (cmd.getAnchor() == 2) {
            this.commandRight = this.removeElement(this.commandRight, cmd);
        }
        this.commandBuffer = this.removeElement(this.commandBuffer, cmd);
    }

    public void setFullScreen(boolean flag) {
        this.fullScreen = flag;
        this.clipHeight = !flag ? this.HEIGHT - this.bordHeight * 2 : this.HEIGHT;
    }

    static void paint3Dtext(Graphics g, String s, int x, int y, int anchor, int color) {
        g.setColor(color);
        GUIGraphics.drawString(g, s, x, y, anchor);
    }

    public void paint(Graphics g) {
        if (this.showMenu) {
            this.commandMenu.show(g);
        } else {
            this.show(g);
        }
    }

    void show(Graphics g) {
        int w = this.WIDTH;
        int bh = this.bordHeight;
        if (this.background != null) {
            this.background.paint(g);
        } else if (GUIManager.getBackground() != null) {
            GUIManager.getBackground().paint(g);
        } else {
            GUIManager.getTheme().gradientFill(g, 0, 0, w, this.HEIGHT, true, GUIManager.getTheme().fonRGB1, GUIManager.getTheme().fonRGB2);
        }
        if (!this.fullScreen) {
            int sw;
            int iw;
            GUIManager.getTheme().gradientFill(g, 0, 0, w, bh, true, GUIManager.getTheme().bordFonRGB1, GUIManager.getTheme().bordFonRGB2);
            g.setColor(GUIManager.getTheme().bordFrameRGB);
            g.drawRect(0, 0, w - 1, bh - 1);
            g.setFont(this.bordFont);
            int xs = 2;
            if (this.titleAlignment == 4) {
                if (this.titleImage != null) {
                    GUIGraphics.drawImage(g, this.titleImage, xs, bh / 2, 6);
                    xs += this.titleImage.getWidth() + 2;
                }
                DeviceScreen.paint3Dtext(g, this.title, xs, 1, 20, GUIManager.getTheme().bordTextRGB);
            } else if (this.titleAlignment == 1) {
                if (this.titleImage != null) {
                    iw = this.titleImage.getWidth() + 2;
                    sw = this.bordFont.stringWidth(this.title);
                    int xss = (w - iw - sw) / 2;
                    GUIGraphics.drawImage(g, this.titleImage, xss, bh / 2, 6);
                    DeviceScreen.paint3Dtext(g, this.title, xss + iw, 1, 20, GUIManager.getTheme().bordTextRGB);
                } else {
                    DeviceScreen.paint3Dtext(g, this.title, w / 2, 1, 17, GUIManager.getTheme().bordTextRGB);
                }
            } else if (this.titleImage != null) {
                iw = this.titleImage.getWidth() + 2;
                sw = this.bordFont.stringWidth(this.title);
                int xss = w - iw - sw;
                GUIGraphics.drawImage(g, this.titleImage, xss, bh / 2, 6);
                DeviceScreen.paint3Dtext(g, this.title, xss + iw, 1, 20, GUIManager.getTheme().bordTextRGB);
            } else {
                DeviceScreen.paint3Dtext(g, this.title, w, 1, 24, GUIManager.getTheme().bordTextRGB);
            }
            int ii = this.HEIGHT - bh;
            GUIManager.getTheme().gradientFill(g, 0, ii, w, bh, true, GUIManager.getTheme().bordFonRGB1, GUIManager.getTheme().bordFonRGB2);
            g.setColor(GUIManager.getTheme().bordFrameRGB);
            g.drawRect(0, ii, w - 1, bh - 1);
            if (this.commandBuffer != null && this.commandBuffer.length > 0) {
                if (this.commandLeft != null && this.commandLeft.length == 1) {
                    GUICommand uic = (GUICommand)this.commandLeft[0];
                    DeviceScreen.paint3Dtext(g, uic.getLabel(), 1, ii + 1, 0, GUIManager.getTheme().bordTextRGB);
                } else if (this.commandLeft != null && this.commandLeft.length > 1) {
                    DeviceScreen.paint3Dtext(g, "\u041c\u0435\u043d\u044e", 1, ii + 1, 0, GUIManager.getTheme().bordTextRGB);
                }
                if (this.commandRight != null && this.commandRight.length == 1) {
                    GUICommand uic = (GUICommand)this.commandRight[0];
                    DeviceScreen.paint3Dtext(g, uic.getLabel(), w - 1, ii + 1, 24, GUIManager.getTheme().bordTextRGB);
                } else if (this.commandRight != null && this.commandRight.length > 1) {
                    DeviceScreen.paint3Dtext(g, "\u041e\u043f\u0446\u0438\u0438", w - 1, ii + 1, 24, GUIManager.getTheme().bordTextRGB);
                }
            }
        } else {
            bh = 0;
        }
        g.setClip(0, bh, w - 2, this.clipHeight - 1);
        g.translate(g.getClipX(), g.getClipY());
        this.paintScreen(g, g.getClipWidth(), g.getClipHeight());
        g.translate(0, -bh);
        g.setClip(0, 0, w, this.HEIGHT);
    }

    public void keyPressed(int key) {
        if (!this.showMenu) {
            int ind;
            if (UniKeys.isKey(key, "LEFT_SOFT")) {
                if (this.commandLeft != null && this.commandLeft.length == 1) {
                    GUICommand guicL = (GUICommand)this.commandLeft[0];
                    this.guicl.commandAction(guicL, this);
                } else if (this.commandLeft != null && this.commandLeft.length > 1) {
                    this.showMenu = true;
                    this.setCmdMenu(this.commandLeft, 1);
                    this.repaint();
                    return;
                }
            } else if (UniKeys.isKey(key, "RIGHT_SOFT")) {
                if (this.commandRight != null && this.commandRight.length == 1) {
                    GUICommand guicR = (GUICommand)this.commandRight[0];
                    this.guicl.commandAction(guicR, this);
                } else if (this.commandRight != null && this.commandRight.length > 1) {
                    this.showMenu = true;
                    this.setCmdMenu(this.commandRight, -1);
                    this.repaint();
                    return;
                }
            } else if (UniKeys.isKey(key, "LEFT")) {
                int ind2 = this.existCommand(3);
                if (this.existCommand(3) != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind2], this);
                }
            } else if (UniKeys.isKey(key, "RIGHT")) {
                int ind3 = this.existCommand(4);
                if (ind3 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind3], this);
                }
            } else if (UniKeys.isKey(key, "UP")) {
                int ind4 = this.existCommand(5);
                if (ind4 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind4], this);
                }
            } else if (UniKeys.isKey(key, "DOWN")) {
                int ind5 = this.existCommand(6);
                if (ind5 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind5], this);
                }
            } else if (UniKeys.isKey(key, "FIRE")) {
                int ind6 = this.existCommand(7);
                if (ind6 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind6], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM0")) {
                int ind7 = this.existCommand(8);
                if (ind7 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind7], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM1")) {
                int ind8 = this.existCommand(9);
                if (ind8 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind8], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM2")) {
                int ind9 = this.existCommand(10);
                if (ind9 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind9], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM3")) {
                int ind10 = this.existCommand(11);
                if (ind10 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind10], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM4")) {
                int ind11 = this.existCommand(12);
                if (ind11 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind11], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM5")) {
                int ind12 = this.existCommand(13);
                if (ind12 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind12], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM6")) {
                int ind13 = this.existCommand(14);
                if (ind13 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind13], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM7")) {
                int ind14 = this.existCommand(15);
                if (ind14 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind14], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM8")) {
                int ind15 = this.existCommand(16);
                if (ind15 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind15], this);
                }
            } else if (UniKeys.isKey(key, "KEY_NUM9")) {
                int ind16 = this.existCommand(17);
                if (ind16 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind16], this);
                }
            } else if (UniKeys.isKey(key, "KEY_POUND")) {
                int ind17 = this.existCommand(19);
                if (ind17 != -1) {
                    this.guicl.commandAction((GUICommand)this.commandBuffer[ind17], this);
                }
            } else if (UniKeys.isKey(key, "KEY_STAR") && (ind = this.existCommand(18)) != -1) {
                this.guicl.commandAction((GUICommand)this.commandBuffer[ind], this);
            }
            this.keyPress(key);
        } else {
            if (UniKeys.isKey(key, "LEFT_SOFT") || UniKeys.isKey(key, "FIRE") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM5")) {
                String g = this.commandMenu.getString(this.commandMenu.getSelectedIndex());
                for (int i = 0; i < this.commandBuffer.length; ++i) {
                    GUICommand guic = (GUICommand)this.commandBuffer[i];
                    String s = guic.getLabel();
                    if (!s.equals(g)) continue;
                    this.showMenu = false;
                    this.guicl.commandAction(guic, this);
                    break;
                }
            }
            if (UniKeys.isKey(key, "RIGHT_SOFT")) {
                this.showMenu = false;
            }
            if (UniKeys.isKey(key, "DOWN") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM8")) {
                this.commandMenu.down();
            }
            if (UniKeys.isKey(key, "UP") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM2")) {
                this.commandMenu.up();
            }
        }
        this.repaint();
    }

    public void keyRepeated(int key) {
        if (!this.showMenu) {
            this.keyRepeat(key);
        }
        this.repaint();
    }

    private void setCmdMenu(Object[] v, int ind) {
        String[] a = new String[v.length];
        Image[] img = new Image[v.length];
        for (int i = 0; i < v.length; ++i) {
            GUICommand uic = (GUICommand)v[i];
            a[i] = uic.getLabel();
            img[i] = uic.getImage();
        }
        this.commandMenu.append(a, img);
        if (ind == 1) {
            this.commandMenu.setX(-2000);
            if (!this.fullScreen) {
                this.commandMenu.setY(this.getHeight() - this.bordHeight - this.commandMenu.getHeightPole());
            } else {
                this.commandMenu.setY(this.getHeight() - this.commandMenu.getHeightPole());
            }
        } else if (ind == -1) {
            this.commandMenu.setX(-3000);
            if (!this.fullScreen) {
                this.commandMenu.setY(this.getHeight() - this.bordHeight - this.commandMenu.getHeightPole());
            } else {
                this.commandMenu.setY(this.getHeight() - this.commandMenu.getHeightPole());
            }
        }
    }

    final boolean exist(Object[] objAr, Object obj) {
        int sz;
        if (obj != null && objAr != null && (sz = objAr.length) > 0) {
            for (int i = 0; i < sz; ++i) {
                if (!objAr[i].equals(obj)) continue;
                return true;
            }
        }
        return false;
    }

    final Object[] addElement(Object[] objAr, Object obj) {
        if (obj != null) {
            if (objAr != null) {
                int sz = objAr.length;
                Object[] objTmp = new Object[sz + 1];
                System.arraycopy(objAr, 0, objTmp, 0, sz);
                objTmp[sz] = obj;
                return objTmp;
            }
            objAr = new Object[]{obj};
            return objAr;
        }
        return null;
    }

    final Object[] removeElement(Object[] objAr, Object obj) {
        if (objAr != null) {
            int sz = objAr.length;
            for (int i = 0; i < sz; ++i) {
                if (!objAr[i].equals(obj)) continue;
                objAr = this.removeElement(objAr, i);
                break;
            }
            return objAr;
        }
        return null;
    }

    final Object[] removeElement(Object[] objAr, int index) {
        if (objAr != null) {
            int sz = objAr.length;
            if (index >= 0 && index < sz && sz > 1) {
                Object[] objTmp = new Object[sz - 1];
                int j = 0;
                for (int i = 0; i < sz; ++i) {
                    if (i == index) continue;
                    objTmp[j] = objAr[i];
                    ++j;
                }
                return objTmp;
            }
        }
        return null;
    }

    private int existCommand(int anchor) {
        if (this.commandBuffer != null) {
            int sz = this.commandBuffer.length;
            for (int i = 0; i < sz; ++i) {
                GUICommand c = (GUICommand)this.commandBuffer[i];
                if (c.getAnchor() != anchor) continue;
                return i;
            }
        }
        return -1;
    }

    Object[] setElement(Object[] objAr, Object obj, int index) {
        if (objAr != null && obj != null) {
            if (index >= 0 && index < objAr.length) {
                objAr[index] = obj;
            }
            return objAr;
        }
        return null;
    }

    void fontCheck() {
        if (!this.bordFont.equals(GUIManager.getTheme().bordFont)) {
            this.bordFont = GUIManager.getTheme().bordFont;
            this.bordHeight = GUIManager.getTheme().bordHeight;
            this.clipHeight = !this.fullScreen ? this.HEIGHT - this.bordHeight * 2 : this.HEIGHT;
            this.reset();
            this.repaint();
        }
        if (!this.itemFont.equals(GUIManager.getTheme().itemFont)) {
            this.itemFont = GUIManager.getTheme().itemFont;
            this.itemHeight = GUIManager.getTheme().itemHeight;
            this.reset();
            this.repaint();
        }
    }

    protected void hideNotify() {
        this.hideNotifyScreen();
    }

    protected void showNotify() {
        this.showNotifyScreen();
    }

    abstract void paintScreen(Graphics var1, int var2, int var3);

    abstract void keyPress(int var1);

    abstract void keyRepeat(int var1);

    abstract void reset();

    abstract void showNotifyScreen();

    abstract void hideNotifyScreen();

    final class ThreadClass
    extends Thread {
        ThreadClass() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        DeviceScreen.this.fontCheck();
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

