/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.Component;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class Readline
extends Component {
    int color;

    Readline(String s) {
        super("");
        this.color = GUIManager.getTheme().textRGB;
        super.setString(s);
    }

    Readline(String s, int alignment) {
        super("");
        this.color = GUIManager.getTheme().textRGB;
        super.setString(s);
        super.setLabelAlignment(alignment);
    }

    void setColor(int rgb) {
        this.color = rgb;
    }

    int paintComponent(Graphics g, int x1, int y1, int width, int height, boolean b) {
        String str = super.getString();
        if (str != null && !str.equals("")) {
            int x;
            Font f = super.getTextFont();
            g.setFont(f);
            g.setColor(this.color);
            int fontHeight = f.getHeight();
            int y = y1;
            int ha = super.getLabelAlignment();
            int anchor = ha | 0x10;
            if (ha == 8) {
                x = x1 + width;
            } else if (ha == 1) {
                x = x1 + width / 2;
            } else {
                x = x1;
                super.setLabelAlignment(4);
            }
            int lineStart = 0;
            int lastBreakableSpot = 0;
            int lastNonWhiteSpace = 0;
            int charWidth = f.charWidth('O');
            width -= charWidth;
            char[] chars = str.toCharArray();
            int sz = chars.length;
            int count = 1;
            for (int i = 0; i < sz; ++i) {
                boolean isSeparator = chars[i] == '-' || chars[i] == '/';
                boolean isWhiteSpace = chars[i] == ' ';
                boolean isLineBreak = chars[i] == '\n';
                int lineWidth = f.charsWidth(chars, lineStart, i - lineStart);
                if (isLineBreak || lineWidth > width) {
                    int lineEnd = isLineBreak ? i : (lastBreakableSpot > lineStart ? lastBreakableSpot : i - 1);
                    GUIGraphics.drawString(g, str.substring(lineStart, lineEnd).trim(), x, y, anchor);
                    y += fontHeight;
                    ++count;
                    lineStart = isLineBreak ? lineEnd + 1 : lineEnd;
                }
                if (isSeparator) {
                    lastBreakableSpot = i + 1;
                }
                if (isWhiteSpace) {
                    lastBreakableSpot = lastNonWhiteSpace + 1;
                    continue;
                }
                lastNonWhiteSpace = i;
            }
            GUIGraphics.drawString(g, str.substring(lineStart).trim(), x, y, anchor);
            return count * fontHeight;
        }
        return 0;
    }

    void keyComponent(int key) {
    }

    String getTypeComponent() {
        return "Readline";
    }
}

