/*
 * Decompiled with CFR 0.152.
 */
package fs;

import fs.File;
import fs.JSR75;
import fs.Moto;
import fs.MotoE1E3;
import fs.SiemensX65;

public class Manager {
    static File fileSystem;
    static final String[] supportedFileSystems;

    static {
        supportedFileSystems = new String[]{"javax.microedition.io.file.FileConnection", "com.motorola.io.file.FileConnection", "com.siemens.mp.io.file.FileConnection", "com.motorola.io.FileConnection"};
        fileSystem = null;
        int n = 0;
        while (n < supportedFileSystems.length && fileSystem == null) {
            try {
                Class<?> clazz = Class.forName(supportedFileSystems[n]);
                switch (n) {
                    case 0: {
                        fileSystem = new JSR75();
                        break;
                    }
                    case 1: {
                        fileSystem = new MotoE1E3();
                        break;
                    }
                    case 2: {
                        fileSystem = new SiemensX65();
                        break;
                    }
                    case 3: {
                        fileSystem = new Moto();
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        if (fileSystem == null) {
            System.err.println("Can't find filesystem access class");
        }
    }

    public static File access() throws  {
        return fileSystem;
    }

    public static File create() throws  {
        File file = null;
        try {
            file = (File)fileSystem.getClass().newInstance();
        }
        catch (Throwable throwable) {
            System.err.println("Can't instance clone class");
        }
        return file;
    }

    public static boolean valid() throws  {
        return fileSystem != null;
    }
}

