/*
 * Decompiled with CFR 0.152.
 */
package framework.sound;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundFX {
    public static final int MIN_VOLUME = 0;
    public static final int MID_VOLUME = 50;
    public static final int MAX_VOLUME = 100;
    public static final int MIN_PRIORITY = 0;
    public static final int MID_PRIORITY = 50;
    public static final int MAX_PRIORITY = 100;
    private static final int DOUBLED_BUFFERS_COUNT = 0;
    private Vector soundFXPlayers = new Vector();
    private Vector soundFXDoubledBuffers = new Vector();
    private Vector soundFXPriorities = new Vector();
    private volatile int currentSoundFXID = -1;
    private Player currentPlayer = null;
    private Player[] currentPlayerDoubledBuffers = null;
    private volatile int currentPlayerPririty = 0;
    private VolumeControl currentVolCtrl;
    private static SoundFX instance;

    private SoundFX() {
    }

    public static SoundFX getInstance() {
        if (instance == null) {
            instance = new SoundFX();
        }
        return instance;
    }

    public Integer addSoundFX(String fileName, int priorityVal) throws IOException, MediaException {
        InputStream inputStream = this.getClass().getResourceAsStream(fileName);
        Player player = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
        player.realize();
        player.prefetch();
        this.soundFXPlayers.addElement(player);
        Player[] doubledPlayers = new Player[]{};
        for (int i = 0; i < 0; ++i) {
            inputStream = this.getClass().getResourceAsStream(fileName);
            doubledPlayers[i] = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
            doubledPlayers[i].realize();
            doubledPlayers[i].prefetch();
        }
        this.soundFXDoubledBuffers.addElement(doubledPlayers);
        Integer priority = new Integer(priorityVal);
        this.soundFXPriorities.addElement(priority);
        return new Integer(this.soundFXPlayers.size() - 1);
    }

    public void playSoundFX() {
        this.playSoundFX(this.currentSoundFXID);
    }

    public void playSoundFX(int SoundFXID) {
        this.playSoundFX(SoundFXID, 1);
    }

    public void playSoundFX(int SoundFXID, int loopCount) {
        try {
            if (this.currentSoundFXID == SoundFXID) {
                if (this.currentPlayer.getState() != 400) {
                    this.currentPlayer.start();
                } else {
                    for (int i = 0; i < 0; ++i) {
                        if (this.currentPlayerDoubledBuffers[i].getState() == 400) continue;
                        this.currentPlayerDoubledBuffers[i].start();
                        break;
                    }
                }
                return;
            }
            Integer newSoundFXPriority = (Integer)this.soundFXPriorities.elementAt(SoundFXID);
            if (this.currentPlayer != null && this.currentPlayer.getState() == 400 && newSoundFXPriority < this.currentPlayerPririty) {
                return;
            }
            this.currentPlayerPririty = newSoundFXPriority;
            this.currentSoundFXID = SoundFXID;
            this.currentPlayer = (Player)this.soundFXPlayers.elementAt(SoundFXID);
            this.currentPlayerDoubledBuffers = (Player[])this.soundFXDoubledBuffers.elementAt(SoundFXID);
            this.currentVolCtrl = null;
            this.currentPlayer.stop();
            this.currentPlayer.setLoopCount(loopCount);
            this.currentPlayer.start();
        }
        catch (Exception exc) {
            throw new RuntimeException("playSoundFX Exception: " + exc.getMessage());
        }
    }

    public void stopSoundFX() {
        this.stopSoundFX(this.currentSoundFXID);
    }

    public void stopSoundFX(int soundFXID) {
        if (this.currentSoundFXID == -1) {
            return;
        }
        try {
            this.currentPlayer.stop();
        }
        catch (Exception exc) {
            throw new RuntimeException("playSoundFX Exception: " + exc.getMessage());
        }
    }

    public void pauseSoundFX() {
        this.pauseSoundFX(this.currentSoundFXID);
    }

    public void pauseSoundFX(int soundFXID) {
        if (this.currentSoundFXID == -1) {
            return;
        }
        try {
            this.currentPlayer.stop();
        }
        catch (Exception exc) {
            throw new RuntimeException("playSoundFX Exception: " + exc.getMessage());
        }
    }

    private VolumeControl getVolCtrl() {
        if (this.currentVolCtrl != null) {
            return this.currentVolCtrl;
        }
        Control[] cs = this.currentPlayer.getControls();
        for (int i = 0; i < cs.length; ++i) {
            if (!(cs[i] instanceof VolumeControl)) continue;
            this.currentVolCtrl = (VolumeControl)cs[i];
            return this.currentVolCtrl;
        }
        return null;
    }

    public void setVolume(int volume) {
        this.getVolCtrl().setLevel(volume);
    }

    public int getVolume() {
        return this.getVolCtrl().getLevel();
    }

    public int increaseVolume(int amount) {
        if (amount < 0) {
            return -1;
        }
        int volumeLevelTemp = this.getVolCtrl().getLevel() + amount;
        return this.currentVolCtrl.setLevel(volumeLevelTemp);
    }

    public int decreaseVolume(int amount) {
        if (amount < 0) {
            return -1;
        }
        int volumeLevelTemp = this.getVolCtrl().getLevel() - amount;
        return this.currentVolCtrl.setLevel(volumeLevelTemp);
    }

    public int returnCurrentSoundFX() {
        return this.currentSoundFXID;
    }

    public int returnPlayersCount() {
        return this.soundFXPlayers.size();
    }
}

