/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.MainGameCanvas;
import framework.menu.IMenuFormListener;
import framework.menu.MenuForm;
import framework.utils.rms.RMSUtils;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import menu.GoolMenu;
import menu.RMSHighscore;
import root.GoolGlobals;

public final class HighscoresAppState
extends GoolMenu
implements IMenuFormListener {
    private static final int MAX_CHARACTERS_IN_LINE = 17;
    private static final int KEY_DELAY = 200;
    private int keyDelayTimer = 200;
    MenuForm highscores;
    private int exitButtonId;
    private int continueButtonId;
    private int scrollBoxId;
    private int descLeftButtonId;
    private boolean exitFlag = false;
    private StringBuffer highscoreList;
    private Vector highscoresRecords;
    public static MenuForm nextMenu;
    private int menuOffset;
    private String nextState;
    private boolean menuHighScores;
    private static final short[] initialHighScores;

    public HighscoresAppState(String name, MainGameCanvas gameCanvas) {
        super(name, gameCanvas);
    }

    public boolean initialize(Object param) {
        if (this.highscores == null || GoolGlobals.switchLangHscr) {
            this.createMenu();
            GoolGlobals.switchLangHscr = false;
        }
        this.menuHighScores = param == null ? true : (Boolean)param;
        this.exitFlag = false;
        try {
            this.highscoresRecords = RMSUtils.loadRecords("highs", Class.forName("menu.RMSHighscore"));
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException("Impossible!");
        }
        HighscoresAppState.highscoresInsertionSortScores(this.highscoresRecords);
        this.highscores.controls[this.scrollBoxId].text = RMSHighscore.createStringFromRecords(this.highscoresRecords, 17, false);
        this.highscores.controls[this.descLeftButtonId].state = 1;
        this.highscores.controls[this.descLeftButtonId].text = Localizaton.TEXT_HIGHSCORES_DESC;
        this.highscores.focusedID = -1;
        this.highscores.controls[this.scrollBoxId].currentLine = 0;
        this.highlightFocusedControl();
        if (this.menuHighScores) {
            this.highscores.controls[this.exitButtonId].isVisible = true;
            this.highscores.controls[this.continueButtonId].isVisible = false;
        } else {
            this.highscores.controls[this.exitButtonId].isVisible = false;
            this.highscores.controls[this.continueButtonId].isVisible = true;
        }
        this.menuOffset = GoolGlobals.background.getWidth();
        if (this.highscores.absoluteX >= 0) {
            this.changeMenuOffset(this.menuOffset, this.highscores);
        }
        if (this.bgOffset >= 0) {
            this.changeBgOffset(this.menuOffset);
        }
        this.enter = true;
        this.nextState = null;
        nextMenu = null;
        return true;
    }

    public void keyPressed(int keyCode) {
        block6: {
            block5: {
                if (keyCode == -7) {
                    out = true;
                }
                if (keyCode == -6) break block5;
                if (keyCode != 53 && keyCode != -5 && keyCode != 53) break block6;
            }
            if (!this.menuHighScores) {
                out = true;
            }
        }
        this.highscores.keyPressed(keyCode);
        this.highlightFocusedControl();
    }

    public void notifyKeypressed(int formID, int controlID) {
    }

    public void update(int deltaTime) {
        super.update(deltaTime);
        this.keyDelayTimer -= deltaTime;
        if (this.keyDelayTimer < 0) {
            this.keyDelayTimer = 0;
        }
        if (this.enter) {
            this.enter(deltaTime);
        } else if (out) {
            this.out(deltaTime);
        }
    }

    public void enter(int deltaTime) {
        if (this.moveStart == 0L) {
            this.moveStart = this.currentTime;
        } else if (this.currentTime - this.moveStart > this.moveSpeed) {
            if (this.menuOffset > 0) {
                this.menuOffset -= GoolGlobals.MENU_OFFSET;
                this.changeMenuOffset(-GoolGlobals.MENU_OFFSET, this.highscores);
                this.changeBgOffset(-GoolGlobals.MENU_OFFSET);
            } else {
                this.enter = false;
                this.moveStart = 0L;
            }
        }
    }

    public void changeMenuOffset(int offset, MenuForm menu) {
        for (int i = 0; i < menu.controls.length - 2; ++i) {
            menu.controls[i].textPozX -= offset;
            menu.controls[i].pozX -= offset;
        }
        menu.absoluteX -= offset;
        menu.controls[menu.controls.length - 2].textPozY += offset;
        menu.controls[menu.controls.length - 1].textPozY += offset;
        menu.controls[menu.controls.length - 2].pozY += offset;
        menu.controls[menu.controls.length - 1].pozY += offset;
    }

    public void changeBgOffset(int offset) {
        this.bgOffset -= offset;
    }

    public void out(int deltaTime) {
        if (this.moveStart == 0L) {
            this.moveStart = this.currentTime;
        } else if (this.currentTime - this.moveStart > this.moveSpeed) {
            if (this.menuOffset < GoolGlobals.background.getWidth()) {
                this.menuOffset += GoolGlobals.MENU_OFFSET;
                this.changeMenuOffset(GoolGlobals.MENU_OFFSET, this.highscores);
                this.changeBgOffset(GoolGlobals.MENU_OFFSET);
            } else {
                out = false;
                this.moveStart = 0L;
                this.mainGameCanvas.requestAppStateChange("Menu");
                if (this.nextState != null) {
                    this.mainGameCanvas.requestAppStateChange(this.nextState);
                } else if (nextMenu != null) {
                    this.highscores = nextMenu;
                    this.enter = true;
                }
            }
        }
    }

    public void render(Graphics g) {
        super.render(g);
        this.highscores.drawMenu(g);
    }

    public void deinitialize() {
        this.highscores.controls[this.scrollBoxId].text = null;
        this.highscoresRecords = null;
        System.gc();
    }

    public int getDescLeftButtonId() {
        return this.descLeftButtonId;
    }

    private void createMenu() {
        HighscoresAppState.createHighscores();
        try {
            int[] rowsSizes = new int[]{40, 1, 8, -1, 8, 7};
            int[] columnsSizes = new int[]{95, -1, 10};
            try {
                this.highscoresRecords = RMSUtils.loadRecords("highs", Class.forName("menu.RMSHighscore"));
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Impossible!");
            }
            this.highscoreList = RMSHighscore.createStringFromRecords(this.highscoresRecords, 17, false);
            this.highscores = MenuForm.createMenuForm(5, rowsSizes, columnsSizes, 240, 320, (byte)0, (byte)0);
            this.highscores.listener = this;
            this.highscores.createControl(4, 100, 10, -1, 0, 1, 18, 18, null, Localizaton.EMPTY, 0, 0);
            this.descLeftButtonId = this.highscores.createControl(4, 10, 10, -1, 2, 0, 18, 18, null, Localizaton.TEXT_HIGHSCORES_DESC, 0, 0);
            this.scrollBoxId = this.highscores.createScrollBox(200, 255, -1, 3, 0, 10, 10, this.highscoreList, 0);
            this.highscores.setRendererFonts(this.scrollBoxId, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
            this.highscores.setRendererFonts(this.descLeftButtonId, "FONT_NORMAL", "FONT_NORMAL", "FONT_NORMAL");
            this.highscores.getControlByID((int)this.scrollBoxId).pozX = 140;
            this.highscores.getControlByID((int)this.scrollBoxId).pozY = 220;
            this.continueButtonId = this.highscores.createControl(4, 100, 10, -1, 5, 0, 17, 17, null, Localizaton.TEXT_MAINMENU[0], 0, 5);
            this.exitButtonId = this.highscores.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 2, 36, 18, GoolGlobals.button, Localizaton.BACK, 0, 0);
            this.highscores.setRendererFonts(this.exitButtonId, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createHighscores() {
        try {
            RecordStore.openRecordStore((String)"highs", (boolean)false);
        }
        catch (RecordStoreException ex) {
            RMSUtils.createRecordStore("highs");
        }
        if (RMSUtils.getRecordsCount("highs") == 0) {
            RMSHighscore[] hs = new RMSHighscore[5];
            for (int i = 0; i < hs.length; ++i) {
                hs[i] = new RMSHighscore(-1, Localizaton.TEXT_HIGHSCORES_ANIMALS[i].toString(), initialHighScores[i]);
            }
            Vector<RMSHighscore> vec = new Vector<RMSHighscore>();
            for (int i = hs.length - 1; i >= 0; --i) {
                vec.addElement(hs[i]);
            }
            RMSUtils.storeRecords("highs", vec);
        }
    }

    private void highlightFocusedControl() {
        this.highscores.controls[this.exitButtonId].state = 0;
        this.highscores.controls[this.continueButtonId].state = 0;
        if (this.highscores.focusedID == this.exitButtonId) {
            this.highscores.controls[this.exitButtonId].state = 1;
        }
        if (this.highscores.focusedID == this.continueButtonId) {
            this.highscores.controls[this.continueButtonId].state = 1;
        }
    }

    public static void highscoresInsertionSortScores(Vector vec) {
        for (int out = 1; out < vec.size(); ++out) {
            int in;
            RMSHighscore temp = (RMSHighscore)vec.elementAt(out);
            for (in = out; in > 0 && ((RMSHighscore)vec.elementAt((int)(in - 1))).scores <= temp.scores; --in) {
                vec.setElementAt(vec.elementAt(in - 1), in);
            }
            vec.setElementAt(temp, in);
        }
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
    }

    static {
        initialHighScores = new short[]{25, 20, 15, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

