/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.AppState;
import framework.MainGameCanvas;
import framework.graphics.TextRenderer;
import framework.menu.IMenuFormListener;
import framework.menu.MenuForm;
import framework.sound.Music;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import root.GoolGlobals;

public class SelectTeamState
extends AppState
implements IMenuFormListener {
    public Image[] teamBig;
    public Image[] teamAvat;
    public Image[] teamNames;
    public Image obfuscator;
    public Image border;
    public Image gap;
    public Image titleBG;
    public Image questionMark;
    public int currentTeam = 0;
    public int currentOppTeam = 1;
    public boolean selectOpponent = false;
    public boolean versus = false;
    public boolean tournament = false;
    public int[] previousTeams = new int[]{GoolGlobals.TEAM_NUMBER - 1, GoolGlobals.TEAM_NUMBER - 2, GoolGlobals.TEAM_NUMBER - 3};
    public int[] nextTeams = new int[]{1, 2, 3};
    public int[] displayPositions = new int[6];
    public int avatarSpace = 3;
    public int[] rgb;
    public int animationShift = 0;
    public int maxAnimationShift;
    public boolean animation = false;
    public long animationStart = 0L;
    public long animationPhazeTime = 100L;
    public boolean direction = true;
    private TextRenderer renderer = TextRenderer.getInstance();
    private int selectTeamTextX;
    private MenuForm menu;
    private StringBuffer selectBuffer = Localizaton.SELECT_TEAM;

    public SelectTeamState(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    private void createMenu() {
        int[] cols = new int[]{-1};
        int[] rows = new int[]{-1};
        this.menu = MenuForm.createMenuForm(2, rows, cols, 240, 320, (byte)1, (byte)0);
        this.menu.listener = this;
        int tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 0, 0, 33, 18, GoolGlobals.button, Localizaton.SELECT, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 0, 0, 36, 18, GoolGlobals.button, Localizaton.BACK, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    private void shift(int direction) {
        if (this.selectOpponent) {
            this.shiftOpponent(direction);
            return;
        }
        if (direction > 0) {
            this.previousTeams[2] = this.previousTeams[1];
            this.previousTeams[1] = this.previousTeams[0];
            this.previousTeams[0] = this.currentTeam;
            this.currentTeam = this.nextTeams[0];
            this.nextTeams[0] = this.nextTeams[1];
            this.nextTeams[1] = this.nextTeams[2];
            this.nextTeams[2] = Math.abs((this.nextTeams[2] + 1) % GoolGlobals.TEAM_NUMBER);
        } else {
            this.nextTeams[2] = this.nextTeams[1];
            this.nextTeams[1] = this.nextTeams[0];
            this.nextTeams[0] = this.currentTeam;
            this.currentTeam = this.previousTeams[0];
            this.previousTeams[0] = this.previousTeams[1];
            this.previousTeams[1] = this.previousTeams[2];
            this.previousTeams[2] = this.previousTeams[2] - 1;
            if (this.previousTeams[2] < 0) {
                this.previousTeams[2] = GoolGlobals.TEAM_NUMBER - 1;
            }
        }
    }

    public void shiftOpponent(int direction) {
        if (direction > 0) {
            this.previousTeams[2] = this.previousTeams[1];
            this.previousTeams[1] = this.previousTeams[0];
            this.previousTeams[0] = this.currentOppTeam;
            this.currentOppTeam = this.nextTeams[0];
            this.nextTeams[0] = this.nextTeams[1];
            this.nextTeams[1] = this.nextTeams[2];
            this.nextTeams[2] = Math.abs((this.nextTeams[2] + 1) % GoolGlobals.TEAM_NUMBER);
        } else {
            this.nextTeams[2] = this.nextTeams[1];
            this.nextTeams[1] = this.nextTeams[0];
            this.nextTeams[0] = this.currentOppTeam;
            this.currentOppTeam = this.previousTeams[0];
            this.previousTeams[0] = this.previousTeams[1];
            this.previousTeams[1] = this.previousTeams[2];
            this.previousTeams[2] = this.previousTeams[2] - 1;
            if (this.previousTeams[2] < 0) {
                this.previousTeams[2] = GoolGlobals.TEAM_NUMBER - 1;
            }
        }
    }

    public void loadImages() {
        this.teamBig = new Image[GoolGlobals.TEAM_NUMBER];
        this.teamAvat = new Image[GoolGlobals.TEAM_NUMBER];
        this.teamNames = new Image[GoolGlobals.TEAM_NUMBER];
        try {
            for (int i = 0; i < GoolGlobals.TEAM_NUMBER; ++i) {
                this.teamBig[i] = Image.createImage((String)("/teams/0" + i + ".jpg"));
                this.teamNames[i] = Image.createImage((String)("/teams/0" + i + ".png"));
                this.teamAvat[i] = Image.createImage((String)("/teams/0" + i + "_avatar.png"));
            }
            this.gap = Image.createImage((String)"/teams/selected.png");
            this.titleBG = Image.createImage((String)"/teams/title_bg.png");
            this.selectTeamTextX = 120 - this.renderer.getStringWidth(Localizaton.SELECT_TEAM.length()) / 2;
            this.border = Image.createImage((String)"/teams/select_bg.png");
            this.questionMark = Image.createImage((String)"/teams/znak_zapytania.png");
        }
        catch (Exception e) {
            System.out.println("blad podczas wczytywania tej calej masy obrazkow");
            e.printStackTrace();
        }
        this.displayPositions[0] = 120 - 2 * this.avatarSpace - 2 * this.teamAvat[this.currentTeam].getWidth();
        this.displayPositions[1] = 120 - this.avatarSpace - this.teamAvat[this.currentTeam].getWidth();
        this.displayPositions[2] = 120 + this.avatarSpace + this.teamAvat[this.currentTeam].getWidth();
        this.displayPositions[3] = 120 + 2 * this.avatarSpace + 2 * this.teamAvat[this.currentTeam].getWidth();
        this.displayPositions[4] = 120 - 3 * this.avatarSpace - 3 * this.teamAvat[this.currentTeam].getWidth();
        this.displayPositions[5] = 120 + 3 * this.avatarSpace + 3 * this.teamAvat[this.currentTeam].getWidth();
        this.rgb = new int[this.teamAvat[0].getWidth() * this.teamAvat[0].getHeight()];
        for (int a = 0; a < this.rgb.length; ++a) {
            this.rgb[a] = Integer.MIN_VALUE;
        }
        this.obfuscator = Image.createRGBImage((int[])this.rgb, (int)this.teamAvat[0].getWidth(), (int)this.teamAvat[0].getHeight(), (boolean)true);
        this.maxAnimationShift = this.avatarSpace + this.teamAvat[0].getWidth();
    }

    public boolean initialize(Object param) {
        GoolGlobals.clearMenuImages();
        this.tournament = param != null;
        this.loadImages();
        this.selectOpponent = false;
        this.versus = false;
        this.selectBuffer = Localizaton.SELECT_TEAM;
        this.previousTeams[0] = GoolGlobals.TEAM_NUMBER - 1;
        this.previousTeams[1] = GoolGlobals.TEAM_NUMBER - 2;
        this.previousTeams[2] = GoolGlobals.TEAM_NUMBER - 3;
        this.nextTeams[0] = 1;
        this.nextTeams[1] = 2;
        this.nextTeams[2] = 3;
        this.currentTeam = 0;
        this.currentOppTeam = 1;
        if (this.menu == null) {
            this.createMenu();
        }
        return true;
    }

    public void update(int deltaTime) {
        if (this.animation) {
            if (this.animationStart == 0L) {
                this.animationStart = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.animationStart > this.animationPhazeTime) {
                this.animationShift = this.direction ? (this.animationShift -= 8) : (this.animationShift += 8);
            }
            if (Math.abs(this.animationShift) >= this.maxAnimationShift) {
                this.animationShift = 0;
                this.animation = false;
                this.animationStart = 0L;
                if (this.direction) {
                    this.shift(1);
                } else {
                    this.shift(-1);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(int keyCode) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        if (this.animation) break block8;
                        if (keyCode == -3) break block9;
                        if (keyCode != 52) break block10;
                    }
                    this.direction = false;
                    this.animation = true;
                    break block8;
                }
                if (keyCode == -4) break block11;
                if (keyCode != 54) break block8;
            }
            this.direction = true;
            this.animation = true;
        }
        if (keyCode != -5) {
            if (keyCode != -6) {
                if (keyCode != 53) {
                    if (keyCode != -7) return;
                    this.mainGameCanvas.requestAppStateChange("Menu");
                    return;
                }
            }
        }
        if (this.tournament) {
            this.mainGameCanvas.requestAppStateChange("Tournament");
            GoolGlobals.tournamentStarted = false;
        }
        if (!this.selectOpponent) {
            this.selectOpponent = true;
            this.selectTeamTextX = 120 - this.renderer.getStringWidth(Localizaton.SELECT_OPP.length()) / 2;
            this.selectBuffer = Localizaton.SELECT_OPP;
            this.nextTeams[0] = 2;
            this.nextTeams[1] = 3;
            this.nextTeams[2] = 4;
            this.previousTeams[0] = 0;
            this.previousTeams[1] = GoolGlobals.TEAM_NUMBER - 1;
            this.previousTeams[2] = GoolGlobals.TEAM_NUMBER - 2;
            return;
        }
        this.mainGameCanvas.requestAppStateChange("Game");
    }

    public void render(Graphics g) {
        try {
            if (this.tournament) {
                g.setColor(0);
                g.fillRect(0, 160, 240, 160);
                g.drawImage(this.questionMark, 120, 240, 2 | 1);
            } else {
                g.drawRegion(this.teamBig[this.currentOppTeam], 0, 0, this.teamBig[this.currentOppTeam].getWidth(), this.teamBig[this.currentOppTeam].getHeight(), 2, 0, 320, 4 | 0x20);
                g.drawImage(this.teamNames[this.currentOppTeam], 0, 320 - (this.teamBig[this.currentOppTeam].getHeight() >> 1), 2 | 4);
            }
            g.drawImage(this.teamBig[this.currentTeam], 0, 13, 0);
            g.drawImage(this.teamNames[this.currentTeam], 240, this.teamBig[this.currentTeam].getHeight() >> 1, 2 | 8);
            g.drawImage(this.border, 0, 160, 2 | 4);
            g.drawImage(this.border, this.border.getWidth(), 160, 2 | 4);
            if (this.animation) {
                if (this.selectOpponent) {
                    g.drawImage(this.teamAvat[this.currentOppTeam], 120 + this.animationShift, 160, 2 | 1);
                } else {
                    g.drawImage(this.teamAvat[this.currentTeam], 120 + this.animationShift, 160, 2 | 1);
                }
                g.drawImage(this.teamAvat[this.previousTeams[1]], this.displayPositions[0] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.teamAvat[this.previousTeams[0]], this.displayPositions[1] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.teamAvat[this.nextTeams[0]], this.displayPositions[2] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.teamAvat[this.nextTeams[1]], this.displayPositions[3] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.teamAvat[this.previousTeams[2]], this.displayPositions[4] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.teamAvat[this.nextTeams[2]], this.displayPositions[5] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[0] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[1] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[2] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[3] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[4] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[5] + this.animationShift, 160, 2 | 1);
                g.drawImage(this.obfuscator, 120 + this.animationShift, 160, 2 | 1);
            } else {
                if (this.selectOpponent) {
                    g.drawImage(this.teamAvat[this.currentOppTeam], 120, 160, 2 | 1);
                } else {
                    g.drawImage(this.teamAvat[this.currentTeam], 120, 160, 2 | 1);
                }
                g.drawImage(this.gap, 120, 160, 2 | 1);
                g.drawImage(this.teamAvat[this.previousTeams[1]], this.displayPositions[0], 160, 2 | 1);
                g.drawImage(this.teamAvat[this.previousTeams[0]], this.displayPositions[1], 160, 2 | 1);
                g.drawImage(this.teamAvat[this.nextTeams[0]], this.displayPositions[2], 160, 2 | 1);
                g.drawImage(this.teamAvat[this.nextTeams[1]], this.displayPositions[3], 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[0], 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[1], 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[2], 160, 2 | 1);
                g.drawImage(this.obfuscator, this.displayPositions[3], 160, 2 | 1);
            }
            GoolGlobals.smDownArrow.paintWithAnchor(g, 0, 160, 0, 7, 4 | 2);
            GoolGlobals.smDownArrow.paintWithAnchor(g, 240, 160, 0, 4, 8 | 2);
            int titleCount = 240 / this.titleBG.getWidth();
            ++titleCount;
            for (int i = 0; i < titleCount; ++i) {
                g.drawImage(this.titleBG, i * this.titleBG.getWidth(), 0, 0x10 | 4);
            }
            this.renderer.renderText(g, this.selectTeamTextX, 0, this.selectBuffer);
            this.menu.drawMenu(g);
        }
        catch (Exception e) {
            System.out.println("problem z rysowaniem");
        }
    }

    public void deinitialize() {
        this.teamBig = null;
        this.teamAvat = null;
        this.teamNames = null;
        this.border = null;
        this.gap = null;
        this.titleBG = null;
        this.rgb = null;
        this.obfuscator = null;
        this.questionMark = null;
        if (!this.tournament) {
            GoolGlobals.currentOpponentTeam = this.currentOppTeam;
        }
        GoolGlobals.currentPlayerTeam = this.currentTeam;
        System.gc();
    }

    public void notifyKeypressed(int formID, int controlID) {
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
        if (GoolGlobals.playMusic) {
            if (paused) {
                Music.stopMusic();
            } else {
                Music.playMusic(GoolGlobals.menuMusicId);
            }
        }
    }
}

