/*
 * Decompiled with CFR 0.152.
 */
package framework.math;

import framework.math.FP;
import framework.math.MathUtils;

public final class Vector3D {
    public int fp_x;
    public int fp_y;
    public int fp_z;

    public Vector3D() {
        this.fp_x = FP.ZERO;
        this.fp_y = FP.ZERO;
        this.fp_z = FP.ZERO;
    }

    public Vector3D(int fp_x, int fp_y, int fp_z) {
        this.fp_x = fp_x;
        this.fp_y = fp_y;
        this.fp_z = fp_z;
    }

    public Vector3D(Vector3D v) {
        this(v.fp_x, v.fp_y, v.fp_z);
    }

    public final void setTo(Vector3D v) {
        this.fp_x = v.fp_x;
        this.fp_y = v.fp_y;
        this.fp_z = v.fp_z;
    }

    public final void setTo(int fp_x, int fp_y, int fp_z) {
        this.fp_x = fp_x;
        this.fp_y = fp_y;
        this.fp_z = fp_z;
    }

    public final void copyTo(Vector3D v) {
        v.fp_x = this.fp_x;
        v.fp_y = this.fp_y;
        v.fp_z = this.fp_z;
    }

    public final Vector3D clone() {
        return new Vector3D(this);
    }

    public final int getLength() {
        return MathUtils.sqrt((this.fp_x * this.fp_x >> FP.SHIFT) + (this.fp_y * this.fp_y >> FP.SHIFT) + (this.fp_z * this.fp_z >> FP.SHIFT));
    }

    public final int getSquaredLength() {
        return (this.fp_x * this.fp_x >> FP.SHIFT) + (this.fp_y * this.fp_y >> FP.SHIFT) + (this.fp_z * this.fp_z >> FP.SHIFT);
    }

    public final void normalize() {
        int fp_tmp = this.getLength();
        if (fp_tmp != 0) {
            this.fp_x = (this.fp_x << FP.SHIFT) / fp_tmp;
            this.fp_y = (this.fp_y << FP.SHIFT) / fp_tmp;
            this.fp_z = (this.fp_z << FP.SHIFT) / fp_tmp;
        } else {
            this.fp_x = 0;
            this.fp_y = 0;
            this.fp_z = 0;
        }
    }

    public final void normalize2() {
        int fp_tmp = this.getLength();
        if (fp_tmp != 0) {
            fp_tmp = (1 << (FP.SHIFT << 1)) / fp_tmp;
            this.fp_x = this.fp_x * fp_tmp >> FP.SHIFT;
            this.fp_y = this.fp_y * fp_tmp >> FP.SHIFT;
            this.fp_z = this.fp_z * fp_tmp >> FP.SHIFT;
        } else {
            this.fp_x = 0;
            this.fp_y = 0;
            this.fp_z = 0;
        }
    }

    public final void reverse() {
        this.fp_x = -this.fp_x;
        this.fp_y = -this.fp_y;
        this.fp_z = -this.fp_z;
    }

    public final void add(Vector3D v) {
        this.fp_x += v.fp_x;
        this.fp_y += v.fp_y;
        this.fp_z += v.fp_z;
    }

    public final void sub(Vector3D v) {
        this.fp_x -= v.fp_x;
        this.fp_y -= v.fp_y;
        this.fp_z -= v.fp_z;
    }

    public final void mul(int fp_alpha) {
        this.fp_x = this.fp_x * fp_alpha >> FP.SHIFT;
        this.fp_y = this.fp_y * fp_alpha >> FP.SHIFT;
        this.fp_z = this.fp_z * fp_alpha >> FP.SHIFT;
    }

    public final void div(int fp_alpha) {
        this.fp_x = (this.fp_x << FP.SHIFT) / fp_alpha;
        this.fp_y = (this.fp_y << FP.SHIFT) / fp_alpha;
        this.fp_z = (this.fp_z << FP.SHIFT) / fp_alpha;
    }

    public final void add(int fp_x, int fp_y, int fp_z) {
        this.fp_x += fp_x;
        this.fp_y += fp_y;
        this.fp_z += fp_z;
    }

    public final void sub(int fp_x, int fp_y, int fp_z) {
        this.fp_x -= fp_x;
        this.fp_y -= fp_y;
        this.fp_z -= fp_z;
    }

    public final int dotProduct(Vector3D v) {
        return (this.fp_x * v.fp_x >> FP.SHIFT) + (this.fp_y * v.fp_y >> FP.SHIFT) + (this.fp_z * v.fp_z >> FP.SHIFT);
    }

    public static final void add(Vector3D v1, Vector3D v2, Vector3D result) {
        result.fp_x = v1.fp_x + v2.fp_x;
        result.fp_y = v1.fp_y + v2.fp_y;
        result.fp_z = v1.fp_z + v2.fp_z;
    }

    public static final void sub(Vector3D v1, Vector3D v2, Vector3D result) {
        result.fp_x = v1.fp_x - v2.fp_x;
        result.fp_y = v1.fp_y - v2.fp_y;
        result.fp_z = v1.fp_z - v2.fp_z;
    }

    public static final void mul(Vector3D v, int fp_alpha, Vector3D result) {
        result.fp_x = fp_alpha * v.fp_x >> FP.SHIFT;
        result.fp_y = fp_alpha * v.fp_y >> FP.SHIFT;
        result.fp_z = fp_alpha * v.fp_z >> FP.SHIFT;
    }

    public static final void div(Vector3D v, int fp_alpha, Vector3D result) {
        result.fp_x = (v.fp_x << FP.SHIFT) / fp_alpha;
        result.fp_y = (v.fp_y << FP.SHIFT) / fp_alpha;
        result.fp_z = (v.fp_z << FP.SHIFT) / fp_alpha;
    }

    public static final int dotProduct(Vector3D v1, Vector3D v2) {
        return (v1.fp_x * v2.fp_x >> FP.SHIFT) + (v1.fp_y * v2.fp_y >> FP.SHIFT) + (v1.fp_z * v2.fp_z >> FP.SHIFT);
    }

    public static final void crossProduct(Vector3D v1, Vector3D v2, Vector3D result) {
        result.fp_x = (v1.fp_y * v2.fp_z >> FP.SHIFT) - (v1.fp_z * v2.fp_y >> FP.SHIFT);
        result.fp_y = (v1.fp_z * v2.fp_x >> FP.SHIFT) - (v1.fp_x * v2.fp_z >> FP.SHIFT);
        result.fp_z = (v1.fp_x * v2.fp_y >> FP.SHIFT) - (v1.fp_y * v2.fp_x >> FP.SHIFT);
    }

    public final String toString() {
        return "[" + FP.toFloat(this.fp_x) + ", " + FP.toFloat(this.fp_y) + "," + FP.toFloat(this.fp_z) + "]";
    }
}

