/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Game
implements Constant {
    int a = 0;
    private boolean isExitConf = false;
    public int exit_curr_selected = 0;
    public IceHockey parent;
    private int state;
    private int state_previous;
    public boolean humanplayer = true;
    public static final byte PLAYERS_PER_TEAM = 3;
    private static final byte STATE_LOAD = 1;
    private static final byte STATE_POSTLOAD = 2;
    private static final byte STATE_INITGAME = 3;
    private static final byte STATE_GAME = 4;
    public static final int PANEL_HEIGHT = 31;
    public static int numchecks = 0;
    public static int numfights = 0;
    public Player[] players;
    public static Player playerInControl = null;
    public static Player playerWithPuck = null;
    public static final Font gameFont = Font.getFont((int)0, (int)0, (int)0);
    public static final Font gameFontSmall = Font.getFont((int)0, (int)0, (int)8);
    public static final Font gameFontSmallBold = Font.getFont((int)0, (int)1, (int)8);
    int[] sin_table;
    Random rand;
    static Random srand = new Random();
    private int[] score;
    private int pause_curr_selected;
    private boolean pause_redraw_flag = false;
    public int game_state;
    public int game_state_save;
    public int game_state_save_pause;
    private int game_state_previous;
    private int game_state_tmpcount;
    private int face_off_state = 0;
    private int score_state;
    private int finished_state;
    private long elapsed_time = 0L;
    private long start_time;
    private boolean clock_running;
    private boolean clock_state_when_paused;
    private int seconds_per_quarter;
    private boolean quarter_finished;
    private boolean exit_flag = false;
    private int fight_state;
    private Sprite[] fighters;
    private int fight_reveal_y;
    private int fight_centre_y = 100;
    private int fighter1_x;
    private int fighter2_x;
    private int runfight_state;
    private int fighter1_id;
    private int fighter2_id;
    public int fight_loser;
    private int[] fight_energy;
    private int MAX_FIGHT_ENERGY = 5;
    private Sprite[] sprgoal;
    private int goaltext_state;
    private int goaltext_count;
    public int team1mid = 2;
    private int loadindex = 0;
    private int team2mid = 3;
    private int team1top = 2;
    private int team2top = 1;
    static final String[] skaters_gfx = new String[]{"Mskate_ALL.png", "Mstandcel_ALL.png", "Mhit_ALL.png", "Mfaceoff_ALL.png", "Mfall_ALL.png", "Tskate_ALL.png", "Tstandcel_ALL.png", "Thit_ALL.png", "Tfaceoff_ALL.png", "Tfall_ALL.png", "Gready_ALL.png", "Gdivel_ALL.png", "Gdiver_ALL.png", "Gdivef_ALL.png", "Mskate_ALL.png", "Mstandcel_ALL.png", "Mhit_ALL.png", "Mfaceoff_ALL.png", "Mfall_ALL.png", "Tskate_ALL.png", "Tstandcel_ALL.png", "Thit_ALL.png", "Tfaceoff_ALL.png", "Tfall_ALL.png", "Gready_ALL.png", "Gdivel_ALL.png", "Gdiver_ALL.png", "Gdivef_ALL.png"};
    private static final byte WHITE = 1;
    private static final byte RED = 2;
    private static final byte BLUE = 3;
    private static final byte BLACK = 4;
    private static final byte GREEN = 5;
    final byte[] stripcolour = new byte[]{2, 3, 3, 4, 4, 4, 4, 2, 2, 3, 3, 2, 3, 4, 4, 2, 3, 2, 3, 3, 2, 4, 3, 5, 3, 4, 5, 4, 2, 3};
    final byte[] helmetcolour = new byte[]{4, 4, 3, 4, 4, 4, 4, 3, 4, 3, 3, 2, 3, 4, 4, 4, 3, 2, 3, 3, 4, 4, 3, 4, 3, 4, 4, 4, 2, 4};
    static final int[] tsin = new int[]{0, 1143, 2287, 3429, 4571, 5711, 6850, 7986, 9120, 10252, 11380, 12504, 13625, 14742, 15854, 16962, 18064, 19160, 20251, 21336, 22414, 23485, 24550, 25606, 26656, 27696, 28729, 29752, 30767, 31772, 32768, 33753, 34728, 35693, 36647, 37590, 38521, 39440, 40347, 41243, 42125, 42995, 43852, 44695, 45525, 46340, 47142, 47930, 48702, 49460, 50203, 50930, 51643, 52339, 53019, 53683, 54331, 54963, 55577, 56175, 56755, 57319, 57864, 58393, 58903, 59395, 59870, 60326, 60763, 61183, 61583, 61965, 62328, 62672, 62997, 63302, 63589, 63856, 64103, 64332, 64540, 64729, 64898, 65047, 65177, 65286, 65376, 65446, 65496, 65526, 65535};
    private int fight_delay;
    private long fight_time;
    private int fight_action;
    private int fight_action_last = -1;
    private static boolean IR_destroyed = false;
    private static final byte IR_BLOCK_SIZE = 32;
    public static int IR_scroll_x;
    public static int IR_scroll_y;
    private static int IR_rink_block_width;
    private static int IR_rink_block_height;
    private static int IR_rink_pixel_width;
    private static int IR_rink_pixel_height;
    public static final int IR_RINK_LEFT = 32;
    public static final int IR_RINK_RIGHT = 346;
    public static final int IR_RINK_TOP = 32;
    public static final int IR_RINK_BOTTOM = 572;
    public static final int IR_RINK_HALFWAY = 302;
    public static final int IR_GOAL_TOP = 80;
    public static final int IR_GOAL_BOTTOM = 528;
    public static final int IR_GOAL_CENTRE = 192;
    public static final int IR_GOAL_WIDTH = 32;
    public static final int IR_GOAL_HEIGHT = 20;
    public static final int IR_GOAL_TOP_YPOS = 53;
    public static final int IR_GOAL_BOTTOM_YPOS = 518;
    public static final int IR_GOAL_SORT_OFFSET = 20;
    public static int[][] IR_goal_collision;
    private Sprite IR_topgoal;
    private Sprite IR_bottomgoal;
    private Sprite IR_logo_top;
    private Sprite IR_logo_bottom;
    private static Sprite IR_rinktopspr;
    private Sprite[] IR_rinkspr;
    private static final short[][] IR_rinkpos;
    private static final int XG = 28;
    private static final int YG = 34;
    private static final int XX = 40;
    private static final int YY = 80;
    private static final short[][] IR_lights;
    private static int PUCK_xPos;
    private static int PUCK_yPos;
    private static int PUCK_xPosOld;
    private static int PUCK_yPosOld;
    private static int PUCK_xPosLast;
    private static int PUCK_yPosLast;
    private Sprite PUCK_sprite;
    private Sprite PUCK_arrow;
    private static final int PUCK_X_ORIGIN = 0;
    private static final int PUCK_Y_ORIGIN = 0;
    public int PUCK_angle = 0;
    public int PUCK_speed = 0;
    public boolean PUCK_powershot = false;
    private boolean PUCK_goalscored = false;
    public int PUCK_scorer = 0;
    private int[] PUCK_power_x;
    private int[] PUCK_power_y;
    public int PUCK_puck_x_start = 190;
    public int PUCK_puck_y_start = 302;
    public boolean PUCK_shot = false;

    Game(IceHockey parent) {
        this.players = new Player[6];
        this.sin_table = new int[450];
        this.rand = new Random();
        this.score = new int[2];
        this.fighters = new Sprite[2];
        this.fight_energy = new int[2];
        this.sprgoal = new Sprite[5];
        this.PUCK_arrow = new Sprite(IceHockey.static_images[5], 8);
        this.PUCK_power_x = new int[20];
        this.PUCK_power_y = new int[20];
        this.parent = parent;
        if (IceHockey.shared_current_period == 0) {
            numfights = 0;
            Frontend.overtime = false;
            this.state = 1;
        } else {
            this.state = 2;
        }
        for (int n = 0; n < 5; ++n) {
            this.sprgoal[n] = new Sprite(IceHockey.static_images[6], 5);
            this.sprgoal[n].SetXY(13 + (IceHockey.canvasWidth - this.sprgoal[0].width * 5) / 2 + n * this.sprgoal[0].width, (IceHockey.canvasHeight - 31) / 2 - this.sprgoal[0].height / 2);
            this.sprgoal[n].SetFrame(n);
        }
        this.team1mid = this.stripcolour[IceHockey.shared_team_id[0]];
        this.team1top = this.helmetcolour[IceHockey.shared_team_id[0]];
        this.team2mid = 1;
        this.team2top = 1;
        if (IceHockey.shared_gametype == 0 && IceHockey.shared_team_id[1] == IceHockey.shared_our_team) {
            int tmp = this.team1mid;
            this.team1mid = this.team2mid;
            this.team2mid = tmp;
            tmp = this.team1top;
            this.team1top = this.team2top;
            this.team2top = tmp;
        }
        this.InitTables();
        if (IceHockey.shared_current_period == 0) {
            this.score[0] = 0;
            this.score[1] = 0;
        } else {
            this.score[0] = IceHockey.shared_score[0];
            this.score[1] = IceHockey.shared_score[1];
        }
        if (IceHockey.shared_option_periodlen == 0) {
            this.seconds_per_quarter = 180;
        }
        if (IceHockey.shared_option_periodlen == 1) {
            this.seconds_per_quarter = 300;
        }
    }

    public int Tick() {
        if (this.state != this.state_previous) {
            this.state_previous = this.state;
        }
        switch (this.state) {
            default: {
                break;
            }
            case 1: {
                int sk = 0;
                if (this.loadindex >= 0 && this.loadindex < 5) {
                    sk = this.team1mid;
                }
                if (this.loadindex >= 5 && this.loadindex < 10) {
                    sk = this.team1top;
                }
                if (this.loadindex >= 10 && this.loadindex < 14) {
                    sk = this.team1mid;
                }
                if (this.loadindex >= 14 && this.loadindex < 19) {
                    sk = this.team2mid;
                }
                if (this.loadindex >= 19 && this.loadindex < 24) {
                    sk = this.team2top;
                }
                if (this.loadindex >= 24 && this.loadindex < 28) {
                    sk = this.team2mid;
                }
                String newstr = "/sk3/" + sk + skaters_gfx[this.loadindex];
                System.out.println("newstr = " + newstr);
                try {
                    IceHockey.static_images[13 + this.loadindex] = Image.createImage((String)newstr);
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                    GameCanvas.bug = "" + newstr;
                }
                newstr = null;
                if (++this.loadindex < 28) break;
                this.state = 2;
                break;
            }
            case 2: {
                this.InitPlayers();
                this.IR_Construct();
                this.PUCK_Construct();
                this.fighters[0] = new Sprite(IceHockey.static_images[7], 5);
                this.fighters[1] = new Sprite(IceHockey.static_images[7], 5);
                this.fighters[0].DeActivate();
                this.fighters[1].DeActivate();
                this.state = 3;
                System.out.println("intit");
                break;
            }
            case 3: {
                this.RunGame();
                this.state = 4;
                this.game_state = 0;
                break;
            }
            case 4: {
                this.RunGame();
                if (!this.exit_flag) break;
                return 1;
            }
        }
        return 0;
    }

    public void DrawConfirmation(Graphics g) {
        try {
            g.setClip(0, 0, IceHockey.canvasWidth, IceHockey.canvasHeight);
            g.setColor(0);
            g.fillRect(15, 45, IceHockey.canvasWidth - 26 + 2, IceHockey.canvasHeight - 86 + 2);
            g.setColor(0xFFFFFF);
            g.fillRect(13, 43, IceHockey.canvasWidth - 26, IceHockey.canvasHeight - 86);
            g.setFont(Frontend.MediumPlainFont);
            int y = 60;
            int x = IceHockey.canvasWidth / 2;
            g.setColor(0, 0, 0);
            g.drawString("Are you sure", x, y, 17);
            g.drawString("you want to quit?", x, y + 20, 17);
            y += 45;
            g.setColor(0, 0, 0);
            if (this.exit_curr_selected == 0) {
                g.setFont(Frontend.MediumBoldFont);
            } else {
                g.setFont(Frontend.MediumPlainFont);
            }
            g.drawString("Yes", x + 1, y + 1, 17);
            y += 20;
            if (this.exit_curr_selected == 1) {
                g.setFont(Frontend.MediumBoldFont);
            } else {
                g.setFont(Frontend.MediumPlainFont);
            }
            g.drawString("No", x + 1, y + 1, 17);
            g.drawImage(IceHockey.static_images[53], 20, IceHockey.canvasHeight - IceHockey.static_images[53].getHeight() - 45, 20);
        }
        catch (Exception e) {
            System.out.println("error in DrawConfirmation() =" + e);
        }
    }

    public static void SetClip(Graphics g) {
        g.setClip(0, 0, IceHockey.canvasWidth, IceHockey.canvasHeight);
    }

    public void Draw(Graphics g) {
        if (this.isExitConf) {
            this.DrawConfirmation(g);
            return;
        }
        switch (this.state) {
            default: {
                break;
            }
            case 1: {
                Game.SetClip(g);
                int pct = IceHockey.canvasWidth * (this.loadindex * 100) / 20 / 100;
                g.setColor(220, pct & 0xFF, 0);
                g.fillRect(0, IceHockey.canvasHeight - 6, pct, 6);
                break;
            }
            case 4: {
                if (this.game_state == 6) {
                    this.DrawPause(g);
                    return;
                }
                if (this.game_state == 5) {
                    if (this.fight_state == 11) {
                        this.DrawRink(g);
                    }
                    if (this.pause_redraw_flag) {
                        this.pause_redraw_flag = false;
                        this.DrawRink(g);
                    }
                    this.DrawFight(g);
                } else {
                    this.DrawRink(g);
                    g.drawImage(IceHockey.static_images[65], IceHockey.canvasWidth - IceHockey.static_images[65].getWidth(), IceHockey.canvasHeight - IceHockey.static_images[65].getHeight(), 20);
                }
                this.ShowGoalText(g);
                if (this.game_state != 4) break;
                this.DrawFinished(g);
            }
        }
    }

    public void StartGamePause() {
        if (this.game_state != 6) {
            this.game_state_save_pause = this.game_state;
            this.clock_state_when_paused = this.clock_running;
            this.parent.StopSound();
            this.pause_curr_selected = 0;
            this.StopClock();
            this.game_state = 6;
        }
    }

    public void EndGamePause() {
        if (this.clock_state_when_paused) {
            this.StartClock();
        }
        this.game_state = this.game_state_save_pause;
        this.pause_redraw_flag = true;
    }

    private void DrawFinished(Graphics g) {
        Game.SetClip(g);
        g.setFont(Frontend.MediumBoldFont);
        int x = IceHockey.canvasWidth / 2;
        int y = IceHockey.canvasHeight / 2;
        g.setColor(0, 0, 0);
        g.drawString(IceHockey.strings[54], x, y, 17);
        g.setColor(255, 255, 255);
        g.drawString(IceHockey.strings[54], x + 1, y + 1, 17);
    }

    private void DrawPause(Graphics g) {
        Game.SetClip(g);
        g.setColor(0, 0, 0);
        g.fillRect(12, 42, IceHockey.canvasWidth - 20 + 2, IceHockey.canvasHeight - 80 + 2);
        g.setColor(0xFFFFFF);
        g.fillRect(10, 40, IceHockey.canvasWidth - 20, IceHockey.canvasHeight - 80);
        g.setFont(Frontend.MediumBoldFont);
        int y = 70;
        int x = IceHockey.canvasWidth / 2;
        g.setColor(0, 0, 0);
        g.drawString(IceHockey.strings[49], x, y, 17);
        y += 30;
        if (this.pause_curr_selected == 0) {
            g.setFont(Frontend.MediumBoldFont);
        } else {
            g.setFont(Frontend.MediumPlainFont);
        }
        g.drawString(IceHockey.strings[50], x, y, 17);
        y += 20;
        if (this.pause_curr_selected == 1) {
            g.setFont(Frontend.MediumBoldFont);
        } else {
            g.setFont(Frontend.MediumPlainFont);
        }
        g.drawString(IceHockey.strings[51], x, y, 17);
        g.drawImage(IceHockey.static_images[53], 15, IceHockey.canvasHeight - IceHockey.static_images[53].getHeight() - 42, 20);
    }

    private void DrawRink(Graphics g) {
        Game.SetClip(g);
        g.setColor(204, 206, 204);
        g.fillRect(0, 31, IceHockey.canvasWidth, IceHockey.canvasHeight - 31);
        Game.SetClip(g);
        this.IR_DrawRink(g);
        Game.SetClip(g);
        this.SortAndDraw(g);
        Game.SetClip(g);
        Game.IR_DrawRinkTopLayer(g);
        this.DrawPowerBar(g);
        this.PUCK_DrawIndicator(g);
        this.DrawPanel(g);
    }

    private void DrawPanel(Graphics g) {
        long time = this.UpdateClock() / 1000L;
        int remain = this.seconds_per_quarter - (int)time;
        if (remain <= 0) {
            remain = 0;
            this.quarter_finished = true;
        }
        if (remain == 60) {
            this.parent.playSound(3);
        }
        Game.SetClip(g);
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, IceHockey.canvasWidth, 30);
        Game.SetClip(g);
        g.setFont(gameFontSmall);
        g.setColor(220, 220, 0);
        Frontend.drawTeamLongName(g, IceHockey.shared_team_id[0], 3, 4, 20, true);
        Frontend.drawTeamLongName(g, IceHockey.shared_team_id[1], 3, 17, 20, true);
        g.setFont(gameFontSmallBold);
        g.drawString("" + this.score[0], IceHockey.canvasWidth - 29, 4, 24);
        g.drawString("" + this.score[1], IceHockey.canvasWidth - 29, 17, 24);
        g.drawString(IceHockey.strings[25 + IceHockey.shared_current_period], IceHockey.canvasWidth - 16, 4, 17);
        g.drawString("" + remain / 60 + ":" + (remain % 60 >= 10 ? "" : "0") + remain % 60, IceHockey.canvasWidth - 14, 17, 17);
        g.setColor(10, 30, 220);
        g.fillRect(0, 0, IceHockey.canvasWidth, 2);
        g.fillRect(0, 29, IceHockey.canvasWidth, 2);
        g.fillRect(0, 0, 2, 30);
        g.fillRect(IceHockey.canvasWidth - 2, 0, 2, 30);
        g.fillRect(IceHockey.canvasWidth - 29, 0, 2, 30);
    }

    private long UpdateClock() {
        if (this.clock_running) {
            this.elapsed_time += System.currentTimeMillis() - this.start_time;
            this.StartClock();
        }
        return this.elapsed_time;
    }

    private void ResetClock() {
        this.elapsed_time = 0L;
        this.clock_running = false;
    }

    public void StartClock() {
        this.clock_running = true;
        this.start_time = System.currentTimeMillis();
    }

    public void StopClock() {
        this.UpdateClock();
        this.clock_running = false;
    }

    private void DrawPowerBar(Graphics g) {
        if (playerWithPuck != null) {
            int team = Game.playerWithPuck.team;
            int pc1 = Player.powershot_counter[team] * 100 / 1000;
            int pc2 = pc1 * 80 / 100;
            g.setColor(0, 255, 0);
            g.fillRect(10, IceHockey.canvasHeight - 10, 80, 6);
            g.setColor(255, 0, 0);
            g.fillRect(10, IceHockey.canvasHeight - 10, pc2, 6);
        }
    }

    private void SortAndDraw(Graphics g) {
        int n;
        int num = 8;
        int[] y = new int[9];
        int[] ix = new int[9];
        for (n = 0; n < 6; ++n) {
            y[n] = this.players[n].GetY();
            ix[n] = n;
        }
        if (playerWithPuck == null) {
            ix[n] = 20;
            y[n++] = Game.PUCK_GetY();
            ++num;
        }
        ix[n] = 21;
        y[n++] = 73;
        ix[n] = 22;
        y[n++] = 538;
        for (int z = 0; z < num - 1; ++z) {
            for (n = 0; n < num - 1 - z; ++n) {
                if (y[n] <= y[n + 1]) continue;
                int t = y[n + 1];
                y[n + 1] = y[n];
                y[n] = t;
                t = ix[n + 1];
                ix[n + 1] = ix[n];
                ix[n] = t;
            }
        }
        block8: for (n = 0; n < num; ++n) {
            switch (ix[n]) {
                case 20: {
                    this.PUCK_Draw(g);
                    continue block8;
                }
                case 21: {
                    this.IR_DrawTopGoal(g);
                    continue block8;
                }
                case 22: {
                    this.IR_DrawBottomGoal(g);
                    continue block8;
                }
                default: {
                    this.players[ix[n]].Draw(g);
                    if (playerWithPuck != this.players[ix[n]]) continue block8;
                    this.PUCK_Draw(g);
                }
            }
        }
    }

    public void Destroy() {
        int n;
        for (n = 0; n < 6; ++n) {
            this.players[n].Destroy();
        }
        this.players = null;
        this.sin_table = null;
        this.rand = null;
        this.IR_Destroy();
        this.PUCK_Destroy();
        for (int i = 0; i < 2; ++i) {
            this.fighters[i].Destroy();
            this.fighters[i] = null;
        }
        this.fighters = null;
        for (n = 0; n < 5; ++n) {
            this.sprgoal[n].Destroy();
            this.sprgoal[n] = null;
        }
        this.sprgoal = null;
        this.PUCK_arrow.Destroy();
        this.PUCK_arrow = null;
        this.PUCK_power_x = null;
        this.PUCK_power_y = null;
    }

    private void InitPlayers() {
        int n;
        int count = 0;
        int attack_dir = 0;
        if (IceHockey.shared_gametype == 0 && IceHockey.shared_team_id[1] == IceHockey.shared_our_team) {
            attack_dir = 1;
        }
        for (n = 0; n < 3; ++n) {
            this.players[count++] = new Player(this, 0, n, attack_dir);
        }
        for (n = 0; n < 3; ++n) {
            this.players[count++] = new Player(this, 1, n, attack_dir ^ 1);
        }
        this.players[0].SetTeamMates(this.players[1], this.players[2]);
        this.players[1].SetTeamMates(this.players[0], this.players[2]);
        this.players[2].SetTeamMates(this.players[0], this.players[1]);
        this.players[3].SetTeamMates(this.players[4], this.players[5]);
        this.players[4].SetTeamMates(this.players[3], this.players[5]);
        this.players[5].SetTeamMates(this.players[3], this.players[4]);
        int team = IceHockey.shared_team_id[0];
        this.players[0].SetStats(IceHockey.TeamStats[team][0], IceHockey.TeamStats[team][1], IceHockey.TeamStats[team][2]);
        this.players[1].SetStats(IceHockey.TeamStats[team][3], IceHockey.TeamStats[team][4], IceHockey.TeamStats[team][5]);
        this.players[2].SetStats(IceHockey.TeamStats[team][6], IceHockey.TeamStats[team][7], IceHockey.TeamStats[team][8]);
        team = IceHockey.shared_team_id[1];
        this.players[3].SetStats(IceHockey.TeamStats[team][0], IceHockey.TeamStats[team][1], IceHockey.TeamStats[team][2]);
        this.players[4].SetStats(IceHockey.TeamStats[team][3], IceHockey.TeamStats[team][4], IceHockey.TeamStats[team][5]);
        this.players[5].SetStats(IceHockey.TeamStats[team][6], IceHockey.TeamStats[team][7], IceHockey.TeamStats[team][8]);
    }

    public static int Distance(int ax, int ay, int bx, int by) {
        return (ax - bx) * (ax - bx) + (ay - by) * (ay - by);
    }

    static int SqDistanceApprox(int x, int y) {
        int s;
        if (x < 0) {
            x = -x;
        }
        if (y < 0) {
            y = -y;
        }
        if ((s = x + y) == 0) {
            return 0;
        }
        return (x * x + y * y) / s + s >> 1;
    }

    public void InitTables() {
        for (int i = 0; i < 90; ++i) {
            this.sin_table[i] = tsin[i];
            this.sin_table[i + 90] = tsin[90 - i];
            this.sin_table[i + 180] = -tsin[i];
            this.sin_table[i + 270] = -tsin[90 - i];
            this.sin_table[i + 360] = tsin[i];
        }
    }

    public int ClampAngle(int angle) {
        if (angle < 0) {
            angle += 360;
        }
        if (angle > 359) {
            angle -= 360;
        }
        return angle;
    }

    private void RunGame() {
        if (this.game_state != this.game_state_previous) {
            this.game_state_previous = this.game_state;
        }
        block0 : switch (this.game_state) {
            default: {
                break;
            }
            case 0: {
                this.face_off_state = 0;
                this.game_state = 1;
                this.PUCK_Reset();
                Game.IR_CentreOverPuck(1);
                for (int n = 0; n < 6; ++n) {
                    this.players[n].ResetPosition();
                }
                playerWithPuck = null;
                playerInControl = null;
                this.ResetClock();
                this.quarter_finished = false;
                break;
            }
            case 1: {
                switch (this.face_off_state) {
                    default: {
                        break;
                    }
                    case 0: {
                        playerWithPuck = null;
                        playerInControl = null;
                        this.PUCK_Reset();
                        this.players[0].StartReturn();
                        this.players[1].StartReturn();
                        this.players[2].StartReturn();
                        this.players[3].StartReturn();
                        this.players[4].StartReturn();
                        this.players[5].StartReturn();
                        ++this.face_off_state;
                        Player.powershot_counter[0] = 0;
                        Player.powershot_counter[1] = 0;
                        this.parent.playSound(4);
                        break;
                    }
                    case 1: {
                        boolean is_centre = this.IR_AutoCentre(playerInControl);
                        for (int n = 0; n < 6; ++n) {
                            this.players[n].Process(playerInControl, playerWithPuck);
                        }
                        int numfin = this.players[1].FinishedReturn();
                        numfin += this.players[2].FinishedReturn();
                        numfin += this.players[4].FinishedReturn();
                        if ((numfin += this.players[5].FinishedReturn()) != 4) break block0;
                        this.game_state_tmpcount = 0;
                        ++this.face_off_state;
                        break;
                    }
                    case 2: {
                        int n;
                        boolean is_centre = this.IR_AutoCentre(playerInControl);
                        for (n = 0; n < 6; ++n) {
                            this.players[n].Process(playerInControl, playerWithPuck);
                        }
                        if (++this.game_state_tmpcount <= 25) break;
                        for (n = 0; n < 6; ++n) {
                            this.players[n].StartFaceOff();
                        }
                        this.game_state_tmpcount = 0;
                        ++this.face_off_state;
                        break;
                    }
                    case 3: {
                        boolean is_centre = this.IR_AutoCentre(playerInControl);
                        for (int n = 0; n < 6; ++n) {
                            this.players[n].Process(playerInControl, playerWithPuck);
                        }
                        if (++this.game_state_tmpcount <= 20) break block0;
                        this.game_state_tmpcount = 0;
                        ++this.face_off_state;
                        break;
                    }
                    case 4: {
                        this.IR_AutoCentre(playerInControl);
                        if (++this.game_state_tmpcount <= 20) break;
                        playerWithPuck = Math.abs(this.rand.nextInt() % 100) > 50 ? this.players[1] : this.players[4];
                        playerInControl = this.players[1];
                        this.players[0].StartSkate();
                        this.players[1].StartSkate();
                        this.players[2].StartSkate();
                        this.players[3].StartSkate();
                        this.players[4].StartSkate();
                        this.players[5].StartSkate();
                        this.game_state = 2;
                        this.StartClock();
                        break;
                    }
                }
                break;
            }
            case 2: {
                for (int n = 0; n < 6; ++n) {
                    this.players[n].Process(playerInControl, playerWithPuck);
                }
                this.TestAllCollisions();
                this.PUCK_Process(playerWithPuck);
                if (this.PUCK_Scored()) {
                    this.parent.playSound(2);
                    this.game_state = 3;
                    this.score_state = 0;
                    this.StopClock();
                }
                if (this.PUCK_shot || playerWithPuck == this.players[0] || playerWithPuck == this.players[3] || this.players[0].IsDiving() || this.players[3].IsDiving() || this.PUCK_Scored()) {
                    Game.IR_CentreOverPuck(1);
                } else if (IceHockey.shared_option_cameramode == 0) {
                    this.IR_AutoCentre(playerInControl);
                } else {
                    this.IR_AutoCentre(null);
                }
                if (!this.quarter_finished) break;
                this.game_state = 4;
                this.finished_state = 0;
                this.parent.playSound(5);
                break;
            }
            case 3: {
                switch (this.score_state) {
                    default: {
                        break;
                    }
                    case 0: {
                        if (this.PUCK_scorer == 0) {
                            if ((IceHockey.shared_current_period & 1) == 0) {
                                this.score[0] = this.score[0] + 1;
                            } else {
                                this.score[1] = this.score[1] + 1;
                            }
                        } else if ((IceHockey.shared_current_period & 1) == 0) {
                            this.score[1] = this.score[1] + 1;
                        } else {
                            this.score[0] = this.score[0] + 1;
                        }
                        this.goaltext_count = 0;
                        this.goaltext_state = 1;
                        this.players[this.PUCK_scorer * 3 + 1].StartCelebrate();
                        this.players[this.PUCK_scorer * 3 + 2].StartCelebrate();
                        this.game_state_tmpcount = 0;
                        ++this.score_state;
                        if (!Frontend.overtime) break block0;
                        this.game_state = 4;
                        this.finished_state = 0;
                        break;
                    }
                    case 1: {
                        this.IR_AutoCentre(null);
                        for (int n = 0; n < 6; ++n) {
                            this.players[n].Process(playerInControl, playerWithPuck);
                        }
                        if (++this.game_state_tmpcount <= 50) break block0;
                        ++this.score_state;
                        this.game_state_tmpcount = 0;
                        break;
                    }
                    case 2: {
                        Game.IR_CentreOverPuck(20);
                        for (int n = 0; n < 6; ++n) {
                            this.players[n].Process(playerInControl, playerWithPuck);
                        }
                        if (++this.game_state_tmpcount <= 50) break block0;
                        this.face_off_state = 0;
                        this.game_state = 1;
                        this.goaltext_state = 0;
                        break;
                    }
                }
                break;
            }
            case 4: {
                switch (this.finished_state) {
                    default: {
                        break block0;
                    }
                    case 0: {
                        this.game_state_tmpcount = 0;
                        ++this.finished_state;
                        break block0;
                    }
                    case 1: 
                }
                for (int n = 0; n < 6; ++n) {
                    this.players[n].Process(playerInControl, playerWithPuck);
                }
                this.IR_AutoCentre(playerInControl);
                if (++this.game_state_tmpcount <= 50) break;
                IceHockey.shared_score[0] = this.score[0];
                IceHockey.shared_score[1] = this.score[1];
                IceHockey.shared_fe_entry_type = 1;
                this.exit_flag = true;
                break;
            }
            case 5: {
                switch (this.fight_state) {
                    default: {
                        break block0;
                    }
                    case 0: {
                        this.fight_reveal_y = 0;
                        ++this.fight_state;
                        this.fighters[0].SetXY(-this.fighters[0].width, this.fight_centre_y - 26);
                        this.fighters[1].SetXY(IceHockey.canvasWidth, this.fight_centre_y - 26);
                        this.fighters[0].SetFrame(1);
                        this.fighters[1].SetFrame(1);
                        this.fighters[0].slide = 0;
                        this.fighters[1].slide = 0;
                        break block0;
                    }
                    case 1: {
                        this.fight_reveal_y += 6;
                        this.fight_reveal_y = 34;
                        ++this.fight_state;
                        this.fighter1_x = IceHockey.canvasWidth / 2 - this.fighters[0].width;
                        this.fighter2_x = IceHockey.canvasWidth / 2;
                        this.fighters[0].Activate();
                        this.fighters[1].Activate();
                        break block0;
                    }
                    case 2: {
                        this.fighters[0].SetX(this.fighters[0].GetX() + 5);
                        if (this.fighters[0].GetX() <= this.fighter1_x) break block0;
                        this.fighters[0].SetX(this.fighter1_x);
                        ++this.fight_state;
                        break block0;
                    }
                    case 3: {
                        this.fighters[1].SetX(this.fighters[1].GetX() - 5);
                        if (this.fighters[1].GetX() >= this.fighter2_x) break block0;
                        this.fighters[1].SetX(this.fighter2_x);
                        this.runfight_state = 0;
                        this.fight_state = 6;
                        break block0;
                    }
                    case 6: {
                        this.RunFight();
                        if (this.fight_energy[0] == 0) {
                            this.fight_loser = this.players[this.fighter1_id].team == 0 ? this.fighter1_id : this.fighter2_id;
                            this.fight_state = 8;
                        }
                        if (this.fight_energy[1] != 0) break block0;
                        this.fight_loser = this.players[this.fighter1_id].team == 1 ? this.fighter1_id : this.fighter2_id;
                        this.fight_state = 8;
                        break block0;
                    }
                    case 8: {
                        this.fighters[this.fight_energy[0] != 0 ? 0 : 1].SetFrame(1);
                        this.fight_state = 9;
                        break block0;
                    }
                    case 9: {
                        int loseid;
                        int n = loseid = this.fight_energy[0] != 0 ? 1 : 0;
                        if (this.fight_energy[loseid] != 0) break block0;
                        this.fighters[loseid].slide += 4;
                        if (this.fighters[loseid].slide <= this.fighters[loseid].height) break block0;
                        this.fight_state = 10;
                        this.fighters[loseid].DeActivate();
                        break block0;
                    }
                    case 10: {
                        boolean winid;
                        boolean bl = winid = this.fight_energy[0] == 0;
                        if (!winid) {
                            this.fighters[0].SetX(this.fighters[0].GetX() - 5);
                            if (this.fighters[0].GetX() >= -this.fighters[0].width) break block0;
                            this.fighters[0].DeActivate();
                            this.fight_state = 11;
                            break block0;
                        }
                        this.fighters[1].SetX(this.fighters[1].GetX() + 5);
                        if (this.fighters[1].GetX() <= IceHockey.canvasWidth) break block0;
                        this.fighters[1].DeActivate();
                        this.fight_state = 11;
                        break block0;
                    }
                    case 11: {
                        this.fight_reveal_y -= 6;
                        if (this.fight_reveal_y >= 0) break block0;
                        this.parent.playSound(1);
                        this.players[this.fight_loser].KnockDownPlayer();
                        this.game_state = this.game_state_save;
                        this.StartClock();
                    }
                }
            }
        }
    }

    private void ShowGoalText(Graphics g) {
        int n;
        if (--this.goaltext_count < 0) {
            this.goaltext_count = 10;
            switch (this.goaltext_state) {
                default: {
                    break;
                }
                case 1: {
                    for (n = 0; n < 5; ++n) {
                        this.sprgoal[n].Activate();
                    }
                    ++this.goaltext_state;
                    break;
                }
                case 2: {
                    for (n = 0; n < 5; ++n) {
                        this.sprgoal[n].DeActivate();
                    }
                    ++this.goaltext_state;
                    break;
                }
                case 3: {
                    for (n = 0; n < 5; ++n) {
                        this.sprgoal[n].Activate();
                    }
                    ++this.goaltext_state;
                    break;
                }
                case 4: {
                    for (n = 0; n < 5; ++n) {
                        this.sprgoal[n].DeActivate();
                    }
                    ++this.goaltext_state;
                    break;
                }
                case 5: {
                    this.sprgoal[0].Activate();
                    ++this.goaltext_state;
                    break;
                }
                case 6: {
                    this.sprgoal[1].Activate();
                    ++this.goaltext_state;
                    break;
                }
                case 7: {
                    this.sprgoal[2].Activate();
                    ++this.goaltext_state;
                    break;
                }
                case 8: {
                    this.sprgoal[3].Activate();
                    ++this.goaltext_state;
                    break;
                }
                case 9: {
                    this.sprgoal[4].Activate();
                    ++this.goaltext_state;
                    break;
                }
                case 10: {
                    for (n = 0; n < 5; ++n) {
                        this.sprgoal[n].DeActivate();
                    }
                    this.goaltext_state = 0;
                }
            }
        }
        if (this.goaltext_state > 1) {
            for (n = 0; n < 5; ++n) {
                this.sprgoal[n].Draw(g);
            }
        }
    }

    private void TestAllCollisions() {
        for (int i = 0; i < 5; ++i) {
            for (int j = i + 1; j < 6 && !this.players[i].IsChecked() && !this.players[j].IsChecked(); ++j) {
                int d;
                int rad;
                int dx = this.players[i].GetX() - this.players[j].GetX();
                int dy = this.players[i].GetY() - this.players[j].GetY();
                if ((dy >= (rad = 25) || dy <= -rad) && (dx >= rad || dx <= -rad) || (d = (this.players[i].GetX() - this.players[j].GetX()) * (this.players[i].GetX() - this.players[j].GetX()) + (this.players[i].GetY() - this.players[j].GetY()) * (this.players[i].GetY() - this.players[j].GetY())) >= rad * rad || d <= 0) continue;
                int fov1 = this.players[i].GetFOV(this.players[j].GetX(), this.players[j].GetY());
                int fov2 = this.players[j].GetFOV(this.players[i].GetX(), this.players[i].GetY());
                int ang1 = Player.AngleBetweenObjects(this.players[j].GetX(), this.players[j].GetY(), this.players[i].GetX(), this.players[i].GetY());
                int ang2 = ang1 + 180;
                if (ang2 > 359) {
                    ang2 -= 360;
                }
                if (i == 0 || i == 3 || j == 0 || j == 3) {
                    int ang = Player.AngleBetweenObjects(this.players[j].GetX(), this.players[j].GetY(), this.players[i].GetX(), this.players[i].GetY());
                    if (!this.players[i].is_goalie) {
                        this.players[i].angle = ang;
                    }
                    if ((ang += 180) > 360) {
                        ang -= 360;
                    }
                    if (!this.players[j].is_goalie) {
                        this.players[j].angle = ang;
                    }
                    if (this.players[i].speed > 131072) {
                        this.players[i].speed -= 65536;
                    }
                    if (this.players[j].speed > 131072) {
                        this.players[j].speed -= 65536;
                    }
                    if (this.players[i].speed < 57344 && !this.players[i].is_goalie) {
                        this.players[i].StartStand();
                    }
                    if (this.players[j].speed >= 57344 || this.players[j].is_goalie) continue;
                    this.players[j].StartStand();
                    continue;
                }
                if (fov1 > 150) {
                    if (!this.players[j].is_goalie) {
                        this.players[j].angle = ang2;
                    }
                    if (this.players[j].speed > 196608) {
                        this.players[j].speed -= 131072;
                    }
                    this.players[i].speed += 131072;
                } else {
                    if (!this.players[i].is_goalie) {
                        this.players[i].angle = ang1;
                    }
                    if (this.players[i].speed > 131072) {
                        this.players[i].speed -= 65536;
                    }
                    if (this.players[j].speed > 131072) {
                        this.players[j].speed -= 65536;
                    }
                }
                if (fov2 > 150) {
                    if (!this.players[i].is_goalie) {
                        this.players[i].angle = ang1;
                    }
                    if (this.players[i].speed > 196608) {
                        this.players[i].speed -= 131072;
                    }
                    this.players[j].speed += 131072;
                } else {
                    if (!this.players[j].is_goalie) {
                        this.players[j].angle = ang2;
                    }
                    if (this.players[i].speed > 131072) {
                        this.players[i].speed -= 65536;
                    }
                    if (this.players[j].speed > 131072) {
                        this.players[j].speed -= 65536;
                    }
                }
                if (this.players[i].speed < 57344 && !this.players[i].is_goalie) {
                    this.players[i].StartStand();
                }
                if (this.players[j].speed >= 57344 || this.players[j].is_goalie) continue;
                this.players[j].StartStand();
            }
        }
    }

    public void StartFight(int id1, int id2) {
        if (this.game_state != 2) {
            return;
        }
        this.fighter1_id = id1;
        this.fighter2_id = id2;
        this.fight_energy[0] = this.MAX_FIGHT_ENERGY;
        this.fight_energy[1] = this.MAX_FIGHT_ENERGY;
        this.game_state_save = this.game_state;
        this.game_state = 5;
        this.fight_state = 0;
        this.parent.playSound(0);
    }

    private void DrawFight(Graphics g) {
        int yh;
        int yt;
        int ix;
        int[][] rects = new int[][]{{23, 0}, {39, 17}, {23, 18}, {67, 51}, {55, 0}, {75, 14}, {35, 15}, {70, 51}, {39, 1}, {59, 16}, {40, 16}, {76, 51}, {54, 3}, {73, 16}, {26, 15}, {63, 51}, {24, 1}, {43, 14}, {3, 15}, {60, 51}};
        int[] fightcolours = new int[]{0, 0xFFFFFF, 14161955, 2700108, 1316887, 2770488};
        int yb = this.fighters[0].GetY() + this.fighters[0].height;
        Game.SetClip(g);
        if (this.fight_reveal_y > 0) {
            g.setColor(255, 255, 255);
            g.fillRect(0, this.fight_centre_y - this.fight_reveal_y, IceHockey.canvasWidth, this.fight_reveal_y << 1);
            g.setColor(140, 180, 140);
            g.fillRect(0, this.fight_centre_y - this.fight_reveal_y, IceHockey.canvasWidth, 2);
            g.fillRect(0, this.fight_centre_y + this.fight_reveal_y, IceHockey.canvasWidth, 2);
        }
        if (this.fighters[0].IsActive()) {
            ix = this.fighters[0].GetFrame() * 4;
            yt = this.fighters[0].GetY() + rects[ix][1] + this.fighters[0].slide;
            yh = rects[ix + 1][1] - rects[ix][1] + 1;
            if (yt < yb) {
                if (yt + yh > yb) {
                    yh = yb - yt;
                }
                g.setColor(fightcolours[this.team1top]);
                g.fillRect(this.fighters[0].GetX() + rects[ix][0], yt, rects[ix + 1][0] - rects[ix][0] + 1, yh);
            }
            yt = this.fighters[0].GetY() + rects[ix += 2][1] + this.fighters[0].slide;
            yh = rects[ix + 1][1] - rects[ix][1] + 1;
            if (yt < yb) {
                if (yt + yh > yb) {
                    yh = yb - yt;
                }
                g.setColor(fightcolours[this.team1mid]);
                g.fillRect(this.fighters[0].GetX() + rects[ix][0], yt, rects[ix + 1][0] - rects[ix][0] + 1, yh);
            }
        }
        if (this.fighters[1].IsActive()) {
            ix = this.fighters[1].GetFrame() * 4;
            yt = this.fighters[1].GetY() + rects[ix][1] + this.fighters[1].slide;
            yh = rects[ix + 1][1] - rects[ix][1] + 1;
            if (yt < yb) {
                if (yt + yh > yb) {
                    yh = yb - yt;
                }
                g.setColor(fightcolours[this.team2top]);
                g.fillRect(this.fighters[1].GetX() + this.fighters[1].width - rects[ix][0] - (rects[ix + 1][0] - rects[ix][0]), this.fighters[1].GetY() + rects[ix][1], rects[ix + 1][0] - rects[ix][0] + 1, rects[ix + 1][1] - rects[ix][1] + 1);
            }
            yt = this.fighters[1].GetY() + rects[ix += 2][1] + this.fighters[1].slide;
            yh = rects[ix + 1][1] - rects[ix][1] + 1;
            if (yt < yb) {
                if (yt + yh > yb) {
                    yh = yb - yt;
                }
                g.setColor(fightcolours[this.team2mid]);
                g.fillRect(this.fighters[1].GetX() + this.fighters[1].width - rects[ix][0] - (rects[ix + 1][0] - rects[ix][0]), this.fighters[1].GetY() + rects[ix][1], rects[ix + 1][0] - rects[ix][0] + 1, rects[ix + 1][1] - rects[ix][1] + 1);
            }
        }
        this.fighters[0].DrawAndSlide(g);
        Game.SetClip(g);
        this.fighters[1].DrawFlipped(g);
        if (this.fight_state == 6) {
            int len;
            Game.SetClip(g);
            int seg = IceHockey.canvasWidth / 2 / this.MAX_FIGHT_ENERGY;
            if (this.fight_energy[0] > 0) {
                len = this.fight_energy[0] == this.MAX_FIGHT_ENERGY ? IceHockey.canvasWidth / 2 : seg * this.fight_energy[0];
                g.setColor(255, 0, 0);
                g.fillRect(0, this.fight_centre_y + 29, len, 3);
            }
            if (this.fight_energy[1] > 0) {
                len = this.fight_energy[1] == this.MAX_FIGHT_ENERGY ? IceHockey.canvasWidth / 2 : seg * this.fight_energy[1];
                g.setColor(255, 255, 0);
                g.fillRect(IceHockey.canvasWidth - len, this.fight_centre_y + 29, len, 3);
            }
            g.setColor(255, 255, 255);
            g.fillRoundRect(150, 150, 20, 20, 10, 10);
            g.setColor(100, 70, 90);
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            int dig_y = 150;
            switch (this.fight_action) {
                case 0: {
                    g.drawString("1", 160, dig_y, 17);
                    break;
                }
                case 1: {
                    g.drawString("2", 160, dig_y, 17);
                    break;
                }
                case 2: 
                case 3: {
                    g.drawString("3", 160, dig_y, 17);
                }
            }
        }
    }

    private void RunFight() {
        switch (this.runfight_state) {
            default: {
                break;
            }
            case 0: {
                this.fight_delay = 0;
                ++this.runfight_state;
                this.fight_action = -1;
                break;
            }
            case 1: {
                int rnum;
                this.fight_delay = 0;
                this.fight_time = System.currentTimeMillis();
                while ((rnum = Math.abs(this.rand.nextInt() % 4)) == this.fight_action_last) {
                }
                this.fight_action = rnum;
                this.fight_action_last = rnum;
                ++this.runfight_state;
                break;
            }
            case 2: {
                int ckey = 0;
                switch (this.fight_action) {
                    case 0: {
                        ckey = 8192;
                        break;
                    }
                    case 1: {
                        ckey = 16384;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ckey = 32768;
                    }
                }
                int keys = GameCanvas.GetKeys();
                boolean wrong = false;
                if ((keys &= 0xE000) > 0) {
                    if ((keys & ckey) == ckey) {
                        switch (this.fight_action) {
                            case 0: {
                                this.fighters[0].SetFrame(4);
                                this.fighters[1].SetFrame(0);
                                this.fight_energy[1] = this.fight_energy[1] - 1;
                                break;
                            }
                            case 1: {
                                this.fighters[0].SetFrame(3);
                                this.fighters[1].SetFrame(0);
                                this.fight_energy[1] = this.fight_energy[1] - 1;
                                break;
                            }
                            case 2: {
                                this.fighters[0].SetFrame(2);
                                this.fighters[1].SetFrame(4);
                                break;
                            }
                            case 3: {
                                this.fighters[0].SetFrame(2);
                                this.fighters[1].SetFrame(3);
                            }
                        }
                        this.fight_action = -1;
                        this.runfight_state = 0;
                    } else {
                        wrong = true;
                    }
                }
                long curr_time = System.currentTimeMillis();
                if (!wrong && curr_time <= this.fight_time + 1750L) break;
                switch (this.fight_action) {
                    case 0: {
                        this.fighters[0].SetFrame(4);
                        this.fighters[1].SetFrame(2);
                        break;
                    }
                    case 1: {
                        this.fighters[0].SetFrame(3);
                        this.fighters[1].SetFrame(2);
                        break;
                    }
                    case 2: {
                        this.fighters[0].SetFrame(0);
                        this.fighters[1].SetFrame(4);
                        this.fight_energy[0] = this.fight_energy[0] - 1;
                        break;
                    }
                    case 3: {
                        this.fighters[0].SetFrame(0);
                        this.fighters[1].SetFrame(3);
                        this.fight_energy[0] = this.fight_energy[0] - 1;
                    }
                }
                this.fight_action = -1;
                this.runfight_state = 0;
            }
        }
    }

    void IR_Construct() {
        this.IR_topgoal = new Sprite(IceHockey.static_images[1], 1);
        this.IR_bottomgoal = new Sprite(IceHockey.static_images[2], 1);
        IR_scroll_x = 95;
        IR_scroll_y = 253;
        IR_rink_block_width = 12;
        IR_rink_block_height = 19;
        IR_rink_pixel_width = IR_rink_block_width * 32;
        IR_rink_pixel_height = IR_rink_block_height * 32;
        this.IR_rinkspr = new Sprite[IR_rinkpos.length];
        for (int n = 0; n < IR_rinkpos.length; ++n) {
            this.IR_rinkspr[n] = new Sprite(null, 1);
        }
        IR_rinktopspr = new Sprite(null, 1);
        int logotop = 1;
        int team = IceHockey.shared_team_id[logotop ^ IceHockey.shared_current_period & 1];
        int logofile = 58 + team / 15;
        this.IR_logo_top = new Sprite(IceHockey.static_images[logofile], 15);
        this.IR_logo_top.SetFrame(team >= 15 ? team - 15 : team);
        team = IceHockey.shared_team_id[logotop ^ 1 ^ IceHockey.shared_current_period & 1];
        logofile = 58 + team / 15;
        this.IR_logo_bottom = new Sprite(IceHockey.static_images[logofile], 15);
        this.IR_logo_bottom.SetFrame(team >= 15 ? team - 15 : team);
        IR_destroyed = false;
    }

    public void IR_Destroy() {
        IR_destroyed = true;
        this.IR_topgoal.Destroy();
        this.IR_bottomgoal.Destroy();
        this.IR_logo_top.Destroy();
        this.IR_logo_bottom.Destroy();
        IR_rinktopspr.Destroy();
        for (int n = 0; n < IR_rinkpos.length; ++n) {
            this.IR_rinkspr[n].Destroy();
            this.IR_rinkspr[n] = null;
        }
        this.IR_rinkspr = null;
    }

    public void IR_DrawRink(Graphics g) {
        int n;
        if (IR_destroyed) {
            return;
        }
        Game.SetClip(g);
        int x = Game.IR_GetX() / 2;
        int y = Game.IR_GetY() / 3;
        for (n = 0; n < IR_lights.length; ++n) {
            g.setGrayScale(200);
            g.fillRoundRect(IR_lights[n][0] - x, IR_lights[n][1] - y, 16, 10, 5, 5);
            g.setGrayScale(220);
            g.fillRoundRect(IR_lights[n][0] - x + 2, IR_lights[n][1] - y + 1, 12, 8, 5, 5);
            g.setGrayScale(235);
            g.fillRoundRect(IR_lights[n][0] - x + 4, IR_lights[n][1] - y + 2, 8, 6, 5, 5);
        }
        x = Game.IR_GetX();
        y = Game.IR_GetY();
        for (n = 0; n < this.IR_rinkspr.length; ++n) {
            this.IR_rinkspr[n].SetXY(IR_rinkpos[n][0] - x, IR_rinkpos[n][1] - y);
            this.IR_rinkspr[n].DrawSingle(IceHockey.static_images[IR_rinkpos[n][2]], g, n == this.IR_rinkspr.length - 1 || n == 1);
            if (IR_rinkpos[n][2] != 42 && IR_rinkpos[n][2] != 61) continue;
            this.IR_rinkspr[n].SetXY(IR_rinkpos[n][0] - x, IR_rinkpos[n][1] - y + IceHockey.static_images[IR_rinkpos[n][2]].getHeight());
            this.IR_rinkspr[n].DrawSingle(IceHockey.static_images[IR_rinkpos[n][2]], g, true);
        }
        this.IR_logo_top.SetXY(176 - x, 160 - y);
        this.IR_logo_top.Draw(g);
        this.IR_logo_bottom.SetXY(176 - x, 415 - y);
        this.IR_logo_bottom.Draw(g);
    }

    public static void IR_DrawRinkTopLayer(Graphics g) {
        Game.SetClip(g);
        int x = Game.IR_GetX();
        int y = Game.IR_GetY();
        IR_rinktopspr.SetXY(0 - x, 512 - y);
        IR_rinktopspr.DrawSingle(IceHockey.static_images[41], g, false);
    }

    public void IR_DrawTopGoal(Graphics g) {
        this.IR_topgoal.SetXY(175 - Game.IR_GetX(), 53 - Game.IR_GetY());
        this.IR_topgoal.Draw(g);
    }

    public void IR_DrawBottomGoal(Graphics g) {
        this.IR_bottomgoal.SetXY(175 - Game.IR_GetX(), 518 - Game.IR_GetY());
        this.IR_bottomgoal.Draw(g);
    }

    public static boolean IR_CentreOverTarget(int dest_x, int dest_y, int speed) {
        int target_x = dest_x - IceHockey.canvasWidth / 2;
        int target_y = dest_y - IceHockey.canvasHeight / 2 - 15;
        if (target_x < 0) {
            target_x = 0;
        }
        if (target_y < -31) {
            target_y = -31;
        }
        if (target_x > IR_rink_pixel_width - IceHockey.canvasWidth - 1) {
            target_x = IR_rink_pixel_width - IceHockey.canvasWidth - 1;
        }
        if (target_y > IR_rink_pixel_height - IceHockey.canvasHeight - 1) {
            target_y = IR_rink_pixel_height - IceHockey.canvasHeight - 1;
        }
        int xoff = (target_x - IR_scroll_x) / speed;
        int yoff = (target_y - IR_scroll_y) / speed;
        IR_scroll_x += xoff;
        IR_scroll_y += yoff;
        return xoff + yoff == 0;
    }

    public static boolean IR_CentreOverPuck() {
        return Game.IR_CentreOverTarget(Game.PUCK_GetX(), Game.PUCK_GetY(), 4);
    }

    public static boolean IR_CentreOverPuck(int speed) {
        return Game.IR_CentreOverTarget(Game.PUCK_GetX(), Game.PUCK_GetY(), speed);
    }

    public boolean IR_AutoCentre(Player curr) {
        if (curr != null) {
            int yoff = curr.attack_dir != 0 ? 30 : -50;
            return Game.IR_CentreOverTarget(curr.GetX(), curr.GetY() + yoff, 4);
        }
        return Game.IR_CentreOverTarget(Game.PUCK_GetX(), Game.PUCK_GetY(), 4);
    }

    public static int IR_GetX() {
        return IR_scroll_x;
    }

    public static int IR_GetY() {
        return IR_scroll_y;
    }

    void PUCK_Construct() {
        this.PUCK_sprite = new Sprite(IceHockey.static_images[0], 1);
        this.PUCK_Init();
    }

    public void PUCK_Destroy() {
        this.PUCK_sprite.Destroy();
        this.PUCK_sprite = null;
    }

    public void PUCK_Init() {
        this.PUCK_Reset();
    }

    public void PUCK_Reset() {
        PUCK_xPos = this.PUCK_puck_x_start << 16;
        PUCK_yPos = this.PUCK_puck_y_start << 16;
        this.PUCK_goalscored = false;
        this.PUCK_shot = false;
        this.PUCK_powershot = false;
        this.PUCK_angle = 0;
        this.PUCK_speed = 0;
    }

    public void PUCK_Process(Player playerWithPuck) {
        PUCK_xPosOld = PUCK_xPos;
        PUCK_yPosOld = PUCK_yPos;
        if (playerWithPuck == null) {
            this.PUCK_ProcessFreePuck();
        } else {
            this.PUCK_ProcessPuckWithPlayer(playerWithPuck);
        }
    }

    public void PUCK_Draw(Graphics g) {
        if (this.PUCK_powershot && !this.quarter_finished) {
            int n = 0;
            while (this.PUCK_power_x[n] != 0) {
                this.PUCK_sprite.SetXY(this.PUCK_power_x[n] - Game.IR_GetX() - 0, this.PUCK_power_y[n] - Game.IR_GetY() - 0);
                this.PUCK_sprite.Draw(g);
                ++n;
            }
        } else {
            this.PUCK_sprite.SetXY((PUCK_xPos >> 16) - Game.IR_GetX() - 0, (PUCK_yPos >> 16) - Game.IR_GetY() - 0);
            this.PUCK_sprite.Draw(g);
        }
    }

    public void PUCK_DrawIndicator(Graphics g) {
        int y;
        int x;
        if (IceHockey.shared_option_cameramode == 0) {
            x = Game.PUCK_GetX() - Game.IR_GetX();
            y = Game.PUCK_GetY() - Game.IR_GetY();
        } else {
            if (playerInControl == null) {
                return;
            }
            x = playerInControl.GetX() - Game.IR_GetX();
            y = playerInControl.GetY() - Game.IR_GetY();
        }
        if (x > 0 && x < IceHockey.canvasWidth && y > 31 && y < IceHockey.canvasHeight) {
            return;
        }
        int fr = -1;
        if (x < 0) {
            x = 0;
            fr = 6;
        } else if (x > IceHockey.canvasWidth) {
            x = IceHockey.canvasWidth;
            fr = 2;
        }
        if (y < 31) {
            y = 31;
            fr = 0;
        } else if (y > IceHockey.canvasHeight) {
            y = IceHockey.canvasHeight;
            fr = 4;
        }
        if (x == 0 && y == 31) {
            fr = 7;
        }
        if (x == IceHockey.canvasWidth && y == 31) {
            fr = 1;
        }
        if (x == IceHockey.canvasWidth && y == IceHockey.canvasHeight) {
            fr = 3;
        }
        if (x == 0 && y == IceHockey.canvasHeight) {
            fr = 5;
        }
        if (x > IceHockey.canvasWidth - 18) {
            x = IceHockey.canvasWidth - 18;
        }
        if (y > IceHockey.canvasHeight - 18) {
            y = IceHockey.canvasHeight - 18;
        }
        this.PUCK_arrow.SetFrame(fr);
        this.PUCK_arrow.SetXY(x, y);
        this.PUCK_arrow.Draw(g);
    }

    public void PUCK_ProcessPuckWithPlayer(Player playerWithPuck) {
        PUCK_xPos = playerWithPuck.GetX() + playerWithPuck.GetPuckX() << 16;
        PUCK_yPos = playerWithPuck.GetY() + playerWithPuck.GetPuckY() << 16;
        this.PUCK_powershot = false;
    }

    public void PUCK_ProcessFreePuck() {
        this.PUCK_Move();
    }

    private void PUCK_BounceOffLeft() {
        this.PUCK_angle = 90 + (270 - this.PUCK_angle);
        this.PUCK_angle = this.ClampAngle(this.PUCK_angle);
        this.PUCK_powershot = false;
    }

    private void PUCK_BounceOffRight() {
        this.PUCK_angle = 270 + (90 - this.PUCK_angle);
        this.PUCK_angle = this.ClampAngle(this.PUCK_angle);
        this.PUCK_powershot = false;
    }

    private void PUCK_BounceOffTop() {
        this.PUCK_angle = 180 - this.PUCK_angle;
        this.PUCK_angle = this.ClampAngle(this.PUCK_angle);
        this.PUCK_powershot = false;
    }

    private void PUCK_BounceOffBottom() {
        this.PUCK_angle = 180 - this.PUCK_angle;
        this.PUCK_angle = this.ClampAngle(this.PUCK_angle);
        this.PUCK_powershot = false;
    }

    private void TestWallCollision() {
        int nx = PUCK_xPos >> 16;
        int ny = PUCK_yPos >> 16;
        if (nx < 32) {
            PUCK_xPos = 0x200000;
            this.PUCK_BounceOffLeft();
            this.PUCK_speed /= 2;
            this.PUCK_shot = false;
        }
        if (nx > 346) {
            PUCK_xPos = 22675456;
            this.PUCK_BounceOffRight();
            this.PUCK_speed /= 2;
            this.PUCK_shot = false;
        }
        if (ny < 32) {
            PUCK_yPos = 0x200000;
            this.PUCK_BounceOffTop();
            this.PUCK_speed /= 2;
            this.PUCK_shot = false;
        }
        if (ny > 572) {
            PUCK_yPos = 37486592;
            this.PUCK_BounceOffBottom();
            this.PUCK_speed /= 2;
            this.PUCK_shot = false;
        }
    }

    private boolean PUCK_TestGoalCollision() {
        int nx = PUCK_xPos >> 16;
        int ny = PUCK_yPos >> 16;
        if (ny < 300) {
            if (nx > IR_goal_collision[0][0] && nx < IR_goal_collision[0][2] && ny > IR_goal_collision[0][1] && ny < IR_goal_collision[0][3]) {
                if (PUCK_yPosLast <= IR_goal_collision[0][1]) {
                    this.PUCK_BounceOffBottom();
                    PUCK_xPos = PUCK_xPosOld;
                    PUCK_yPos = IR_goal_collision[0][1] - 1 << 16;
                    this.PUCK_speed /= 2;
                } else if (PUCK_xPosLast <= IR_goal_collision[0][0]) {
                    this.PUCK_BounceOffLeft();
                    PUCK_xPos = IR_goal_collision[0][0] - 1 << 16;
                    PUCK_yPos = PUCK_yPosOld;
                    this.PUCK_speed /= 2;
                } else if (PUCK_xPosLast >= IR_goal_collision[0][2]) {
                    this.PUCK_BounceOffRight();
                    PUCK_xPos = IR_goal_collision[0][2] + 1 << 16;
                    PUCK_yPos = PUCK_yPosOld;
                    this.PUCK_speed /= 2;
                } else if (PUCK_yPosLast >= IR_goal_collision[0][3]) {
                    if (!this.PUCK_goalscored) {
                        this.PUCK_scorer = 0;
                    }
                    this.PUCK_goalscored = true;
                    this.PUCK_shot = false;
                    this.PUCK_powershot = false;
                    playerInControl = null;
                    playerWithPuck = null;
                    this.PUCK_speed /= 3;
                    if (this.PUCK_speed >> 16 < 1) {
                        return true;
                    }
                    if (ny < IR_goal_collision[0][1] + 2) {
                        PUCK_xPos = PUCK_xPosOld;
                        PUCK_yPos = PUCK_yPosOld;
                    }
                    if (nx < IR_goal_collision[0][0] + 2) {
                        PUCK_xPos = PUCK_xPosOld;
                        PUCK_yPos = PUCK_yPosOld;
                    }
                    if (nx > IR_goal_collision[0][2] - 2) {
                        PUCK_xPos = PUCK_xPosOld;
                        PUCK_yPos = PUCK_yPosOld;
                    }
                }
            }
        } else if (nx > IR_goal_collision[1][0] && nx < IR_goal_collision[1][2] && ny > IR_goal_collision[1][1] && ny < IR_goal_collision[1][3]) {
            if (PUCK_yPosLast >= IR_goal_collision[1][3]) {
                this.PUCK_BounceOffTop();
                PUCK_xPos = PUCK_xPosOld;
                PUCK_yPos = IR_goal_collision[1][3] + 1 << 16;
            } else if (PUCK_xPosLast <= IR_goal_collision[1][0]) {
                this.PUCK_BounceOffLeft();
                PUCK_xPos = IR_goal_collision[1][0] - 1 << 16;
                PUCK_yPos = PUCK_yPosOld;
            } else if (PUCK_xPosLast >= IR_goal_collision[1][2]) {
                this.PUCK_BounceOffRight();
                PUCK_xPos = IR_goal_collision[1][2] + 1 << 16;
                PUCK_yPos = PUCK_yPosOld;
            } else if (PUCK_yPosLast <= IR_goal_collision[1][3]) {
                if (!this.PUCK_goalscored) {
                    this.PUCK_scorer = 1;
                }
                this.PUCK_goalscored = true;
                this.PUCK_shot = false;
                this.PUCK_powershot = false;
                playerInControl = null;
                playerWithPuck = null;
                this.PUCK_speed /= 3;
                if (this.PUCK_speed >> 16 < 1) {
                    return true;
                }
                if (ny > IR_goal_collision[1][3] - 2) {
                    PUCK_xPos = PUCK_xPosOld;
                    PUCK_yPos = PUCK_yPosOld;
                }
                if (nx < IR_goal_collision[1][0] + 2) {
                    PUCK_xPos = PUCK_xPosOld;
                    PUCK_yPos = PUCK_yPosOld;
                }
                if (nx > IR_goal_collision[1][2] - 2) {
                    PUCK_xPos = PUCK_xPosOld;
                    PUCK_yPos = PUCK_yPosOld;
                }
            }
        }
        return false;
    }

    public static int PUCK_GetX() {
        return PUCK_xPos >> 16;
    }

    public static int PUCK_GetY() {
        return PUCK_yPos >> 16;
    }

    public static void PUCK_SetX(int x) {
        PUCK_xPos = x << 16;
    }

    public static void PUCK_SetY(int y) {
        PUCK_yPos = y << 16;
    }

    private void PUCK_Move() {
        if (this.PUCK_speed >> 16 <= 0) {
            this.PUCK_powershot = false;
            return;
        }
        int spd = this.PUCK_speed >> 16;
        int mv = 2;
        int pwr = 0;
        do {
            if (PUCK_xPos >> 16 != PUCK_xPosLast) {
                PUCK_xPosLast = PUCK_xPos >> 16;
            }
            if (PUCK_yPos >> 16 != PUCK_yPosLast) {
                PUCK_yPosLast = PUCK_yPos >> 16;
            }
            this.PUCK_power_x[pwr] = (PUCK_xPos += this.sin_table[this.PUCK_angle] * mv) >> 16;
            this.PUCK_power_y[pwr++] = (PUCK_yPos -= this.sin_table[this.PUCK_angle + 90] * mv) >> 16;
            this.TestWallCollision();
            if (!this.PUCK_TestGoalCollision()) continue;
            spd = 0;
        } while ((spd -= mv) > 0);
        this.PUCK_power_x[pwr] = 0;
        this.PUCK_power_y[pwr++] = 0;
    }

    public boolean PUCK_Scored() {
        return this.PUCK_goalscored;
    }

    public void HandleKey(int key, int action) {
        if (this.isExitConf) {
            if (key == -6 || key == -7) {
                if (this.exit_curr_selected == 0) {
                    IceHockey.shared_fe_entry_type = 2;
                    this.exit_flag = true;
                } else {
                    this.isExitConf = false;
                    this.EndGamePause();
                }
            }
            if (action == 1 || action == 50 || action == 6 || action == 56) {
                this.exit_curr_selected = (this.exit_curr_selected + 1) % 2;
            }
            return;
        }
        if (this.game_state == 6) {
            if ((action == 1 || action == 50) && this.pause_curr_selected > 0) {
                --this.pause_curr_selected;
            }
            if ((action == 6 || action == 56) && this.pause_curr_selected < 1) {
                ++this.pause_curr_selected;
            }
            if (key == -6 || key == -5) {
                if (this.pause_curr_selected == 0) {
                    this.EndGamePause();
                }
                if (this.pause_curr_selected == 1) {
                    this.isExitConf = true;
                }
            }
        } else {
            if (key == -7) {
                this.StartGamePause();
            }
            if (playerInControl != null && this.game_state == 2) {
                playerInControl.HandleKey(key, action);
            }
        }
    }

    static {
        IR_goal_collision = new int[][]{{176, 60, 208, 80}, {176, 528, 208, 548}};
        IR_rinkpos = new short[][]{{0, 0, 50}, {0, 64, 49}, {352, 64, 49}, {32, 80, 48}, {192, 80, 48}, {32, 304, 48}, {192, 304, 48}, {32, 528, 48}, {192, 528, 48}, {32, 223, 47}, {192, 223, 47}, {32, 385, 47}, {192, 385, 47}, {55, 105, 42}, {47, 145, 43}, {135, 145, 43}, {250, 105, 42}, {242, 145, 43}, {330, 145, 43}, {55, 426, 42}, {47, 466, 43}, {135, 466, 43}, {250, 426, 42}, {242, 466, 43}, {330, 466, 43}, {162, 274, 64}, {152, 264, 61}, {170, 82, 45}, {170, 500, 45}};
        IR_lights = new short[][]{{40, 114}, {40, 148}, {40, 182}, {40, 216}, {40, 250}, {236, 114}, {236, 148}, {236, 182}, {236, 216}, {236, 250}, {68, 80}, {96, 80}, {124, 80}, {152, 80}, {180, 80}, {208, 80}, {68, 284}, {96, 284}, {124, 284}, {152, 284}, {180, 284}, {208, 284}};
    }
}

