/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Frontend {
    public static Font SmallPlainFont = Font.getFont((int)0, (int)0, (int)8);
    public static Font SmallBoldFont = Font.getFont((int)0, (int)1, (int)8);
    public static Font MediumBoldFont = Font.getFont((int)0, (int)1, (int)0);
    private IceHockey parent;
    private static int exitflag = 0;
    private int curr_screen;
    private boolean isDisplaySecondResult;
    private int forward_screen;
    private int back_screen;
    private int curr_item;
    private int num_items;
    private int help_strings_num;
    private int help_strings_curr;
    private int menu_var;
    private int menu_var_max;
    public boolean isExitConf = false;
    public int exit_curr_selected = 0;
    int exitTime;
    boolean exitSplash = false;
    int item_text_colour_hi = 0xFFFFFF;
    int item_text_colour_lo = 0x666666;
    int item_back_colour_hi = 0xAAAAAA;
    int item_back_colour_lo = 0xFFFFFF;
    int item_shadow_colour_hi = 0x666666;
    int item_shadow_colour_lo = 0x666666;
    int line_colour = 1661824;
    int dark_text_colour = 262660;
    static final int MENU_DEFAULTNUM = 6;
    static boolean overtime = false;
    String[] help_strings;
    private static final byte[] division = new byte[]{25, 10, 5, 6, 20, 11, 15, 21, 16, 26, 17, 22, 12, 27, 23, 7, 18, 0, 1, 2, 8, 3, 28, 4, 29, 19, 13, 9, 24, 14};
    static final short MENU_TITLE = 0;
    static final short MENU_ITEM = 1;
    static final short MENU_FLAGS = 2;
    static final short MENU_SETY = 3;
    static final short MENU_VAR = 4;
    static final short MENU_SPECIAL = 5;
    static final short MENU_TEXT = 6;
    static final short MENU_COLOUR = 7;
    static final short MENU_ONBUTTON = 8;
    static final short MENU_EXITBUTTON = 9;
    static final short MENU_OPTION = 10;
    static final short MENU_SHOWHELP = 11;
    private static byte SCREEN_OPTION = (byte)-2;
    private static byte SCREEN_NULL = (byte)-1;
    private static byte SCREEN_MAIN = 0;
    private static byte SCREEN_QUICKTEAMSELECT1 = 1;
    private static byte SCREEN_CHALLENGE = (byte)2;
    private static byte SCREEN_STATS = (byte)3;
    private static byte SCREEN_OPTIONS = (byte)4;
    private static byte SCREEN_HELP = (byte)5;
    private static byte SCREEN_ABOUT = (byte)6;
    private static byte SCREEN_CREDITS = (byte)7;
    private static byte SCREEN_QUICKTEAMSELECT2 = (byte)8;
    private static byte SCREEN_QUICK_PREGAME = (byte)9;
    private static byte SCREEN_CHALLENGE_HUB = (byte)10;
    private static byte SCREEN_CHALLENGE_STATS = (byte)11;
    private static byte SCREEN_CHALLENGE_PREGAME = (byte)12;
    private static byte SCREEN_CHALLENGE_WON = (byte)13;
    private static byte SCREEN_CHALLENGE_LOST = (byte)14;
    private static byte SCREEN_CHALLENGE_RESULT = (byte)15;
    private static byte SCREEN_QUICK_RESULT = (byte)16;
    private static byte SCREEN_CHALLENGE_NEWCONTINUE = (byte)17;
    private static byte SCREEN_CHALLENGE_NEW = (byte)18;
    private static byte SCREEN_CHALLENGE_STANDINGS = (byte)19;
    private static byte SCREEN_CHALLENGE_SEMI_RESULT = (byte)20;
    private static byte SCREEN_CHALLENGE_FINAL_RESULT = (byte)21;
    private static byte SCREEN_CHALLENGE_WINNER = (byte)22;
    private static byte SCREEN_CHALLENGE_POSTGAME = (byte)23;
    private static byte SCREEN_QUICK_POSTGAME = (byte)24;
    private static byte SCREEN_HELP_1 = (byte)25;
    private static byte SCREEN_HELP_2 = (byte)26;
    private static byte SCREEN_HELP_3 = (byte)27;
    private static byte SCREEN_HELP_4 = (byte)28;
    private static final byte BACK = 1;
    private static final byte FORWARD = 2;
    private static final byte SPECIAL_STATS = 0;
    private static final byte SPECIAL_HELP = 1;
    private static final byte SPECIAL_TEAMSELECT = 2;
    private static final byte SPECIAL_QUICKPREGAME = 3;
    private static final byte SPECIAL_CHALLENGE = 4;
    private static final byte SPECIAL_RESULT = 5;
    private static final byte SPECIAL_LOST = 6;
    private static final byte SPECIAL_WON = 7;
    private static final byte SPECIAL_CHALLENGE_STATS = 8;
    private static final byte SPECIAL_CHALLENGE_STANDINGS = 9;
    private static final byte SPECIAL_CHALLENGE_RESULT = 10;
    private static final byte SPECIAL_CHALLENGE_PLAYOFF_RESULT = 11;
    private static final byte SPECIAL_CHALLENGE_WINNER = 12;
    private Sprite spr_teamselect1;
    private Sprite spr_teamselect2;
    int our_team_hicolour = 0xE02020;
    static int window_left;
    static int window_width;
    static int window_centre;
    static int window_top;
    public static final int LEAGUE_TEAMID = 0;
    public static final int LEAGUE_WON = 1;
    public static final int LEAGUE_LOST = 2;
    public static final int LEAGUE_TIED = 3;
    public static final int LEAGUE_OTLOSS = 4;
    public static final int LEAGUE_GOALSSCORED = 5;
    static int[][] results;
    static int[] semis_teams;
    static int[] semis_result;
    static int[] final_teams;
    static int[] final_result;
    static int[] hometeams;
    static int[] awayteams;
    static byte[] menu_00;
    static byte[] menu_01;
    static byte[] menu_02;
    static byte[] menu_03;
    static byte[] menu_04;
    static byte[] menu_05;
    static byte[] menu_06;
    static byte[] menu_07;
    static byte[] menu_08;
    static byte[] menu_09;
    static byte[] menu_10;
    static byte[] menu_11;
    static byte[] menu_12;
    static byte[] menu_13;
    static byte[] menu_14;
    static byte[] menu_15;
    static byte[] menu_16;
    static byte[] menu_17;
    static byte[] menu_18;
    static byte[] menu_19;
    static byte[] menu_20;
    static byte[] menu_21;
    static byte[] menu_22;
    static byte[] menu_23;
    static byte[] menu_24;
    static byte[] menu_25;
    static byte[] menu_26;
    static byte[] menu_27;
    static byte[] menu_28;
    static byte[][] menus;

    Frontend(IceHockey parent) {
        this.parent = parent;
        exitflag = 0;
        this.isDisplaySecondResult = false;
        window_left = 0;
        window_width = IceHockey.canvasWidth - window_left;
        window_centre = window_left + window_width / 2;
        window_top = SmallBoldFont.getHeight() + 4;
        this.spr_teamselect1 = new Sprite(null, 1);
        this.spr_teamselect2 = new Sprite(null, 1);
        this.help_strings = new String[115];
        switch (IceHockey.shared_fe_entry_type) {
            case 0: {
                this.InitNewScreen(SCREEN_MAIN);
                break;
            }
            case 2: {
                if (IceHockey.shared_gametype == 0) {
                    this.InitNewScreen(SCREEN_CHALLENGE_HUB);
                }
                if (IceHockey.shared_gametype != 1) break;
                this.InitNewScreen(SCREEN_MAIN);
                break;
            }
            case 1: {
                boolean bl = overtime = IceHockey.shared_current_period == 2 && IceHockey.shared_score[0] == IceHockey.shared_score[1];
                if (IceHockey.shared_gametype == 0 && IceHockey.shared_current_period == 3 && IceHockey.shared_current_week >= 10 && IceHockey.shared_score[0] == IceHockey.shared_score[1]) {
                    --IceHockey.shared_current_period;
                    overtime = true;
                }
                if (++IceHockey.shared_current_period < 3 || overtime) {
                    if (IceHockey.shared_gametype == 0) {
                        this.InitNewScreen(SCREEN_CHALLENGE_POSTGAME);
                    }
                    if (IceHockey.shared_gametype == 1) {
                        this.InitNewScreen(SCREEN_QUICK_POSTGAME);
                    }
                    if (!overtime) break;
                    parent.playSound(3);
                    break;
                }
                if (IceHockey.shared_gametype == 0) {
                    if (IceHockey.shared_current_week == 10) {
                        if (IceHockey.shared_game_id == 0) {
                            Frontend.PlayComputerGame(semis_teams[2], semis_teams[3], 1);
                        } else {
                            Frontend.PlayComputerGame(semis_teams[0], semis_teams[1], 0);
                        }
                        Frontend.semis_result[IceHockey.shared_game_id * 2] = IceHockey.shared_score[0];
                        Frontend.semis_result[IceHockey.shared_game_id * 2 + 1] = IceHockey.shared_score[1];
                        ++IceHockey.shared_current_week;
                        parent.saveRMS();
                        this.InitNewScreen(SCREEN_CHALLENGE_SEMI_RESULT);
                    } else if (IceHockey.shared_current_week == 11) {
                        Frontend.final_result[0] = IceHockey.shared_score[0];
                        Frontend.final_result[1] = IceHockey.shared_score[1];
                        IceHockey.final_winner = final_result[0] > final_result[1] ? final_teams[0] : final_teams[1];
                        ++IceHockey.shared_current_week;
                        if (IceHockey.final_winner == IceHockey.shared_our_team) {
                            ++IceHockey.shared_total_seasons_won;
                        }
                        parent.saveRMS();
                        this.InitNewScreen(SCREEN_CHALLENGE_FINAL_RESULT);
                    } else {
                        Frontend.ApplyResultToLeague(IceHockey.shared_team_id[0], IceHockey.shared_score[0], IceHockey.shared_team_id[1], IceHockey.shared_score[1], IceHockey.shared_current_period);
                        Frontend.ApplyResultToStats(IceHockey.shared_our_team, IceHockey.shared_current_period, false);
                        this.PlayComputerGames();
                        Frontend.results[IceHockey.shared_game_id][0] = IceHockey.shared_team_id[0];
                        Frontend.results[IceHockey.shared_game_id][1] = IceHockey.shared_team_id[1];
                        Frontend.results[IceHockey.shared_game_id][2] = IceHockey.shared_score[0];
                        Frontend.results[IceHockey.shared_game_id][3] = IceHockey.shared_score[1];
                        this.InitNewScreen(SCREEN_CHALLENGE_RESULT);
                    }
                }
                if (IceHockey.shared_gametype != 1) break;
                Frontend.ApplyResultToStats(IceHockey.shared_team_id[0], IceHockey.shared_current_period, true);
                parent.saveRMS();
                this.InitNewScreen(SCREEN_QUICK_RESULT);
            }
        }
    }

    public void Destroy() {
        for (int i = 0; i < this.help_strings.length; ++i) {
            this.help_strings[i] = null;
        }
        this.help_strings = null;
        this.spr_teamselect1.Destroy();
        this.spr_teamselect1 = null;
        this.spr_teamselect2.Destroy();
        this.spr_teamselect2 = null;
    }

    public int Tick() {
        return exitflag;
    }

    public void Draw(Graphics g) {
        if (this.exitSplash) {
            g.drawImage(IceHockey.static_images[26], 0, 0, 20);
            return;
        }
        g.setColor(12837627);
        g.fillRect(0, 0, IceHockey.canvasWidth, 12);
        g.setColor(9489130);
        g.fillRect(0, 12, IceHockey.canvasWidth, IceHockey.canvasHeight - 12);
        this.DrawCurrScreen(g);
    }

    private void InitNewScreen(int screen) {
        byte[] menudat = menus[screen];
        this.curr_screen = screen;
        this.curr_item = !IceHockey.sound_option && this.curr_screen == SCREEN_OPTIONS ? 1 : 0;
        this.help_strings_num = 0;
        this.help_strings_curr = 0;
        this.menu_var = screen == SCREEN_QUICKTEAMSELECT2 ? 15 : 0;
        this.menu_var_max = 0;
        if (screen == SCREEN_CHALLENGE_WON) {
            IceHockey.shared_our_team = -1;
            IceHockey.shared_current_week = 0;
            this.parent.saveRMS();
        }
        this.num_items = menudat[2];
        this.forward_screen = menudat[4];
        this.back_screen = menudat[5];
    }

    public void DrawConfirmation(Graphics g) {
        g.setClip(0, 0, IceHockey.canvasWidth, IceHockey.canvasHeight);
        g.setColor(0);
        g.fillRect(12, 22, IceHockey.canvasWidth - 20 + 2, IceHockey.canvasHeight - 40 + 2);
        g.setColor(0xFFFFFF);
        g.fillRect(10, 20, IceHockey.canvasWidth - 20, IceHockey.canvasHeight - 40);
        g.setFont(SmallPlainFont);
        int y = 25;
        int x = IceHockey.canvasWidth / 2;
        g.setColor(0);
        GameCanvas.drawString(g, "Are you sure", x, y, 1);
        GameCanvas.drawString(g, "you want to exit?", x, y + 15, 1);
        y += 40;
        if (this.exit_curr_selected == 0) {
            g.setColor(170, 170, 170);
            g.fillRect(x - 8, y - 1, 20, 10);
        }
        GameCanvas.drawString(g, "Yes", x + 1, y + 1, 1);
        y += 15;
        if (this.exit_curr_selected == 1) {
            g.setColor(170, 170, 170);
            g.fillRect(x - 8, y - 1, 20, 10);
        }
        GameCanvas.drawString(g, "No", x + 1, y + 1, 1);
        g.drawImage(IceHockey.static_images[16], 15, IceHockey.canvasHeight - IceHockey.static_images[16].getHeight() - 25, 20);
    }

    private void DrawCurrScreen(Graphics g) {
        if (this.curr_screen < 0) {
            return;
        }
        byte[] menudat = menus[this.curr_screen];
        if (this.isExitConf) {
            this.DrawConfirmation(g);
            return;
        }
        if (this.curr_screen == SCREEN_MAIN) {
            g.drawImage(IceHockey.static_images[27], 1, 1, 20);
        }
        g.setColor(0);
        GameCanvas.drawString(g, IceHockey.strings[menudat[0]], IceHockey.canvasWidth - 1, 3, 2);
        if ((menudat[1] & 1) > 0) {
            g.drawImage(IceHockey.static_images[15], IceHockey.canvasWidth - IceHockey.static_images[15].getWidth(), IceHockey.canvasHeight - IceHockey.static_images[15].getHeight(), 20);
        }
        if ((menudat[1] & 2) > 0) {
            g.drawImage(IceHockey.static_images[16], 0, IceHockey.canvasHeight - IceHockey.static_images[16].getHeight(), 20);
        }
        int numitems = menudat[2];
        int curr_y = menudat[3];
        int off = 6;
        int xpos = 30;
        if (numitems > 0) {
            int n = 0;
            if (!IceHockey.sound_option && this.curr_screen == SCREEN_OPTIONS) {
                n = 1;
            }
            for (n = 0; n < numitems; ++n) {
                int shadowcol;
                int backcol;
                int txtcol;
                int strnum = menudat[off];
                if (this.curr_screen == SCREEN_OPTIONS) {
                    if (n == 0) {
                        strnum += IceHockey.shared_option_sound;
                    }
                    if (n == 1) {
                        strnum += IceHockey.shared_option_periodlen;
                    }
                    if (n == 2) {
                        strnum += IceHockey.shared_option_cameramode;
                    }
                }
                if (n == this.curr_item) {
                    txtcol = this.item_text_colour_hi;
                    backcol = this.item_back_colour_hi;
                    shadowcol = this.item_shadow_colour_hi;
                } else {
                    txtcol = this.item_text_colour_lo;
                    backcol = this.item_back_colour_lo;
                    shadowcol = this.item_shadow_colour_lo;
                }
                if (IceHockey.sound_option || this.curr_screen != SCREEN_OPTIONS || off != 6) {
                    g.setColor(backcol);
                    g.fillRect(xpos, curr_y, IceHockey.canvasWidth - xpos, 10);
                    g.fillArc(xpos - 5, curr_y, 10, 10, 270, -180);
                    g.setColor(shadowcol);
                    g.fillRect(xpos, curr_y + 10, IceHockey.canvasWidth - xpos, 1);
                    g.fillRect(xpos + 2, curr_y + 11, IceHockey.canvasWidth - xpos + 2, 1);
                    g.setColor(txtcol);
                    if (this.curr_screen == 2) {
                        GameCanvas.drawString(g, IceHockey.strings[strnum], IceHockey.canvasWidth - 2, curr_y + 2, 1);
                    } else {
                        GameCanvas.drawString(g, IceHockey.strings[strnum], IceHockey.canvasWidth - 2, curr_y + 2, 2);
                    }
                }
                off += 2;
                curr_y += 17;
                xpos += 6;
            }
        }
        while (off < menudat.length) {
            switch (menudat[off]) {
                case 0: 
                case 8: {
                    g.setFont(SmallBoldFont);
                    g.setColor(0);
                    int left = 5;
                    int right = IceHockey.canvasWidth - 5;
                    GameCanvas.drawString(g, IceHockey.strings[32], left, 15, 0);
                    GameCanvas.drawString(g, "" + IceHockey.shared_total_games_played[menudat[off] == 8 ? 1 : 0], right, 15, 2);
                    GameCanvas.drawString(g, IceHockey.strings[menudat[off] == 8 ? 71 : 72], left, 30, 0);
                    GameCanvas.drawString(g, "" + IceHockey.shared_total_games_won[menudat[off] == 8 ? 1 : 0], right, 30, 2);
                    GameCanvas.drawString(g, IceHockey.strings[35], left, 45, 0);
                    GameCanvas.drawString(g, "" + IceHockey.shared_total_games_lost[menudat[off] == 8 ? 1 : 0] + "(" + IceHockey.shared_total_games_otlost[menudat[off] == 8 ? 1 : 0] + ")", right, 45, 2);
                    GameCanvas.drawString(g, IceHockey.strings[34], left, 60, 0);
                    GameCanvas.drawString(g, "" + IceHockey.shared_total_games_tied[menudat[off] == 8 ? 1 : 0], right, 60, 2);
                    GameCanvas.drawString(g, IceHockey.strings[36], left, 75, 0);
                    GameCanvas.drawString(g, "" + IceHockey.shared_total_goals_for[menudat[off] == 8 ? 1 : 0], right, 75, 2);
                    GameCanvas.drawString(g, IceHockey.strings[37], left, 90, 0);
                    GameCanvas.drawString(g, "" + IceHockey.shared_total_goals_against[menudat[off] == 8 ? 1 : 0], right, 90, 2);
                    if (menudat[off] == 8) {
                        GameCanvas.drawString(g, "Seasons Won:", left, 105, 0);
                        GameCanvas.drawString(g, "" + IceHockey.shared_total_seasons_won, right, 105, 2);
                    }
                    g.setColor(this.item_text_colour_lo);
                    int y = 24;
                    for (int n = 0; n < (menudat[off] == 8 ? 7 : 6); ++n) {
                        g.drawLine(left, y, right, y);
                        y += 15;
                    }
                    ++off;
                    break;
                }
                case 1: {
                    if (this.help_strings_num == 0) {
                        this.ParseString(menudat[off + 1]);
                    }
                    g.setColor(0xFFFFFF);
                    g.setFont(SmallBoldFont);
                    int curr = this.help_strings_curr;
                    int align = 20;
                    int tx = 2;
                    int ty = 28;
                    for (int n = 0; n < 9; ++n) {
                        this.help_strings[curr] = this.help_strings[curr].replace('~', '#');
                        int tmp = this.help_strings[curr].indexOf(37);
                        if (tmp == -1) {
                            GameCanvas.drawString(g, this.help_strings[curr].replace('~', '#'), tx, ty, align);
                        } else {
                            GameCanvas.drawString(g, this.help_strings[curr].substring(0, tmp), tx, ty, align);
                            int tmpX = tx + SmallBoldFont.stringWidth(this.help_strings[curr].substring(0, tmp)) - 3;
                            g.setClip(tmpX, ty, 10, 4);
                            g.drawImage(IceHockey.static_images[18], tmpX, ty, 20);
                            g.setClip(0, 0, IceHockey.canvasWidth, IceHockey.canvasHeight);
                            GameCanvas.drawString(g, this.help_strings[curr].substring(tmp + 1), tmpX + 32, ty, 1);
                        }
                        ty += 12;
                        ++curr;
                    }
                    if (this.help_strings_curr > 0) {
                        g.drawImage(IceHockey.static_images[30], IceHockey.canvasWidth / 2, 15, 17);
                    }
                    if (this.help_strings_curr < this.help_strings_num - 9) {
                        g.drawImage(IceHockey.static_images[29], IceHockey.canvasWidth / 2, IceHockey.canvasHeight - 8, 17);
                    }
                    off += 2;
                    break;
                }
                case 2: {
                    int selectTeam = division[this.menu_var];
                    int logox = IceHockey.canvasWidth / 2 - 10;
                    g.setColor(140, 140, 140);
                    g.fillRect(logox + 1, 35, 20, 20);
                    g.setColor(255, 255, 255);
                    g.fillRect(logox, 34, 20, 20);
                    g.setFont(SmallPlainFont);
                    g.setColor(this.item_text_colour_lo);
                    Frontend.drawTeamLongName(g, selectTeam, IceHockey.canvasWidth / 2, 17, 1, false);
                    int im = 21 + selectTeam / 15;
                    this.spr_teamselect1.SetFrame(selectTeam < 15 ? selectTeam : selectTeam - 15);
                    this.spr_teamselect1.SetXY(logox, 34);
                    this.spr_teamselect1.DrawFromImage(IceHockey.static_images[im], g, 15);
                    GameCanvas.ResetClip(g);
                    g.drawImage(IceHockey.static_images[17], IceHockey.canvasWidth / 2 - 25, 40, 17);
                    g.drawImage(IceHockey.static_images[28], IceHockey.canvasWidth / 2 + 25, 40, 17);
                    GameCanvas.drawString(g, IceHockey.strings[29], 1, 70, 0);
                    GameCanvas.drawString(g, IceHockey.strings[31], 1, 85, 0);
                    GameCanvas.drawString(g, IceHockey.strings[30], 1, 100, 0);
                    this.DrawStars(g, 68, (IceHockey.TeamStats[selectTeam][0] + IceHockey.TeamStats[selectTeam][3] + IceHockey.TeamStats[selectTeam][6]) / 3);
                    this.DrawStars(g, 83, (IceHockey.TeamStats[selectTeam][1] + IceHockey.TeamStats[selectTeam][4] + IceHockey.TeamStats[selectTeam][7]) / 3);
                    this.DrawStars(g, 98, (IceHockey.TeamStats[selectTeam][2] + IceHockey.TeamStats[selectTeam][5] + IceHockey.TeamStats[selectTeam][8]) / 3);
                    ++off;
                    break;
                }
                case 3: {
                    g.setFont(SmallPlainFont);
                    g.setColor(this.item_text_colour_lo);
                    GameCanvas.drawString(g, IceHockey.strings[21 + IceHockey.shared_current_period], IceHockey.canvasWidth / 2, 35, 1);
                    this.DrawVersusTeams(g, IceHockey.shared_team_id[0], IceHockey.shared_team_id[1], IceHockey.shared_score[0], IceHockey.shared_score[1], 80, true);
                    ++off;
                    break;
                }
                case 4: {
                    this.DrawSeasonWeek(g);
                    ++off;
                    break;
                }
                case 5: {
                    this.DrawVersusTeams(g, IceHockey.shared_team_id[0], IceHockey.shared_team_id[1], IceHockey.shared_score[0], IceHockey.shared_score[1], 65, true);
                    ++off;
                    break;
                }
                case 10: {
                    this.DrawSeasonResults(g);
                    ++off;
                    break;
                }
                case 11: {
                    this.DrawPlayOffResults(g, IceHockey.shared_current_week < 12);
                    ++off;
                    break;
                }
                case 6: {
                    this.DrawVersusTeams(g, IceHockey.shared_team_id[0], IceHockey.shared_team_id[1], IceHockey.shared_score[0], IceHockey.shared_score[1], 65, true);
                    g.setFont(SmallPlainFont);
                    g.setColor(this.item_text_colour_lo);
                    GameCanvas.drawString(g, IceHockey.strings[69], IceHockey.canvasWidth / 2, 100, 1);
                    ++off;
                    break;
                }
                case 7: {
                    this.DrawVersusTeams(g, IceHockey.shared_team_id[0], IceHockey.shared_team_id[1], IceHockey.shared_score[0], IceHockey.shared_score[1], 65, true);
                    g.setFont(SmallPlainFont);
                    g.setColor(this.item_text_colour_lo);
                    GameCanvas.drawString(g, IceHockey.strings[74], IceHockey.canvasWidth / 2, 95, 1);
                    GameCanvas.drawString(g, IceHockey.strings[70], IceHockey.canvasWidth / 2, 107, 1);
                    ++off;
                    break;
                }
                case 9: {
                    this.DrawStandings(g);
                    ++off;
                    break;
                }
                case 12: {
                    this.DrawWinner(g);
                    ++off;
                }
            }
        }
    }

    private void DrawStandings(Graphics g) {
        int i;
        int ty = window_top + 10;
        int lg_off = this.menu_var * 5;
        int[] values = new int[5];
        int[] indexes = new int[5];
        for (int n = 0; n < 5; ++n) {
            values[n] = Frontend.GetTeamValue(IceHockey.league[lg_off + n][0]);
            indexes[n] = IceHockey.league[lg_off + n][0];
        }
        for (int z = 0; z < 4; ++z) {
            for (int n = 0; n < 4 - z; ++n) {
                if (values[n] <= values[n + 1]) continue;
                int t = values[n + 1];
                values[n + 1] = values[n];
                values[n] = t;
                t = indexes[n + 1];
                indexes[n + 1] = indexes[n];
                indexes[n] = t;
            }
        }
        g.setColor(262660);
        GameCanvas.drawString(g, IceHockey.strings[38 + this.menu_var], window_centre, 17, 1);
        g.drawImage(IceHockey.static_images[17], window_left + 2, 15, 20);
        g.drawImage(IceHockey.static_images[28], IceHockey.canvasWidth - 2 - IceHockey.static_images[28].getWidth(), 15, 20);
        String[] sColumnTitles = new String[]{"GP", "W", "L", "T", "OTL", "PTS"};
        for (i = 0; i < 5; ++i) {
            g.setColor(6655395);
            g.fillRect(21 + i * 18, 28, 17, 9);
            g.fillRect(38 + i * 18, 38, 1, 73);
            g.setColor(0xFFFFFF);
            GameCanvas.drawString(g, sColumnTitles[i], 30 + i * 18, 30, 1);
        }
        g.setColor(6655395);
        g.fillRect(111, 28, 17, 9);
        g.setColor(0xFFFFFF);
        GameCanvas.drawString(g, sColumnTitles[5], 120, 30, 1);
        g.setColor(14938874);
        g.fillRect(1, 43, 20, 9);
        g.fillRect(1, 58, 20, 9);
        for (i = 0; i < 5; ++i) {
            int team = indexes[4 - i];
            g.setFont(SmallPlainFont);
            g.setColor(7029309);
            if (IceHockey.league[team][0] == IceHockey.shared_our_team) {
                g.setColor(220, 150, 150);
                g.fillRect(1, 43 + i * 15, 20, 9);
            }
            GameCanvas.drawString(g, IceHockey.TeamNamesShort[team], 2, 45 + i * 15, 0);
            g.setColor(262660);
            g.setFont(SmallPlainFont);
            int played = IceHockey.league[team][1] + IceHockey.league[team][2] + IceHockey.league[team][3];
            GameCanvas.drawString(g, "" + played, 31, 44 + i * 15, 1);
            GameCanvas.drawString(g, "" + IceHockey.league[team][1], 49, 44 + i * 15, 1);
            GameCanvas.drawString(g, "" + IceHockey.league[team][2], 67, 44 + i * 15, 1);
            GameCanvas.drawString(g, "" + IceHockey.league[team][3], 85, 44 + i * 15, 1);
            GameCanvas.drawString(g, "" + IceHockey.league[team][4], 103, 44 + i * 15, 1);
            GameCanvas.drawString(g, "" + Frontend.CalculatePoints(team), 121, 44 + i * 15, 1);
        }
    }

    private void DrawVersusTeams(Graphics g, int team1, int team2, int score1, int score2, int middle, boolean showscores) {
        g.drawImage(IceHockey.static_images[20], IceHockey.canvasWidth / 2, middle - IceHockey.static_images[20].getHeight() / 2, 17);
        g.setColor(1661824);
        g.fillRect(IceHockey.canvasWidth / 2, middle - IceHockey.static_images[20].getHeight() / 2 - 4 - 18, 1, 18);
        g.fillRect(IceHockey.canvasWidth / 2, middle + IceHockey.static_images[20].getHeight() / 2 + 4, 1, 18);
        int x1 = IceHockey.canvasWidth / 2 - 15 - 10;
        int x2 = IceHockey.canvasWidth / 2 + 15 + 10;
        g.setColor(140, 140, 140);
        g.fillRect(x1 - 10 + 1, middle + 1 - 10, 20, 20);
        g.fillRect(x2 - 10 + 1, middle + 1 - 10, 20, 20);
        g.setColor(255, 255, 255);
        g.fillRect(x1 - 10, middle - 10, 20, 20);
        g.fillRect(x2 - 10, middle - 10, 20, 20);
        int im = 21 + team1 / 15;
        this.spr_teamselect1.SetXY(x1 - 10, middle - 10);
        this.spr_teamselect1.SetFrame(team1 < 15 ? team1 : team1 - 15);
        this.spr_teamselect1.DrawFromImage(IceHockey.static_images[im], g, 15);
        im = 21 + team2 / 15;
        this.spr_teamselect2.SetXY(x2 - 10, middle - 10);
        this.spr_teamselect2.SetFrame(team2 < 15 ? team2 : team2 - 15);
        this.spr_teamselect2.DrawFromImage(IceHockey.static_images[im], g, 15);
        GameCanvas.ResetClip(g);
        int tty = middle - 12 - g.getFont().getHeight() - 4;
        g.setColor(262660);
        GameCanvas.drawString(g, IceHockey.TeamNamesShort[team1], x1, tty, 1);
        GameCanvas.drawString(g, IceHockey.TeamNamesShort[team2], x2, tty, 1);
        if (showscores) {
            tty = middle + 12 + 4;
            g.setColor(7029309);
            GameCanvas.drawString(g, "" + score1, x1, tty, 1);
            GameCanvas.drawString(g, "" + score2, x2, tty, 1);
        }
    }

    private void DrawStars(Graphics g, int y, int num) {
        int x = IceHockey.canvasWidth - 12;
        for (int n = 0; n < num; ++n) {
            g.drawImage(IceHockey.static_images[19], x, y, 20);
            x -= 12;
        }
    }

    public void HandleKey(int key, int action) {
        byte[] menudat = menus[this.curr_screen];
        int destscreen = SCREEN_NULL;
        if (this.exitSplash) {
            return;
        }
        if (this.isExitConf) {
            if (key == -6 || key == -5) {
                if (this.exit_curr_selected == 0) {
                    this.exitSplash = true;
                    this.exitTime = 0;
                } else {
                    this.isExitConf = false;
                    exitflag = 3;
                }
            }
            if (action == 1 || action == 50 || action == 6 || action == 56) {
                this.exit_curr_selected = (this.exit_curr_selected + 1) % 2;
            }
            return;
        }
        if (key == -6 || key == -5) {
            if (this.curr_screen == SCREEN_QUICKTEAMSELECT1) {
                IceHockey.shared_team_id[0] = division[this.menu_var];
            }
            if (this.curr_screen == SCREEN_QUICKTEAMSELECT2) {
                IceHockey.shared_team_id[1] = division[this.menu_var];
                IceHockey.shared_current_period = 0;
                IceHockey.shared_score[0] = 0;
                IceHockey.shared_score[1] = 0;
            }
            if (this.curr_screen == SCREEN_QUICK_PREGAME || this.curr_screen == SCREEN_QUICK_POSTGAME) {
                IceHockey.shared_gametype = 1;
                exitflag = 1;
            }
            if (this.curr_screen == SCREEN_CHALLENGE) {
                IceHockey.shared_current_period = 0;
                IceHockey.shared_current_week = 0;
                this.parent.resetSeasonVars();
                this.parent.resetSeasonStats();
                IceHockey.shared_our_team = division[this.menu_var];
                IceHockey.shared_score[0] = 0;
                IceHockey.shared_score[1] = 0;
            }
            if (this.curr_screen == SCREEN_CHALLENGE_PREGAME || this.curr_screen == SCREEN_CHALLENGE_POSTGAME) {
                IceHockey.shared_gametype = 0;
                exitflag = 1;
            }
            if (this.num_items > 0) {
                destscreen = menudat[6 + this.curr_item * 2 + 1];
            }
            if (this.forward_screen != SCREEN_NULL) {
                destscreen = this.forward_screen;
            }
            if (this.curr_screen == SCREEN_CHALLENGE_HUB && destscreen == SCREEN_CHALLENGE_PREGAME) {
                IceHockey.shared_current_period = 0;
                IceHockey.shared_score[0] = 0;
                IceHockey.shared_score[1] = 0;
                this.PlayThisWeeksGames();
                this.parent.saveRMS();
                return;
            }
            if (destscreen == SCREEN_CHALLENGE_NEWCONTINUE && IceHockey.shared_our_team == -1) {
                destscreen = SCREEN_CHALLENGE_NEW;
            }
            if (destscreen == SCREEN_OPTION) {
                destscreen = SCREEN_NULL;
                if (this.curr_item == 0 && ++IceHockey.shared_option_sound > 1) {
                    IceHockey.shared_option_sound = 0;
                }
                if (this.curr_item == 1 && ++IceHockey.shared_option_periodlen > 1) {
                    IceHockey.shared_option_periodlen = 0;
                }
                if (this.curr_item == 2 && ++IceHockey.shared_option_cameramode > 1) {
                    IceHockey.shared_option_cameramode = 0;
                }
            }
            if (destscreen != SCREEN_NULL) {
                this.InitNewScreen(destscreen);
            }
            if (this.curr_screen == SCREEN_MAIN && destscreen == SCREEN_NULL) {
                exitflag = 2;
            }
        }
        if (key == -7) {
            if (this.curr_screen == SCREEN_MAIN) {
                exitflag = 2;
                return;
            }
            if (this.curr_screen == SCREEN_OPTIONS) {
                this.parent.saveRMS();
            }
            if (this.back_screen != SCREEN_NULL) {
                this.InitNewScreen(this.back_screen);
            }
        }
        if (action == 2 || action == 52) {
            if (this.curr_screen == SCREEN_CHALLENGE_RESULT) {
                if (!this.isDisplaySecondResult) {
                    --this.menu_var;
                }
                if (this.menu_var < 0) {
                    this.menu_var = 5;
                }
                this.isDisplaySecondResult = !this.isDisplaySecondResult;
            } else if (this.curr_screen == SCREEN_CHALLENGE_SEMI_RESULT) {
                this.isDisplaySecondResult = !this.isDisplaySecondResult;
            } else if (--this.menu_var < 0) {
                this.menu_var = this.curr_screen == SCREEN_CHALLENGE_STANDINGS ? 5 : 29;
            }
        }
        if (action == 5 || action == 54) {
            if (this.curr_screen == SCREEN_CHALLENGE_RESULT) {
                if (this.isDisplaySecondResult) {
                    ++this.menu_var;
                }
                if (this.menu_var > 5) {
                    this.menu_var = 0;
                }
                this.isDisplaySecondResult = !this.isDisplaySecondResult;
            } else if (this.curr_screen == SCREEN_CHALLENGE_SEMI_RESULT) {
                this.isDisplaySecondResult = !this.isDisplaySecondResult;
            } else if (++this.menu_var >= (this.curr_screen == SCREEN_CHALLENGE_STANDINGS ? 6 : 30)) {
                this.menu_var = 0;
            }
        }
        if (action == 1 || action == 50) {
            if (this.curr_item > 0 && this.num_items > 0) {
                --this.curr_item;
            }
            if (this.help_strings_num > 0 && this.help_strings_curr > 0) {
                --this.help_strings_curr;
            }
        }
        if (action == 6 || action == 56) {
            if (this.curr_item < this.num_items - 1 && this.num_items > 0) {
                ++this.curr_item;
            }
            if (this.help_strings_num > 0 && this.help_strings_curr < this.help_strings_num - 9) {
                ++this.help_strings_curr;
            }
        }
        if (this.curr_screen == SCREEN_OPTIONS && this.curr_item == 0 && !IceHockey.sound_option) {
            this.curr_item = 1;
        }
    }

    private void ParseString(int strnum) {
        try {
            String str = IceHockey.strings[strnum];
            int strlen = str.length();
            int nextspace = 0;
            int lastspace = 0;
            int curridx = 0;
            int currstr = 0;
            int maxwid = IceHockey.canvasWidth - 9;
            Font f = SmallBoldFont;
            do {
                int width = 0;
                do {
                    String tmpstr;
                    if ((nextspace = str.indexOf(" ", (lastspace = nextspace) + 1)) == -1) {
                        tmpstr = str.substring(curridx, strlen);
                        width = f.stringWidth(tmpstr);
                        if (width > maxwid) {
                            this.help_strings[currstr++] = str.substring(curridx, lastspace);
                            curridx = lastspace + 1;
                        }
                        lastspace = strlen;
                        break;
                    }
                    tmpstr = str.substring(curridx, nextspace);
                    int cr = tmpstr.indexOf("#");
                    if (cr != -1) {
                        this.help_strings[currstr++] = tmpstr.substring(0, cr);
                        if (tmpstr.substring(0, cr).equals("Version")) {
                            int n = currstr - 1;
                            this.help_strings[n] = this.help_strings[n] + " " + this.parent.getAppProperty("MIDlet-Version");
                        }
                        nextspace = curridx += cr + 1;
                        width = 0;
                        continue;
                    }
                    width = f.stringWidth(tmpstr);
                } while (width <= maxwid);
                this.help_strings[currstr++] = str.substring(curridx, lastspace);
            } while ((curridx = lastspace + 1) <= strlen);
            this.help_strings_num = currstr;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void ApplyResultToLeague(int team1, int score1, int team2, int score2, int numperiods) {
        for (int n = 0; n < 30; ++n) {
            if (IceHockey.league[n][0] == team1) {
                int[] nArray = IceHockey.league[n];
                nArray[5] = nArray[5] + score1;
                if (score1 == score2) {
                    int[] nArray2 = IceHockey.league[n];
                    nArray2[3] = nArray2[3] + 1;
                }
                if (score1 < score2) {
                    int[] nArray3 = IceHockey.league[n];
                    nArray3[2] = nArray3[2] + 1;
                    if (numperiods == 4) {
                        int[] nArray4 = IceHockey.league[n];
                        nArray4[4] = nArray4[4] + 1;
                    }
                }
                if (score1 > score2) {
                    int[] nArray5 = IceHockey.league[n];
                    nArray5[1] = nArray5[1] + 1;
                }
            }
            if (IceHockey.league[n][0] != team2) continue;
            int[] nArray = IceHockey.league[n];
            nArray[5] = nArray[5] + score2;
            if (score2 == score1) {
                int[] nArray6 = IceHockey.league[n];
                nArray6[3] = nArray6[3] + 1;
            }
            if (score2 < score1) {
                int[] nArray7 = IceHockey.league[n];
                nArray7[2] = nArray7[2] + 1;
                if (numperiods == 4) {
                    int[] nArray8 = IceHockey.league[n];
                    nArray8[4] = nArray8[4] + 1;
                }
            }
            if (score2 <= score1) continue;
            int[] nArray9 = IceHockey.league[n];
            nArray9[1] = nArray9[1] + 1;
        }
    }

    static void ApplyResultToStats(int teamid, int numperiods, boolean isQP) {
        int score2;
        int score1;
        if (IceHockey.shared_team_id[0] == teamid) {
            score1 = IceHockey.shared_score[0];
            score2 = IceHockey.shared_score[1];
        } else if (IceHockey.shared_team_id[1] == teamid) {
            score1 = IceHockey.shared_score[1];
            score2 = IceHockey.shared_score[0];
        } else {
            return;
        }
        int n = isQP ? 0 : 1;
        IceHockey.shared_total_games_played[n] = IceHockey.shared_total_games_played[n] + 1;
        int n2 = isQP ? 0 : 1;
        IceHockey.shared_total_goals_for[n2] = IceHockey.shared_total_goals_for[n2] + score1;
        int n3 = isQP ? 0 : 1;
        IceHockey.shared_total_goals_against[n3] = IceHockey.shared_total_goals_against[n3] + score2;
        if (score1 == score2) {
            int n4 = isQP ? 0 : 1;
            IceHockey.shared_total_games_tied[n4] = IceHockey.shared_total_games_tied[n4] + 1;
        }
        if (score1 < score2) {
            int n5 = isQP ? 0 : 1;
            IceHockey.shared_total_games_lost[n5] = IceHockey.shared_total_games_lost[n5] + 1;
            if (numperiods == 4) {
                int n6 = isQP ? 0 : 1;
                IceHockey.shared_total_games_otlost[n6] = IceHockey.shared_total_games_otlost[n6] + 1;
            }
        }
        if (score1 > score2) {
            int n7 = isQP ? 0 : 1;
            IceHockey.shared_total_games_won[n7] = IceHockey.shared_total_games_won[n7] + 1;
        }
    }

    private static int GetTeamValue(int id) {
        return Frontend.CalculatePoints(id) * 10000 + IceHockey.league[id][1] * 100 + IceHockey.league[id][5];
    }

    static int CalculatePoints(int leagueID) {
        return IceHockey.league[leagueID][1] * 2 + IceHockey.league[leagueID][3] + IceHockey.league[leagueID][4];
    }

    private void PlayThisWeeksGames() {
        boolean us_playing = false;
        int week = IceHockey.shared_current_week;
        if (week == 10) {
            Frontend.FindBestTeams();
            int team1 = semis_teams[0];
            int team2 = semis_teams[1];
            if (team1 == IceHockey.shared_our_team || team2 == IceHockey.shared_our_team) {
                us_playing = true;
                IceHockey.shared_team_id[0] = team1;
                IceHockey.shared_team_id[1] = team2;
                IceHockey.shared_game_id = 0;
            }
            team1 = semis_teams[2];
            team2 = semis_teams[3];
            if (team1 == IceHockey.shared_our_team || team2 == IceHockey.shared_our_team) {
                us_playing = true;
                IceHockey.shared_team_id[0] = team1;
                IceHockey.shared_team_id[1] = team2;
                IceHockey.shared_game_id = 1;
            }
            if (us_playing) {
                this.InitNewScreen(SCREEN_CHALLENGE_PREGAME);
            } else {
                this.PlayComputerGames();
            }
        } else if (week == 11) {
            Frontend.final_teams[0] = semis_result[0] > semis_result[1] ? semis_teams[0] : semis_teams[1];
            Frontend.final_teams[1] = semis_result[2] > semis_result[3] ? semis_teams[2] : semis_teams[3];
            us_playing = final_teams[0] == IceHockey.shared_our_team || final_teams[1] == IceHockey.shared_our_team;
            if (us_playing) {
                IceHockey.shared_team_id[0] = final_teams[0];
                IceHockey.shared_team_id[1] = final_teams[1];
                this.InitNewScreen(SCREEN_CHALLENGE_PREGAME);
            } else {
                this.PlayComputerGames();
            }
        } else if (week == 12) {
            this.InitNewScreen(SCREEN_CHALLENGE_WINNER);
        } else {
            for (int n = 0; n < 6; ++n) {
                int team1 = IceHockey.league[n * 5 + hometeams[week * 2]][0];
                int team2 = IceHockey.league[n * 5 + awayteams[week * 2]][0];
                int team3 = IceHockey.league[n * 5 + hometeams[week * 2 + 1]][0];
                int team4 = IceHockey.league[n * 5 + awayteams[week * 2 + 1]][0];
                if (team1 == IceHockey.shared_our_team || team2 == IceHockey.shared_our_team) {
                    us_playing = true;
                    IceHockey.shared_team_id[0] = team1;
                    IceHockey.shared_team_id[1] = team2;
                    IceHockey.shared_game_id = n * 2;
                }
                if (team3 != IceHockey.shared_our_team && team4 != IceHockey.shared_our_team) continue;
                us_playing = true;
                IceHockey.shared_team_id[0] = team3;
                IceHockey.shared_team_id[1] = team4;
                IceHockey.shared_game_id = n * 2 + 1;
            }
            if (us_playing) {
                this.InitNewScreen(SCREEN_CHALLENGE_PREGAME);
            } else {
                this.PlayComputerGames();
            }
        }
    }

    static void PlayComputerGame(int team1, int team2, int resultnumber) {
        int tmp;
        int score2;
        int numperiods = 3;
        int week = IceHockey.shared_current_week;
        int score1 = Math.abs(Game.srand.nextInt() % 4);
        if (score1 == (score2 = Math.abs(Game.srand.nextInt() % 4))) {
            int sc_idx = Math.abs(Game.srand.nextInt() % 1);
            int sc_add = Math.abs(Game.srand.nextInt() % 3);
            if (sc_idx == 0) {
                score1 += sc_add;
            } else {
                score2 += sc_add;
            }
            numperiods = 4;
        }
        if (week == 10) {
            if (score1 != score2 || ((tmp = Game.srand.nextInt()) & 1) <= 0) {
                // empty if block
            }
            Frontend.semis_result[resultnumber * 2] = ++score1;
            Frontend.semis_result[resultnumber * 2 + 1] = ++score2;
        } else if (week == 11) {
            if (score1 != score2 || ((tmp = Game.srand.nextInt()) & 1) <= 0) {
                // empty if block
            }
            Frontend.final_result[0] = ++score1;
            Frontend.final_result[1] = ++score2;
            IceHockey.final_winner = final_result[0] > final_result[1] ? final_teams[0] : final_teams[1];
        } else {
            Frontend.ApplyResultToLeague(team1, score1, team2, score2, numperiods);
            Frontend.results[resultnumber][0] = team1;
            Frontend.results[resultnumber][1] = team2;
            Frontend.results[resultnumber][2] = score1;
            Frontend.results[resultnumber][3] = score2;
        }
    }

    private void PlayComputerGames() {
        int week = IceHockey.shared_current_week++;
        boolean us_playing = false;
        if (week == 10) {
            Frontend.PlayComputerGame(semis_teams[0], semis_teams[1], 0);
            Frontend.PlayComputerGame(semis_teams[2], semis_teams[3], 1);
            this.InitNewScreen(SCREEN_CHALLENGE_SEMI_RESULT);
            this.parent.saveRMS();
        } else if (week == 11) {
            Frontend.PlayComputerGame(final_teams[0], final_teams[1], 0);
            this.InitNewScreen(SCREEN_CHALLENGE_FINAL_RESULT);
            ++IceHockey.shared_current_week;
            this.parent.saveRMS();
        } else {
            for (int n = 0; n < 6; ++n) {
                int team1 = IceHockey.league[n * 5 + hometeams[week * 2]][0];
                int team2 = IceHockey.league[n * 5 + awayteams[week * 2]][0];
                int team3 = IceHockey.league[n * 5 + hometeams[week * 2 + 1]][0];
                int team4 = IceHockey.league[n * 5 + awayteams[week * 2 + 1]][0];
                if (team1 != IceHockey.shared_our_team && team2 != IceHockey.shared_our_team) {
                    Frontend.PlayComputerGame(team1, team2, n * 2);
                }
                if (team3 == IceHockey.shared_our_team || team4 == IceHockey.shared_our_team) continue;
                Frontend.PlayComputerGame(team3, team4, n * 2 + 1);
            }
            ++IceHockey.shared_current_week;
            this.parent.saveRMS();
            this.InitNewScreen(SCREEN_CHALLENGE_RESULT);
        }
    }

    private static void FindBestTeams() {
        int n;
        int[] totals = new int[30];
        for (int n2 = 0; n2 < 30; ++n2) {
            totals[n2] = Frontend.GetTeamValue(n2);
        }
        int high = 0;
        int high_ix = 0;
        for (n = 0; n < 15; ++n) {
            if (totals[n] <= high) continue;
            high_ix = n;
            high = totals[n];
        }
        Frontend.semis_teams[0] = IceHockey.league[high_ix][0];
        totals[high_ix] = 0;
        high = 0;
        for (n = 0; n < 15; ++n) {
            if (totals[n] <= high) continue;
            high_ix = n;
            high = totals[n];
        }
        Frontend.semis_teams[1] = IceHockey.league[high_ix][0];
        totals[high_ix] = 0;
        high = 0;
        for (n = 15; n < 30; ++n) {
            if (totals[n] <= high) continue;
            high_ix = n;
            high = totals[n];
        }
        Frontend.semis_teams[2] = IceHockey.league[high_ix][0];
        totals[high_ix] = 0;
        high = 0;
        for (n = 15; n < 30; ++n) {
            if (totals[n] <= high) continue;
            high_ix = n;
            high = totals[n];
        }
        Frontend.semis_teams[3] = IceHockey.league[high_ix][0];
        totals[high_ix] = 0;
        high = 0;
    }

    private void DrawSeasonResults(Graphics g) {
        int off = this.menu_var * 2;
        g.setColor(262660);
        g.setFont(SmallBoldFont);
        GameCanvas.drawString(g, IceHockey.strings[38 + this.menu_var], window_centre, 15, 1);
        g.drawImage(IceHockey.static_images[17], window_left + 2, 15, 20);
        g.drawImage(IceHockey.static_images[28], IceHockey.canvasWidth - 2 - IceHockey.static_images[28].getWidth(), 15, 20);
        if (!this.isDisplaySecondResult) {
            this.DrawVersusTeams(g, results[off][0], results[off][1], results[off][2], results[off][3], 70, true);
        } else {
            this.DrawVersusTeams(g, results[off + 1][0], results[off + 1][1], results[off + 1][2], results[off + 1][3], 70, true);
        }
    }

    private void DrawPlayOffResults(Graphics g, boolean isSemiFinal) {
        g.setFont(SmallPlainFont);
        g.setColor(this.item_text_colour_lo);
        if (!isSemiFinal) {
            GameCanvas.drawString(g, IceHockey.strings[58], window_centre, 15, 1);
            this.DrawVersusTeams(g, final_teams[0], final_teams[1], final_result[0], final_result[1], 70, true);
        } else {
            g.drawImage(IceHockey.static_images[17], window_left + 10, 15, 20);
            g.drawImage(IceHockey.static_images[28], IceHockey.canvasWidth - 10 - IceHockey.static_images[28].getWidth(), 15, 20);
            if (!this.isDisplaySecondResult) {
                GameCanvas.drawString(g, IceHockey.strings[57] + " 1", window_centre, 15, 1);
                this.DrawVersusTeams(g, semis_teams[0], semis_teams[1], semis_result[0], semis_result[1], 70, true);
            } else {
                GameCanvas.drawString(g, IceHockey.strings[57] + " 2", window_centre, 15, 1);
                this.DrawVersusTeams(g, semis_teams[2], semis_teams[3], semis_result[2], semis_result[3], 70, true);
            }
        }
    }

    private void DrawSeasonWeek(Graphics g) {
        g.setFont(SmallPlainFont);
        g.setColor(this.item_text_colour_lo);
        switch (IceHockey.shared_current_week) {
            case 10: {
                GameCanvas.drawString(g, IceHockey.strings[56] + " " + IceHockey.strings[57], 2, 20, 20);
                break;
            }
            case 11: {
                GameCanvas.drawString(g, IceHockey.strings[56] + " " + IceHockey.strings[58], 2, 20, 20);
                break;
            }
            default: {
                GameCanvas.drawString(g, IceHockey.strings[56] + " " + (IceHockey.shared_current_week + 1), 2, 20, 20);
            }
            case 12: 
        }
    }

    private void DrawWinner(Graphics g) {
        g.setFont(SmallPlainFont);
        Frontend.drawTeamLongName(g, IceHockey.final_winner, window_centre, 15, 1, true);
        Image tmp = null;
        try {
            tmp = Image.createImage((String)"/stanleycup.png");
        }
        catch (Exception e) {
            return;
        }
        int wid = tmp.getWidth();
        int hgt = tmp.getHeight();
        g.drawImage(tmp, IceHockey.canvasWidth / 2, IceHockey.canvasHeight / 2 + 10, 3);
        tmp = null;
    }

    public static void drawTeamLongName(Graphics g, int index, int x, int y, int align, boolean isBlack) {
        int tmp = IceHockey.TeamNamesLong[index].indexOf(37);
        if (tmp == -1) {
            GameCanvas.drawString(g, IceHockey.TeamNamesLong[index], x, y, align);
        } else {
            GameCanvas.drawString(g, IceHockey.TeamNamesLong[index].substring(0, tmp), x, y, align);
            int tmpX = IceHockey.canvasWidth / 2 + g.getFont().stringWidth(IceHockey.TeamNamesLong[index].substring(0, tmp)) / 2 + 2;
            g.setClip(6 + tmpX, y, 10, 4);
            g.drawImage(IceHockey.static_images[18], 6 + tmpX - (isBlack ? 10 : 20), y, 20);
            g.setClip(0, 0, IceHockey.canvasWidth, IceHockey.canvasHeight);
            GameCanvas.drawString(g, IceHockey.TeamNamesLong[index].substring(tmp + 1), tmpX + 12, y, align);
        }
    }

    static {
        results = new int[12][4];
        semis_teams = new int[4];
        semis_result = new int[4];
        final_teams = new int[2];
        final_result = new int[2];
        hometeams = new int[]{0, 2, 4, 1, 3, 2, 1, 4, 0, 3, 4, 0, 1, 2, 3, 1, 0, 3, 3, 4};
        awayteams = new int[]{1, 3, 0, 2, 0, 4, 0, 3, 2, 1, 2, 3, 4, 0, 4, 2, 4, 1, 2, 1};
        menu_00 = new byte[]{0, 3, 7, 25, SCREEN_NULL, SCREEN_NULL, 2, SCREEN_QUICKTEAMSELECT1, 1, SCREEN_CHALLENGE_NEWCONTINUE, 13, SCREEN_STATS, 3, SCREEN_OPTIONS, 4, SCREEN_HELP, 5, SCREEN_ABOUT, 6, SCREEN_NULL};
        menu_01 = new byte[]{10, 3, 0, 25, SCREEN_QUICKTEAMSELECT2, SCREEN_MAIN, 2};
        menu_02 = new byte[]{10, 3, 0, 25, SCREEN_CHALLENGE_HUB, SCREEN_MAIN, 2};
        menu_03 = new byte[]{16, 1, 0, 25, SCREEN_NULL, SCREEN_MAIN, 0};
        menu_04 = new byte[]{17, 3, 3, 40, SCREEN_NULL, SCREEN_MAIN, 45, SCREEN_OPTION, 47, SCREEN_OPTION, 52, SCREEN_OPTION};
        menu_05 = new byte[]{18, 3, 4, 50, SCREEN_NULL, SCREEN_MAIN, 63, SCREEN_HELP_1, 64, SCREEN_HELP_2, 65, SCREEN_HELP_3, 66, SCREEN_HELP_4};
        menu_06 = new byte[]{19, 1, 0, 25, SCREEN_NULL, SCREEN_MAIN, 1, 62};
        menu_07 = new byte[]{18, 2, 0, 25, SCREEN_MAIN, SCREEN_NULL, 1, 77};
        menu_08 = new byte[]{20, 3, 0, 25, SCREEN_QUICK_PREGAME, SCREEN_QUICKTEAMSELECT1, 2};
        menu_09 = new byte[]{14, 3, 0, 20, SCREEN_NULL, SCREEN_QUICKTEAMSELECT2, 3};
        menu_10 = new byte[]{68, 2, 4, 50, SCREEN_NULL, SCREEN_NULL, 11, SCREEN_CHALLENGE_PREGAME, 12, SCREEN_CHALLENGE_STANDINGS, 13, SCREEN_CHALLENGE_STATS, 75, SCREEN_MAIN, 4};
        menu_11 = new byte[]{16, 1, 0, 25, SCREEN_NULL, SCREEN_CHALLENGE_HUB, 8};
        menu_12 = new byte[]{14, 3, 0, 25, SCREEN_NULL, SCREEN_CHALLENGE_HUB, 3};
        menu_13 = new byte[]{68, 2, 0, 25, SCREEN_MAIN, SCREEN_NULL, 7};
        menu_14 = new byte[]{55, 2, 0, 25, SCREEN_MAIN, SCREEN_NULL, 6};
        menu_15 = new byte[]{55, 2, 0, 25, SCREEN_CHALLENGE_HUB, SCREEN_NULL, 10};
        menu_16 = new byte[]{55, 2, 0, 25, SCREEN_MAIN, SCREEN_NULL, 5};
        menu_17 = new byte[]{68, 3, 2, 50, SCREEN_NULL, SCREEN_MAIN, 8, SCREEN_CHALLENGE, 9, SCREEN_CHALLENGE_HUB};
        menu_18 = new byte[]{7, 3, 1, 50, SCREEN_NULL, SCREEN_MAIN, 8, SCREEN_CHALLENGE};
        menu_19 = new byte[]{15, 1, 0, 25, SCREEN_NULL, SCREEN_CHALLENGE_HUB, 9};
        menu_20 = new byte[]{55, 2, 0, 25, SCREEN_CHALLENGE_HUB, SCREEN_NULL, 11};
        menu_21 = new byte[]{55, 2, 0, 25, SCREEN_CHALLENGE_WINNER, SCREEN_NULL, 11};
        menu_22 = new byte[]{61, 2, 0, 25, SCREEN_CHALLENGE_HUB, SCREEN_NULL, 12};
        menu_23 = new byte[]{14, 2, 0, 25, SCREEN_NULL, SCREEN_NULL, 3};
        menu_24 = new byte[]{14, 2, 0, 25, SCREEN_NULL, SCREEN_NULL, 3};
        menu_25 = new byte[]{76, 1, 0, 25, SCREEN_NULL, SCREEN_HELP, 1, 77};
        menu_26 = new byte[]{78, 1, 0, 25, SCREEN_NULL, SCREEN_HELP, 1, 79};
        menu_27 = new byte[]{80, 1, 0, 25, SCREEN_NULL, SCREEN_HELP, 1, 81};
        menu_28 = new byte[]{82, 1, 0, 25, SCREEN_NULL, SCREEN_HELP, 1, 83};
        menus = new byte[][]{menu_00, menu_01, menu_02, menu_03, menu_04, menu_05, menu_06, menu_07, menu_08, menu_09, menu_10, menu_11, menu_12, menu_13, menu_14, menu_15, menu_16, menu_17, menu_18, menu_19, menu_20, menu_21, menu_22, menu_23, menu_24, menu_25, menu_26, menu_27, menu_28};
    }
}

