/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Player {
    private Game parent;
    public int team;
    private int id;
    public int attack_dir;
    public boolean is_goalie;
    private int max_speed;
    private int accuracy;
    private int strength;
    private int player_mode_default = 0;
    private int speed_orig;
    private int strength_orig;
    private int turnspeed;
    public int speed = 0;
    private int goalie_speed;
    private int xPos;
    private int yPos;
    private int xPosOld;
    private int yPosOld;
    private int justFiredPuck = 0;
    private int timeWithPuck;
    private int numchecks;
    private int CHECKING_DISTANCE = 900;
    private int TACKLE_DISTANCE = 900;
    private int GOALIE_TAKE_RAD = 8;
    private int PLAYER_TAKE_RAD = 20;
    private int POINT_DISTANCE = 225;
    private Player[] teammates = new Player[2];
    private Sprite sprite;
    private static int ACCELERATION = 32768;
    private static int DECELERATION = 2048;
    public int angle;
    public int angle_previous;
    private int decision_timer = 0;
    private int checked_counter = 0;
    public static int[] powershot_counter = new int[2];
    private int collision_top;
    private int collision_bottom;
    private int collision_left;
    private int collision_right;
    private int collision_x_centre;
    private int collision_y_centre;
    private int[] distancebuf = new int[4];
    private static final int PLAYER_X_ORIGIN = 23;
    private static final int PLAYER_Y_ORIGIN = 46;
    private static final int COLLISION_WIDTH = 24;
    private static final int COLLISION_HEIGHT = 14;
    private static final int COLLISION_HEIGHT2 = 7;
    private static final int COLLISION_Y_OFF = -4;
    public static final int POWERSHOT_MAX = 1000;
    public static final int POWERSHOT_FULL = 900;
    private int computer_mode = 0;
    private int computer_mode_count = 0;
    private static final int COMP_SKATING = 0;
    private static final int COMP_CHASING = 1;
    private static final int COMP_RETURNING = 2;
    private static final int COMP_RETURNING2 = 3;
    private static final int COMP_CHECKED = 4;
    private static final int GOALIE_STANDING = 0;
    private static final int GOALIE_DIVING = 1;
    private static final int P2_FR_OFF = 17;
    private static final int FOV = 100;
    private static final int GOALIE_X_POS = 190;
    private int current_point = 0;
    private static final int[][] points = new int[][]{{100, 148}, {140, 168}, {190, 178}, {240, 168}, {280, 148}, {100, 228}, {140, 238}, {190, 248}, {240, 238}, {280, 228}, {100, 298}, {140, 298}, {190, 298}, {240, 298}, {280, 298}, {100, 398}, {140, 388}, {190, 378}, {240, 388}, {280, 398}, {100, 468}, {140, 468}, {190, 468}, {240, 468}, {280, 468}};
    private static final int[][] start_points = new int[][]{{190, 523}, {180, 333}, {230, 378}, {190, 103}, {190, 303}, {150, 248}};
    private int player_mode_current;
    private static final int MODE_ATTACK = 0;
    private static final int MODE_FORWARD = 1;
    private static final int MODE_MID = 2;
    private static final int MODE_BACK = 3;
    private static final int MODE_DEFEND = 4;
    private static final int MODE_ROAM = 5;
    private static final int[][] mode_table = new int[][]{{0, 10}, {0, 15}, {4, 15}, {9, 15}, {14, 10}, {0, 25}};
    private static final int ANIM_RATE = 32768;
    private static final int ANIM_END = 32769;
    private static final int ANIM_REPEAT = 32770;
    private static final int ANIM_CALLBACK = 32771;
    private static int[] anim_standing = new int[]{32768, 5, 9, 32769};
    private static int[] anim_skate = new int[]{32768, 5, 0, 1, 2, 1, 32770};
    private static int[] anim_shoot = new int[]{32768, 1, 3, 32771, 2, 4, 5, 32771, 0, 32769};
    private static int[] anim_faceoff = new int[]{32768, 5, 6, 7, 8, 32770};
    private static int[] anim_faceoffrev = new int[]{32768, 5, 8, 7, 6, 32770};
    private static int[] anim_celebrate = new int[]{32768, 10, 9, 10, 32770};
    private static int[] anim_pass = new int[]{32768, 1, 4, 32771, 1, 5, 32771, 0, 32769};
    private static int[] anim_tackle = new int[]{32768, 2, 32771, 3, 5, 32771, 0, 32769};
    private static int[] anim_fall = new int[]{32768, 5, 11, 32769};
    private static int[] anim_goaliestand = new int[]{32768, 5, 12, 32769};
    private static int[] anim_goaliecatch = new int[]{32768, 10, 15, 32771, 4, 32769};
    private static int[] anim_goaliediveleft = new int[]{32768, 10, 13, 32771, 4, 32769};
    private static int[] anim_goaliediveright = new int[]{32768, 10, 14, 32771, 4, 32769};
    private static int[] anim_goaliedive = new int[]{32768, 10, 16, 32771, 4, 32769};
    private static final int[][] anim_table = new int[][]{{8, 3, 0, 0, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 2, 6, 15, 20}, {8, 3, 0, 0, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 2, 6, 15, 20}, {8, 3, 0, 0, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 2, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 0, 6, 15, 20}, {1, 1, 0, 0, 23, 10, 8}, {1, 1, 0, 1, 23, 10, 8}, {1, 1, 0, 2, 23, 10, 8}, {1, 1, 0, 1, 23, 10, 8}, {1, 1, 0, 2, 23, 10, 8}, {8, 3, 0, 0, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 2, 6, 15, 20}, {8, 3, 0, 0, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 2, 6, 15, 20}, {8, 3, 0, 0, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 2, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 1, 6, 15, 20}, {8, 3, 0, 0, 6, 15, 20}, {1, 1, 0, 0, 23, 10, 8}, {1, 1, 0, 2, 23, 10, 8}, {1, 1, 0, 1, 23, 10, 8}, {1, 1, 0, 2, 23, 10, 8}, {1, 1, 0, 1, 23, 10, 8}};
    private static final short[][] sprdat = new short[][]{{0, 0, 21, 19}, {21, 0, 16, 24}, {37, 0, 19, 21}, {56, 0, 24, 15}, {80, 0, 21, 19}, {101, 0, 15, 24}, {116, 0, 19, 21}, {135, 0, 24, 15}, {0, 24, 18, 17}, {18, 24, 18, 18}, {36, 24, 17, 18}, {53, 24, 18, 18}, {71, 24, 18, 17}, {89, 24, 18, 18}, {107, 24, 17, 18}, {124, 24, 18, 18}, {0, 42, 20, 16}, {20, 42, 16, 20}, {36, 42, 16, 20}, {52, 42, 20, 16}, {72, 42, 20, 16}, {92, 42, 16, 20}, {108, 42, 16, 20}, {124, 42, 20, 16}};
    private static final short[][] gk_sprdat = new short[][]{{0, 0, 27, 18}, {0, 18, 35, 16}, {0, 36, 33, 16}, {27, 0, 27, 18}, {35, 18, 35, 18}, {33, 36, 33, 16}};
    private static final short[][] colblk = new short[][]{{7, 3, 9, 11, 15, 3, 2, 4, 4, 5, 3, 4, 2, 6, 3, 5}, {22, 4, 7, 4, 25, 5, 7, 12, 32, 9, 5, 4}, {45, 2, 4, 6, 49, 5, 2, 4, 42, 8, 10, 8, 49, 12, 4, 5}, {63, 3, 10, 7, 72, 0, 4, 9, 67, 10, 4, 5}, {85, 5, 9, 10, 84, 12, 4, 4, 95, 8, 4, 4, 94, 10, 3, 4}, {102, 11, 4, 4, 106, 7, 6, 12, 112, 10, 2, 4, 109, 16, 7, 4}, {119, 4, 4, 4, 119, 5, 11, 9, 121, 114, 3, 3, 123, 15, 4, 4}, {139, 6, 4, 9, 144, 0, 4, 5, 142, 5, 10, 6, 143, 11, 6, 2}, {1, 29, 4, 4, 6, 27, 3, 2, 4, 28, 14, 4, 7, 32, 8, 6}, {22, 26, 3, 6, 24, 30, 7, 11, 22, 33, 13, 5}, {39, 31, 11, 8, 44, 25, 3, 6, 46, 27, 3, 4, 45, 39, 4, 3}, {54, 31, 9, 6, 56, 29, 5, 12, 64, 28, 5, 2, 63, 30, 3, 7}, {74, 27, 8, 11, 71, 33, 14, 4, 85, 32, 3, 4}, {90, 27, 13, 5, 94, 25, 7, 12, 100, 34, 3, 6}, {111, 24, 4, 16, 110, 27, 11, 8, 113, 37, 3, 4}, {128, 29, 4, 9, 126, 36, 2, 2, 132, 26, 7, 10, 133, 29, 8, 8}, {6, 45, 12, 4, 4, 47, 3, 5, 2, 49, 2, 3, 7, 49, 9, 7}, {21, 46, 7, 3, 24, 49, 9, 8, 22, 52, 13, 4, 25, 56, 5, 3}, {38, 49, 11, 9, 42, 44, 4, 5, 46, 47, 2, 2, 45, 58, 4, 2}, {56, 44, 7, 3, 55, 47, 12, 6, 58, 53, 5, 4, 65, 43, 3, 6}, {76, 44, 9, 10, 74, 51, 6, 4, 85, 48, 5, 4}, {93, 48, 12, 5, 97, 45, 6, 11, 103, 47, 3, 4, 100, 54, 7, 4}, {111, 44, 4, 12, 115, 46, 6, 3, 115, 49, 7, 6, 114, 55, 4, 5}, {129, 44, 5, 9, 128, 51, 4, 6, 134, 42, 4, 14, 138, 46, 3, 10}};
    private static final short[][] colblkg = new short[][]{{3, 6, 18, 5, 8, 11, 8, 7}, {11, 0, 8, 7, 6, 7, 18, 5}, {9, 9, 6, 4, 18, 3, 4, 5, 21, 2, 4, 3, 15, 8, 10, 6}, {10, 4, 10, 6, 20, 5, 6, 4, 13, 10, 4, 5, 10, 13, 4, 3}, {2, 4, 5, 5, 4, 6, 8, 9, 12, 9, 2, 4, 14, 9, 6, 3}, {13, 4, 6, 3, 19, 3, 2, 4, 21, 1, 8, 9, 26, 7, 5, 5}};
    private static final byte[][] stickdata = new byte[][]{{17, -2, 13, 1, 13, 1, 0, 5}, {19, 7, 14, 6, 14, 6, 2, 0}, {20, 17, 17, 13, 17, 13, 14, 0}, {16, 16, 18, 11, 18, 11, 23, 2}, {3, 20, 7, 17, 7, 17, 20, 13}, {-3, 17, 2, 18, 2, 18, 12, 22}, {-1, 4, 1, 8, 1, 8, 4, 20}, {7, -3, 5, 2, 5, 2, 1, 12}, {18, 1, 13, 2, 13, 2, 0, 3}, {20, 11, 15, 9, 15, 9, 5, 0}, {15, 18, 14, 13, 14, 13, 12, 0}, {6, 19, 8, 15, 8, 15, 17, 5}, {-1, 15, 4, 14, 4, 14, 17, 12}, {-2, 6, 1, 8, 1, 8, 11, 16}, {1, -1, 2, 4, 2, 4, 4, 17}, {11, -2, 9, 2, 9, 2, 0, 12}, {17, 0, 12, 2, 12, 2, 0, 5}, {18, 9, 14, 8, 14, 8, 3, 1}, {17, 19, 14, 15, 14, 15, 10, 1}, {10, 18, 12, 14, 12, 14, 18, 2}, {0, 17, 4, 14, 4, 14, 18, 11}, {-3, 10, 2, 12, 2, 12, 12, 18}, {-1, 1, 1, 6, 1, 6, 5, 18}, {9, -2, 7, 3, 7, 3, 1, 12}};
    private static final byte[][] stickdata2 = new byte[][]{{0, 6, 13, -1, 13, -1, 17, -5}, {2, 0, 17, 5, 17, 5, 22, 4}, {13, 0, 20, 12, 20, 12, 24, 15}, {21, 1, 18, 14, 18, 14, 20, 20}, {19, 13, 7, 20, 7, 20, 5, 23}, {12, 21, -2, 18, -2, 18, -6, 19}, {5, 19, -2, 8, -2, 8, -6, 6}, {2, 12, 5, -2, 5, -2, 4, -7}, {1, 5, 13, -1, 13, -1, 18, -6}, {5, 0, 18, 6, 18, 6, 22, 6}, {11, 1, 16, 12, 16, 12, 20, 15}, {16, 5, 11, 16, 11, 16, 13, 21}, {16, 10, 6, 16, 6, 16, 3, 20}, {13, 14, 0, 10, 0, 10, -5, 11}, {6, 16, -1, 5, -1, 5, -5, 2}, {2, 12, 6, -1, 6, -1, 5, -6}, {0, 6, 14, -2, 14, -2, 17, -5}, {2, 1, 15, 5, 15, 5, 20, 5}, {10, 1, 16, 13, 16, 13, 21, 16}, {18, 2, 15, 14, 15, 14, 16, 19}, {18, 9, 6, 16, 6, 16, 3, 20}, {13, 17, -1, 14, -1, 14, -5, 15}, {7, 18, -1, 6, -1, 6, -5, 3}, {2, 13, 5, 1, 5, 1, 4, -4}};
    private static final int[][] puck_offsets = new int[][]{{12, -18}, {12, -15}, {12, -12}, {9, -5}, {-6, -6}, {-11, -8}, {-11, -12}, {-9, -15}};
    int[] striprgb = new int[]{0, 0xFFFFFF, 14161955, 2700108, 1316887, 2770488};
    private static final int ANIM_DEFAULT_RATE = 5;
    private boolean ANIM_paused = true;
    private int ANIM_curr_index;
    private int ANIM_repeat_index;
    private int ANIM_curr_timer;
    private int ANIM_curr_rate;
    private int ANIM_curr_frame;
    private int[] ANIM_sequence;

    public Player(Game parent, int team, int id, int dir) {
        this.parent = parent;
        this.team = team;
        this.id = id;
        this.attack_dir = dir ^ IceHockey.shared_current_period & 1;
        this.angle = 0;
        if (id == 0) {
            this.ANIM_Init(anim_goaliestand, this);
        } else {
            this.ANIM_Init(anim_skate, this);
        }
        this.sprite = new Sprite(null, 1);
        this.Init();
    }

    public void SetStats(int speed, int accuracy, int strength) {
        if (speed > 5) {
            speed = 5;
        }
        if (speed < 1) {
            speed = 1;
        }
        this.max_speed = 5 + speed / 2;
        this.turnspeed = this.max_speed * 3;
        if (accuracy > 5) {
            accuracy = 5;
        }
        if (accuracy < 1) {
            accuracy = 1;
        }
        this.accuracy = accuracy;
        if (strength > 5) {
            strength = 5;
        }
        if (strength < 1) {
            strength = 1;
        }
        this.strength = 10 + strength;
        this.speed_orig = speed;
        this.strength_orig = strength;
    }

    public void Destroy() {
        this.sprite.Destroy();
        this.sprite = null;
    }

    public void Process(Player incontrol, Player withpuck) {
        int keys = GameCanvas.GetKeys();
        this.xPosOld = this.xPos;
        this.yPosOld = this.yPos;
        if (this.parent.game_state != 2) {
            keys = 0;
        }
        if (Game.playerWithPuck == this) {
            ++this.timeWithPuck;
        }
        ++this.computer_mode_count;
        if (this.parent.game_state == 2) {
            this.UpdatePowerShot();
        }
        if (this.is_goalie) {
            this.GoalieControl();
            this.CreatePlayerCollision();
        } else if (this.parent.humanplayer && incontrol == this) {
            this.PlayerControl(keys);
            this.CreatePlayerCollision();
            if (this.TestRinkCollision()) {
                this.speed /= 2;
                if (this.speed < 57344) {
                    this.StartStand();
                }
            }
            this.TestGoalCollision(0);
            this.TestGoalCollision(1);
        } else {
            this.ComputerControl();
            this.CreatePlayerCollision();
            if (this.TestRinkCollision()) {
                this.angle += 90;
                this.speed /= 2;
            }
            if (this.TestGoalCollision(0)) {
                this.angle += 90;
            }
            if (this.TestGoalCollision(1)) {
                this.angle -= 90;
            }
            this.angle = this.parent.ClampAngle(this.angle);
        }
    }

    public void StartSkate() {
        if (this.ANIM_sequence == anim_skate) {
            return;
        }
        if (this.id == 0) {
            this.ANIM_Init(anim_goaliestand, this);
            this.SetComputerMode(0);
        } else {
            this.ANIM_Init(anim_skate, this);
            this.SetComputerMode(0);
        }
    }

    public void ResetXYPos() {
        this.xPos = this.xPosOld;
        this.yPos = this.yPosOld;
    }

    public void StartReturn() {
        if (this.id == 0) {
            this.ANIM_Init(anim_goaliestand, this);
            this.SetComputerMode(0);
        } else {
            this.ANIM_Init(anim_skate, this);
            this.SetComputerMode(2);
        }
    }

    public void StartFaceOff() {
        if (this.id == 0) {
            this.ANIM_Init(anim_goaliestand, this);
        }
        if (this.id == 1) {
            if (this.attack_dir == 0) {
                this.ANIM_Init(anim_faceoff, this);
            } else {
                this.ANIM_Init(anim_faceoffrev, this);
            }
        }
        if (this.id == 2) {
            this.ANIM_Init(anim_standing, this);
        }
    }

    public void StartCelebrate() {
        this.ANIM_Init(anim_celebrate, this);
        this.player_mode_current = 0;
        this.SetComputerMode(0);
    }

    public void KnockDownPlayer() {
        this.checked_counter = 60;
        this.ANIM_Init(anim_fall, this);
        this.SetComputerMode(4);
    }

    public boolean IsChecked() {
        return this.computer_mode == 4;
    }

    public void StartTackle() {
        if (this.ANIM_sequence != anim_tackle) {
            this.ANIM_Init(anim_tackle, this);
        }
    }

    public void StartShoot() {
        int n = 1;
        if (this.ANIM_sequence != anim_shoot) {
            this.ANIM_Init(anim_shoot, this);
        } else {
            ++n;
        }
    }

    public void StartPass() {
        int n = 1;
        if (this.ANIM_sequence != anim_pass) {
            this.ANIM_Init(anim_pass, this);
        } else {
            ++n;
        }
    }

    public void StartStand() {
        if (this.ANIM_sequence != anim_standing) {
            this.ANIM_Init(anim_standing, this);
        }
    }

    private void UpdatePowerShot() {
        int dir = 0;
        Player in = Game.playerWithPuck;
        if (in == this) {
            dir = 3;
            if (this.GetY() < 302 && dir > 0) {
                dir += 4;
            }
            if (this.angle > 270 && this.angle < 90) {
                dir += 2;
            }
        } else if (in == this.teammates[0] || in == this.teammates[1]) {
            dir = 1;
            if (this.GetY() < 302 && dir > 0) {
                dir += 2;
            }
        } else {
            dir = -15;
        }
        int n = this.team;
        powershot_counter[n] = powershot_counter[n] + dir;
        if (powershot_counter[this.team] < 0) {
            Player.powershot_counter[this.team] = 0;
        }
        if (powershot_counter[this.team] > 1000) {
            Player.powershot_counter[this.team] = 1000;
        }
    }

    private void CreatePlayerCollision() {
        this.collision_left = (this.xPos >> 16) - 12;
        this.collision_right = (this.xPos >> 16) + 12;
        this.collision_bottom = (this.yPos >> 16) + -4;
        this.collision_top = this.collision_bottom - 14;
        this.collision_x_centre = this.xPos;
        this.collision_y_centre = this.collision_top + 7;
    }

    public void Move() {
        int spd = this.speed >> 16;
        if (spd < 0) {
            return;
        }
        if (spd > 1) {
            if (Game.playerWithPuck == this) {
                --spd;
            }
        }
        this.xPos += this.parent.sin_table[this.angle] * spd;
        this.yPos -= this.parent.sin_table[this.angle + 90] * spd;
    }

    private void GoalieControl() {
        this.TakePuck();
        this.TestGoalieDive();
        if (Game.playerWithPuck == this) {
            if (this.timeWithPuck > 25) {
                this.PassToClosestTeammate();
            }
        } else {
            if (--this.goalie_speed > 0) {
                return;
            }
            this.goalie_speed = 5 - this.speed_orig;
            if (this.parent.PUCK_shot) {
                --this.goalie_speed;
            }
            Player player = this;
            int diff = (player.parent.PUCK_GetX() - this.GetX()) / 4;
            int dir = 0;
            if (diff < 0) {
                dir = -1;
            } else if (diff > 0) {
                dir = 1;
            }
            this.SetX(this.GetX() + dir);
            if (this.GetX() < 178) {
                this.SetX(178);
            }
            if (this.GetX() > 202) {
                this.SetX(202);
            }
        }
    }

    public boolean IsDiving() {
        return this.computer_mode == 1;
    }

    private void TestGoalieDive() {
        if (this.computer_mode != 0) {
            return;
        }
        if (Game.playerWithPuck == this) {
            return;
        }
        if (this.parent.PUCK_Scored()) {
            return;
        }
        if (--this.decision_timer > 0) {
            return;
        }
        this.decision_timer = 6 - this.strength_orig;
        this.distancebuf[3] = this.distancebuf[2];
        this.distancebuf[2] = this.distancebuf[1];
        this.distancebuf[1] = this.distancebuf[0];
        Player player = this;
        Player player2 = this;
        this.distancebuf[0] = Game.Distance(this.GetX(), this.GetY() - 7, player.parent.PUCK_GetX(), player2.parent.PUCK_GetY());
        if (this.distancebuf[0] < this.TACKLE_DISTANCE) {
            if (Game.playerWithPuck != null) {
                if (Game.playerWithPuck != this.teammates[0]) {
                    if (Game.playerWithPuck != this.teammates[1]) {
                        this.ANIM_Init(anim_goaliedive, this);
                        this.SetComputerMode(1);
                        return;
                    }
                }
            }
        }
        if (Game.playerWithPuck == null && this.distancebuf[0] < this.distancebuf[1] && this.distancebuf[1] < this.distancebuf[2] && this.distancebuf[2] < this.distancebuf[3] && this.distancebuf[0] < 5000) {
            int diff;
            Player player3 = this;
            int px = player3.parent.PUCK_GetX() << 16;
            Player player4 = this;
            int py = player4.parent.PUCK_GetY() << 16;
            int pan = this.parent.PUCK_angle;
            int gy = 0;
            gy = pan > 90 && pan < 270 ? 528 : 80;
            while (Math.abs((py >> 16) - gy) > 8) {
                if (px >> 16 <= 32) break;
                if (px >> 16 >= 346) break;
                px += this.parent.sin_table[pan] * 8;
                py -= this.parent.sin_table[pan + 90] * 8;
            }
            if ((diff = Math.abs((px >>= 16) - this.GetX())) < 50) {
                this.SetComputerMode(1);
                if (diff < 15) {
                    this.ANIM_Init(anim_goaliecatch, this);
                } else if (px < this.GetX()) {
                    this.ANIM_Init(anim_goaliediveleft, this);
                } else {
                    this.ANIM_Init(anim_goaliediveright, this);
                }
            }
        }
    }

    private void ChooseNewDestination() {
        int r1 = Math.abs(this.parent.rand.nextInt() % mode_table[this.player_mode_current][1]);
        this.current_point = mode_table[this.player_mode_current][0] + r1;
        if (this.attack_dir == 1) {
            this.current_point = points.length - 1 - this.current_point;
        }
        this.StartSkate();
    }

    private void ComputerControl() {
        int newangle = this.angle;
        switch (this.computer_mode) {
            case 0: {
                this.MakeDecision();
                int ptx = points[this.current_point][0];
                int pty = points[this.current_point][1];
                int distance = Game.Distance(this.GetX(), this.GetY(), ptx, pty);
                if (distance < this.POINT_DISTANCE) {
                    this.ChooseNewDestination();
                    ptx = points[this.current_point][0];
                    pty = points[this.current_point][1];
                    newangle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), ptx, pty);
                } else {
                    newangle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), ptx, pty);
                }
                this.DoComputerMove(newangle);
                break;
            }
            case 1: {
                this.MakeDecision();
                if (Game.playerWithPuck == this) {
                    this.SetComputerMode(0);
                    this.ChooseNewDestination();
                }
                if (this.computer_mode_count++ > 100) {
                    this.SetComputerMode(0);
                    this.ChooseNewDestination();
                }
                Player player = this;
                Player player2 = this;
                newangle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), player.parent.PUCK_GetX(), player2.parent.PUCK_GetY());
                this.DoComputerMove(newangle);
                break;
            }
            case 2: {
                int ptx = start_points[this.attack_dir * 3 + this.id][0];
                int pty = start_points[this.attack_dir * 3 + this.id][1];
                int distance = Game.Distance(this.GetX(), this.GetY(), ptx, pty);
                if (distance < this.POINT_DISTANCE) {
                    if (this.id > 0) {
                        this.ANIM_Init(anim_standing, this);
                    }
                    this.SetComputerMode(3);
                    break;
                }
                newangle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), ptx, pty);
                this.DoComputerMove(newangle);
                break;
            }
            case 3: {
                int na = this.attack_dir == 0 ? 0 : 180;
                int ptx = start_points[this.attack_dir * 3 + this.id][0];
                int pty = start_points[this.attack_dir * 3 + this.id][1];
                if (this.GetX() > ptx) {
                    this.SetX(this.GetX() - 1);
                } else if (this.GetX() < ptx) {
                    this.SetX(this.GetX() + 1);
                }
                if (this.GetY() > pty) {
                    this.SetY(this.GetY() - 1);
                } else if (this.GetY() < pty) {
                    this.SetY(this.GetY() + 1);
                }
                this.angle = this.AngleDifference(this.angle, na) < this.turnspeed ? na : (this.angle += this.GetRotationDirection(this.angle, na) * this.turnspeed);
                this.angle = this.parent.ClampAngle(this.angle);
                break;
            }
            case 4: {
                if (--this.checked_counter >= 0) break;
                this.speed = 0;
                this.StartSkate();
                this.ChooseNewDestination();
            }
        }
    }

    public int FinishedReturn() {
        if (this.computer_mode == 2) {
            return 0;
        }
        return 1;
    }

    private void DoComputerMove(int newangle) {
        this.angle = this.AngleDifference(this.angle, newangle) < this.turnspeed ? newangle : (this.angle += this.GetRotationDirection(this.angle, newangle) * this.turnspeed);
        this.angle = this.parent.ClampAngle(this.angle);
        int curspd = this.speed >> 16;
        if (curspd < this.max_speed) {
            this.speed += ACCELERATION;
        } else if (curspd > this.max_speed) {
            this.speed -= ACCELERATION;
        }
        this.Move();
        if (Game.playerWithPuck == null && this.TakePuck()) {
            this.player_mode_current = Math.abs(this.parent.rand.nextInt() % 2);
            this.ChooseNewDestination();
        }
    }

    private void MakeDecision() {
        int opponent1_dist = 0;
        int opponent2_dist = 0;
        if (this.parent.game_state != 2) {
            return;
        }
        if (--this.decision_timer > 0) {
            return;
        }
        this.decision_timer = Math.abs(this.parent.rand.nextInt() % 4 + 3);
        int opponent1_id = (this.team ^ 1) * 3 + 1;
        opponent1_dist = Game.Distance(this.GetX(), this.GetY(), this.parent.players[opponent1_id].GetX(), this.parent.players[opponent1_id].GetY());
        int opponent2_id = (this.team ^ 1) * 3 + 2;
        opponent2_dist = Game.Distance(this.GetX(), this.GetY(), this.parent.players[opponent2_id].GetX(), this.parent.players[opponent2_id].GetY());
        if (Game.playerWithPuck != this && (opponent1_dist < this.CHECKING_DISTANCE || opponent2_dist < this.CHECKING_DISTANCE)) {
            this.StartTackle();
        }
        if (Game.playerWithPuck == this) {
            int gx;
            int ty;
            int tx;
            boolean forcepass = false;
            if (this.attack_dir == 0) {
                if (this.GetY() < 80 + 25) {
                    if (this.teammates[1].GetY() > 80 + 25) {
                        forcepass = true;
                    }
                }
            } else if (this.GetY() > 528 - 25) {
                if (this.teammates[1].GetY() < 528 - 25) {
                    forcepass = true;
                }
            }
            if (forcepass && this.GetFOV(tx = this.teammates[1].GetX(), ty = this.teammates[1].GetY()) < 100) {
                this.StartPass();
                this.decision_timer = 5;
                return;
            }
            int rnum = Math.abs(this.parent.rand.nextInt() % 100);
            if (rnum < 15) {
                gx = 192;
                int gy = this.attack_dir == 0 ? 80 : 528;
                int mydist = Game.Distance(this.GetX(), this.GetY(), gx, gy);
                int othdist = Game.Distance(this.teammates[1].GetX(), this.teammates[1].GetY(), gx, gy);
                int tx2 = this.teammates[1].GetX();
                int ty2 = this.teammates[1].GetY();
                if (othdist < mydist && this.GetFOV(tx2, ty2) < 100) {
                    this.StartPass();
                }
                this.decision_timer = 5;
                return;
            }
            gx = 192;
            int gy = this.attack_dir == 0 ? 80 : 528;
            int gdist = Game.Distance(this.GetX(), this.GetY(), gx, gy);
            if (gdist < 18000 && this.GetFOV(gx, gy) < 100) {
                this.StartShoot();
                this.decision_timer = 5;
                return;
            }
            if (this.player_mode_current != 0) {
                this.player_mode_current = 0;
                this.ChooseNewDestination();
            }
            return;
        }
        if (!this.is_goalie) {
            if (Game.playerWithPuck == this.teammates[1]) {
                if (this.computer_mode == 1) {
                    this.SetComputerMode(0);
                }
                if (this.player_mode_current != 0) {
                    this.player_mode_current = 0;
                    this.ChooseNewDestination();
                }
                return;
            }
        }
        if (Game.playerWithPuck == null) {
            if (this.teammates[1].computer_mode != 1) {
                this.SetComputerMode(1);
            }
            return;
        }
        if (Game.playerWithPuck != this) {
            if (Game.playerWithPuck != this.teammates[0]) {
                if (Game.playerWithPuck != this.teammates[1]) {
                    int rnum = Math.abs(this.parent.rand.nextInt() % 100);
                    if (rnum > 60 && this.teammates[1].computer_mode != 1) {
                        this.SetComputerMode(1);
                    }
                    return;
                }
            }
        }
    }

    private void PlayerControl(int keys) {
        int destangle = this.angle;
        boolean moved = false;
        if (this.IsChecked()) {
            if (--this.checked_counter < 0) {
                this.speed = 0;
                this.StartSkate();
            }
            return;
        }
        if ((keys & 1) > 0) {
            destangle = 270;
            moved = true;
        }
        if ((keys & 2) > 0) {
            destangle = 90;
            moved = true;
        }
        if ((keys & 4) > 0) {
            destangle = 0;
            moved = true;
        }
        if ((keys & 8) > 0) {
            destangle = 180;
            moved = true;
        }
        if ((keys & 0x2000) > 0) {
            destangle = 315;
            moved = true;
        }
        if ((keys & 0x8000) > 0) {
            destangle = 45;
            moved = true;
        }
        if ((keys & 0x80000) > 0) {
            destangle = 225;
            moved = true;
        }
        if ((keys & 0x200000) > 0) {
            destangle = 135;
            moved = true;
        }
        int speedlast = this.speed;
        if (moved) {
            this.speed += ACCELERATION;
        } else {
            this.speed -= DECELERATION;
            if (this.speed < 0) {
                this.speed = 0;
                this.StartStand();
            }
        }
        if (moved && speedlast < 32768) {
            this.StartSkate();
        }
        if (moved && this.ANIM_sequence == anim_standing) {
            this.StartSkate();
        }
        if (this.speed >> 16 > this.max_speed) {
            this.speed = this.max_speed << 16;
        }
        if (this.speed < 0) {
            this.speed = 0;
        }
        this.angle = this.AngleDifference(this.angle, destangle) < this.turnspeed ? destangle : (this.angle += this.GetRotationDirection(this.angle, destangle) * this.turnspeed);
        this.angle = this.parent.ClampAngle(this.angle);
        this.Move();
        if (Game.playerWithPuck == null) {
            this.TakePuck();
        }
    }

    private boolean TakePuck() {
        block19: {
            block18: {
                if (this.parent.game_state != 2) {
                    return false;
                }
                if (this.computer_mode != 0 && this.computer_mode != 1) {
                    return false;
                }
                if (Game.playerWithPuck == this.parent.players[0]) break block18;
                if (Game.playerWithPuck != this.parent.players[3]) break block19;
            }
            return false;
        }
        if (Game.playerWithPuck != this) {
            if (this.justFiredPuck == 0) {
                int distfrompuck;
                if (Game.playerWithPuck != null) {
                    int rnum = Math.abs(this.parent.rand.nextInt() % 100);
                    if (rnum < 60) {
                        return false;
                    }
                    distfrompuck = Game.Distance(this.GetX(), this.GetY() - 7, Game.playerWithPuck.GetX(), Game.playerWithPuck.GetY());
                } else {
                    Player player = this;
                    Player player2 = this;
                    distfrompuck = Game.Distance(this.GetX(), this.GetY() - 7, player.parent.PUCK_GetX(), player2.parent.PUCK_GetY());
                }
                int range = this.is_goalie ? this.GOALIE_TAKE_RAD : this.PLAYER_TAKE_RAD;
                if (Game.playerWithPuck != null) {
                    range += 5;
                }
                if (distfrompuck < (range += this.accuracy * 2) * range) {
                    if (this.parent.PUCK_powershot) {
                        if (Game.playerWithPuck == null) {
                            if (this.id > 0) {
                                this.KnockDownPlayer();
                            }
                            return false;
                        }
                    }
                    Game.playerWithPuck = this;
                    this.parent.PUCK_powershot = false;
                    this.parent.PUCK_shot = false;
                    this.justFiredPuck = 10;
                    this.timeWithPuck = 0;
                    if (this.team == 0) {
                        Game.playerInControl = this;
                    }
                    return true;
                }
            } else {
                --this.justFiredPuck;
            }
        }
        return false;
    }

    public void HandleKey(int key, int action) {
        if (this.is_goalie) {
            return;
        }
        if (Game.playerWithPuck == this) {
            if (key == -6 || key == 35) {
                this.StartShoot();
            }
            if (key == -5 || key == 53) {
                this.StartPass();
            }
        } else {
            if (key == -6 || key == 35) {
                this.StartTackle();
            }
            if (!(key != -5 && key != 53 || this.is_goalie)) {
                Game.playerInControl = this.teammates[1];
            }
        }
    }

    private boolean TestRinkCollision() {
        boolean found = false;
        if (this.collision_left < 32) {
            this.xPos = 32 + 1 + 12 << 16;
            found = true;
        }
        if (this.collision_right > 346) {
            this.xPos = 346 - 12 << 16;
            found = true;
        }
        if (this.collision_top < 32) {
            this.yPos = 32 + 14 - -4 << 16;
            found = true;
        }
        if (this.collision_bottom > 572) {
            this.yPos = 572 - -4 << 16;
            found = true;
        }
        return found;
    }

    private void Init() {
        this.is_goalie = this.id == 0;
        if (this.id == 1) {
            this.player_mode_default = 1;
        }
        if (this.id == 2) {
            this.player_mode_default = 0;
        }
        this.player_mode_current = this.player_mode_default;
        this.ResetPosition();
    }

    public void ResetPosition() {
        this.xPos = 0xBE0000;
        this.yPos = this.attack_dir == 0 ? 0x2100000 : 0x620000;
        this.angle = this.attack_dir == 0 ? 0 : 180;
        if (this.id == 1) {
            this.player_mode_default = 1;
        }
        if (this.id == 2) {
            this.player_mode_default = 0;
        }
        this.speed = 0;
        this.justFiredPuck = 0;
    }

    public void Draw(Graphics g) {
        Player player = this;
        Player player2 = this;
        this.sprite.SetXY((this.xPos >> 16) - player.parent.IR_GetX() - 5, (this.yPos >> 16) - player2.parent.IR_GetY() - 15);
        if (Game.playerInControl == this) {
            this.sprite.SetFrame(0);
            this.sprite.DrawFromImage(IceHockey.static_images[4], g, 2);
        } else if (Game.playerWithPuck == this && this.team == 1) {
            this.sprite.SetFrame(1);
            this.sprite.DrawFromImage(IceHockey.static_images[4], g, 2);
        } else {
            this.sprite.SetFrame(0);
            this.sprite.DrawFromImage(IceHockey.static_images[3], g, 1);
        }
        Player player3 = this;
        int x = this.GetX() - player3.parent.IR_GetX() - 23;
        Player player4 = this;
        int y = this.GetY() - player4.parent.IR_GetY() - 46;
        int fr = this.ANIM_Animate(this);
        if (this.team == 1) {
            fr += 17;
        }
        int numwid = anim_table[fr][0];
        int numhgt = anim_table[fr][1];
        int x_off = anim_table[fr][2];
        int y_off = anim_table[fr][3];
        int index = 4;
        int numfr = (anim_table[fr].length - index) / 3;
        int nangle = this.parent.ClampAngle(this.angle + 22);
        this.sprite.SetFrame(nangle / (360 / numwid));
        if (anim_table[fr][index] == 23) {
            GameCanvas.ResetClip(g);
            this.sprite.SetXY(this.sprite.GetX() - 6, this.sprite.GetY() - 2);
            int ff = this.attack_dir == 0 ? 0 : 3;
            ff += y_off;
            int frnum = y_off * 2;
            if (this.attack_dir == 1) {
                ++frnum;
            }
            if (this.team == 0) {
                g.setColor(this.striprgb[this.parent.team1mid]);
            } else {
                g.setColor(0xFFFFFF);
            }
            int numcols = colblkg[frnum].length / 4;
            int imx = 0;
            int imy = 0;
            int z = 0;
            int xp = this.sprite.GetX();
            int yp = this.sprite.GetY();
            for (int n = 0; n < numcols; ++n) {
                g.fillRect(xp + colblkg[frnum][z++] - imx, yp + colblkg[frnum][z++] - imy, (int)colblkg[frnum][z++], (int)colblkg[frnum][z++]);
            }
            this.sprite.DrawS40Skater(g, IceHockey.static_images[23], gk_sprdat[ff][0], gk_sprdat[ff][1], gk_sprdat[ff][2], gk_sprdat[ff][3]);
        } else {
            this.sprite.SetXY(this.sprite.GetX(), this.sprite.GetY() - 3);
            int frnum = y_off * numwid + this.sprite.GetFrame();
            int xx = this.sprite.GetX();
            int yy = this.sprite.GetY();
            byte[][] sdat = stickdata;
            if (this.sprite.GetFrame() == 4 || this.sprite.GetFrame() == 5 || this.sprite.GetFrame() == 6) {
                sdat = stickdata2;
            }
            GameCanvas.ResetClip(g);
            g.setColor(8405008);
            g.drawLine(xx + sdat[frnum][0], yy + sdat[frnum][1], xx + sdat[frnum][2], yy + sdat[frnum][3]);
            g.setColor(0);
            g.drawLine(xx + sdat[frnum][4], yy + sdat[frnum][5], xx + sdat[frnum][6], yy + sdat[frnum][7]);
            int numcols = colblk[frnum].length / 4;
            short imx = sprdat[frnum][0];
            short imy = sprdat[frnum][1];
            if (this.team == 0) {
                g.setColor(this.striprgb[this.parent.team1mid]);
            } else {
                g.setColor(0xFFFFFF);
            }
            int z = 0;
            int xp = this.sprite.GetX();
            int yp = this.sprite.GetY();
            for (int n = 0; n < numcols; ++n) {
                g.fillRect(xp + colblk[frnum][z++] - imx, yp + colblk[frnum][z++] - imy, (int)colblk[frnum][z++], (int)colblk[frnum][z++]);
            }
            this.sprite.DrawS40Skater(g, IceHockey.static_images[6], imx, imy, sprdat[frnum][2], sprdat[frnum][3]);
        }
    }

    public int GetX() {
        return this.xPos >> 16;
    }

    public int GetY() {
        return this.yPos >> 16;
    }

    public void SetX(int x) {
        this.xPos = x << 16;
    }

    public void SetY(int y) {
        this.yPos = y << 16;
    }

    public static int sqrt(long x) {
        long r = 0L;
        long m = 0x40000000L;
        do {
            long nr;
            if ((nr = r + m) <= x) {
                x -= nr;
                r = nr + m;
            }
            r >>= 1;
        } while ((m >>= 2) != 0L);
        return (int)r;
    }

    void SetTeamMates(Player teammate1, Player teammate2) {
        this.teammates[0] = teammate1;
        this.teammates[1] = teammate2;
    }

    boolean TestGoalCollision(int goalnum) {
        if (this.is_goalie) {
            return false;
        }
        if (this.collision_right < Game.IR_goal_collision[goalnum][0]) {
            return false;
        }
        if (this.collision_left > Game.IR_goal_collision[goalnum][2]) {
            return false;
        }
        if (this.collision_top > Game.IR_goal_collision[goalnum][3]) {
            return false;
        }
        if (this.collision_bottom < Game.IR_goal_collision[goalnum][1]) {
            return false;
        }
        this.xPos = this.xPosOld;
        this.yPos = this.yPosOld;
        return true;
    }

    int DistanceToTeamMate(int teammate) {
        return Game.Distance(this.GetX(), this.GetY(), this.teammates[teammate].GetX(), this.teammates[teammate].GetY());
    }

    public int GetFOV(int objx, int objy) {
        int d_angle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), objx, objy);
        int d_diff = d_angle - this.angle;
        if (d_diff < 0) {
            d_diff += 360;
        }
        if (d_diff > 359) {
            d_diff -= 360;
        }
        if (d_diff > 180) {
            d_diff = 360 - d_diff;
        }
        return d_diff;
    }

    public static int AngleBetweenObjects(int x1, int y1, int x2, int y2) {
        int xx = x1 - x2 << 16;
        int yy = y1 - y2 << 16;
        int axx = Math.abs(xx);
        int ayy = Math.abs(yy);
        int angle = 0;
        if (xx == 0 && yy == 0) {
            return 0;
        }
        try {
            int result;
            int quad;
            if (xx > 0) {
                if (yy > 0) {
                    if (axx < ayy) {
                        quad = 1;
                        result = 65536 - axx / (ayy >> 16);
                    } else {
                        quad = 0;
                        result = ayy / (axx >> 16);
                    }
                } else if (axx < ayy) {
                    quad = 6;
                    result = axx / (ayy >> 16);
                } else {
                    quad = 7;
                    result = 65536 - ayy / (axx >> 16);
                }
            } else if (yy > 0) {
                if (axx < ayy) {
                    quad = 2;
                    result = axx / (ayy >> 16);
                } else {
                    quad = 3;
                    result = 65536 - ayy / (axx >> 16);
                }
            } else if (axx < ayy) {
                quad = 5;
                result = 65536 - axx / (ayy >> 16);
            } else {
                quad = 4;
                result = ayy / (axx >> 16);
            }
            result += quad << 16;
            angle = (result *= 45) >> 16;
            if ((angle -= 90) < 0) {
                angle += 360;
            }
        }
        catch (ArithmeticException aa) {
            // empty catch block
        }
        return angle;
    }

    private int GetRotationDirection(int currentangle, int newangle) {
        this.angle_previous = this.angle;
        if (newangle == currentangle) {
            return 0;
        }
        if (currentangle >= 180 && newangle < currentangle - 180) {
            return 1;
        }
        if (currentangle < 180 && newangle > currentangle + 180) {
            return -1;
        }
        if (newangle < currentangle) {
            return -1;
        }
        return 1;
    }

    private int AngleDifference(int currentangle, int newangle) {
        int diff = 0;
        if (newangle == currentangle) {
            return 0;
        }
        if (currentangle >= 180 && newangle < currentangle - 180) {
            diff = 360 - currentangle + newangle;
        }
        if (currentangle < 180 && newangle > currentangle + 180) {
            diff = 360 - newangle + currentangle;
        }
        diff = newangle < currentangle ? currentangle - newangle : newangle - currentangle;
        return diff;
    }

    public void Callback(int num) {
        switch (num) {
            case 0: {
                this.ANIM_Init(anim_skate, this);
                break;
            }
            case 1: {
                if (Game.playerWithPuck != this) break;
                this.PassToClosestTeammate();
                break;
            }
            case 2: {
                if (Game.playerWithPuck != this) break;
                this.ShootPuck();
                break;
            }
            case 3: {
                if (Game.playerWithPuck == this) break;
                this.CheckOpponent();
                this.TakePuck();
                break;
            }
            case 4: {
                this.ANIM_Init(anim_goaliestand, this);
                this.SetComputerMode(0);
            }
        }
    }

    public void SetComputerMode(int mode) {
        this.computer_mode = mode;
        this.computer_mode_count = 0;
    }

    private void PassToClosestTeammate() {
        int teammate;
        int[] distances = new int[2];
        if (this.is_goalie) {
            distances[0] = this.DistanceToTeamMate(0);
            distances[1] = this.DistanceToTeamMate(1);
            teammate = distances[0] < distances[1] ? 0 : 1;
        } else {
            teammate = 1;
        }
        this.PassToTeammate(teammate);
        if (this.team == 0) {
            Game.playerInControl = this.teammates[teammate];
        }
    }

    private void PassToTeammate(int teammate) {
        int fov = 0;
        int distance = 0;
        int dismult = 0;
        int xoff = 0;
        int yoff = 0;
        try {
            fov = this.GetFOV(this.teammates[teammate].GetX(), this.teammates[teammate].GetY());
            distance = Player.sqrt(this.DistanceToTeamMate(teammate));
            dismult = distance / (this.accuracy * 3);
            xoff = this.parent.sin_table[this.teammates[teammate].angle] * ((this.teammates[teammate].speed >> 16) * dismult);
            yoff = this.parent.sin_table[this.teammates[teammate].angle + 90] * ((this.teammates[teammate].speed >> 16) * dismult);
            this.parent.PUCK_powershot = false;
            this.parent.PUCK_shot = false;
            this.parent.PUCK_angle = Player.AngleBetweenObjects(this.GetX(), this.GetY() - 7, this.teammates[teammate].GetX() + (xoff >> 16), this.teammates[teammate].GetY() - 7 - (yoff >> 16));
            this.parent.parent.sound_hit();
            this.parent.PUCK_speed = this.speed + (this.strength << 16);
            Game.playerWithPuck = null;
            this.justFiredPuck = 10;
        }
        catch (ArithmeticException aa) {
            // empty catch block
        }
    }

    private void ShootPuck() {
        int gx = 192;
        int gy = this.attack_dir == 0 ? 80 : 528;
        int fov = this.GetFOV(gx, gy);
        this.parent.PUCK_powershot = powershot_counter[this.team] > 900;
        this.parent.PUCK_shot = true;
        if (this.team == 0) {
            if (fov < 100) {
                int tmp = this.parent.rand.nextInt() % ((7 - this.accuracy) * 4);
                this.parent.PUCK_angle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), gx + tmp, gy);
            } else {
                this.parent.PUCK_angle = this.angle;
            }
        } else {
            int tmp = this.parent.rand.nextInt() % ((7 - this.accuracy) * 4);
            this.parent.PUCK_angle = Player.AngleBetweenObjects(this.GetX(), this.GetY(), gx + tmp, gy);
        }
        this.parent.parent.sound_hit();
        this.parent.PUCK_speed = this.speed + (this.strength << 16);
        Game.playerWithPuck = null;
        this.justFiredPuck = 10;
    }

    private boolean CheckOpponent() {
        int pid = (this.team ^ 1) * 3 + 1;
        for (int n = 0; n < 2; ++n) {
            if (Game.playerWithPuck == this.parent.players[pid] || this.parent.players[pid].IsChecked()) continue;
            int dist = Game.Distance(this.GetX(), this.GetY(), this.parent.players[pid].GetX(), this.parent.players[pid].GetY());
            if (dist < this.CHECKING_DISTANCE) {
                this.DoCheck(pid);
                return true;
            }
            ++pid;
        }
        return false;
    }

    private void DoCheck(int opponent) {
    }

    public int GetPuckX() {
        int fr = this.ANIM_GetFrame();
        int nangle = this.angle + 22;
        if (nangle > 359) {
            nangle -= 360;
        }
        int an = nangle / (360 / anim_table[fr][0]);
        return puck_offsets[an][0];
    }

    public int GetPuckY() {
        int fr = this.ANIM_GetFrame();
        int nangle = this.angle + 22;
        if (nangle > 359) {
            nangle -= 360;
        }
        int an = nangle / (360 / anim_table[fr][0]);
        return puck_offsets[an][1];
    }

    void ANIM_Construct() {
        this.ANIM_Pause();
    }

    public void ANIM_Init(int[] sequence, Player player) {
        this.ANIM_sequence = sequence;
        this.ANIM_curr_rate = 5;
        this.ANIM_curr_timer = 0;
        this.ANIM_curr_index = 0;
        this.ANIM_repeat_index = 0;
        this.ANIM_UnPause();
        this.ANIM_Advance(player);
    }

    public int ANIM_Animate(Player player) {
        if (!this.ANIM_paused && this.ANIM_sequence != null && ++this.ANIM_curr_timer > this.ANIM_curr_rate) {
            this.ANIM_curr_timer = 0;
            this.ANIM_Advance(player);
        }
        return this.ANIM_curr_frame;
    }

    public int ANIM_Advance(Player player) {
        switch (this.ANIM_sequence[this.ANIM_curr_index]) {
            case 32768: {
                ++this.ANIM_curr_index;
                this.ANIM_curr_rate = this.ANIM_sequence[this.ANIM_curr_index++];
                this.ANIM_Advance(player);
                break;
            }
            case 32770: {
                this.ANIM_curr_index = this.ANIM_repeat_index;
                this.ANIM_Advance(player);
                break;
            }
            case 32769: {
                break;
            }
            case 32771: {
                ++this.ANIM_curr_index;
                player.Callback(this.ANIM_sequence[this.ANIM_curr_index++]);
                break;
            }
            default: {
                this.ANIM_curr_frame = this.ANIM_sequence[this.ANIM_curr_index++];
            }
        }
        return this.ANIM_curr_frame;
    }

    public void ANIM_Pause() {
        this.ANIM_paused = true;
    }

    public void ANIM_UnPause() {
        this.ANIM_paused = false;
    }

    public int ANIM_GetFrame() {
        return this.ANIM_curr_frame;
    }
}

