/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Exception;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSetParser;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.InMemoryRepresentable;
import org.bouncycastle.asn1.b;
import org.bouncycastle.asn1.e;
import org.bouncycastle.asn1.f;
import org.bouncycastle.asn1.g;
import org.bouncycastle.asn1.k;

public class ASN1StreamParser {
    private final InputStream a;
    private final int b;
    private final byte[][] c;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, k.a(inputStream));
    }

    public ASN1StreamParser(InputStream inputStream, int n2) {
        this.a = inputStream;
        this.b = n2;
        this.c = new byte[11][];
    }

    final ASN1Primitive a(boolean bl2, int n2) {
        if (!bl2) {
            f f2 = (f)this.a;
            return new DERTaggedObject(false, n2, new DEROctetString(f2.b()));
        }
        ASN1EncodableVector aSN1EncodableVector = this.b();
        if (this.a instanceof g) {
            if (aSN1EncodableVector.a() == 1) {
                return new BERTaggedObject(true, n2, aSN1EncodableVector.a(0));
            }
            return new BERTaggedObject(false, n2, org.bouncycastle.asn1.b.a(aSN1EncodableVector));
        }
        if (aSN1EncodableVector.a() == 1) {
            return new DERTaggedObject(true, n2, aSN1EncodableVector.a(0));
        }
        return new DERTaggedObject(false, n2, e.a(aSN1EncodableVector));
    }

    public final ASN1Encodable a() {
        int n2 = this.a.read();
        if (n2 == -1) {
            return null;
        }
        ASN1StreamParser aSN1StreamParser = this;
        if (aSN1StreamParser.a instanceof g) {
            ((g)aSN1StreamParser.a).a(false);
        }
        int n3 = ASN1InputStream.a(this.a, n2);
        boolean bl2 = (n2 & 0x20) != 0;
        int n4 = ASN1InputStream.b(this.a, this.b);
        if (n4 < 0) {
            if (!bl2) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            g g2 = new g(this.a, this.b);
            ASN1StreamParser aSN1StreamParser2 = new ASN1StreamParser(g2, this.b);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, aSN1StreamParser2);
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, aSN1StreamParser2);
            }
            int n5 = n3;
            ASN1StreamParser aSN1StreamParser3 = aSN1StreamParser2;
            switch (n5) {
                case 8: {
                    return new DERExternalParser(aSN1StreamParser3);
                }
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser3);
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser3);
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser3);
                }
            }
            throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(n5));
        }
        f f2 = new f(this.a, n4);
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(bl2, n3, f2.b());
        }
        if ((n2 & 0x80) != 0) {
            return new BERTaggedObjectParser(bl2, n3, new ASN1StreamParser(f2));
        }
        if (bl2) {
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(f2));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(f2));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(f2));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(f2));
                }
            }
            throw new IOException("unknown tag " + n3 + " encountered");
        }
        switch (n3) {
            case 4: {
                return new DEROctetStringParser(f2);
            }
        }
        try {
            return ASN1InputStream.a(n3, f2, this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", 0);
        }
    }

    final ASN1EncodableVector b() {
        ASN1Encodable aSN1Encodable;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Encodable = this.a()) != null) {
            if (aSN1Encodable instanceof InMemoryRepresentable) {
                aSN1EncodableVector.a(((InMemoryRepresentable)((Object)aSN1Encodable)).e());
                continue;
            }
            aSN1EncodableVector.a(aSN1Encodable.a());
        }
        return aSN1EncodableVector;
    }
}

