/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ball {
    public int iBallX;
    public int iBallY;
    public int iBallZ;
    public int iBallWidth = 3;
    private int iBallSpeedX;
    private int iBallSpeedY;
    private int iBallSpeedZ;
    private int iBallSpeedZInit;
    private int iLostSpeedX;
    private int iLostSpeedY;
    private int iLostSpeedZ;
    private int iTotalLostSpeedX;
    private int iTotalLostSpeedY;
    private int iTotalLostSpeedZ;
    public int iBallXIncremental;
    public int iBallYIncremental;
    public int iBallZIncremental;
    public boolean isNet;
    public boolean isPitched;
    public boolean isOut;
    public boolean canHit;
    public boolean isPlayerLocked;
    private int[] ballTrailPoint;
    private int iTrailCounter;
    private Image[] imgBall;
    private Image imgTrail;
    int[] iSpEffectXY;
    boolean isSpEffect = false;
    public static int iDefaultAccuracy = 25;
    public static int iAccuracyMultiplier = 5;
    public static int iMaxFrameForShot = 22;
    public static int iFrameDecrementForShot = 2;
    public static int iMaxFrameForServe = 24;
    public static int iFrameDecrementForServe = 3;
    public static final int iMinSpeedMPH = 75;
    public static final int iMaxSpeedMPH = 155;
    private int iAccuracy;
    public int iFrameToPoint;
    public int iFrameToPointForCurrentBall;
    private int iFrameForZ;
    public static final int iFramesInLoftedPatch = 7;
    public int[] iPointSelected;
    public int[] iPointPredicted;
    byte bMPH_Per_Frames;
    public boolean isReady;
    SynAnimSprite sprSpeEff;
    byte iSPEFAnimID;
    Random rnd;
    public boolean isBallLofted;
    public boolean isBallFast;
    public boolean isBallSliced;
    public boolean isBallDropped;
    public boolean isBallVolley;
    int iZIncreaseMaxTo = 30;
    public int[] iServeSpeed;
    boolean bServe;
    int iOldBallX;
    int iOldBallY;
    static final int[][] iTrianglePointsLeft = Define.iTrianglePointsLeft;
    static final int[][] iTrianglePointsRight = Define.iTrianglePointsRight;
    static final int iServeLineTop = 111;
    static final int iServeLineBottom = 255;

    public Ball(int n, int n2) {
        this.setXYZ(n, n2, 65);
        this.isNet = false;
        this.isPitched = false;
        this.isOut = false;
        this.canHit = true;
        this.ballTrailPoint = new int[2];
        this.iPointSelected = new int[2];
        this.iPointPredicted = new int[2];
        this.ballTrailPoint[0] = 0;
        this.ballTrailPoint[1] = 0;
        this.iBallSpeedX = 0;
        this.iBallSpeedY = 0;
        this.iBallSpeedZInit = 0;
        this.rnd = new Random();
        this.isReady = false;
        try {
            this.imgBall = new Image[2];
            this.imgBall[0] = Image.createImage((String)"/ball1.png");
            this.imgBall[1] = Image.createImage((String)"/ball_Final.png");
            this.iSpEffectXY = new int[2];
            this.imgTrail = Image.createImage((String)"/balltrail.png");
            this.sprSpeEff = new SynAnimSprite("/effects.png", "/sp_ef.bin");
            this.sprSpeEff.loadSprite();
            this.iSPEFAnimID = (byte)4;
            this.sprSpeEff.resetAnim(this.iSPEFAnimID);
        }
        catch (Exception exception) {
            this.imgBall = null;
            System.out.println("Error in loading Ball Image");
        }
    }

    public void setXYZ(int n, int n2, int n3) {
        this.iBallX = n;
        this.iBallY = n2;
        this.iBallZ = n3;
        this.isReady = true;
    }

    public int[] getCollisionRect() {
        return new int[]{this.iBallX, this.iBallY - this.iBallZ, this.imgBall[1].getWidth(), this.imgBall[1].getHeight()};
    }

    public void setBallPerameters(int n, int n2) {
        this.isReady = true;
        this.iFrameToPointForCurrentBall = iMaxFrameForShot;
        this.iFrameToPointForCurrentBall -= n * iFrameDecrementForShot;
        this.iAccuracy = iDefaultAccuracy;
        this.iAccuracy -= n2 * iAccuracyMultiplier;
    }

    public void setSpeed(int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.canHit) {
            return;
        }
        this.isReady = true;
        int n = nArray[0];
        int n2 = nArray[1];
        boolean bl5 = true;
        this.isBallLofted = bl2;
        this.isBallFast = bl;
        this.isBallSliced = bl3;
        this.isBallDropped = false;
        this.isPlayerLocked = false;
        this.iTrailCounter = 10;
        if (this.bServe) {
            this.iAccuracy >>= 1;
        }
        if (bl4) {
            n = n == Define.iSpecialShotXY[0][0] || n == Define.iAISpecialShotXY[0][0] ? (n += UTILITY.getRandomInt(iDefaultAccuracy << 1) + 1) : (n -= UTILITY.getRandomInt(iDefaultAccuracy << 1) - 1);
            n2 = n2 == Define.iSpecialShotXY[0][1] || n2 == Define.iSpecialShotXY[1][1] ? (n2 -= UTILITY.getRandomInt(iDefaultAccuracy << 1) - 1) : (n2 += UTILITY.getRandomInt(iDefaultAccuracy << 1) + 1);
        } else if (bl3) {
            if (UTILITY.getRandomInt(2) == 0) {
                n += UTILITY.getRandomInt(this.iAccuracy) + 1;
                n2 += UTILITY.getRandomInt(this.iAccuracy - 4) + 1;
            } else {
                n -= UTILITY.getRandomInt(this.iAccuracy) - 1;
                n2 -= UTILITY.getRandomInt(this.iAccuracy - 4) - 1;
            }
        } else if (bl2) {
            if (UTILITY.getRandomInt(2) == 0) {
                n -= UTILITY.getRandomInt(this.iAccuracy << 1) - 1;
                n2 -= UTILITY.getRandomInt(this.iAccuracy) - 1;
            } else {
                n += UTILITY.getRandomInt(this.iAccuracy << 1) + 1;
                n2 += UTILITY.getRandomInt(this.iAccuracy) + 1;
            }
        } else if (bl) {
            if (UTILITY.getRandomInt(2) == 0) {
                n -= UTILITY.getRandomInt(this.iAccuracy + (this.iAccuracy >> 1)) + 1;
                n2 += UTILITY.getRandomInt(this.iAccuracy + (this.iAccuracy >> 1)) + 1;
            } else {
                n += UTILITY.getRandomInt(this.iAccuracy + (this.iAccuracy >> 1)) + 1;
                n2 -= UTILITY.getRandomInt(this.iAccuracy + (this.iAccuracy >> 1)) + 1;
            }
        } else if (UTILITY.getRandomInt(2) == 0) {
            n += UTILITY.getRandomInt(this.iAccuracy) + 1;
            n2 += UTILITY.getRandomInt(this.iAccuracy) + 1;
        } else {
            n -= UTILITY.getRandomInt(this.iAccuracy) - 1;
            n2 -= UTILITY.getRandomInt(this.iAccuracy) - 1;
        }
        this.iFrameToPoint = this.iFrameToPointForCurrentBall;
        if (bl) {
            this.iFrameToPoint -= this.iFrameToPoint >> 2;
        } else if (this.isBallSliced) {
            this.iFrameToPoint += this.iFrameToPoint >> 2;
        } else if (bl2) {
            this.iFrameToPoint += this.iFrameToPoint >> 2;
        } else if (bl4) {
            this.iFrameToPoint -= this.iFrameToPoint / 3;
        } else if (this.bServe) {
            this.iFrameToPoint -= this.iFrameToPoint / 4;
        }
        this.isBallVolley = false;
        if (!bl3 && 180 > n2) {
            if (this.iBallY < Define.iAIServePoints[3][1]) {
                this.iFrameToPoint -= this.iFrameToPoint / 2;
            } else if (this.iBallY < 255) {
                this.isBallVolley = true;
                this.iFrameToPoint -= this.iFrameToPoint / 3;
            }
        }
        this.iBallSpeedX = Math.abs((n - this.iBallX) / this.iFrameToPoint);
        this.iBallSpeedY = Math.abs((n2 - this.iBallY) / this.iFrameToPoint);
        this.iLostSpeedX = Math.abs((n - this.iBallX) % this.iFrameToPoint);
        this.iLostSpeedY = Math.abs((n2 - this.iBallY) % this.iFrameToPoint);
        this.iPointSelected[0] = n;
        this.iPointSelected[1] = n2;
        this.iTotalLostSpeedX = 0;
        this.iTotalLostSpeedY = 0;
        this.iBallXIncremental = n < this.iBallX ? -1 : 1;
        this.iBallYIncremental = n2 < this.iBallY ? -1 : 1;
        this.predictFuturePointOfBall(n, n2);
        if (this.bServe && this.iPointPredicted[1] < 45) {
            this.iPointPredicted[1] = 45;
        } else if (this.iPointPredicted[1] < 45) {
            this.iPointPredicted[1] = 45;
        }
        if (bl2) {
            this.iFrameToPoint -= 7;
        }
        if (bl2) {
            this.iFrameForZ = (this.iFrameToPoint >> 1) + 1;
            this.iZIncreaseMaxTo = 110;
        } else if (bl4) {
            this.iFrameForZ = this.iFrameToPoint / 4;
            this.iBallZ = 36;
            this.iZIncreaseMaxTo = 33;
        } else if (this.bServe) {
            this.iFrameForZ = this.iFrameToPoint / 3;
            this.iZIncreaseMaxTo = 78;
        } else if (bl3) {
            this.iFrameForZ = this.iFrameToPoint / 4;
            this.iZIncreaseMaxTo = 50;
            this.iBallZ = 30;
        } else if (!bl3 && 180 < n2 && this.iBallY < Define.iAIServePoints[3][1]) {
            this.iFrameForZ = this.iFrameToPoint / 2;
            this.iZIncreaseMaxTo = 38;
            this.isBallDropped = true;
        } else {
            this.iFrameForZ = this.iFrameToPoint / 3;
            this.iZIncreaseMaxTo = 60;
            this.iBallZ = 25;
        }
        this.iBallZIncremental = -1;
        if (this.bServe) {
            this.iFrameForZ += 2;
        } else if (bl4) {
            this.iFrameForZ += 2;
        } else if (bl3) {
            ++this.iFrameForZ;
        }
        this.iBallSpeedZInit = (this.iZIncreaseMaxTo - this.iBallZ) / (this.iFrameToPoint - this.iFrameForZ);
        if ((this.iZIncreaseMaxTo - this.iBallZ) % (this.iFrameToPoint - this.iFrameForZ) > 5) {
            ++this.iBallSpeedZInit;
        }
        this.iBallSpeedZ = (this.iBallZ + this.iBallSpeedZInit * (this.iFrameToPoint - this.iFrameForZ)) / this.iFrameForZ;
        this.iLostSpeedZ = (this.iBallZ + this.iBallSpeedZInit * (this.iFrameToPoint - this.iFrameForZ)) % this.iFrameForZ;
        this.iTotalLostSpeedZ = 0;
        if (bl2) {
            this.iFrameToPoint += 7;
        }
        this.isPitched = false;
        this.isSpEffect = true;
        this.iSpEffectXY[0] = this.iBallX;
        this.iSpEffectXY[1] = this.iBallY - this.iBallZ;
        this.iSPEFAnimID = bl && this.iPointSelected[1] < 180 ? (byte)1 : (bl4 && this.iPointSelected[1] < 180 ? (byte)5 : (cMap.isAceServe ? (byte)0 : (byte)2));
        this.sprSpeEff.resetAnim(this.iSPEFAnimID);
    }

    public void setSpEffectXY(int n, int n2) {
        this.isSpEffect = true;
        this.iSpEffectXY[0] = n;
        this.iSpEffectXY[1] = n2;
    }

    public void predictFuturePointOfBall(int n, int n2) {
        int n3 = this.iBallSpeedX;
        int n4 = this.iBallSpeedY;
        if (this.isBallLofted) {
            n3 = this.iBallSpeedX - (this.iBallSpeedX >> 2);
            n4 = this.iBallSpeedY - (this.iBallSpeedY >> 2);
        } else if (this.isBallSliced) {
            if (!this.isPitched) {
                n3 = this.iBallSpeedX >> 1;
                n4 = this.iBallSpeedY - 5 * this.iBallSpeedY / 6;
            } else {
                n3 = this.iBallSpeedX >> 2;
                n4 = this.iBallSpeedY >> 2;
            }
        } else {
            n3 = this.iBallSpeedX - this.iBallSpeedX / 5;
            n4 = this.iBallSpeedY - this.iBallSpeedY / 5;
        }
        int n5 = 1;
        n5 = this.iBallY < 180 ? (this.bServe ? 25 : (this.isBallSliced ? 15 : (this.isBallLofted ? 13 : 10))) : (this.bServe ? 6 : (this.isBallVolley || this.isBallDropped ? 2 : (this.isBallFast ? 3 : 5)));
        this.iPointPredicted[0] = n + n3 * this.iBallXIncremental * n5;
        this.iPointPredicted[1] = n2 + n4 * this.iBallYIncremental * n5;
    }

    public void setBallDirection(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        this.iBallX = nArray2[0];
        this.iBallY = nArray2[1];
        this.iBallZ = 90;
        this.iBallSpeedZInit = 0;
        this.bServe = true;
        if (n == 4) {
            n3 = 100;
        }
        this.isNet = false;
        this.isPitched = false;
        this.isOut = false;
        this.canHit = true;
        this.iFrameToPointForCurrentBall = iMaxFrameForServe;
        int n4 = 1 + n3 * (n * iFrameDecrementForServe) / 100;
        this.iFrameToPointForCurrentBall -= n4;
        this.iAccuracy = iDefaultAccuracy;
        this.iAccuracy -= n2 * iAccuracyMultiplier;
        this.iAccuracy -= this.iAccuracy >> 2;
        this.setSpeed(nArray, false, false, false, false);
        this.iServeSpeed = this.getServeSpeed(n3, n);
        this.iServeSpeed[0] = this.iServeSpeed[0] == 155 ? this.iServeSpeed[0] - Math.abs(this.rnd.nextInt() % 4) : this.iServeSpeed[0] + this.rnd.nextInt() % 6;
        this.iServeSpeed[1] = this.iServeSpeed[1] + this.rnd.nextInt() % 10;
        this.iServeSpeed[1] = Math.abs(this.iServeSpeed[1]);
        if (this.iServeSpeed[1] / 10 == 0) {
            this.iServeSpeed[1] = this.iServeSpeed[1] * 10;
        } else if (this.iServeSpeed[1] / 100 != 0) {
            this.iServeSpeed[1] = this.iServeSpeed[1] / 10;
        }
    }

    public int[] getLastServeSpeed() {
        return this.iServeSpeed;
    }

    public int[] getServeSpeed(int n, int n2) {
        int n3 = n * (n2 * iFrameDecrementForServe) / 100;
        int[] nArray = new int[]{80 * n3 / (4 * iFrameDecrementForServe) + 75, 80 % (4 * iFrameDecrementForServe) * n3};
        return nArray;
    }

    public boolean updateBall() {
        if (this.isSpEffect && !this.sprSpeEff.updateAnimOnce(this.iSPEFAnimID)) {
            this.isSpEffect = false;
        }
        if (!this.isPitched) {
            if (this.isPlayerLocked) {
                this.sprSpeEff.updateAnim(3);
            } else {
                this.sprSpeEff.updateAnim(4);
            }
        }
        this.iOldBallX = this.iBallX;
        this.iOldBallY = this.iBallY;
        this.iBallX += this.iBallSpeedX * this.iBallXIncremental;
        this.iBallY += this.iBallSpeedY * this.iBallYIncremental;
        this.iTotalLostSpeedX += this.iLostSpeedX;
        this.iTotalLostSpeedY += this.iLostSpeedY;
        if (this.iTotalLostSpeedX > this.iFrameToPointForCurrentBall - 1) {
            this.iBallX += this.iBallXIncremental * (this.iTotalLostSpeedX / this.iFrameToPointForCurrentBall);
            this.iTotalLostSpeedX %= this.iFrameToPointForCurrentBall;
        }
        if (this.iTotalLostSpeedY > this.iFrameToPointForCurrentBall - 1) {
            this.iBallY += this.iBallYIncremental * (this.iTotalLostSpeedY / this.iFrameToPointForCurrentBall);
            this.iTotalLostSpeedY %= this.iFrameToPointForCurrentBall;
        }
        if (this.iFrameToPoint <= this.iFrameForZ) {
            this.iBallZ += this.iBallSpeedZ * this.iBallZIncremental;
            this.iTotalLostSpeedZ += this.iLostSpeedZ;
            if (this.iTotalLostSpeedZ > this.iFrameToPointForCurrentBall - 1) {
                this.iBallZ += this.iBallZIncremental * (this.iTotalLostSpeedZ / this.iFrameToPointForCurrentBall);
                this.iTotalLostSpeedZ %= this.iFrameToPointForCurrentBall;
            }
            if (this.iBallZ < 0) {
                this.iLostSpeedY = 0;
                this.iLostSpeedX = 0;
                this.iLostSpeedZ = 0;
                this.iBallZIncremental = 1;
                this.iBallZ *= -1;
                this.checkCollision(this.iOldBallX, this.iOldBallY);
                if (this.iBallXIncremental == 0 && this.iBallYIncremental == 0) {
                    this.iBallSpeedZ >>= 1;
                    this.iZIncreaseMaxTo /= 3;
                } else if (this.isBallLofted) {
                    this.iBallSpeedX -= this.iBallSpeedX >> 2;
                    this.iBallSpeedY -= this.iBallSpeedY >> 2;
                    this.iBallSpeedZ >>= 1;
                    this.iZIncreaseMaxTo = 25;
                } else if (this.isBallSliced) {
                    if (!this.isPitched) {
                        this.iBallSpeedX >>= 1;
                        this.iBallSpeedY -= 2 * this.iBallSpeedY / 6;
                    } else {
                        this.iBallSpeedX >>= 2;
                        this.iBallSpeedY >>= 2;
                    }
                    this.iBallSpeedZ -= 2 * this.iBallSpeedZ / 3;
                    this.iZIncreaseMaxTo >>= 2;
                } else if (this.bServe) {
                    this.iBallSpeedX -= this.iBallSpeedX / 4;
                    this.iBallSpeedY -= this.iBallSpeedY / 4;
                    this.iZIncreaseMaxTo /= 3;
                    this.iBallSpeedZ >>= 2;
                    this.bServe = false;
                } else {
                    this.iZIncreaseMaxTo >>= 1;
                    this.iBallSpeedZ = this.isBallFast ? (this.iBallSpeedZ -= this.iBallSpeedZ / 4) : (this.iBallSpeedZ -= this.iBallSpeedZ / 6);
                    if (this.isPitched) {
                        this.iBallSpeedX -= this.iBallSpeedX / 4;
                        this.iBallSpeedY -= this.iBallSpeedY / 4;
                    } else {
                        this.iBallSpeedX -= this.iBallSpeedX / 5;
                        this.iBallSpeedY -= this.iBallSpeedY / 5;
                    }
                }
                if (this.isPitched) {
                    this.canHit = false;
                }
                this.isPitched = true;
            } else if (this.iBallZ >= this.iZIncreaseMaxTo) {
                this.iBallZIncremental = -1;
            }
        } else {
            this.iBallZ = this.isBallLofted && this.iFrameToPoint <= this.iFrameForZ + 7 ? (this.iBallZ += 3 - (this.iFrameForZ + 7 - this.iFrameToPoint)) : (this.iBallZ += this.iBallSpeedZInit);
        }
        --this.iFrameToPoint;
        if (this.iBallXIncremental == 1 && this.iBallX > 541 || this.iBallXIncremental == -1 && this.iBallX < 71) {
            this.iBallXIncremental = 0;
            this.iBallYIncremental = 0;
            this.iBallZIncremental = -1;
            this.iZIncreaseMaxTo /= 3;
            this.canHit = false;
            return false;
        }
        if (this.iBallYIncremental == 1 && this.iBallY > 360 || this.iBallYIncremental == -1 && this.iBallY < 16) {
            this.iBallXIncremental = 0;
            this.iBallYIncremental = 0;
            this.iBallZIncremental = -1;
            this.iBallY = this.iBallY < 16 ? 16 : 360;
            this.iZIncreaseMaxTo /= 3;
            this.canHit = false;
            return false;
        }
        if (this.iBallY > 175 && this.iBallY < 185 && this.iBallZ < 21) {
            if (this.canHit) {
                this.isNet = true;
            }
            this.iBallY = this.iBallYIncremental > 0 ? 175 : 185;
            this.iBallXIncremental = 0;
            this.iBallYIncremental = 0;
            this.iBallZIncremental = -1;
            this.iZIncreaseMaxTo /= 3;
        }
        if (this.isNet || this.isOut) {
            this.canHit = false;
        }
        return this.iBallSpeedX != 0 || this.iBallSpeedY != 0;
    }

    public void checkCollision(int n, int n2) {
        if (this.isPitched) {
            return;
        }
        if (this.CollisionCheck(iTrianglePointsLeft, n, n2)) {
            this.isOut = true;
            System.out.println("iBallx:" + n + " iBally:" + n2 + " iBallZ:" + this.iBallZ);
            System.out.println("X1:" + iTrianglePointsLeft[0][0] + " Y1:" + iTrianglePointsLeft[0][1]);
            System.out.println("X2:" + iTrianglePointsLeft[1][0] + " Y2:" + iTrianglePointsLeft[1][1]);
            System.out.println("X3:" + iTrianglePointsLeft[2][0] + " Y3:" + iTrianglePointsLeft[2][1]);
            System.out.println("Colliding 40, 95");
        } else if (this.CollisionCheck(iTrianglePointsRight, n, n2)) {
            this.isOut = true;
            System.out.println("iBallx:" + n + " iBally:" + n2);
            System.out.println("X1:" + iTrianglePointsRight[0][0] + " Y1:" + iTrianglePointsRight[0][1]);
            System.out.println("X2:" + iTrianglePointsRight[1][0] + " Y2:" + iTrianglePointsRight[1][1]);
            System.out.println("X3:" + iTrianglePointsRight[2][0] + " Y3:" + iTrianglePointsRight[2][1]);
            System.out.println("Colliding 36, 194");
        } else if (n < iTrianglePointsLeft[0][0]) {
            this.isOut = true;
            System.out.println("Came OUT 1");
        } else if (n > iTrianglePointsRight[0][0]) {
            this.isOut = true;
            System.out.println("Came OUT 2");
        } else if (n2 < iTrianglePointsLeft[0][1]) {
            this.isOut = true;
            System.out.println("Came OUT 3 iBally:" + n2);
            System.out.println("Came OUT 3 iBallZ:" + this.iBallZ);
        } else if (n2 > iTrianglePointsLeft[2][1]) {
            this.isOut = true;
            System.out.println("Came OUT 4");
        } else if (this.bServe && (n2 < 111 || n2 > 255)) {
            this.isOut = true;
            System.out.println("Came OUT 5 iBallZ:" + this.iBallZ);
            System.out.println("iBallY:" + this.iBallY + " iServeLineTop:" + 111 + " iServeLineBottom:" + 255);
        }
    }

    public void paintBall(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.imgBall[0], n - this.imgBall[0].getWidth() - (this.imgBall[0].getWidth() >> 1), n2, 3);
    }

    public void paint(Graphics graphics) {
        if (!this.isPitched && this.iPointSelected[1] > 180) {
            if (this.isPlayerLocked) {
                this.sprSpeEff.paintAnim(graphics, 3, this.iPointSelected[0], this.iPointSelected[1]);
            } else {
                this.sprSpeEff.paintAnim(graphics, 4, this.iPointSelected[0], this.iPointSelected[1]);
            }
        }
        graphics.setColor(70, 70, 70);
        graphics.fillRect(this.iBallX - (this.iBallWidth >> 1), this.iBallY - (this.iBallWidth >> 1), this.iBallWidth, this.iBallWidth);
        graphics.setColor(255, 255, 0);
        if (this.iTrailCounter > 0) {
            if (this.iBallYIncremental == 1) {
                // empty if block
            }
            --this.iTrailCounter;
        }
        try {
            graphics.setColor(255, 255, 0);
            graphics.drawImage(this.imgBall[1], this.iBallX, this.iBallY - this.iBallZ, 3);
        }
        catch (Exception exception) {
            graphics.setColor(255, 255, 0);
            graphics.fillRect(this.iBallX - 2, this.iBallY - 2 - this.iBallZ / 3, 4, 4);
        }
        if (this.isSpEffect) {
            this.sprSpeEff.paintAnim(graphics, this.iSPEFAnimID, this.iSpEffectXY[0], this.iSpEffectXY[1]);
        }
        this.ballTrailPoint[0] = this.iBallX;
        this.ballTrailPoint[1] = this.iBallY - this.iBallZ;
    }

    public boolean CollisionCheck(int[][] nArray, int n, int n2) {
        return UTILITY.checkTriangleCollision(nArray, n, n2);
    }
}

