/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AIController;
import com.ea.game.BlueToothConnection;
import com.ea.game.BlueToothListener;
import com.ea.game.Controller;
import com.ea.game.DDDebug;
import com.ea.game.DDFile;
import com.ea.game.DDImage;
import com.ea.game.DDMath;
import com.ea.game.DDTextEntry;
import com.ea.game.GameAI;
import com.ea.game.GameFormation;
import com.ea.game.GameLogic;
import com.ea.game.GameRender;
import com.ea.game.HumanController;
import com.ea.game.Trajectory;
import com.ea.game.XMLMenuSystem;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMoreGames16;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class MainFrame
implements SDKGame,
ResourceLoader,
BlueToothListener {
    private static final boolean CHEATS_ON = true;
    public static final boolean MINIMAL_DRAWING = false;
    public static final int FRAMERATE_MAXIMUM = 24;
    private static final int FRAMERATE_MODIFIER_PERCENT_FOR_TOUCHSCREENS = 100;
    public static final int FRAMERATE_MAXIMUM_FOR_SDK = 24;
    public static final int FRAMERATE_LANDSCAPE_AND_BLUETOOTH = 12;
    public static int m_inGameFrameRate = 24;
    public static int m_bluetoothFrameRate;
    public static final boolean TOUCHSCREEN = true;
    public static final int MASTERSTATE_LOADLANGUAGE = 0;
    public static final int MASTERSTATE_LANGUAGE = 1;
    public static final int MASTERSTATE_LOGOS = 2;
    public static final int MASTERSTATE_LOADFRONTEND = 3;
    public static final int MASTERSTATE_FRONTEND = 4;
    public static final int MASTERSTATE_LOADGAME = 5;
    public static final int MASTERSTATE_INGAME = 6;
    public static final int MASTERSTATE_PAUSED = 7;
    public static final int MASTERSTATE_MOREGAMES = 8;
    public static final int MASTERSTATE_BLUETOOTH = 9;
    public static final int MASTERSTATE_INGAME_MENU = 10;
    public static final int MASTERSTATE_LANDSCAPENOTSUPPORTED = 11;
    public static final int MASTERSTATE_ROTATED = 12;
    public static final int JOYSTICK_LEFT = 1;
    public static final int JOYSTICK_RIGHT = 2;
    public static final int JOYSTICK_UP = 4;
    public static final int JOYSTICK_DOWN = 8;
    public static final int JOYSTICK_FIRE = 16;
    public static final int JOYSTICK_RSK = 32;
    public static final int JOYSTICK_LSK = 64;
    public static final int JOYSTICK_OTHER1 = 128;
    public static final int JOYSTICK_OTHER2 = 256;
    public static final int JOYSTICK_BACK_KEY = 512;
    public static final int JOYSTICK_CLR_KEY = 1024;
    public static final int JOYSTICK_UP_LEFT = 2048;
    public static final int JOYSTICK_UP_RIGHT = 4096;
    public static final int JOYSTICK_DOWN_LEFT = 8192;
    public static final int JOYSTICK_DOWN_RIGHT = 16384;
    public static final int JOYSTICK_OTHER3 = 32768;
    public static final int NUMKEY_UP_LEFT = 256;
    public static final int NUMKEY_UP = 512;
    public static final int NUMKEY_UP_RIGHT = 1024;
    public static final int NUMKEY_LEFT = 2048;
    public static final int NUMKEY_FIRE = 4096;
    public static final int NUMKEY_RIGHT = 8192;
    public static final int NUMKEY_DOWN_LEFT = 16384;
    public static final int NUMKEY_DOWN = 32768;
    public static final int NUMKEY_DOWN_RIGHT = 65536;
    public static final int NUMKEY_OTHER = 128;
    private static final int G_LEFT = 4;
    private static final int G_RIGHT = 8;
    private static final int G_HCENTER = 1;
    private static final int G_VCENTER = 2;
    private static final int G_TOP = 16;
    private static final int G_BOTTOM = 32;
    private static final int LOADCOUNT_MENU = 6;
    private static final int LOADCOUNT_GRAPHICS = 7;
    private static final int LOADCOUNT_LOGIC = 3;
    public static final int LOADCOUNT_MAX = 16;
    public static int m_masterState;
    private static boolean m_inPaint;
    public static int m_resumeState;
    public static int m_loadTimer;
    private static int m_loadTimerEnd;
    private static int m_loadNextState;
    private static int m_loadMenuID;
    public static int m_loadReturnMenu;
    public static int m_loadError;
    private static final int LOGO_NUM = 4;
    private static final int LOGO_DELAY = 3000;
    public static boolean m_gameMenuLoaded;
    public static boolean m_matchResultsProcessed;
    public static int m_soundPlayDelay;
    public static boolean m_soundRestart;
    protected static int m_pointerCurrentPosX;
    protected static int m_pointerCurrentPosY;
    protected static boolean m_pointerPressed;
    protected static int m_canvasW;
    protected static int m_canvasH;
    private static SDKImage m_displayImage;
    private static SDKGraphics m_displayGraphics;
    private static int[] m_displayImageRGB;
    private static int[] m_displayDoubledImageRGB;
    public static SDKCanvas m_canvas;
    public static int m_keysPressedThisFrame;
    public static int m_keysReleasedThisFrame;
    public static int m_keyState;
    public static int m_joystick;
    public static int m_joystickHeld;
    private static int m_keyASCIILast;
    public static int m_framesReplayActive;
    public static int m_framesSinceReplayControlUsed;
    public static boolean m_interruptDuringLoad;
    public static boolean ignorePtrRelease;
    public static SDKMoreGames16 m_mgInstance;
    private static int[] m_qwerty_keycode;
    private static int[] m_qwerty_remap_keycode;
    private static final int NUM_QWERTY_REMAP_KEYS = 10;
    public static volatile int m_paintCounter;
    public static boolean quitInTutorialMenu;
    public static boolean m_pointerPressedProcessed;
    public static boolean m_pointerReleasedToProcess;
    public static int m_pointerReleasedToProcessX;
    public static int m_pointerReleasedToProcessY;
    public static final int MOREGAMES_NUM = 3;
    public static SDKImage m_logoImage;
    public static SDKImage m_logoImageFifaCopyright;
    public static SDKImage m_logoImageEALogo;
    public static SDKImage m_logoImageFIFALogo;
    private static int m_logoCurrent;
    private static int m_logoTimer;
    private static SDKImage m_warningImage;
    private static SDKSoundManager m_soundInst;
    private static final String[] m_fileexten;
    private static final String[] m_fileexten_qcp;
    private static boolean[] m_soundsLoaded;
    private static int m_soundResume;
    private static int m_soundResumeFlags;
    private static final int SOUNDTYPE_SAMPLE = 0;
    private static final int SOUNDTYPE_SEQUENCE = 1;
    private static final int SOUNDTYPE_NUMBER = 2;
    public static final int SOUNDFLAG_PLAYONCE = 1;
    public static final int SOUNDFLAG_LOOP = 2;
    public static final int SOUNDFLAG_RESUME = 4;
    public static final int SOUNDFLAG_QUEUEUP = 8;
    public static final int SOUNDFLAG_IMMEDIATEPLAY = 16;
    private static boolean m_vibrateOn;
    private static int m_frameRateCount;
    private static int m_frameRate;
    private static long m_frameRateTime;
    private static boolean m_frameRateProcess;
    private static final int DEBUG_STRING_X = 0;
    private static final int DEBUG_STRING_Y = 0;
    private static final int DEBUG_STRING_FONT_FRONTEND = 0;
    private static final int DEBUG_STRING_PALETTE_FRONTEND = 1;
    private static final int DEBUG_STRING_FONT_LOAD_FRONTEND = 0;
    private static final int DEBUG_STRING_PALETTE_LOAD_FRONTEND = 1;
    private static final int DEBUG_STRING_FONT_LOAD_GAME = 0;
    private static final int DEBUG_STRING_PALETTE_LOAD_GAME = 1;
    private static final int DEBUG_STRING_FONT_INGAME = 0;
    private static final int DEBUG_STRING_PALETTE_INGAME = 1;
    private static final int DEBUG_STRING_NUM_LINES = 16;
    private static final int DEBUG_STRING_LINE_HEIGHT_PIXELS = 20;
    private static SDKString[] m_debugStringBuffer;
    private static SDKString m_debugString;
    public static boolean m_debugStringEnabled;
    private static final int DEBUG_MEMORY_METER_RECT_VALUE_KB = 100;
    private static final int DEBUG_MEMORY_METER_RECT_VALUE_BYTES = 102400;
    private static final int DEBUG_MEMORY_RECT_WIDTH = 12;
    private static final int DEBUG_MEMORY_RECT_HEIGHT = 10;
    private static final int DEBUG_MEMORY_RECT_Y_OFFSET = 80;
    private static final int DEBUG_MEMORY_RECT_SPACE = 3;
    private static final int DEBUG_MEMORY_RECT_TOTAL_COLOR = 0xFFFF00;
    private static final int DEBUG_MEMORY_RECT_USED_COLOR = 0xFF0000;
    public static final int BLUETOOTH_STATE_IDLE = 0;
    public static final int BLUETOOTH_STATE_DISOVERABLE = 1;
    public static final int BLUETOOTH_STATE_SEARCH = 2;
    public static final int BLUETOOTH_STATE_CONNECTING = 3;
    public static final int BLUETOOTH_STATE_CONNECTED = 4;
    public static final int BLUETOOTH_STATE_SEARCHCOMPLETE = 5;
    public static final int BLUETOOTH_WAIT_NONE = -1;
    public static final int BLUETOOTH_WAIT_TEAMSELECT = 0;
    public static final int BLUETOOTH_TYPE_JOINED = 0;
    public static final int BLUETOOTH_TYPE_HOST = 1;
    private static final int BLUETOOTH_SLEEP_WAIT_TIME = 200;
    private static final int BLUETOOTH_MAX_DATA_SIZE = 18;
    private static final int BLUETOOTH_BUFFER_MAX_NUM_PACKETS = 5;
    private static final int BLUETOOTH_BUFFER_SIZE = 90;
    private static BlueToothConnection m_bluetoothConnection;
    public static int m_bluetoothType;
    protected static int m_bluetoothState;
    private static int m_bluetoothDataIndex;
    private static int m_bluetoothTransmissionLength;
    public static byte[] m_bluetoothReceivedData;
    public static byte[] m_bluetoothDataToSend;
    public static boolean m_bluetoothFirstFrame;
    public static boolean m_bluetoothRunning;
    private static byte[] m_bluetoothGameBuffer;
    private static byte[] m_bluetoothThreadBuffer;
    private static int m_bluetoothGameBufferOff;
    private static int m_bluetoothThreadBufferOff;
    private static int m_bluetoothNumPackets;
    private static int m_bluetoothPacketWanted;
    private static byte[] m_bluetoothPacket;
    public static int m_bluetoothWaiting;
    public static final int BLUETOOTH_PACKET_INGAME = 1;
    public static final int BLUETOOTH_PACKET_WAITING = 2;
    public static final int BLUETOOTH_PACKET_SUBS = 3;
    public static final int BLUETOOTH_PACKET_REMATCH = 4;
    public static final int BLUETOOTH_PACKET_INTERRUPT = 5;
    public static final int BLUETOOTH_PACKET_CONNECTION_CHECK = 6;
    public static final int BLUETOOTH_PACKET_TACTICS = 7;
    public static boolean m_bluetoothSafeToProcessData;
    public static boolean m_bluetoothInSync;
    public static int m_bluetoothOldBallX;
    public static int m_bluetoothOldBallY;
    public static byte m_bluetoothOldPlayerDataChecksum;
    private static final int BLUETOOTH_NUM_STRINGS = 20;
    public static String[] m_bluetoothStrings;
    public static int m_bluetoothDevs;
    public static int m_bluetoothServs;
    public static int m_bluetoothServsSearched;
    private static int m_bluetoothFrameRateCheck;
    public static int m_bluetoothJoystick;
    public static int m_bluetoothJoystickIndex;
    public static int[] m_bluetoothLockedJoystick;
    public static int m_bluetoothFrame;
    public static boolean m_bluetoothRematch;
    public static boolean m_bluetoothRematchDataReceived;
    public static boolean m_bluetoothPlayerRematch;
    public static int m_bluetoothWaitTimer;
    public static final int BLUETOOTH_WAIT_SHOWICON_TIME = 3;
    public static int m_bluetoothWaitNumFrames;
    public static boolean m_bluetoothInterruptSent;
    public static boolean m_bluetoothScreenSizesDifferent;
    public static int m_bluetoothOpponentSprintControlType;
    public static int m_bluetoothTicks;
    public static int m_bluetoothTargetTicks;
    public static boolean bluetoothNeedTacticsPacketBackToContinue;
    public static final int BLUETOOTH_DEBUG_OUTPUT_BUFFER_HEIGHT = 32;
    private static int m_bluetoothDebugOutputBufferOffset;
    private static int m_bluetoothDebugOutputBufferNumRows;
    private static StringBuffer[] m_bluetoothDebugOutputStringBuffers;
    public static final int BLUETOOTH_DEBUG_OUTPUT_STRINGBUFFER_NUM_CHARS = 1024;

    public byte[] loadResource(int n2) {
        String string = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            string = "/snd" + n2 + m_fileexten[i2];
            byte[] byArray = DDFile.loadFileBytes(string);
            if (byArray == null) continue;
            MainFrame.m_soundsLoaded[n2] = true;
            return byArray;
        }
        return SDKInputStream.loadResourceAsByteArray(n2);
    }

    public MainFrame(SDKCanvas sDKCanvas) {
        m_canvas = sDKCanvas;
        m_soundInst = SDKSoundManager.getManager();
        m_soundInst.setLoader(this);
    }

    public void init() {
        MainFrame.bluetoothLoad();
        DDDebug.init();
        m_canvas.vpadSetHeight(0);
        Controller controller = new HumanController(0);
        controller.m_180turn = true;
        controller = null;
        controller = new AIController(0);
        controller.m_180turn = true;
        controller = null;
        DDFile.fileInit();
        DDMath.init();
        GameLogic.init();
        GameFormation.initFormations();
        GameFormation.initialiseFormationZoneValues();
        GameAI.initAI();
        Trajectory.initTrajectory();
        XMLMenuSystem.menuInit(m_canvas);
        GameRender.gameRenderInit();
        MainFrame.setMasterState(0);
        MainFrame.clearSoundResume();
        MainFrame.loadSounds();
        MainFrame.debugStringLoad();
        MainFrame.bluetoothDebugOutputLoad();
    }

    public void appLetterPressed(int n2, long l2) {
        m_keyASCIILast = n2;
    }

    public void appLetterReleased(int n2, long l2) {
    }

    public void appKeyReleased(int n2, long l2) {
        if (m_masterState == 3 || m_masterState == 5) {
            return;
        }
        m_keysReleasedThisFrame |= n2;
        m_keyState &= ~n2;
    }

    public void appKeyPressed(int n2, long l2) {
        if (m_masterState == 3 || m_masterState == 5) {
            return;
        }
        m_keyState |= n2;
        if (((m_keysPressedThisFrame |= n2) & 0x20) != 0 && (m_keysPressedThisFrame & 0x1000) != 0) {
            m_keysPressedThisFrame &= 0xFFFFFFDF;
            m_keyState &= 0xFFFFFFDF;
        }
        if (m_masterState == 8) {
            m_mgInstance.processKey(n2);
        } else {
            GameLogic.checkCheats(n2);
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        SDKUtils.setGraphics(sDKGraphics);
        m_inPaint = true;
        switch (m_masterState) {
            case 11: {
                XMLMenuSystem.drawLandscapeScreen(sDKGraphics, m_canvasW, m_canvasH);
                break;
            }
            case 12: {
                break;
            }
            case 2: {
                MainFrame.logoDraw(sDKGraphics);
                break;
            }
            case 0: 
            case 3: {
                XMLMenuSystem.drawLoading(sDKGraphics, m_loadTimer, m_loadTimerEnd);
                break;
            }
            case 5: {
                XMLMenuSystem.drawLoading(sDKGraphics, m_loadTimer, m_loadTimerEnd);
                if (!m_gameMenuLoaded) break;
                XMLMenuSystem.m_menuRefreshCount = 1;
                XMLMenuSystem.draw(sDKGraphics);
                break;
            }
            case 7: 
            case 10: {
                if (XMLMenuSystem.m_menuRefreshCount > 0) {
                    try {
                        GameRender.draw(sDKGraphics);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            case 1: 
            case 4: {
                XMLMenuSystem.draw(sDKGraphics);
                break;
            }
            case 6: {
                try {
                    GameRender.draw(sDKGraphics);
                }
                catch (Exception exception) {}
                break;
            }
            case 8: {
                if (!m_mgInstance.isActive()) break;
                m_mgInstance.paint(sDKGraphics);
            }
        }
        MainFrame.debugStringDraw(sDKGraphics);
        MainFrame.debugMemoryMeterDraw(sDKGraphics);
        m_inPaint = false;
    }

    public static void setMasterState(int n2) {
        int n3 = m_masterState;
        m_joystick = 0;
        m_masterState = n2;
        switch (n2) {
            case 0: {
                m_loadTimer = -2;
                m_loadMenuID = 2;
                m_loadTimerEnd = 16;
                m_loadNextState = 1;
                break;
            }
            case 2: {
                MainFrame.logoInit();
                break;
            }
            case 3: {
                DDImage.m_landscapeDrawingMode = 0;
                XMLMenuSystem.createLoadingImage();
                m_loadTimer = -2;
                m_loadMenuID = 1;
                m_loadTimerEnd = 16;
                m_loadNextState = 4;
                MainFrame.soundStopAll();
                break;
            }
            case 4: {
                m_logoImage = null;
                m_logoImageFifaCopyright = null;
                m_logoImageEALogo = null;
                m_logoImageFIFALogo = null;
                XMLMenuSystem.m_font = -1;
                GameLogic.requestSound(0);
                XMLMenuSystem.removeLoadingImage();
                if (XMLMenuSystem.m_gameInProgress) break;
                XMLMenuSystem.shirtsReset();
                break;
            }
            case 5: {
                DDImage.m_landscapeDrawingMode = GameRender.m_landscapeMode;
                m_loadTimer = -2;
                m_loadMenuID = 3;
                m_loadError = 0;
                m_loadTimerEnd = 16;
                m_loadNextState = XMLMenuSystem.m_inGameFlag ? 7 : 6;
                m_gameMenuLoaded = false;
                m_matchResultsProcessed = false;
                MainFrame.soundStopAll();
                MainFrame.clearSoundResume();
                m_interruptDuringLoad = false;
                break;
            }
            case 10: {
                XMLMenuSystem.m_inGamePrevMenu = 37;
                XMLMenuSystem.setMenu(26);
                break;
            }
            case 7: {
                int n4;
                if (n3 == 6) {
                    XMLMenuSystem.m_touchscreenGestureProcessed = true;
                    XMLMenuSystem.m_inGamePrevMenu = -1;
                    for (n4 = 0; n4 < 2; ++n4) {
                        if (!GameLogic.m_controller[n4].m_microGame.inProgress()) continue;
                        GameLogic.m_controller[n4].m_microGame.cancelMicroGame();
                    }
                }
                if (GameLogic.m_gameMode != 99 && GameLogic.m_gameMode != 2) {
                    if (GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 5 || GameLogic.m_gameMode == 1 && XMLMenuSystem.m_menuSeasonType == 2) {
                        if (n3 == 6) {
                            XMLMenuSystem.m_inGamePrevMenu = XMLMenuSystem.m_currMenu;
                        }
                        if (GameLogic.m_gameMode == 5) {
                            if (GameLogic.m_freeKickChallengeRoundComplete) break;
                            XMLMenuSystem.setMenu(6);
                            break;
                        }
                        if (XMLMenuSystem.m_replayOption == 0) {
                            XMLMenuSystem.setMenu(6);
                            break;
                        }
                        if (XMLMenuSystem.m_menuSeasonType == 2 && GameLogic.m_matchState == 1 && GameLogic.m_matchSubState == 4) {
                            XMLMenuSystem.setMenu(6);
                            break;
                        }
                        XMLMenuSystem.setMenu(11);
                        break;
                    }
                    if (XMLMenuSystem.m_menuMatchType == 4) {
                        if (n3 == 6) {
                            XMLMenuSystem.m_inGamePrevMenu = XMLMenuSystem.m_currMenu == 4 || XMLMenuSystem.m_currMenu == 5 ? 37 : XMLMenuSystem.m_currMenu;
                        }
                        XMLMenuSystem.setMenu(4);
                        break;
                    }
                    if (n3 == 6) {
                        XMLMenuSystem.m_inGamePrevMenu = XMLMenuSystem.m_currMenu;
                    }
                    if (GameLogic.m_matchState == 4 || GameLogic.m_matchState == 15) {
                        XMLMenuSystem.setMenu(6);
                        break;
                    }
                    if (GameLogic.inShootoutView() || GameLogic.isShootoutViewEnabled() && GameLogic.m_matchPeriod == 4) {
                        XMLMenuSystem.setMenu(4);
                        break;
                    }
                    if (GameAI.m_playerInjured != null) {
                        if (XMLMenuSystem.m_replayOption == 0) {
                            XMLMenuSystem.setMenu(6);
                            break;
                        }
                        XMLMenuSystem.setMenu(11);
                        break;
                    }
                    n4 = GameLogic.MATCH_PERIOD_START_TIMES[GameLogic.m_matchPeriod] + GameLogic.m_matchTimer;
                    if (GameLogic.m_matchState == 1 && n4 == 0) {
                        XMLMenuSystem.setMenu(6);
                        break;
                    }
                    if (GameLogic.m_matchState == 3 || GameLogic.m_matchState == 5 || GameLogic.m_matchState == 6 || GameLogic.m_matchState == 10 || GameLogic.m_matchState == 11 || GameLogic.m_matchState == 14 || GameLogic.m_matchState == 17 || GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 3 || GameLogic.m_matchSubState == 4) || XMLMenuSystem.m_replayOption == 0) {
                        XMLMenuSystem.setMenu(4);
                        break;
                    }
                    XMLMenuSystem.setMenu(2);
                    break;
                }
                if (GameLogic.m_gameMode == 99) {
                    XMLMenuSystem.setMenu(6);
                    break;
                }
                if (GameLogic.m_controller[0].m_gotoTrainingMenu) {
                    quitInTutorialMenu = true;
                    XMLMenuSystem.setTutorialMenu();
                    GameLogic.m_controller[0].m_gotoTrainingMenu = false;
                    break;
                }
                if (XMLMenuSystem.m_currTutorial == -1) {
                    quitInTutorialMenu = true;
                    XMLMenuSystem.setTutorialMenu();
                    break;
                }
                if (GameLogic.m_gameMode == 2) {
                    XMLMenuSystem.setMenu(13);
                    break;
                }
                if (XMLMenuSystem.m_replayOption == 0) {
                    XMLMenuSystem.setMenu(6);
                    break;
                }
                XMLMenuSystem.setMenu(11);
                break;
            }
            case 6: {
                XMLMenuSystem.m_gameInProgress = true;
                break;
            }
            case 8: {
                MainFrame.soundStopAll();
                XMLMenuSystem.setSoftKeys(9, 9);
                SDKUtils.loadStringsChunk(5);
                m_mgInstance.reset("mnu");
                break;
            }
            case 11: {
                switch (XMLMenuSystem.m_menuSystemID) {
                    case 2: {
                        XMLMenuSystem.setSoftKeys(23, 9);
                    }
                    case 1: {
                        XMLMenuSystem.setSoftKeys(16, 9);
                    }
                    case 3: {
                        XMLMenuSystem.setSoftKeys(16, 9);
                    }
                }
            }
        }
    }

    public void update(long l2) {
        MainFrame.bluetoothUpdateAllMasterStates();
        --m_soundPlayDelay;
        if (DDTextEntry.isTextInputActive()) {
            m_keyState = DDTextEntry.handleKeyPress(m_keyState);
            if (m_keyASCIILast != 0) {
                DDTextEntry.handleLetterPress(m_keyASCIILast);
                m_keyASCIILast = 0;
            }
            if ((m_keyState & 0x1000) != 0) {
                m_keyState &= 0xFFFFEFFF;
            }
            m_keysPressedThisFrame = m_keyState;
        }
        if (m_masterState != 6) {
            m_joystick = MainFrame.mapSDKKeysToJoystick(m_keysPressedThisFrame, false);
        } else {
            if (GameLogic.m_matchState == 13) {
                ++m_framesReplayActive;
                if (m_framesSinceReplayControlUsed < 5) {
                    ++m_framesSinceReplayControlUsed;
                }
            }
            if (XMLMenuSystem.m_currMenu == 32 || XMLMenuSystem.m_currMenu == 25 || XMLMenuSystem.m_currMenu == 31) {
                m_joystick = MainFrame.mapSDKKeysToJoystick(m_keysPressedThisFrame, false);
            } else {
                m_joystick = MainFrame.mapSDKKeysToJoystick(m_keyState | m_keysPressedThisFrame & m_keysReleasedThisFrame, false);
                if (m_masterState == 6 && GameLogic.m_matchState != 7 && GameLogic.m_matchState != 16 && GameLogic.m_matchState != 19 && GameLogic.m_matchState != 13) {
                    if ((m_joystick & 0x40) != 0) {
                        m_joystick &= 0xFFFFFFBF;
                    }
                    if ((m_joystick & 0x20) != 0) {
                        m_joystick &= 0xFFFFFFDF;
                    }
                }
                if (GameLogic.m_quickPlayMomentAvailable && GameLogic.m_quickPlayMomentFramesActivated < 3) {
                    if ((m_joystick & 0x10) != 0) {
                        m_joystick &= 0xFFFFFFEF;
                        m_keyState &= 0xFFFFFFEF;
                        m_keyState &= 0xFFFFEFFF;
                    }
                    ++GameLogic.m_quickPlayMomentFramesActivated;
                }
            }
        }
        m_keysPressedThisFrame = 0;
        m_keysReleasedThisFrame = 0;
        switch (m_masterState) {
            case 11: {
                XMLMenuSystem.m_touchscreenGestureProcessed = false;
                if ((XMLMenuSystem.touchGetJoystick() & 0x50) == 0) break;
                return;
            }
            case 2: {
                MainFrame.logoUpdate();
                break;
            }
            case 0: 
            case 3: 
            case 5: {
                MainFrame.loadUpdate(m_joystick);
                break;
            }
            case 10: {
                if (XMLMenuSystem.m_currMenu == 26) {
                    // empty if block
                }
            }
            case 7: {
                XMLMenuSystem.m_menuRefreshCount = 1;
            }
            case 1: 
            case 4: {
                if (m_masterState == 4 && m_soundPlayDelay == 0) {
                    GameLogic.requestSound(0);
                }
                XMLMenuSystem.update(m_joystick);
                MainFrame.clearJoystick();
                break;
            }
            case 6: {
                XMLMenuSystem.update(m_joystick);
                if (!MainFrame.bluetoothUpdateMasterStateInGameBlock1()) {
                    return;
                }
                if (GameLogic.m_controller[0].m_goIntoPause || GameLogic.m_controller[1].m_goIntoPause || GameLogic.m_controller[0].m_gotoTrainingMenu || GameLogic.m_controller[1].m_gotoTrainingMenu) {
                    MainFrame.setMasterState(7);
                    break;
                }
                if (GameLogic.m_controller[0].m_gotoSetPieceMenu || GameLogic.m_controller[1].m_gotoSetPieceMenu) {
                    if (GameAI.teamGetControlType(GameLogic.m_possession) == 2) {
                        MainFrame.setMasterState(10);
                    }
                    GameLogic.m_controller[0].m_gotoSetPieceMenu = false;
                    GameLogic.m_controller[1].m_gotoSetPieceMenu = false;
                    break;
                }
                MainFrame.bluetoothUpdateMasterStateInGameBlock2();
                GameLogic.update();
                GameRender.update();
                GameLogic.updateControllers();
                break;
            }
            case 8: {
                if (m_mgInstance.isActive()) {
                    m_mgInstance.update();
                    break;
                }
                SDKUtils.loadStringsChunk(2);
                MainFrame.setMasterState(4);
                XMLMenuSystem.setMenu(2);
                XMLMenuSystem.awaitingPointerReleaseInMainMenuExitMenu = true;
                break;
            }
        }
        MainFrame.frameRateProcess();
    }

    private static void unloadMoreGames() {
        m_mgInstance = null;
    }

    public static void loadMoreGames() {
        m_mgInstance = new SDKMoreGames16(240, 320);
        Object[] objectArray = XMLMenuSystem.setEAFonts();
        m_mgInstance.setFonts(objectArray);
        byte[] byArray = DDFile.loadFileBytesDirect("/moregames");
        m_mgInstance.setProductData(byArray);
    }

    public void pause() {
        MainFrame.soundStopAll();
        GameRender.resetReplayControls();
        MainFrame.soundStopAndClose();
        XMLMenuSystem.m_inGamePrevMenu = -1;
        MainFrame.clearSoundResume();
        if (m_masterState == 6) {
            if (!(GameLogic.m_matchState == 7 || GameLogic.m_matchState == 16 || GameLogic.m_matchState == 19 || GameLogic.m_matchState == 13 || GameLogic.m_gameMode == 5 && GameLogic.m_freeKickChallengeRoundComplete)) {
                if (XMLMenuSystem.m_menuMatchType == 4) {
                    GameLogic.m_controller[GameLogic.getPlayerTeam()].m_interrupted = true;
                } else {
                    XMLMenuSystem.m_globalArray[1] = 0;
                    GameLogic.m_controller[1].m_goIntoPause = true;
                    GameLogic.m_controller[0].m_goIntoPause = true;
                }
                XMLMenuSystem.m_inGamePrevMenu = XMLMenuSystem.m_menuMatchType == 4 && (XMLMenuSystem.m_currMenu == 4 || XMLMenuSystem.m_currMenu == 5) ? 37 : XMLMenuSystem.m_currMenu;
            }
        } else if (m_masterState == 5) {
            // empty if block
        }
    }

    public void resume() {
        XMLMenuSystem.m_menuRefreshCount = 3;
        MainFrame.clearJoystick();
        m_keysReleasedThisFrame = 0;
        m_soundRestart = true;
        MainFrame.loadSounds();
        GameRender.m_replayPlaybackControlsLeftHold = false;
        GameRender.m_replayPlaybackControlsRightHold = false;
        if (m_masterState == 5) {
            // empty if block
        }
        if (m_masterState == 6) {
            GameLogic.m_interruptContinueMatchTimer = true;
        }
    }

    public void exiting() {
        XMLMenuSystem.unload();
        GameRender.unload();
        GameLogic.unload();
        MainFrame.debugStringUnload();
        MainFrame.bluetoothDebugOutputUnload();
    }

    private static void orientationWarningDraw(SDKGraphics sDKGraphics) {
    }

    public void updateSoftKeyLabels(String string, String string2) {
    }

    public static void loadSounds() {
        for (int i2 = 0; i2 < 3; ++i2) {
            MainFrame.soundLoad(i2);
        }
    }

    private static void loadUpdate(int n2) {
        m_loadError = 0;
        if (++m_loadTimer == 0) {
            switch (m_masterState) {
                case 0: 
                case 3: 
                case 5: {
                    MainFrame.unloadMoreGames();
                    XMLMenuSystem.unload();
                    GameRender.unload();
                    GameLogic.unload();
                }
            }
            if (m_loadError != 0) {
                m_loadTimer = -1;
            }
        }
        if (MainFrame.isLoadingComplete()) {
            m_loadReturnMenu = -1;
            XMLMenuSystem.touchClear();
            MainFrame.setMasterState(m_loadNextState);
        } else if (m_loadTimer >= 0 && m_loadTimer < m_loadTimerEnd) {
            switch (m_masterState) {
                case 0: 
                case 3: {
                    XMLMenuSystem.load(m_loadMenuID, m_loadTimer, m_loadReturnMenu);
                    break;
                }
                case 5: {
                    if (m_loadTimer < 6) {
                        XMLMenuSystem.load(m_loadMenuID, m_loadTimer, m_loadReturnMenu);
                        if (m_loadTimer == 5) {
                            if (GameRender.m_landscapeMode == 0) {
                                XMLMenuSystem.setMenu(15);
                            } else {
                                XMLMenuSystem.setMenu(18);
                            }
                            m_gameMenuLoaded = true;
                        }
                    } else if (m_loadTimer < 13) {
                        GameRender.load(m_loadTimer - 6);
                    } else if (m_loadTimer < 16) {
                        GameLogic.load(m_loadTimer - 13);
                    }
                    Thread.yield();
                }
            }
        }
        if (m_loadError != 0 && m_loadTimer > 0) {
            m_loadTimer = -1;
        }
    }

    public static boolean isLoadingComplete() {
        return m_loadTimer >= m_loadTimerEnd + 2;
    }

    public void appPointerPressed(int n2, int n3, long l2) {
        if (GameLogic.m_europeanCupTrophyLifted) {
            this.appKeyPressed(4096, 0L);
            GameLogic.m_europeanCupTrophyLifted = false;
        }
        m_pointerPressedProcessed = false;
        m_pointerPressed = true;
        m_pointerCurrentPosX = n2;
        m_pointerCurrentPosY = n3;
        if (m_masterState != 6) {
            XMLMenuSystem.setPointerPosition(n2, n3);
            if (m_masterState == 8) {
                m_mgInstance.pointerPressed(n2, n3);
            }
        }
    }

    public void appPointerReleased(int n2, int n3, long l2) {
        if (ignorePtrRelease) {
            ignorePtrRelease = false;
            return;
        }
        if (m_masterState == 6) {
            if (m_pointerPressedProcessed) {
                m_pointerPressed = false;
                m_pointerCurrentPosX = n2;
                m_pointerCurrentPosY = n3;
            } else {
                m_pointerReleasedToProcess = true;
                m_pointerReleasedToProcessX = n2;
                m_pointerReleasedToProcessY = n3;
            }
        } else {
            if (m_masterState == 8) {
                m_mgInstance.pointerReleased(n2, n3);
            }
            XMLMenuSystem.awaitingPointerReleaseInMainMenuExitMenu = false;
            m_pointerReleasedToProcess = true;
            m_pointerPressed = false;
            m_pointerCurrentPosX = n2;
            m_pointerCurrentPosY = n3;
            GameRender.m_replayPlaybackControlsLeftHold = false;
            GameRender.m_replayPlaybackControlsRightHold = false;
            XMLMenuSystem.setPointerPosition(n2, n3);
        }
    }

    public void appPointerDragged(int n2, int n3, long l2) {
        if (m_masterState == 8) {
            m_mgInstance.pointerDragged(n2, n3);
        }
        m_pointerPressed = true;
        m_pointerCurrentPosX = n2;
        m_pointerCurrentPosY = n3;
        XMLMenuSystem.setPointerPosition(n2, n3);
    }

    public static void getMoreGamesParameters() {
    }

    private static int mapSDKKeysToJoystick(int n2, boolean bl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 8;
        }
        if ((n2 & 4) != 0) {
            n3 |= 1;
        }
        if ((n2 & 8) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x10) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 0x20) != 0) {
            n3 |= 0x40;
        }
        if ((n2 & 0x40) != 0) {
            n3 |= 0x20;
        }
        if ((n2 & 0x80) != 0) {
            n3 |= 0x80;
        }
        if ((n2 & 0x20000) != 0) {
            n3 |= 0x100;
        }
        if ((n2 & 0x40000) != 0) {
            n3 |= 0x8000;
        }
        if ((n2 & 0x200) != 0) {
            n3 |= 4;
        }
        if ((n2 & 0x8000) != 0) {
            n3 |= 8;
        }
        if ((n2 & 0x800) != 0) {
            n3 |= 1;
        }
        if ((n2 & 0x2000) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x1000) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 0x80000) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x800000) != 0) {
            n3 |= 0x400;
        }
        if (m_masterState == 6) {
            if ((n2 & 0x100) != 0) {
                n3 |= 5;
            }
            if ((n2 & 0x400) != 0) {
                n3 |= 6;
            }
            if ((n2 & 0x4000) != 0) {
                n3 |= 9;
            }
            if ((n2 & 0x10000) != 0) {
                n3 |= 0xA;
            }
        }
        return n3;
    }

    public static void clearJoystick() {
        m_keyState = 0;
        m_joystick = 0;
    }

    public void appScreenChanged(int n2, int n3) {
    }

    private static void logoInit() {
        m_logoCurrent = -1;
        XMLMenuSystem.setSoftKeys(9, 9);
    }

    public static void logoDraw(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        sDKGraphics.fillRect(0, 0, 240, 320);
        if (m_logoImage != null) {
            sDKGraphics.setClip(0, 0, 240, 320);
            int n2 = 160;
            if (m_logoCurrent == 1) {
                int n3 = m_logoImage.getHeight() * 205 / 1000 / 2;
                boolean bl = false;
                if (XMLMenuSystem.m_selectedLanguage == 1) {
                    bl = false;
                }
                int n4 = n2 + m_logoImage.getHeight() / 2;
                if (!bl) {
                    n4 -= n3;
                }
                sDKGraphics.drawImage(m_logoImageFifaCopyright, 120 + m_logoImage.getWidth() / 2, n4, 36);
                if (!bl) {
                    sDKGraphics.setClip(0, (n2 += n3) - m_logoImage.getHeight() / 2, 240, m_logoImage.getHeight() * 795 / 1000);
                }
            }
            sDKGraphics.drawImage(m_logoImage, 120, n2, 3);
            if (m_logoCurrent >= 3) {
                n2 = 9;
                sDKGraphics.drawImage(m_logoImageFIFALogo, 120, n2, 17);
                int n5 = 192;
                n2 = 278;
                sDKGraphics.drawImage(m_logoImageEALogo, n5, n2, 3);
            }
        }
    }

    private static void logoUpdate() {
        int n2 = -1;
        int n3 = (int)m_canvas.getAppTime() - m_logoTimer;
        if (m_logoCurrent < 0) {
            XMLMenuSystem.unload();
        }
        if (n3 > 3000 || m_logoCurrent < 0) {
            if (++m_logoCurrent < 3) {
                m_logoImage = null;
            }
            if (m_logoCurrent >= 4) {
                n2 = 3;
            } else {
                if (m_logoCurrent < 3) {
                    m_logoImage = DDFile.loadImage("/logo" + m_logoCurrent + ".png");
                }
                if (m_logoCurrent == 1) {
                    m_logoImageFifaCopyright = DDFile.loadImage("/logo" + m_logoCurrent + "b.png");
                } else if (m_logoCurrent == 2) {
                    m_logoImageEALogo = DDFile.loadImage("/ea_logo_splash.png");
                    m_logoImageFIFALogo = DDFile.loadImage("/fifa13_splash_logo.png");
                }
            }
            m_logoTimer = (int)m_canvas.getAppTime();
        }
        if (n2 >= 0) {
            MainFrame.setMasterState(n2);
        }
    }

    public static void soundLoad(int n2) {
        m_soundInst.loadSound(n2);
        MainFrame.m_soundsLoaded[n2] = true;
    }

    public static void soundPlay(int n2, int n3) {
        if (m_soundInst.isSoundEnabled() && m_soundsLoaded[n2]) {
            MainFrame.clearSoundResume();
            if ((n3 & 4) == 4) {
                m_soundResume = n2;
                m_soundResumeFlags = n3;
            }
            if ((n3 & 2) == 2) {
                m_soundInst.setCurrentLoop(-1);
            } else {
                m_soundInst.setCurrentLoop(1);
            }
            if ((n3 & 8) == 8) {
                m_soundInst.setPlaybackType(1);
            } else {
                m_soundInst.setPlaybackType(0);
            }
            m_soundInst.playSound(n2);
        }
    }

    private static void clearSoundResume() {
        m_soundResume = -1;
        m_soundResumeFlags = -1;
    }

    public static void soundStopAll() {
        m_soundInst.stopSounds();
    }

    public static void soundSetOnOff(boolean bl) {
        m_soundInst.setSoundEnabled(bl);
    }

    public static boolean soundIsEnabled() {
        return m_soundInst.isSoundEnabled();
    }

    public static boolean soundIsEffectAvailable(int n2) {
        return m_soundsLoaded[n2];
    }

    public static void soundSetVolume(int n2) {
        DDMath.max(0, n2);
        DDMath.min(100, n2);
    }

    public static void soundStopAndClose() {
        MainFrame.soundStopAll();
        for (int i2 = 0; i2 < 3; ++i2) {
            m_soundInst.unloadSound(i2);
            m_soundInst.unloadCachedSound(i2);
            MainFrame.m_soundsLoaded[i2] = false;
        }
    }

    public static void unloadSound(int n2) {
        if (m_soundsLoaded[n2]) {
            m_soundInst.unloadSound(n2);
            m_soundInst.unloadCachedSound(n2);
            MainFrame.m_soundsLoaded[n2] = false;
        }
    }

    public static void vibrateSetOnOff(boolean bl) {
        m_vibrateOn = bl;
    }

    public static void vibratePlay(int n2) {
        if (m_vibrateOn) {
            m_soundInst.vibrate(n2);
        }
    }

    private static void frameRateProcess() {
        if (m_frameRateProcess) {
            long l2 = System.currentTimeMillis();
            if (l2 - m_frameRateTime >= 1000L) {
                m_frameRate = m_frameRateCount;
                m_frameRateCount = 0;
                m_frameRateTime = System.currentTimeMillis();
            }
            ++m_frameRateCount;
        }
    }

    private static void debugStringLoad() {
    }

    private static void debugStringUnload() {
    }

    public static void debugStringSet(String string) {
    }

    public static void debugStringAppend(String string) {
    }

    private static void debugStringDraw(SDKGraphics sDKGraphics) {
    }

    public static void debugStringSet(String string, int n2) {
    }

    public static void debugStringAppend(String string, int n2) {
    }

    private static void debugMemoryMeterDraw(SDKGraphics sDKGraphics) {
    }

    public static void bluetoothLoad() {
    }

    public void bluetoothOnError(Exception exception, int n2) {
    }

    public void bluetoothOnNewPacketArrived(byte[] byArray) {
    }

    private static void bluetoothCopyBuffer() {
    }

    public static int bluetoothCheckForNewPacket(int n2) {
        return -1;
    }

    public static void bluetoothRemovePacketFromBuffer(int n2) {
    }

    public static void bluetoothPullPacketFromBuffer() {
    }

    public static void bluetoothSetState(int n2, int n3) {
    }

    public static void bluetoothSetWait(int n2) {
    }

    public static void bluetoothClearBuffer() {
    }

    public void bluetoothOnNewConnection() {
    }

    public void bluetoothOnCompletedDeviceEnumeration() {
    }

    public void bluetoothOnNotifyNewDeviceFound() {
    }

    public void bluetoothOnConfirmationPacketReceived() {
    }

    public void bluetoothOnConfirmationPacketSent() {
    }

    public static void bluetoothShowDevices() {
    }

    public static void bluetoothSendData(byte[] byArray, int n2) {
    }

    private static void bluetoothInit() {
    }

    public static void bluetoothEndConnection() {
    }

    public static void bluetoothResetVars() {
    }

    private static void bluetoothUpdateAllMasterStates() {
    }

    private static boolean bluetoothUpdateMasterStateInGameBlock1() {
        return true;
    }

    private static void bluetoothUpdateMasterStateInGameBlock2() {
    }

    private static void bluetoothDebugOutputLoad() {
    }

    private static void bluetoothDebugOutputUnload() {
    }

    public static void bluetoothDebugOutputWrite(String string) {
    }

    public static void bluetoothDebugOutputAppend(String string) {
    }

    public static void bluetoothDebugOutputNewLine() {
        ++m_bluetoothDebugOutputBufferNumRows;
        if (++m_bluetoothDebugOutputBufferOffset == 32) {
            m_bluetoothDebugOutputBufferOffset = 0;
        }
    }

    public static void bluetoothDebugOutputDumpToSystemOut() {
    }

    private static void bluetoothDebugOutputDumpToSystemOut(int n2, int n3) {
    }

    static {
        m_loadReturnMenu = -1;
        m_gameMenuLoaded = false;
        m_soundPlayDelay = -1;
        m_soundRestart = false;
        m_canvasW = 0;
        m_canvasH = 0;
        m_framesReplayActive = 0;
        m_framesSinceReplayControlUsed = 5;
        m_interruptDuringLoad = false;
        ignorePtrRelease = false;
        m_qwerty_keycode = new int[]{33, 34, 36, 38, 43, 45, 58, 61, 92, 95};
        m_qwerty_remap_keycode = new int[]{113, 119, 115, 101, 111, 105, 46, 112, 108, 107};
        m_paintCounter = 0;
        quitInTutorialMenu = false;
        m_pointerPressedProcessed = true;
        m_pointerReleasedToProcess = false;
        m_warningImage = null;
        m_fileexten = new String[]{".wav", ".mid"};
        m_fileexten_qcp = new String[]{".qcp", ".mid"};
        m_soundsLoaded = new boolean[3];
        m_frameRateProcess = true;
        m_bluetoothType = -1;
        m_bluetoothState = 0;
        m_bluetoothDataIndex = 0;
        m_bluetoothTransmissionLength = 0;
        m_bluetoothFirstFrame = false;
        m_bluetoothRunning = false;
        m_bluetoothGameBufferOff = 0;
        m_bluetoothThreadBufferOff = 0;
        m_bluetoothNumPackets = 0;
        m_bluetoothPacketWanted = 0;
        m_bluetoothWaiting = -1;
        m_bluetoothSafeToProcessData = false;
        m_bluetoothInSync = true;
        m_bluetoothOldBallX = 0;
        m_bluetoothOldBallY = 0;
        m_bluetoothOldPlayerDataChecksum = 0;
        m_bluetoothDevs = 0;
        m_bluetoothServs = 0;
        m_bluetoothServsSearched = 0;
        m_bluetoothJoystick = 0;
        m_bluetoothJoystickIndex = 0;
        m_bluetoothFrame = 0;
        m_bluetoothRematch = false;
        m_bluetoothRematchDataReceived = false;
        m_bluetoothPlayerRematch = false;
        m_bluetoothWaitTimer = 0;
        m_bluetoothTicks = 0;
        m_bluetoothTargetTicks = 0;
    }
}

